package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailBusinessType;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;

@TableName(value = "rd_security_station_rails",autoResultMap = true)
@Data
public class RdSecurityStationRailEntity extends EntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;
    @TableField("name")
    private String name;
    @TableField(value = "shape_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RailShapeType shapeType;
    @TableField("area_json")
    private String areaJson;
    @TableField(value = "business_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RailBusinessType businessType;
    @TableField("reference_number")
    private String referenceNumber;
    @TableField("reference_name")
    private String referenceName;
    @TableField(value = "begin_time")
    private Date beginTime;
    @TableField(value = "end_time")
    private Date endTime;
    @TableField(value = "is_deleted")
    private boolean deleted;
    @TableField(value = "created_time")
    private Timestamp createdTime;
    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "last_modifier_id")
    private String lastModifierId;
    @TableField(value = "creator_id")
    private String creatorId;

    @TableField(value = "rule_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RailRuleType ruleType;

    @TableField(value = "supervise_depart_id")
    private String superviseDepartId;

    @TableField(value = "supervise_depart_name")
    private String superviseDepartName;

    @TableField(value = "creator_name")
    private String creatorName;

    @TableField(value = "last_modifier_name")
    private String lastModifierName;
    /**
     *
     */
    @TableField(value = "note")
    private String note;

    /**
     * 该电子围栏创建的企业
     */
    @TableField(value = "organization_id")
    private String organizationId;

    /**
     * 该电子围栏驻勤点所属的企业
     */
    @TableField(value = "owner_organization_id")
    private String ownerOrganizationId;
    protected RdSecurityStationRailEntity(){}

    public RdSecurityStationRailEntity(long id,String organizationId, String employeeId,String employeeName, String ownerOrganizationId) {
        this.setPkId(id);
        this.setCreatorId(employeeId);
        this.setOrganizationId(organizationId);

        this.setCreatorName(employeeName);
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setOwnerOrganizationId(ownerOrganizationId);
    }

    public void change(String name,
                       RailShapeType shapeType,
                       String areaJson,
                       RailBusinessType businessType,
                       String referenceNumber,
                       String referenceName,Date beginTime,
                       Date endTime,
                       RailRuleType ruleType,
                       String modifierId,
                       String note,
                       String superviseDepartId,
                       String superviseDepartName,
                       String modifierName) {
        if(ruleType==RailRuleType.Access) {
            throw new NotSupportTenantException(String.format("围栏类型无效,目前仅支持离开告警的围栏类型", ruleType.name()));
        }

        this.setName(name);
        this.setShapeType(shapeType);
        this.setAreaJson(areaJson);
        this.setBusinessType(businessType);
        this.setReferenceName(referenceName);
        this.setReferenceNumber(referenceNumber);
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
        this.setRuleType(ruleType);
        this.setNote(note);

        this.setLastModifierId(modifierId);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setSuperviseDepartId(superviseDepartId);
        this.setSuperviseDepartName(superviseDepartName);
        this.setLastModifierName(modifierName);
    }

    public void markAsDeleted(String modifierId,String modifierName) {
        this.setDeleted(true);
        this.setLastModifierId(modifierId);
        this.setLastModifierName(modifierName);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public static RdSecurityStationRailEntity create(
            long id,
            String organizationId,
            String name,
            RailShapeType shapeType,
            String areaJson,
            RailBusinessType businessType,
            String referenceNumber,
            String referenceName,
            Date beginTime,
            Date endTime,
            RailRuleType ruleType,String userId,
            String note,
            String superviseDepartId,
            String superviseDepartName,
            String userName,
            String ownerOrganizationId) {
        RdSecurityStationRailEntity entity = new RdSecurityStationRailEntity(id,organizationId, userId,userName,ownerOrganizationId);
        entity.setPkId(id);
        entity.change(name, shapeType, areaJson, businessType, referenceNumber, referenceName,
                beginTime, endTime, ruleType, userId,note,superviseDepartId,superviseDepartName,userName);

        return entity;
    }
}