package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.domains.typeHandlers.GeoPointTypeHandler;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "rd_security_station_summary",autoResultMap = true)
@Data
public class RdSecurityStationEntity extends RdSuperviseEntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField("id")
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "station_type")
    private String stationType;

    /**
     * 驻勤点对应的业务类型:
     * 驻勤点/社区警务/内保驻勤点/临保岗点
     */
    @TableField(value = "resource_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ResourceType resourceType;

    @TableField(value = "company_name")
    private String companyName;

    @TableField(value = "principal_id")
    private String principalId;

    @TableField(value = "principal_name")
    private String principalName;

    @TableField(value = "principal_contact")
    private String principalContact;

    @TableField(value = "service_scope")
    private String serviceScope;

    @TableField(value = "address")
    private String address;

    @TableField(value = "count_of_security_man")
    private int countOfSecurityMan;

    /**
     * flink暂时不支持自定义函数的Point; 不好搞
     */
    //@TableField(value = "lon_lat", typeHandler = GeoPointTypeHandler.class)
    //private GeoPointValueType lonLat;
    @TableField(value = "lon_lat")
    private String lonLat;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "site_state")
    private String siteState;

    @TableField(value = "begin_date")
    private Date beginDate;

    @TableField(value = "end_date")
    private Date endDate;

    /**
     * 企业的行业类型
     */
    @TableField(value = "industry")
    private String industry;

    /**
     * 企业的机构类型
     */
    @TableField(value = "institutional")
    private String institutional;

    /**
     * 执行范围（米）;签到范围
     */
    @TableField(value = "perform_range")
    private Double performRange;

    /**
     * 临保项目Id
     */
    @TableField(value = "project_id")
    private String projectId;

    /**
     * 临保项目名称
     */
    @TableField(value = "project_name")
    private String projectName;


    public RdSecurityStationEntity() {
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }
}
