package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.domains.typeHandlers.GeoPointTypeHandler;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CompanyStatus;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;


/**
 * 归集来自:
 * baibaodunflow.tlk_companyinformation,
 * obpm2.tenant_organizations
 * 监管归属: organizationauth.tlk_DepartmentLevel dl JOIN baibaodunflow.tlk_SetSupervise
 */
@TableName(value = "rd_company_summary",autoResultMap = true)
@Data
public class RdCompanyEntity extends RdSuperviseEntityAbstract implements Aggregate {
    @TableId(value = "pk_id")
    private Long pkId;

    @TableField(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "legal")
    private String legal;

    @TableField(value = "legal_telephone")
    private String legalTelephone;

    @TableField(value = "institutional")
    private String institutional;

    @TableField(value = "register_address")
    private String registerAddress;

    @TableField(value = "business_address")
    private String businessAddress;

    @TableField(value = "count_of_activity_station")
    private int countOfActivityStation;

    @TableField(value = "count_of_security_man")
    private int countOfSecurityMan;

    /**
     * 用户的人数
     */
    @TableField(value = "count_of_men")
    private int countOfMen;

    @TableField(value = "service_scope")
    private String serviceScope;

    @TableField(value = "lon_lat")
    private String lonLat;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private CompanyStatus status;

    @TableField(value = "supervise_depart_id")
    private String superviseDepartId;

    @TableField(value = "supervise_depart_name")
    private String superviseDepartName;

    @TableField(value = "industry")
    private String industry;

    /**
     * 联动值数量
     */
    @TableField(value = "points")
    private Long points;

    /**
     * 可用调度台数量
     */
    @TableField(value = "count_of_desk")
    private int countOfDesk;

    /**
     * 监管区域编码
     */
    @TableField(value = "supervise_region_code")
    private String superviseRegionCode;

    public RdCompanyEntity() {

        this.setStatus(CompanyStatus.Normal);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }
}