package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.PointChangeType;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * https://kvi9mvrp7j.feishu.cn/docx/QV3LdrbVsoompUxYAdHcY4Ynn0c
 */
@TableName(value = "tlk_org_purse_transaction",autoResultMap = true)
@Data
public class OrgPurseTransactionEntity extends EntityAbstract implements Aggregate {
    /**
     * 主键
     */
    @TableField(value = "ITEM_PK_ID")
    private String pkId;
    /**
     * 企业Id-
     */
    @TableField(value = "ITEM_ORGANIZATION_ID")
    private String organizationId;
    /**
     * 充值则该值为正数
     * 消费则为负数
     */
    @TableField(value = "ITEM_POINTS")
    private Long points;

    /**
     * 企业Id-
     */
    @TableField(value = "DOMAINID")
    private String domainId;

    /**
     * 0: 充值
     * 1: 音频
     * 2: 视频
     * 3: 人工充值
     * 4: 点名
     * 5： 月度账单扣费
     */
    @TableField(value = "ITEM_TYPE", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private PointChangeType type;

    /**
     * 音视频 device_comminicated_logs_detail.id
     * 充值: 订单Number
     * 平台充值-充值日志Id
     */
    @TableField(value = "ITEM_REFERENCE_NUMBER")
    private String referenceNumber;

    @TableField(value = "ITEM_REFERENCE_JSON")
    private String referenceJson;
    @TableField(value = "ITEM_CREATED_TIME")
    private Timestamp createdTime;
    @TableField(value = "ID")
    private String id;
    @TableField(value = "ITEM_OPERATORNAME")
    private String operatorName;
    @TableField(value = "ITEM_OPERATORID")
    private String operatorId;
    @TableField(value = "ITEM_ORGANIZATION_NAME")
    private String organizationName;

    @TableField(value = "FORMID")
    private String formId;

    @TableField(value = "LASTMODIFIED")
    private Timestamp lastModified;

    @TableField(value = "CREATED")
    private Timestamp created;

    public OrgPurseTransactionEntity(){}

    public OrgPurseTransactionEntity(Long pkId,String idPrefix) {
        this.setPkId(String.valueOf(pkId));

        this.createdTime = Timestamp.from(Instant.now());
        this.setFormId("__Mo4BefvUBDNi4DtP4TW");
        this.setId(String.format("%s--%s", idPrefix, this.getFormId()));
        this.setLastModified(this.getCreatedTime());
    }

    public static OrgPurseTransactionEntity create(
            Long pkId,String idPrefix,
            String organizationId,
                                                   String organizationName,
                                                   PointChangeType type,
                                                   String referenceNumber,
                                                   String referenceJson,
                                                   String operatorName,
                                                   String operatorId,
                                                   int points,
            Timestamp businessCreatedTime) {
        OrgPurseTransactionEntity entity = new OrgPurseTransactionEntity(pkId,idPrefix);
        entity.setType(type);
        entity.setOrganizationId(organizationId);
        entity.setDomainId(organizationId);

        entity.setOrganizationName(organizationName);
        entity.setReferenceNumber(referenceNumber);
        entity.setReferenceJson(referenceJson);
        entity.setOperatorId(operatorId);
        entity.setOperatorName(operatorName);
        entity.setPoints((long) points);
        entity.setCreatedTime(businessCreatedTime);
        entity.setCreated(entity.getCreatedTime());


        return entity;
    }
}
