package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.utils.PointUtils;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@Data
@TableName(value = "tlk_device_comminicated_logs_detail",autoResultMap = true)
public class DeviceCommunicatedLogDetailEntity extends EntityAbstract implements Aggregate {

    @TableId(value = "ID")
    private String id;

    @TableField(value = "ITEM_PK_ID")
    private Long pkId;
    @TableField(value = "ITEM_BEGIN_TIME")
    private Timestamp beginTime;
    @TableField(value = "ITEM_END_TIME")
    private Timestamp endTime;
    @TableField(value = "ITEM_TYPE", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private CommunicatedType communicatedType;
    @TableField(value = "ITEM_CALLER_USER_ID")
    private String callerUserId;
    @TableField(value = "ITEM_CALLER_USER_NAME")
    private String callerUserName;
    @TableField(value = "ITEM_CALLER_DEVICE_PK_ID")
    private String callerDevicePkId;
    @TableField(value = "ITEM_CALLER_DEVICE_NO")
    private String callerDeviceNo;
    @TableField(value = "ITEM_CALLER_COMPANY_NAME")
    private String callerCompanyName;

    @TableField(value = "ITEM_CALLED_USER_ID")
    private String calledUserId;
    @TableField(value = "ITEM_CALLED_USER_NAME")
    private String calledUserName;

    @TableField(value = "ITEM_CALLED_DEVICE_NO")
    private String calledDeviceNo;
    @TableField(value = "DOMAINID")
    private String domainId;
    @TableField(value = "ITEM_DOMAIN_ID")
    private String callerDomainId;

    @TableField(value = "ITEM_CALLED_DOMAIN_ID")
    private String calledDomainId;
    @TableField(value = "ITEM_TENCENT_USER_ID")
    private String tencentUserId;
    @TableField(value = "ITEM_TENCENT_USER_NAME")
    private String tencentUserName;
    @TableField(value = "ITEM_CALLED_COMPANY_NAME")
    private String calledCompanyName;

    @TableField(value = "ITEM_ROOM_ID")
    private String roomId;

    @TableField(value = "ITEM_CREATED_TIME")
    private Timestamp createdTime;

    @TableField(value = "ITEM_DISPATCH_TIME")
    private int dispatchTimeInMinutes;
    @TableField(value = "ITEM_CONSUME_VALUE")
    private int points;

    @TableField(value = "ITEM_DEVICE_COMMINICATED_LOG_ID")
    private String deviceCommunicatedLogId;

    @TableField(value = "FORMID")
    private String formId;
    @TableField(value = "LASTMODIFIED")
    private Timestamp lastModified;

    @TableField(value = "CREATED")
    private Timestamp created;

    @TableField(value = "LASTFLOWOPERATION")
    private String lastFlowOperation;

    /**
     * 是否为发起方付钱
     */
    @TableField(value = "ITEM_IS_PAID_BY_CALLER")
    private boolean paidByCaller;

    /**
     * 调度方的机构类型
     */
    @TableField(value = "ITEM_CALLER_ORG_INSTITUTIONAL")
    private String callerOrgInstitutional;

    /**
     * 调度原因
     */
    @TableField(value = "ITEM_REFERENCE_TYPE", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DispatchReasonType referenceType;

    /**
     * 调度的引用Id
     */
    @TableField(value = "ITEM_REFERENCE_NUMBER")
    private String referenceNumber;

    /**
     * 调度台类型
     */
    @TableField(value = "desk_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DeskType deskType;

    @TableField(value = "ITEM_PROJECT_ID")
    private String projectId;

    @TableField(value = "ITEM_PROJECT_Name")
    private String projectName;

    protected DeviceCommunicatedLogDetailEntity(){}

    public DeviceCommunicatedLogDetailEntity(
            ConfigOfBillEntity config,
            DeskType deskType,
            Long pkId,
                                             String idPrefix,
                                             String roomId,
                                             CommunicatedType communicatedType,
                                             String callerUserId,
                                             String callerUserName,
                                             String callerDeviceNo,
                                             String callerCompanyName,
                                             String calledUserId,
                                             String calledUserName,
                                             String calledDeviceNo,
                                             String calledCompanyName,
                                             String callerDomainId,
                                             String calledDomainId,
                                             Timestamp beginTime,
                                             Timestamp endTime,
            DispatchReasonType referenceType,
            String referenceNumber,
            boolean isPaidByCaller,
            String callerOrgInstitutional,
            String projectId,
            String projectName
            ) {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setCreated(this.getCreatedTime());
        
        this.setFormId("__WI4bvTGo4YzPsRe1kXV");
        this.setId(String.format("%s--%s", idPrefix, this.getFormId()));
        this.setPkId(pkId);
        this.setLastFlowOperation("最新版本标记v1.2");

        this.setRoomId(roomId);

        this.setLastModified(this.getCreatedTime());
        this.setCommunicatedType(communicatedType);
        this.setCallerUserId(callerUserId);
        this.setCallerUserName(callerUserName);
        this.setCallerDeviceNo(callerDeviceNo);
        this.setCallerCompanyName(callerCompanyName);
        this.setCalledUserId(calledUserId);
        this.setCalledUserName(calledUserName);
        this.setTencentUserId(calledUserId);
        this.setTencentUserName(calledUserName);

        this.setCalledDeviceNo(calledDeviceNo);
        this.setCalledCompanyName(calledCompanyName);
        this.setCallerDomainId(callerDomainId);
        this.setDomainId(callerDomainId);
        this.setCalledDomainId(calledDomainId);
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
        this.setReferenceType(referenceType);
        this.setReferenceNumber(referenceNumber);
        this.setPaidByCaller(isPaidByCaller);
        this.setCallerOrgInstitutional(callerOrgInstitutional);
        this.setDeskType(deskType);
        this.setProjectId(projectId);
        this.setProjectName(projectName);

        /**
         * 针对无接听的情况; 调度时间为0
         */
        if (beginTime == null && endTime == null) {
            this.setDispatchTimeInMinutes(1);
            this.setPoints(-1);
        } else if (endTime == null) {
            /**
             * 未接听的按照一个联动值来计算： B202401044120-未接通按照一个联动值计算
             */
            int dispatchTimeInMinutes = 1;
            this.setDispatchTimeInMinutes(dispatchTimeInMinutes);
            /*
            int points = PointUtils.translate2Points(
                    config,
                    this.getCommunicatedType(), dispatchTimeInMinutes);

             */
            int points = -1;
            this.setPoints(points);
        } else {
            int dispatchTimeInMinutes = PointUtils.translate2DispatchTimeInMinutes(this.getBeginTime(), this.getEndTime());
            this.setDispatchTimeInMinutes(dispatchTimeInMinutes);
            int points = PointUtils.translate2Points(
                    config,
                    this.getCommunicatedType(), dispatchTimeInMinutes);
            this.setPoints(points);
        }
    }

    public void assignLogId(String logId) {
        this.setDeviceCommunicatedLogId(logId);
    }

    public void cleanPoints() {
        this.setPoints(0);
    }

    /**
     *
     * @param config
     * @param pkId
     * @param roomId
     * @param communicatedType
     * @param callerUserId
     * @param callerUserName
     * @param callerDeviceNo
     * @param callerCompanyName
     * @param calledUserId
     * @param calledUserName
     * @param calledDeviceNo
     * @param calledCompanyName
     * @param callerDomainId 调度的组织Id
     * @param calledDomainId
     * @param beginTime
     * @param endTime
     * @return
     */
    public static DeviceCommunicatedLogDetailEntity create(
            ConfigOfBillEntity config,
            DeskType deskType,
            Long pkId,
            String idPrefix,
            String roomId,
            CommunicatedType communicatedType,
            String callerUserId,
            String callerUserName,
            String callerDeviceNo,
            String callerCompanyName,
            String calledUserId,
            String calledUserName,
            String calledDeviceNo,
            String calledCompanyName,
            String callerDomainId,
            String calledDomainId,
            Timestamp beginTime,
            Timestamp endTime,
            DispatchReasonType referenceType,
            String referenceNumber,
            boolean isPaidByCaller,
            String callerOrgInstitutional,
            String projectId,
            String projectName
            ) {
        DeviceCommunicatedLogDetailEntity entity =
                new DeviceCommunicatedLogDetailEntity(
                        config,
                        deskType,
                        pkId,
                        idPrefix,
                        roomId,
                        communicatedType,
                        callerUserId, callerUserName,
                        callerDeviceNo,
                        callerCompanyName,
                        calledUserId, calledUserName,
                        calledDeviceNo,
                        calledCompanyName,
                        callerDomainId,
                        calledDomainId,
                        beginTime, endTime,
                        referenceType,
                        referenceNumber,
                        isPaidByCaller,
                        callerOrgInstitutional,
                        projectId,
                        projectName
                );

        return entity;
    }

    public DeviceCommunicatedLogDetailEntity copy(
            ConfigOfBillEntity config,
            Long pkId,
            String idPrefix,
            String calledUserId,
                      String calledUserName,
                      String calledDeviceNo,
                      String calledCompanyName,
                      String calledDomainId,
                      Timestamp beginTime,
                      Timestamp endTime
    ) {
        DeviceCommunicatedLogDetailEntity copy =
                DeviceCommunicatedLogDetailEntity.create(
                        config,
                        deskType,
                        pkId, idPrefix,
                        roomId, communicatedType, callerUserId,
                        callerUserName, callerDeviceNo, callerCompanyName,
                        calledUserId, calledUserName, calledDeviceNo,
                        calledCompanyName, domainId, calledDomainId,
                        beginTime, endTime, this.getReferenceType(), this.getReferenceNumber(),
                        this.isPaidByCaller(),
                        this.getCallerOrgInstitutional(),
                        projectId,
                        projectName
                );

        return copy;
    }
}