package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import lombok.Data;

@TableName(value = "tlk_config_of_bill",autoResultMap = true)
@Data
public class ConfigOfBillEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "id")
    private String id;

    //签到签退计费操作次数
    @TableField(value = "ITEM_SIGN_DO")
    private Integer signDo;
    //签到签退计费消耗联动值
    @TableField(value = "ITEM_SIGN_MINUTE_PERSON")
    private Integer signMinutePerson;
    //签到签退月账单生成日期
    @TableField(value = "ITEM_SIGN_GENERATE_BILL_MOUTH")
    private Integer signGenBillMonth;

    //点名轮换计费操作次数
    @TableField(value = "ITEM_CALL_DO")
    private Integer callDo;
    //点名轮换计费消耗联动值
    @TableField(value = "ITEM_CALL_MINUTE_PERSON")
    private Integer callMinutePerson;
    //点名轮换月账单生成日期
    @TableField(value = "ITEM_CALL_GENERATE_BILL_MOUTH")
    private Integer callGenBillMonth;

    //轨迹查询计费操作次数
    @TableField(value = "ITEM_TRACK_DO")
    private Integer trackDo;
    //轨迹查询计费消耗联动值
    @TableField(value = "ITEM_TRACK_MINUTE_PERSON")
    private Integer trackMinutePerson;
    //轨迹查询月账单生成日期
    @TableField(value = "ITEM_TRACK_GENERATE_BILL_MOUTH")
    private Integer trackGenBillMonth;

    //电子围栏计费操作次数
    @TableField(value = "ITEM_FENCE_DO")
    private Integer fenceDo;
    //电子围栏计费消耗联动值
    @TableField(value = "ITEM_FENCE_MINUTE_PERSON")
    private Integer fenceMinutePerson;
    //电子围栏月账单生成日期
    @TableField(value = "ITEM_FENCE_GENERATE_BILL_MOUTH")
    private Integer fenGenBillMonth;

    //音频消耗联动值
    @TableField(value = "ITEM_AUDIO_MINUTE_PERSON")
    private Integer audioMinutePerson;
    //音频月账单生成日期
    @TableField(value = "ITEM_AUDIO_GENERATE_BILL_MOUTH")
    private Integer audioBillMonth;

    //视频消耗联动值
    @TableField(value = "ITEM_VIDEO_MINUTE_PERSON")
    private Integer videoMinutePerson;
    //视频月账单生成日期
    @TableField(value = "ITEM_VIDEO_GENERATE_BILL_MOUTH")
    private Integer videoBillMonth;

    private static ConfigOfBillEntity _defaultOne;
    public static ConfigOfBillEntity getDefault() {
        if (_defaultOne == null) {
            ConfigOfBillEntity configOfBillEntity = new ConfigOfBillEntity();
            configOfBillEntity.setAudioMinutePerson(2);
            configOfBillEntity.setVideoMinutePerson(8);

            _defaultOne = configOfBillEntity;
        }

        return _defaultOne;
    }
}
