package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Date;

@TableName(value = "bill_status_checkpoint",autoResultMap = true)
@Data
public class BillStatusCheckpointEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "pk_id")
    private Integer id;

    @TableField(value = "organization_id")
    private String organizationId;

    /**
     * 0,日账单；1，月账单
     */
    @TableField(value = "type")
    private Integer type;

    @TableField(value = "bill_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private BillType billType;
    @TableField(value = "last_update_date")
    private Date lastUpdate;

    public static BillStatusCheckpointEntity create(Integer id,
                                                    String organizationId,
                                                    Integer type,
                                                    BillType billType,
                                                    Date lastUpdate){
        BillStatusCheckpointEntity checkpoint = new BillStatusCheckpointEntity();
        checkpoint.setId(id);
        checkpoint.setOrganizationId(organizationId);
        checkpoint.setType(type);
        checkpoint.setBillType(billType);
        checkpoint.setLastUpdate(lastUpdate);
        return checkpoint;
    }
}
