package com.bcxin.tenant.open.domains.dtos;

import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import lombok.Getter;

@Getter
public class LogoSettingDTO {
    private final String deviceNo;
    private final DispatchAccountType deviceType;
    private final String logo;
    private final String title;
    private final String operatorId;
    private final String operatorName;

    private final String alarmBell;

    public LogoSettingDTO(String deviceNo, DispatchAccountType deviceType, String logo, String title, String operatorId, String operatorName,
                          String alarmBell) {
        this.deviceNo = deviceNo;
        this.deviceType = deviceType;
        this.logo = logo;
        this.title = title;
        this.operatorId = operatorId;
        this.operatorName = operatorName;
        this.alarmBell = alarmBell;
    }

    public static LogoSettingDTO create(String deviceNo, DispatchAccountType deviceType, String logo, String title, String operatorId, String operatorName,
                                        String alarmBell){
        return new LogoSettingDTO(deviceNo,deviceType,logo,title,operatorId,operatorName,alarmBell);
    }
}
