package com.bcxin.tenant.open.domains.dtos;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.time.DateUtils;

import java.io.Serializable;
import java.sql.Timestamp;

@Getter
@Setter(AccessLevel.PRIVATE)
public class CalculateCommunicatedDTO implements Serializable {
    private final Timestamp beginTime;
    private  Timestamp endTime;

    private final String calledUserId;

    /**
     * 用于计算时间段
     * @param endTime
     */
    public void updateSwitchMaxEndTime(Timestamp endTime) {
        if(endTime!=null) {
            this.setEndTime(endTime);
        }
    }

    public CalculateCommunicatedDTO(Timestamp beginTime, Timestamp endTime, String calledUserId) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.calledUserId = calledUserId;
    }

    public static CalculateCommunicatedDTO create(Timestamp beginTime, Timestamp endTime, String calledUserId) {
        return new CalculateCommunicatedDTO(beginTime, endTime, calledUserId);
    }
}
