package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import lombok.Getter;

import java.util.Date;

@Getter
public class MyDispatchLogRecordCriteria extends CriteriaAbstract {

    private final String employeeId;

    private final Date beginDate;

    private final Date endDate;

    public MyDispatchLogRecordCriteria(String employeeId, Date beginDate, Date endDate) {
        this.employeeId = employeeId;
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    public static MyDispatchLogRecordCriteria create(String employeeId, Date beginDate, Date endDate) {
        return new MyDispatchLogRecordCriteria(employeeId, beginDate, endDate);
    }
}
