package com.bcxin.tenant.open.domains;

import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import lombok.AccessLevel;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

@Getter(AccessLevel.PRIVATE)
public class BillPaymentRuleConfig {
    private final Collection<String> paidByCallerRegionExpressions;
    private final boolean ignoredCalledPoints;

    public BillPaymentRuleConfig(Collection<String> paidByCallerRegionExpressions, boolean ignoredCalledPoints) {
        this.paidByCallerRegionExpressions = paidByCallerRegionExpressions;
        this.ignoredCalledPoints = ignoredCalledPoints;
    }

    /**
     * 返回: 是否为支付方
     * 目前: 内保单位发起调度/轨迹查询/..; 由内保单位付款、活动承办商发起的由他来支持
     * 监管单位发起调度/轨迹查询/...; 北京地区由监管付费
     * @param sponsorOrgInstitutional 发起方的机构类型
     * @param sponsorSuperviseRegionCode 发起方的监管区域编码
     * @return
     *   发起方作为支付方则返回true; 否则为调度方付款
     *   返回false的话; 表示此为企业调度; 走原本的企业付费
     */
    public boolean isPaymentOwner(
            String sponsorOrgInstitutional,
            String sponsorSuperviseRegionCode) {
        if (BusinessUtil.isProprietor(sponsorOrgInstitutional) ||
                BusinessUtil.isEventSponsor(sponsorOrgInstitutional)
        ) {
            return true;
        }

        if(BusinessUtil.isSupervise(sponsorOrgInstitutional) && !CollectionUtils.isEmpty(this.getPaidByCallerRegionExpressions())) {
            boolean matched = this.getPaidByCallerRegionExpressions()
                    .stream().anyMatch(ii -> sponsorSuperviseRegionCode.startsWith(ii));

            return matched;
        }

        /**
         * 走普通的监管/企业模式; 也就是自己调用; 自己付钱
         */
        return false;
    }


    public boolean isPaymentOwner(
            String sponsorOrgId,
            String sponsorOrgInstitutional,
            String sponsorSuperviseRegionCode) {
        return isPaymentOwner(sponsorOrgInstitutional,sponsorSuperviseRegionCode);
    }

        public boolean ignoreCheckUserPoints(boolean paymentOwner) {
        return this.isIgnoredCalledPoints();
    }
}
