package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.SecurityServicek;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 保安服务公司设立信息解析
 */

@Data
public class SecurityServicekDto {

    /**
     * 1、选择办事区域
     */
    //所属监管机构
    private String item_officePoliceAddress;
    // 公司类型
    private String item_company_type;
    /**
     * 2、填写单位基本信息
     */
    //申请单位名称
    private String item_companyName;
    //办公住所
    private String item_address;
    //注册资本（万元）
    private String item_registeredCapital;
    //申请服务范围
    private  List<String> item_businessScope;
    /**
     * 3、填写法定代表人信息
     */
    //姓名
    private String  item_legalName;
    //性别
    private String  item_legalSex;
    //民族
    private String  item_nation;
    //政治面貌
    private String  item_identity;
    //文化程度
    private String item_education;
    //保安师资格证编号
    private String item_vocational_certificate;
    //联系方式
    private String  item_hunan_telephone;
    //证件类型
    private String item_legalType;
    //证件号码
    private String  item_legalCardnumber;
    /**
     *4、填写股东信息
     */
    private List<ShareholderDto> item_shareholder;

    /**
     * 5、填写主要管理人员及技术人员信息
     */
    List<ManagerInfoDto> txzyglry;

    /**
     * 6、填写许可证领取方式
     */
    //新证领取方式
    private String  item_claim_way;
    //领取地址
    private String  xzlqdz;
    //收件人
    private String  jzsjr;
    //手机号
    private String  agentPhone_2;
    //收件地址
    private String  sjdz;
    /**
     * 7、经办人信息
     */
    //姓名
    private String item_applicant_name;
    //联系电话
    private String  item_applicant_phone;

    /**
     * 8、承诺上述填报信息真实有效
     */
    //承诺上述填报信息真实有效
    private String item_premit;



    public SecurityServicek convert(Notice notice){
        SecurityServicek securityServicek  = new SecurityServicek();
        Date now  =new Date();
        //审核数据
        securityServicek.setItemAuditStatus("3");
        //保安服务公司设立申请表  表单需求数据
        securityServicek.setID(StrUtil.join("--",notice.getTaskId(), OnlineTaskConstant.SECURITY_SERVICE_K));
        securityServicek.setCreated(now);
        securityServicek.setLastmodified(now);
        securityServicek.setFormname("许可申报/保安服务许可申报/SecuritySeviceCompany");
        securityServicek.setFormid(OnlineTaskConstant.SECURITY_SERVICE_K);
        securityServicek.setIstmp(true);
        securityServicek.setApplicationid("__JvOHkqjhV41mUo4ITRv");
        securityServicek.setDomainid("__UDa4uPMdcOYgP7HETaf");
        securityServicek.setItemRegion("湖南省");
        securityServicek.setIsdelivery("0");
        //办件数据
        securityServicek.setTaskId(notice.getTaskId());

        //业务数据
        //办事区域
        securityServicek.setItemOfficePoliceAddress(this.getItem_officePoliceAddress());
        securityServicek.setItemSevicepermittype(this.getItem_company_type());
        //单位基本信息
        securityServicek.setItemCompanyName(this.getItem_companyName());
        //办公住所格式化
        AddressDto addressDto = JSON.parseObject(this.getItem_address(), AddressDto.class);
        securityServicek.setItemAddress(addressDto.convert());
        securityServicek.setItemRegisteredCapital(this.getItem_registeredCapital());
        securityServicek.setItemBusinessScope(OnlineTaskUtil.scopConvert(this.getItem_businessScope()));

        //法定代表人信息
        securityServicek.setItemLegalName(this.getItem_legalName());
        securityServicek.setItemSex(this.getItem_legalSex());
        securityServicek.setItemNation(this.getItem_nation());
        securityServicek.setItemIdentity(OnlineTaskUtil.identConvert(this.getItem_identity()));
        securityServicek.setItemEducation(OnlineTaskUtil.eduConvert(this.getItem_education()));
        securityServicek.setItemVocationalCertificate(this.getItem_vocational_certificate());
        securityServicek.setItemLegalPhone(this.getItem_hunan_telephone());
        securityServicek.setItemDocumentType(OnlineTaskUtil.idCardTypeConvert(this.getItem_legalType()));
        securityServicek.setItemLegalCardnumber(OnlineTaskUtil.decrypt(this.getItem_legalCardnumber()));
       //股东信息
        //只要技术管理人员信息

        //许可证领取方式
        securityServicek.setItemClaimWay(this.getItem_claim_way());
//        securityServicek.setItemValue(this.getXzlqdz());
        securityServicek.setItemRecipient(this.getJzsjr());
        securityServicek.setItemRecipientPhone(this.getAgentPhone_2());
        if (this.getItem_claim_way().equals("1")){
            securityServicek.setItemRecipientAddress(this.getXzlqdz());
        }else {
            securityServicek.setItemRecipientAddress(this.getSjdz());
        }
        //填写经办人信息
        securityServicek.setItemApplicantName(this.getItem_applicant_name());
        securityServicek.setItemApplicantPhone(this.getItem_applicant_phone());

        //承诺上述填报信息真实有效
        securityServicek.setItemPermit("");
        return  securityServicek;
    }





}
