package com.bcxin.backend.certificateSignatures;

public interface CertificateSignatureProvider {
    /**
     * 准备待签章的数据
     */
    void step1_prepareData();

    /**
     * 根据队列生成PDF数据
     */
    void step2_generatePdf();

    /**
     * 执行签章操作
     */
    void step3_doSignature();

    /**
     * 将已签章的文件上传到百保盾监管系统的目录并更改证书信息表及状态
     */
    void step4_moveOutDocument2BusinessDirAndFinishSignature();

    /**
     * 针对签章异常:
     * 1、PDF生成但是签章异常的情况
     */
    void step5_doneForExceptionData();
}
