package com.bcxin.backend.domain.utils;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.edis.EDIConstants;
import com.bcxin.backend.domain.signature.service.impls.BeiJingInJTLZServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class JTLZBodyUtil {
    private static final Logger logger = LoggerFactory.getLogger(JTLZBodyUtil.class);
    public static String license_issue(String serviceCode, String serviceName, String sealCode, JSONObject data_field, BeiJingInJTLZServiceImpl.OperatorData operatorData, List<BeiJingInJTLZServiceImpl.FileData> fileDataList) {
        // 生成 token 的逻辑
        String license_code = "";
        try {
            JSONObject data = new JSONObject();
            JSONObject json = new JSONObject();
            json.put(EDIConstants.PARAM_API_LIANG_ZHENG_SERVICE_ITEM_CODE, serviceCode);// 事项编码
            json.put(EDIConstants.PARAM_API_LIANG_ZHENG_SERVICE_ITEM_NAME, serviceName);//事项名称
            json.put("license_group", "组别1");//照面模版组别名称
            json.put(EDIConstants.PARAM_API_LIANG_ZHENG_BIZ_NUM, UUID.randomUUID().toString());
            JSONObject operator = new JSONObject();
            operator.put("account", operatorData.getAccount());
            operator.put("name", operatorData.getName());
            operator.put("identity_num", operatorData.getIdcardno());
            operator.put("role", operatorData.getRoleName());
            operator.put("service_org", operatorData.getOrgName());
            operator.put("division", operatorData.getRegionName());
            operator.put("division_code", operatorData.getRegionCode());
            json.put("operator", operator);
            json.put("data_fields", data_field);
            json.put("seal_code", sealCode);//章编码
            json.put("sign_attach", false);
            JSONArray attachments = new JSONArray();
            JSONObject attachment;
            for (BeiJingInJTLZServiceImpl.FileData fileData : fileDataList){
                attachment = new JSONObject();
                attachment.put("is_show_template", "true");
                attachment.put("is_license_image", "true");
                attachment.put("file_type", fileData.getFiletype());
                attachment.put("name", fileData.getFilename());
                attachment.put("description", fileData.getDescription());
                attachment.put("file_data", fileData.getFilebase64());
                attachments.add(attachment);
            }
            json.put("attachments", attachments);
            data.put("data", json);
            String body = data.toJSONString();

            return body;
        } catch (Exception e) {
            logger.error("====> 京通靓证信息推送定时任务.license_issue.error:", e);
            return license_code;
        }
    }

    /**
     * <b> 京通靓证(废止)同步报文业务组装 </b>
     * @author ZXF
     * @create 2024/11/20 0020 17:33
     * @version
     * @注意事项 </b>
     */
    public static String license_issue_fz(String serviceCode,String serviceName,String idCode) {
        logger.error("====> 京通靓证信息废止定时任务.license_issue_fz.star---------");
        // 生成 token 的逻辑
        String license_code = "";
        try {
            BeiJingInJTLZServiceImpl.OperatorData operatorData =
                    BeiJingInJTLZServiceImpl.OperatorData.fixedOperatorData();

            JSONObject data = new JSONObject();
            JSONObject json = new JSONObject();
            json.put("id_code", idCode);// 证照号码
            json.put(EDIConstants.PARAM_API_LIANG_ZHENG_SERVICE_ITEM_CODE, serviceCode);// 事项编码
            json.put(EDIConstants.PARAM_API_LIANG_ZHENG_SERVICE_ITEM_NAME, serviceName);//事项名称
            json.put(EDIConstants.PARAM_API_LIANG_ZHENG_BIZ_NUM, UUID.randomUUID().toString());
            JSONObject operator = new JSONObject();
            operator.put("account", operatorData.getAccount());
            operator.put("name", operatorData.getName());
            operator.put("identity_num", operatorData.getIdcardno());
            operator.put("role", operatorData.getRoleName());
            operator.put("service_org", operatorData.getOrgName());
            operator.put("division", operatorData.getRegionName());
            operator.put("division_code", operatorData.getRegionCode());
            json.put("operator", operator);
            data.put("data", json);
            String body = data.toJSONString();
            logger.error("====> 京通靓证信息废止定时任务.license_issue_fz.请求报文：{}" , body);

            return body;
        } catch (Exception e) {
            logger.error("====> 京通靓证信息废止定时任务.license_issue_fz.error:{}", serviceCode, e);

            return license_code;
        }
    }
}
