package com.bcxin.backend.domain.models;

import cn.hutool.core.date.DateUtil;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * 工作事项通知、提醒
 * @author Happy
 *
 */
@Data
@Entity
@Table(name="mc_notice")
public class NoticeDto extends EntityBase<String> implements IAggregate {

	/**
	 *
	 */
	private static final long serialVersionUID = -4836070850643712525L;

	@Id
	private String id;

	/**
	 * 通知摘要
	 */
	@Column(name="SUMMARY")
	private String summary;
	
	/**
	 * 通知内容（JSON格式）
	 */
	@Column(name="CONTENT")
	private String content;

	/**
	 * 接收用户id
	 */
	@Column(name="TO_USER_ID")
	private String toUserId;
	
	/**
	 * 创建时间
	 */
	@Column(name="CREATE_TIME")
	private Date createTime; 
	
	/**
	 * 是否已读
	 */
	@Column(name="IS_READ")
	private boolean read;
	
	/**
	 * 通知来源（功能模块）
	 */
	@Column(name="MODULE")
	private String module;

	/**
	 * 工作事项链接参数（JSON格式）
	 */
	@Column(name="LINK_PARAMS")
	private String linkParams;
	
	/**
	 * 类型
	 */
	@Column(name="SUBJECT_TYPE")
	private int subjectType;

	@Column(name="DOMAIN_ID")
	private String domainid;


	public NoticeDto(){}

	public NoticeDto(String id,
					 String content,
					 String toUserId,
					 String domainid){
		this.id = id;
		this.content = "{\"content\":\""+content+"\"}";
		this.toUserId = toUserId;
		this.domainid = domainid;
		this.setRead(false);
		this.setSubjectType(1);
		this.setCreateTime(DateUtil.date());
	}
}
