package com.bcxin.backend.domain.approval.entities.source;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;


@Data
@Table(name = "approval_data_bj")
@Entity
public class BjApprovalDataEntity {
    @Id
    @Column(name = "id")
    private String id;

    @Column(name = "item_type")
    private String type;

    @Column(name = "ITEM_COMPANYNAME")
    private String companyName;

    @Column(name = "ITEM_OFFICEPOLICEADDRESSID")
    private String officePoliceId;

    @Column(name = "ITEM_OFFICEPOLICEIDINDEX")
    private String officePoliceIdIndex;

    @Column(name = "ITEM_AUDITSTATUS")
    private String auditStatus;

    @Column(name = "created")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createdTime;

    @Column(name = "ITEM_Approval_End_Time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approvalEndTime;

    @Column(name = "item_applicant_name")
    private String applicantName;

    @Column(name = "item_applicant_idCardNumber")
    private String applicantIdCardNumber;

    @Column(name = "lastmodified")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastModified;

    @Column(name = "item_policeOrgName")
    private String orgName;
    @Column(name = "item_policeStation")
    private String policeStation;

}
