<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<table class="table">
	<thead>
		<tr>
			<th>用户名</th>
			<th>企业名称</th>
			<th>所在省市</th>
			<th>统一社会信用码</th>
			<th>账户状态</th>
			<th>资料审核状态</th>
			<th>银行账户验证结果</th>
			<th>注册时间</th>
			<th>操作</th>
		</tr>
	</thead>
	<tbody>
	<c:choose>
		<c:when test="${empty userList }">
			<tr><td colspan="9" style="text-align: center;">无查询结果</td></tr>
		</c:when>
		<c:otherwise>
			<c:forEach items="${userList }" var="companyUser">
				<tr>
					<td>${companyUser.userName }</td>
					<td>${companyUser.company.fullName }</td>
					<td>${companyUser.company.provinceName }${companyUser.company.cityName }</td>
					<td>${companyUser.company.idNumber }</td>
					<td>${companyUser.userStatus.name }</td>
					<td>${companyUser.company.bankStatus.name }</td>
					<td>${companyUser.company.companyStatus.name }</td>
					<td><fmt:formatDate pattern='yyyy-MM-dd' value='${companyUser.registerDate }'/></td>
					<td>
						<a href="javascript:void(0);" onclick="showCompanyDetail('${companyUser.company.oid}');" class="check-chit">详情</a>
						<c:if test="${companyUser.userStatus eq 'DISCARD' && companyUser.company.bankStatus eq 'PASS' && companyUser.company.companyStatus eq 'PASS' }">
						<a href="javascript:void(0);" onclick="activate('${companyUser.oid}');" class="check-chit" style="margin-bottom:10px">激活该账号</a>
						</c:if>
						<c:if test="${companyUser.userStatus eq 'ACTIVATE' && companyUser.company.bankStatus eq 'PASS' && companyUser.company.companyStatus eq 'PASS' }">
						<a href="javascript:void(0);" onclick="discard('${companyUser.oid}');" class="check-chit" style="margin-bottom:10px">失效该账号</a>
						</c:if>
					</td>
				</tr>
			</c:forEach>
		</c:otherwise>
	</c:choose>
	</tbody>
</table>
