<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
</head>
<body>
<form id="companyForm">
<div class="container">
<input name="oid" value="${company.oid }" type="hidden">
<div class="message-war"><!-- message-war start -->
	<div class="w-95-auto"><!-- w-95-auto start -->
		<div class="mess-title"><h3>企业信息</h3></div>
		<div class="affirm-warr">
			<table class="table ">
				<tbody> 
					<tr>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">企业名称</td>
                           <td class="col-sm-4 col-xs-4">${ company.fullName }</td>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">所在省市</td>
                           <td class="col-sm-4 col-xs-4">${ company.provinceName }${ company.cityName }</td>
                       </tr>
					<tr>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">统一社会信用码/注册号/组织机构代码证号</td>
                           <td class="col-sm-4 col-xs-4">${ company.idNumber }</td>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">企业电话</td>
                           <td class="col-sm-4 col-xs-4">${ company.bidPhone }</td>
                       </tr>
                  	</tbody>
			</table>
		</div>
		<div class="mess-title"><h3>企业银行账户信息</h3></div>
		<div class="affirm-warr">
			<table class="table ">
                      <tbody> 
					<tr>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">账户名</td>
                           <td class="col-sm-4 col-xs-4">${ company.accountName }</td>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">开户行</td>
                           <td class="col-sm-4 col-xs-4">${ company.bankName }</td>
                       </tr>
					<tr>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">帐号</td>
                           <td class="col-sm-4 col-xs-4">${ company.bankCard }</td>
                           <td class="tablebg_f5f8fa col-sm-2 col-xs-2">&nbsp;</td>
                           <td class="col-sm-4 col-xs-4">&nbsp;</td>
                       </tr>
                  	</tbody>
			</table>
		</div>
		<div class="mess-title"><h3> 联系人信息</h3></div>
		<div class="affirm-warr">
			<table class="table ">
                    <tbody> 
	                    <tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">姓名</td>
							<td class="col-sm-4 col-xs-4">${ company.linkman }</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">电话</td>
							<td class="col-sm-4 col-xs-4">${ company.linkphone }</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮编</td>
							<td class="col-sm-4 col-xs-4">${ company.zipcode }</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮箱</td>
							<td class="col-sm-4 col-xs-4">${ company.linkEmail }</td>
						</tr>
                  	</tbody>
			</table>
		</div>
		
		<div class="mess-title"><h3> 企业资料</h3></div>
		<div class="affirm-warr">
			<table class="table ">
                      <tbody> 
                       <tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">组织机构代码证</td>
						<td class="col-sm-4 col-xs-4">
							<c:if test="${not empty company.organizingPath }">
								<a href="javascript:void(0);" onclick="viewImg('${ company.organizingPath }')">预览</a>
							</c:if>
						</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业执照</td>
						<td class="col-sm-4 col-xs-4">
							<c:if test="${not empty company.businessPath }">
								<a href="javascript:void(0);" onclick="viewImg('${ company.businessPath }')">预览</a>
							</c:if>
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">税务登记证</td>
						<td class="col-sm-4 col-xs-4">
							<c:if test="${not empty company.taxPath }">
								<a href="javascript:void(0);" onclick="viewImg('${ company.taxPath }')">预览</a>
							</c:if>
						</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">&nbsp;</td>
						<td class="col-sm-4 col-xs-4">&nbsp;</td>
					</tr>
                  	</tbody>
			</table>
		</div>
		<div class="mess-title"><h3> 审核操作</h3></div>
		<div class="affirm-warr" style="height: 80px;">
			<div class="col-sm-6 col-xs-6">
				<p>资料审核结果</p>
				<select name="companyStatus" id=companyStatus class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
					<option value="">--请选择--</option>
					<c:forEach items="${reviewStatusList }" var="companyStatus">
						<option value="${companyStatus }" ${company.companyStatus eq companyStatus ? "selected=selected":"" }>${companyStatus.name }</option>
					</c:forEach>
				</select> 
			</div> 
			<div class="col-sm-6 col-xs-6">
				<p>银行账户是否通过验证</p>
				<select name="bankStatus" id=bankStatus class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
					<option value="">--请选择--</option>
					<c:forEach items="${reviewStatusList }" var="bankStatus">
						<option value="${bankStatus }" ${company.bankStatus eq bankStatus ? "selected=selected":"" }>${bankStatus.name }</option>
					</c:forEach>
				</select> 
			</div>
		</div>
	</div><!-- w-95-auto end -->
</div>
</div>
<div class="modal-footer">
				<div class="mofo-sub" style="text-align: center;">
					<button type="button" class="btn notarize-btn" onclick="identification();">确认</button>
				</div>
			  </div> 
</form>
<div style="display: none;" id="imgDiv" class="layui-layer-wrap"><img id="viewImgID" src=""></div>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/hover-dropdown.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script>
	var baseUrl = '${pageContext.request.contextPath }';
	var indexIframe = parent.layer.getFrameIndex(window.name); //获取窗口索引

	var imgHeight = 0;
	var imgWidth = 0;

	function getImageWidth(url, callback) {
		var img = new Image();
		img.src = url;
		// 如果图片被缓存，则直接返回缓存数据
		if (img.complete) {
			callback(img.width, img.height);
		} else {
			// 完全加载完毕的事件
			img.onload = function() {
				callback(img.width, img.height);
			}
		}
	}

	function viewImg(imgPath) {
		imgHeight = 0;
		imgWidth = 0;
		$("#viewImgID").attr("src", imgPath);
		getImageWidth(imgPath,function(w,h){
			//console.log({width:w,height:h});
			imgHeight = h;
	    	imgWidth = w;
	    	
	    	if(imgWidth >0 && imgHeight > 0){
	    		var body = parent.layer.getChildFrame('body', indexIframe);
			    var iframeHeight = body.height();
			    var iframeWidth = body.width();
	    		if(imgHeight > iframeHeight-50)
	    			imgHeight = '90%';
	    		if(imgWidth > iframeWidth-50)
	    			imgWidth = '90%';

				layer.open({
					type : 1,
					title : false,
					closeBtn : 1,
					area : [ imgWidth, imgHeight ],
					skin : 'layui-layer-nobg', //没有背景色
					shadeClose : true,
					scrollbar : false,
					content : $("#imgDiv")
				});
			}
		});

	}

	function identification() {
		var index = layer.load(0, {shade : [ 0.3, '#808080' ]});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/user/reviewCompanyInfo.json",
			data : $("#companyForm").serialize(),
			dataType : "json",
			success : function(data) {
				layer.close(index);
				layer.msg(data.message);
				if(data.status=="200"){
					parent.submitOrderForm();
					parent.layer.close(indexIframe);
				}
			},
			error : function() {
				layer.close(index);
			}
		});
	}
</script>
</body>
</html>