<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-对帐报表</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<style type="text/css">
		.myContainer {
			padding-right: 15px;
			padding-left: 15px;
			margin-right: auto;
			margin-left: auto;
			background: #eff3f6;
		}
		.lay-bak {
			padding-right: 15px;
			padding-left: 15px;
			margin-right: auto;
			margin-left: auto;
			background: #eff3f6;
		}
	</style>
	<body>
		<div class="container-fluid">
			<jsp:include page="../pcHeader.jsp"/>
			<form id="advanceForm">
			<div class="mar-content mt-80">
				<!-- 我的账户-业务查询 start -->
				<div class="container-fluid">
					<div class="tender-war clearfix">
						<div class="query-criteria">
							<h4>查询条件</h4>
								<div class="qucr-sub clearfix">
									<div class="w-98-auto"> 
										<div class="col-sm-4 col-xs-4">
											<p>关键字</p>
											<input name="keywords" id="keywords" type="text" class="form-control" placeholder="产品名称/订单编号" />
										</div> 
										<div class="col-sm-2 col-xs-2">
											<p>状态</p>
											<select name="advanceStatus" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
												<option value="">全部</option>
												<c:forEach items="${advanceStatusList }" var="advanceStatus">
													<option value="${advanceStatus.value }">${advanceStatus.label }</option>
												</c:forEach>

											</select>
										</div>
										<div class="col-sm-4 col-xs-4">
											<p>日期选择</p>
											<div class="row">
												<div class="col-sm-5 col-xs-5"><input placeholder="" name="clearingStar" id="clearingStar" class="laydate-icon form-control"></div>
												<div class="col-sm-1 col-xs-1 lineation"><span></span></div>
												<div class="col-sm-5 col-xs-5"><input placeholder="" name="clearingEnd" id="clearingEnd" class="laydate-icon form-control"></div>
											</div>
										</div> 
										<div class="col-sm-2 col-xs-2">
											&nbsp;
										</div>

									</div>
								</div>
								<div class="btn-bottom pull-left">
									<p> <span>获得总佣金：${totalBrokerage} 元</span>&nbsp;&nbsp;<span>未结算佣金：${unBrokerage} 元</span> </p>
								</div>
								<div class="btn-bottom pull-right">
									<p><a href="javascript:submitAdvanceForm();" class="conserve pull-left">查询</a></p>
								</div>
						</div>
					</div>
					<div class="tender-war">
						<div class="query-criteria" id="queryResult">
						</div>
					</div>
				</div>
				<!-- 我的账户-业务查询 end -->
			</div><!-- mar-content 右边内容块 end -->
		</form>
		</div>
		<!-- 修改账户信息 start -->
		<div class="modal fade" id="revamp-bankCard" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
		   	<div class="modal-dialog" role="document">
				<div class="modal-content" id="revamp-bankCard-content">

				</div>
		  </div> 
		</div> 
		<!-- 修改账户信息 end -->
	</body>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/choice.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/reseller.js'/>"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
		choiseMenu("advance");
		
		//日期范围限制
		var clearingStar = {
		    elem: '#clearingStar',
		    format: 'YYYY-MM-DD',
		    max: '2099-06-16', //最大日期
		    istoday: false,
		    choose: function(datas){
		    }
		};
		var clearingEnd = {
		    elem: '#clearingEnd',
		    format: 'YYYY-MM-DD',
		    max: '2099-06-16',
		    istoday: false,
		    choose: function(datas){
		    }
		};
		Date.prototype.Format = function (fmt) { //author: meizz
		    var o = {
		        "M+": this.getMonth() + 1, //月份 
		        "d+": this.getDate(), //日 
		        "h+": this.getHours(), //小时 
		        "m+": this.getMinutes(), //分 
		        "s+": this.getSeconds(), //秒 
		        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
		        "S": this.getMilliseconds() //毫秒 
		    };
		    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
		    for (var k in o)
		    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		    return fmt;
		}
		laydate(clearingStar);
		laydate(clearingEnd);

	</script>
</html>

