<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-我的账户</title>
	<style>
		.ss-width{
			width: 156px !important;
			/*white-space: nowrap;
			overflow: hidden;
			text-overflow: ellipsis;*/
		}
		.ss-line{
			line-height: 24px !important;
			padding-top: 24px;
		}
		.tab-query .tab-con .con-s2 ul.tab-body li .no-cont a{
			margin-top: 0 !important;
		}
		.pagination{
			right: 0px;
		}
	</style>
</head>

<body style="position: relative">
<jsp:include page="../../index/multi_h.jsp"/>
<div class="container">
	<%--<div class="addr">
		<span>当前位置：</span>
		<span class="current">首页 > </span>
		<a class="active" href="#">我的账户</a>
	</div>--%>
	<jsp:include page="../../index/multi_pc_l.jsp"/>
	<!--右边内容块-->
	<div class="pp-content">
		<ul class="order-list wed-list" id="wed-list">
			<li class="active">理赔记录</li>
		</ul>
		<p class="pp-wert" style="left:123.5px;top:0;line-height:46px">理赔申请</p>
	</div>
	<div class="tab-query tab-order my-order">
		<div class="tab-con" id="tab-con">
			<div class="sdf">
				<div class="con-srt con-s2" style="display: block;">
					<div class="s-head clearfix">
						<div class="head-input fl">
							<span>关键字</span>
							<input type="text" id="keyword_it" value="${keyword}" placeholder="请填写报案号/保单号">
						</div>
						<div class="head-time fl">
							<span>报案时间</span>
							<input type="text" value="${startDate}" id="start-s2">
							<span class="sdf">至</span>
							<input type="text" value="${endDate}" id="end-s2">
						</div>
						<div class="head-status fl">
							<span>状态</span>
							<div class="status fr">
								<p id="status-xuan-s2" data-status="${pay_status }">
									<c:if test="${empty status}">请选择</c:if>
									<c:if test="${status eq '0'}">待提交</c:if>
									<c:if test="${status eq '1'}">审核中</c:if>
									<c:if test="${status eq '2'}">已结案</c:if>
								</p>
								<ul class="status-select" id="drag-s2">
									<li<c:if test="${empty status}"> class="active"</c:if> data-status="">请选择</li>
									<li<c:if test="${status eq '0'}"> class="active"</c:if> data-status="0">待提交</li>
									<li<c:if test="${status eq '1'}"> class="active"</c:if> data-status="1">审核中</li>
									<li<c:if test="${status eq '2'}"> class="active"</c:if> data-status="2">已结案</li>
								</ul>
							</div>
						</div>
						<div class="head-button fr" onclick="searchList()">
							<p>搜索</p>
						</div>
					</div>
					<div class="tab-content" id="reportsArea">
						<ul class="order-num wed-num">
							<li class="width-s3 ss-width">
								<span>案件号</span>
							</li>
							<li class="width-s3 ss-width">
								<span>保单号</span>
							</li>
							<li class="width-s3">
								<span>出险时间</span>
							</li>
							<li class="width-s3">
								<span>理赔金额（元）</span>
							</li>
							<li class="width-s3">
								<span>案件状态</span>
							</li>
							<li class="width-s3">
								<span>结案时间</span>
							</li>
							<li class="width-s3">
								<span>报案时间</span>
							</li>
							<li class="width-s3">
								<span>操作</span>
							</li>
						</ul>
						<ul class="tab-body">
							<c:choose>
								<c:when test="${empty reportList }">
									<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
										暂无记录！！
									</li>
								</c:when>
								<c:otherwise>
									<c:forEach items="${reportList }" var="report">
										<li class="clearfix">
											<div class="no-cont ss-width">
												<span>${empty report.report_no ? '-' : report.report_no }</span>
											</div>
											<div class="no-cont ss-width">
												<span>${report.policy_no }</span>
											</div>
											<div class="no-cont">
												<span class="ss-line">${empty report.accident_date ? '-' : report.accident_date }</span>
											</div>
											<div class="no-cont">
												<span>${empty report.check_loss_sum ? '-' : report.check_loss_sum }</span>
											</div>
											<div class="no-cont">
												<span>${fns:getDictLabel (report.status,"reportStatus","")}</span>
											</div>
											<div class="no-cont">
												<span class="ss-line">${empty report.end_case_date ? '-' : report.end_case_date }</span>
											</div>
											<div class="no-cont">
												<span class="ss-line">${empty report.report_date ? '-' : report.report_date }</span>
											</div>
											<div class="no-cont">
												<c:choose>
													<c:when test="${report.status eq '0' }">
														<a href="<c:url value='/pc/report/continueReport/${report.ins_common_report_id }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="a-progress">继续填写</a>
														<a href="javascript:;" onclick="deleteReport('${report.ins_common_report_id }');" class="pro-delete">删除</a>
													</c:when>
													<c:otherwise>
														<a href="<c:url value='/pc/report/getInsCommonReportByReportId/${report.ins_common_report_id }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="a-progress">详情</a>
													</c:otherwise>
												</c:choose>
											</div>
										</li>
									</c:forEach>
								</c:otherwise>
							</c:choose>
						</ul>
					</div>
					<!--分页-->
					<div class="filter-pagination" style="padding-top:10px;">
						<div id="callBackPager"></div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="clearfix"></div>
	<form id="reportForm" action="<c:url value='/pc/report/reportList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
		<input type="hidden" id="start_time" name="startDate" value="${startDate }"/>
		<input type="hidden" id="end_time" name="endDate" value="${endDate }"/>
		<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
		<input type="hidden" id="pay_status" name="status" value="${status }"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
</div>

<!--人员变更提示弹窗-->
<div class="personnel-changes animated" style="position: absolute!important;top:25%;">
	<div class="payment-head">
		<span>提示</span>
		<a href="javascript:;" id="personnel-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<div class="personnel-cont">
		<p>
			如需报案，请在“我的订单”中查询对应的保单<br/>
			点击“理赔申请”进入理赔申请流程！
		</p>
	</div>
	<div class="personnel-butt">
		<span class="personnel-bibi">关闭</span>
		<span class="personnel-wed" onclick="openPolicy()">进入“我的订单”</span>
	</div>
</div>

<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<jsp:include page="../../index/multi_f.jsp"/>
<script src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/corrections.js' />"></script>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;
    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("reportForm","reportsArea");
        }
    });
    function openPolicy(){
        location.href=baseUrl+'/pc/order/myOrder?policyStatus=21&ACCESS_TOKEN=${ACCESS_TOKEN}';
    }

    function searchList(){
        $("#start_time").val($("#start-s2").val());
        $("#end_time").val($("#end-s2").val());
        $("#keyword").val($("#keyword_it").val());
        $("#pageNum").val(1);
        $("#numPerPage").val(5);
        $("#totalCount").val(0);
        $("#pay_status").val($('.con-s2 #status-xuan-s2').attr('data-status'));
        $("#reportForm").submit();
    }

    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("reportForm","reportsArea");
            }
        });
    };


    function getListForPage(formId,contentId){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : baseUrl + "/pc/report/getReportListForPage",
            data : $("#"+formId).serialize(),
            dataType : "text",
            success : function(data) {
                layer.close(index);
                $("#"+contentId).html(data);
            },
            error: function(){
                layer.close(index);
            }
        });
    }

    function choisePolicyStatus(policyStatus,totalCount,obj){
        $(".order-list li").removeClass("active");
        $(obj).addClass("active");
        $("#policyStatus").val(policyStatus);
        $('#totalCount').val(totalCount);
        $('#pageNum').val("1");
        loadDataAndPage();
        getListForPage("reportForm","reportsArea");
    }

    function deleteReport(reportId){
        layer.confirm('确定删除此订单？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/report/deleteReport",
                data : {
                    "oid":reportId,
                },
                dataType : "json",
                success : function(data) {
                    layer.close(index);
                    layer.msg(data.message);
                    if(data.status =="200"){
                        getListForPage("reportForm","reportsArea");
                    }
                },
                error: function(){
                    layer.close(index);
                }
            });
        });
    }

    function refreshTotal(){
        var total = Number($("#"+id).html());
        var totalCount = total -1;
        var numPerPage = Number($('#numPerPage').val());
        var pageNum = Number($("#pageNum").val());
        if(totalCount%numPerPage ==0)
            pageNum = pageNum -1;

        $("#"+id).html(totalCount);
        $('#totalCount').val(totalCount);
        $('#pageNum').val(pageNum);
        loadDataAndPage();

        $("#callBackPager li").each(function(){
            $(this).removeClass('active');
            if ($(this).find('a').html() == pageNum) {
                $(this).addClass('active');
            }
        });

        getListForPage("reportForm","reportsArea");
    }
</script>
</body>
</html>

<script>
    $('ul.aside-list li').removeClass('on');
    $("#myReport").addClass('on');
</script>