<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
		<style>
			.no-number p i {
				margin-left: 5px;
				font-size: 13px;
			}
		</style>
	</head>

	<body style="position: relative">
	<jsp:include page="../../index/multi_h.jsp"/>
	<div class="container">
		<%--<div class="addr">
			<span>当前位置：</span>
			<span class="current">首页 > </span>
			<a class="active" href="#">我的账户</a>
		</div>--%>
		<jsp:include page="../../index/multi_pc_l.jsp"/>
		<!--右边内容块-->
		<div class="pp-content">
			<ul class="order-list wed-list" id="wed-list">
				<li class="active">批改申请记录</li>
				<li onclick="openBillModel();">保全账单</li>
				<li onclick="openSettlementModel()">保全结算单</li>
				<li onclick="openBatchModel();">批量减员</li>
				<li onclick="openPerChangeModel();">人员变更</li>
			</ul>
<%--			<p class="pp-wert">人员变更</p>--%>
		</div>
		<div class="tab-query tab-order my-order">
			<div class="tab-con" id="tab-con">
				<div class="sdf">
					<div class="con-srt con-s1">
						<div class="s-head clearfix">
							<div class="head-input fl">
								<span>关键字</span>
								<input type="text" value="${keyword}" id="keyword_it" placeholder="请输入暂批改单号/保单号/姓名">
							</div>
							<div class="head-time fl">
								<span>提交时间</span>
								<input type="text" value="${start_time}" id="start-s1">
								<span class="sdf">至</span>
								<input type="text" value="${end_time}" id="end-s1">
							</div>
							<div class="head-status fl">
								<span>状态</span>
								<div class="status fr">
									<p id="status-xuan-s1" data-status="${revise_status }">
										<c:if test="${empty revise_status}">请选择</c:if>
										<c:if test="${revise_status eq '1'}">待提交</c:if>
										<c:if test="${revise_status eq '2'}">待审核</c:if>
										<c:if test="${revise_status eq '3'}">审核退回</c:if>
										<c:if test="${revise_status eq '4'}">已审核</c:if>
										<c:if test="${revise_status eq '5'}">已生效</c:if>
									</p>
									<ul class="status-select" id="drag-s1" style="z-index: 1;">
										<li<c:if test="${empty revise_status}"> class="active"</c:if> data-status="">请选择</li>
										<li<c:if test="${revise_status eq '1'}"> class="active"</c:if> data-status="1">待提交</li>
										<li<c:if test="${revise_status eq '2'}"> class="active"</c:if> data-status="2">待审核</li>
										<li<c:if test="${revise_status eq '3'}"> class="active"</c:if> data-status="3">审核退回</li>
										<li<c:if test="${revise_status eq '4'}"> class="active"</c:if> data-status="4">已审核</li>
										<li<c:if test="${revise_status eq '5'}"> class="active"</c:if> data-status="5">已生效</li>
									</ul>
								</div>
							</div>
							<div class="head-button fr" onclick="searchList()">
								<p>搜索</p>
							</div>
						</div>
						<div class="tab-content" id="preservationsArea">
							<ul class="order-num wed-num">
								<li class="width-s1">
									<span>单号信息（<a href="javascript:downRecordList();">导出清单</a>）</span>
								</li>
								<li class="width-s2">
									<span>批改类型</span>
								</li>
								<li class="width-s2">
									<span>生效日期</span>
								</li>
								<li class="width-s2">
									<span>保全金额</span>
								</li>
								<li class="width-s2">
									<span>批改状态</span>
								</li>
								<li class="width-s2">
									<span>提交时间</span>
								</li>
								<li class="width-s2">
									<span>操作</span>
								</li>
							</ul>
							<ul class="tab-body">
							<c:choose>
								<c:when test="${empty iprList }">
									<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
										暂无记录！！
									</li>
								</c:when>
								<c:otherwise>
									<c:forEach items="${iprList }" var="ipr">
										<li class="clearfix">
											<div class="no no-number">
												<p class="clearfix">
													<b>${not empty ipr.revise_serial_num_ins ? '批改单号' : '暂批单号'}</b>
													<i title="${not empty ipr.revise_serial_num_ins ? ipr.revise_serial_num_ins : ipr.revise_serial_number}">${not empty ipr.revise_serial_num_ins ? ipr.revise_serial_num_ins : ipr.revise_serial_number}</i>
												</p>
												<p class="clearfix">
													<b>保单号</b>
													<i title="${ipr.external_reference }">${ipr.external_reference }</i>
												</p>
											</div>
											<div class="no no-styles">
													<span>${fns:getDictLabel (ipr.revise_type,"revise_type","")}</span>
											</div>
											<div class="no no-date">
												<span><fmt:formatDate value="${ipr.inception_date }" pattern="yyyy-MM-dd" /></span>
											</div>
											<div class="no no-money">
												<span>${empty ipr.total_premium ? '' : '￥'}${empty ipr.total_premium ? '-' : ipr.total_premium}</span>
											</div>
											<div class="no no-status">
												<span<c:if test="${ipr.revise_status eq '3'}"> style="color: red;"</c:if>>${fns:getDictLabel (ipr.revise_status,"revise_status","")}</span>
											</div>
											<div class="no no-time">
												<span><fmt:formatDate value="${ipr.start_time }" pattern="yyyy-MM-dd" /></span>
											</div>
											<div class="no no-handle">
												<c:if test="${ipr.revise_status eq '1'||ipr.revise_status eq '3'}">
													<p class="pro-delete" onclick="deletePreservationRecord('${ipr.ins_preservation_record_id }');">删除</p>
												</c:if>
												<c:choose>
													<c:when test="${ipr.revise_status eq '1'}">
														<c:if test="${ipr.revise_type eq '1'}">
															<p class="s1" onclick="do_preservation('add','${ipr.ins_preservation_record_id }');">详情</p>
														</c:if>
														<c:if test="${ipr.revise_type eq '2'}">
															<p class="s2" onclick="do_preservation('minus','${ipr.ins_preservation_record_id }');">详情</p>
														</c:if>
														<c:if test="${ipr.revise_type eq '3'}">
															<p class="s3" onclick="do_preservation('replace','${ipr.ins_preservation_record_id }');">详情</p>
														</c:if>
													</c:when>
													<%-- 审批中状态 增员类型 存在支付地址 --%>
													<c:when test="${ipr.revise_status eq '2'}">
														<c:if test="${ipr.revise_type eq '1' && not empty ipr.revise_pay}">
															<p onclick="do_revisePay('${ipr.revise_pay}');">支付</p>
															<p class="pro-delete" onclick="revokePreservationRecord('${ipr.ins_preservation_record_id }');">撤销</p>
														</c:if>
														<p class="handle-xiang" data-pre-id="${ipr.ins_preservation_record_id }" onclick="openRecordDetail('${ipr.ins_preservation_record_id }');">详情</p>
													</c:when>
													<c:otherwise>
														<p class="handle-xiang" data-pre-id="${ipr.ins_preservation_record_id }" onclick="openRecordDetail('${ipr.ins_preservation_record_id }');">详情</p>
													</c:otherwise>
												</c:choose>
												<c:if test="${not empty ipr.revise_path && (ipr.revise_status eq '4' || ipr.revise_status eq '5' ) }">
													<p class="handle-ert" onclick="loadCanvas('${ipr.revise_path }');">批改单</p>
													<c:if test="${ipr.revise_type eq '1' && not empty ipr.revise_pay}">
														<p class="pro-delete" onclick="requestInvoice('${ipr.e_invoice_url }','${ipr.ins_preservation_record_id }',this);">发票</p>
													</c:if>
												</c:if>
											</div>
										</li>
									</c:forEach>
								</c:otherwise>
							</c:choose>
							</ul>
						</div>
						<!--分页-->
						<div class="filter-pagination" style="padding-top:10px;">
							<div id="callBackPager"></div>
						</div>
						<%--<ul class="paper-num">

						</ul>--%>
					</div>
				</div>
			</div>
		</div>



		<div class="clearfix"></div>
			<form id="preservationForm" action="<c:url value='/pc/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
				<input type="hidden" id="start_time" name="start_time" value="${start_time }"/>
				<input type="hidden" id="end_time" name="end_time" value="${end_time }"/>
				<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
				<input type="hidden" id="revise_status" name="revise_status" value="${revise_status }"/>
				<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
				<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
				<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
			</form>
		</div>

	<!--缴费凭证弹窗-->
	<div class="payment-voucher animated" style="position: absolute!important;top: 30%;">
		<div class="payment-head">
			<span>缴费详情</span>
			<a href="javascript:;" id="payment-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div class="payment-cont">
			<canvas id="cvs" width="440" height="260"></canvas>
			<div class="payment-span">
				<span class="payment-ert">关闭</span>
				<span class="p-upload">再次上传<input type="file" class="upload_pic" id="upload" /></span>
			</div>
		</div>
	</div>

	<!--人员变更提示弹窗-->
	<div class="personnel-changes animated" style="position: absolute!important;top: 30%;">
		<div class="payment-head">
			<span>提示</span>
			<a href="javascript:;" id="personnel-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div class="personnel-cont">
			<p>
				如有企业人员变动（如，员工离职、新员工入职等）<br/>
				可在“我的订单”中查询对应的保险，<br/>
				点击“保全”进入保单中的人员增减操作！
			</p>
		</div>
		<div class="personnel-butt">
			<span class="personnel-bibi">关闭</span>
			<span class="personnel-wed" onclick="openPolicy()">进入“我的订单”</span><%--<c:url value='/pc/order/myOrder'/>--%>
		</div>
	</div>

	<!--批改单扫描件弹窗-->
	<div class="correct-scan animated" style="position: absolute!important;">
		<div class="payment-head">
			<span>批改单</span>
			<a href="javascript:;" id="scan-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div class="scan-cont" style="padding: inherit;margin-left: 30px;">
			<div class="cont-img" id='scan-ex'>
				<img src='<c:url value='/resources/versions-2.0.2/images/daisy.png'/>' width='440' height='400' alt='Daisy on the Ohoopee'/>
			</div>
		</div>
		<div class="download">
			<a  href="javascript:;" class="scan-download">下载文件</a>
		</div>
	</div>


	<!--批改详情弹窗-->
	<div class="correcting-details animated" style="position: absolute!important;">
		<div class="popo-head">
			<span>批改详情</span>
			<a href="javascript:;" id="correcting-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="correcting-content">

		</div>
	</div>


	<!--新增人员弹窗-->
	<div class="increased-styles news-increased animated" style="position: absolute!important;">
		<div class="payment-head">
			<span>新增人员</span>
			<a href="javascript:;" id="news-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="add-increased-table">

		</div>

	</div>

	<!--减少人员弹窗-->
	<div class="increased-styles redues-increased animated" style="position: absolute!important;">
		<div class="payment-head">
			<span>减少人员</span>
			<a href="javascript:;" id="redues-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="minus-increased-table">

		</div>
	</div>

	<!--人员替换弹窗-->
	<div class="increased-styles replaces-increased animated" style="position: absolute!important;">
		<div class="payment-head">
			<span>人员替换</span>
			<a href="javascript:;" id="replaces-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="replace-increased-table">

		</div>
	</div>



	<!--黑色蒙版-->
	<div class="black-mask"></div>
	<!--黑色蒙版2-->
	<div class="black-mask-more"></div>


	<jsp:include page="../../index/multi_f.jsp"/>

	<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/corrections.js' />"></script>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/version_new/js/FileSaver.js'/>"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
        $(function () {
            function mouse(even, stat, iconA, iconB) {
                $('.order-detail').on(even, '.guar', function () {
                    $(this).siblings('.guar-list').css('display',stat);
                    $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
                });
            }
            //鼠标移动到元素上显示
            mouse('mouseenter', 'block', 'down-icon', 'up-icon');
            //鼠标移出元素
            mouse('mouseleave', 'none', 'up-icon', 'down-icon');
            $('#callBackPager .pagination').attr('style','right: 0;');
        })
        var totalCount = Number($('#totalCount').val()) || 0;
        var showCount = $('#showCount').val() || 5;
        var limit = Number($('#numPerPage').val()) || 5;

        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("preservationForm","preservationsArea");
            }
        });

        function searchList(){
			$("#start_time").val($("#start-s1").val());
			$("#end_time").val($("#end-s1").val());
			$("#keyword").val($("#keyword_it").val());
			$("#pageNum").val(1);
			$("#numPerPage").val(5);
			$("#totalCount").val(0);
			$("#revise_status").val($('.con-s1 #status-xuan-s1').attr('data-status'));
//            getListForPage("preservationForm","preservationsArea");
			$("#preservationForm").submit();
		}

		function openRecordModel(){
			location.href=baseUrl+'/pc/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}';
		}
		function openBillModel(){
			location.href=baseUrl+'/pc/preservation/pay/payList?ACCESS_TOKEN=${ACCESS_TOKEN}';
		}
		function openSettlementModel(){
			location.href=baseUrl+'/pc/preservation/pay/settlementList?ACCESS_TOKEN=${ACCESS_TOKEN}';
		}
        function openBatchModel(){
            location.href=baseUrl+'/pc/preservation/batchMinus?ACCESS_TOKEN=${ACCESS_TOKEN}';
		}
        function openPerChangeModel(){
			$('.personnel-changes').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
			$('.black-mask').show();
		}

        function openPolicy(){
            location.href=baseUrl+'/pc/order/myOrder?policyStatus=21&ACCESS_TOKEN=${ACCESS_TOKEN}';
        }


        function loadDataAndPage(){
            totalCount = Number($('#totalCount').val()) || 0;
            $('#callBackPager').extendPagination({
                totalCount: totalCount,
                showCount: showCount,
                limit: limit,
                callback: function (curr, limit, totalCount) {
                    getListForPage("preservationForm","preservationsArea");
                }
            });
        };


        function getListForPage(formId,contentId){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/getRecordListForPage?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : $("#"+formId).serialize(),
                dataType : "text",
                success : function(data) {
                    layer.close(index);
                    $("#"+contentId).html(data);
                },
                error: function(){
                    layer.close(index);
                }
            });
        }

        function choisePolicyStatus(policyStatus,totalCount,obj){
            $(".order-list li").removeClass("active");
            $(obj).addClass("active");
            $("#policyStatus").val(policyStatus);
            $('#totalCount').val(totalCount);
            $('#pageNum').val("1");
            loadDataAndPage();
            getListForPage("preservationForm","preservationsArea");
        }

        function deletePreservationRecord(preservationId){
            layer.confirm('确定删除此申请单？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                layer.closeAll();
                var index = layer.load(0, {shade: [0.3,'#808080']});
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/deleteInsPreservationRecord?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : {
                        "oid":preservationId,
                    },
                    dataType : "json",
                    success : function(data) {
                        layer.close(index);
                        layer.msg(data.message);
                        if(data.status =="200"){
                            getListForPage("preservationForm","preservationsArea");
                        }
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            });
        }

        function revokePreservationRecord(preservationId){
            layer.confirm('确定撤销此申请单？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                layer.closeAll();
                var index = layer.load(0, {shade: [0.3,'#808080']});
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/revokeInsPreservationRecord?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : {
                        "oid":preservationId,
                    },
                    dataType : "json",
                    success : function(data) {
                        layer.close(index);
                        layer.msg(data.message);
                        if(data.status =="200"){
                            getListForPage("preservationForm","preservationsArea");
                        }
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            });
        }

		var invoiceM = 0;
		function requestInvoice(_url,_oid,_obj){
			if(_url == '1'){
				layer.msg("电子发票申请不支持专票开具，请联系客服咨询");
				return;
			}
			if(_url != '' && _url != '1'){
				window.open(_url);
				return;
			}
			//只询问一次
			if(invoiceM == 0){
				layer.confirm('当前发票申请功能仅支持电子普票开具下载（专票开具请线下联系客服咨询），电子发票申请后将无法开具纸质发票，是否继续申请？', {
					btn: ['确定','取消'] //按钮
				}, function(){
					layer.closeAll();
					invoiceM += 1;
					applyInvoice(_oid,_obj);
				});
			}else{
				applyInvoice(_oid,_obj);
			}
		}

		function applyInvoice(_oid,_obj){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			var _url = '/TB-API/GZZRX/PRINT_RECORD_INVOICE/'+_oid;
			$.ajax({
				type: 'POST',
				url:baseUrl + _url,
				dataType:"json",
				success: function(json){
					if(json.statusCode == '200') {
						if(json.message == '1'){
							layer.msg("电子发票申请不支持专票开具，请联系客服咨询");
						}else {
							$(_obj).attr("onclick","requestInvoice('"+json.message+"','"+_oid+"',this)");
							window.open(json.message);
						}
					}else{
						layer.msg(json.message);
					}
					layer.close(index);
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}

        function againRecord(){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            var count = 0;
            $("div .correcting-s7").each(function(){
                if($(this).html().trim().length>14){
                    count = 1;
                    return false;
				}
			});
            if(count == 1){
				layer.msg("请删除未通过条目后提交！");
                layer.close(index);
			}else{
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/againRecord?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : {
                        "oid":$("#recordId").val(),
                    },
                    dataType : "json",
                    success : function(data) {
                        layer.msg(data.message);
                        layer.close(index);
                        if(data.status =="200"){
                            $('.correcting-details').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                            $('.black-mask').hide();
                            getListForPage("preservationForm","preservationsArea");
                        }
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
			}

		}
        function addAgainRecord(){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/addAgainRecord?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : $("#addAgainRecordForm").serialize(),
                dataType : "json",
                success : function(data) {
                    layer.msg(data.message);
                    layer.close(index);
                    if(data.status =="200"){
                        $('.correcting-details').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                        $('.black-mask').hide();
                        getListForPage("preservationForm","preservationsArea");
                    }
                },
                error: function(){
                    layer.close(index);
                }
            });
		}

        function openRecordDetail(_id){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/getRecordDetailByPreservationId/"+_id+"?ACCESS_TOKEN=${ACCESS_TOKEN}",
                dataType : "html",
                success : function(data) {
                    $("#correcting-content").html(data);
                    layer.close(index);
                    correcting();
                },
                error: function(){
                    layer.close(index);
                }
            });
		}

        function loadCanvas(_img){
            if(_img == 'null'){
                layer.msg('批改单地址获取失败！');
			}else{
                var dPath = baseUrl + _img;
                if(!checkImgExists(dPath)){
                    $(".download").children().attr('href', dPath);
                    window.open(dPath);
                }else{
                    var _img_ex = "<img src='"+dPath+"' width='440px' height='400px' alt='Daisy on the Ohoopee'/>";
                    $("#scan-ex").html(_img_ex);
                    $(".download").children().attr('href', baseUrl + _img);
                    $('#scan-ex').zoom({ on:'click' });
                }
            }
        }

        function checkImgExists(imgurl) {
            //判断是否是图片 - strFilter必须是小写列举
            var strFilter=".jpeg|.gif|.jpg|.png|.bmp|.pic|"
            if(imgurl.indexOf(".")>-1){
                var p = imgurl.lastIndexOf(".");
                var strPostfix=imgurl.substring(p,imgurl.length) + '|';
                strPostfix = strPostfix.toLowerCase();
                if(strFilter.indexOf(strPostfix)>-1){
                    return true;
                }
            }
            return false;
        }

        function refreshTotal(){
            var total = Number($("#"+id).html());
            var totalCount = total -1;
            var numPerPage = Number($('#numPerPage').val());
            var pageNum = Number($("#pageNum").val());
            if(totalCount%numPerPage ==0)
                pageNum = pageNum -1;

            $("#"+id).html(totalCount);
            $('#totalCount').val(totalCount);
            $('#pageNum').val(pageNum);
            loadDataAndPage();

            $("#callBackPager li").each(function(){
                $(this).removeClass('active');
                if ($(this).find('a').html() == pageNum) {
                    $(this).addClass('active');
                }
            });

            getListForPage("preservationForm","preservationsArea");
        }

        function deleteRecordDetail(recordDetailId,recordId){
            layer.confirm('确定删除此人员？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                layer.closeAll();
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/deleteRecordDetail?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : {
                        "oid":recordDetailId,
                    },
                    dataType : "json",
                    success : function(data) {
                        layer.msg(data.message);
                        if(data.status =="200"){
                            openRecordDetail(recordId);
                        }
                    }
                });
            });
        }

        function deleteUpdateDetail(_oid,_th){
            layer.confirm('确定删除此记录？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                layer.closeAll();
                if(_oid == ''){
                    $(_th).parent().parent().remove();
                    layer.msg('删除成功！',{time:1000});
                }else{
                    $.ajax({
                        type : 'POST',
                        url : baseUrl + "/pc/preservation/resultSet/deleteRecordDetail?ACCESS_TOKEN=${ACCESS_TOKEN}",
                        data : {
                            "oid":_oid,
                        },
                        dataType : "json",
                        success : function(data) {
                            if(data.status =="200"){
                                $(_th).parent().parent().remove();
                                layer.msg(data.message,{time:1000});
                            }
                        }
                    });
                }
            });
        }


        function do_preservation(_status,_pid){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/thr_preservation_view?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : {
                    operate:_status,
                    preservationId:_pid
                },
                dataType : "html",
                success : function(data) {
                    $("#"+_status+"-increased-table").html(data);
                    if(_status == "add"){
                        $('.news-increased').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
                        $('.black-mask').show();
					}else if(_status == "minus"){
                        $('.redues-increased').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
                        $('.black-mask').show();
                    }else if(_status == "replace"){
                        $('.replaces-increased').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
                        $('.black-mask').show();
                    }
					layer.close(index);
                },
                error: function(){
                    layer.close(index);
                }
            });
        }

        function do_revisePay(payurl){
			window.open(payurl);
			layer.confirm('已完成在线支付？（批改结果预计将在1分钟后更新，请注意查看“批改申请记录”状态）', {  btn: ['是', '否'] }, function () {
				location.reload();
			});
        }

        function save_preservation(_sign){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $("#add_sign").val(_sign);
            var isT = 0;
            if(_sign == '1'){
                isT = submitFormValidator('add_detail_list_form');
            }
            if(isT == 0){
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/add_preservation_service?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : $("#add_detail_list_form").serialize(),
                    dataType : "json",
                    success : function(data) {
                        if(data.statusCode == "200"){
							$('.news-increased').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
							$('.black-mask').hide();
							if(data.forwardUrl && data.forwardUrl != 'null'){
								window.open(data.forwardUrl);
								layer.confirm('已完成在线支付？（批改结果预计将在1分钟后更新，请注意查看“批改申请记录”状态）', {  btn: ['是', '否'] }, function () {
									getListForPage("preservationForm","preservationsArea");
								});
							}else{
								layer.msg(data.message,{time:2000});
								$("#add-increased-table").html('');
								getListForPage("preservationForm","preservationsArea");
							}
                        }else{
                            if(data.message.indexOf('部分证件号已在保，无法重复投保：')!=-1){
                                layer.msg("部分证件号已在保，无法重复投保!",{time:2000});
                                var reg = new RegExp(',','g');
                                var blob = new Blob(['(注：以下证件号已在保，请检查并剔除后重新提交。)\n'+data.message.split('：')[1].replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                                saveAs(blob, "人员重复投保清单.txt");
                            }else{
                                layer.msg(data.message,{time:2000});
                            }
                        }
                        layer.close(index);
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            }else{
                layer.close(index);
			}
        }
        function minus_save_preservation(_sign){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $("#minus_sign").val(_sign);
            var isT = 0;
            if(_sign == '1'){
                isT = submitFormValidator('minus_detail_list_form');
            }
            if(isT == 0){
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/update_detail_minus_service?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : $("#minus_detail_list_form").serialize(),
                    dataType : "json",
                    success : function(data) {
                        if(data.statusCode == "200"){
                            layer.msg(data.message,{time:3000});
                            $('.redues-increased').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                            $('.black-mask').hide();
                            $("#minus-increased-table").html('');
                            getListForPage("preservationForm","preservationsArea");
                        }else{
                            layer.msg(data.message);
                        }
                        layer.close(index);
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            }else{
                layer.close(index);
			}
        }
        function replace_save_preservation(_sign){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $("#replace_sign").val(_sign);
            var isT = 0;
            if(_sign == '1'){
                isT = submitFormValidator('replace_detail_list_form');
            }
            if(isT == 0){
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/replace_preservation_service?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : $("#replace_detail_list_form").serialize(),
                    dataType : "json",
                    success : function(data) {
                        if(data.statusCode == "200"){
                            layer.msg(data.message,{time:2000});
                            $('.replaces-increased').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                            $('.black-mask').hide();
                            $("#replace-increased-table").html('');
                            getListForPage("preservationForm","preservationsArea");
                        }else{
                            if(data.message.indexOf('部分证件号已在保，无法重复投保：')!=-1){
                                layer.msg("部分证件号已在保，无法重复投保!",{time:2000});
                                var reg = new RegExp(',','g');
                                var blob = new Blob(['(注：以下证件号已在保，请检查并剔除后重新提交。)\n'+data.message.split('：')[1].replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                                saveAs(blob, "人员重复投保清单.txt");
                            }else{
                                layer.msg(data.message,{time:2000});
                            }
                        }
                        layer.close(index);
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            }else{
                layer.close(index);
			}
        }
        function uploadBatchInsure(){
            var formData = new FormData();
            var files = document.getElementById("batch_record").files[0];
            if(files == undefined){
                return;
            }
            if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
                layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
                return;
            }
            var index = layer.load(0, {shade: [0.3,'#808080']});
            formData.append('role_record', files);
            $('#batch_record').val('');
            $.ajax({
                type: 'POST',
                url:baseUrl + '/pc/preservation/uploadRoleFile?ACCESS_TOKEN=${ACCESS_TOKEN}',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + "/pc/preservation/update_detail_add_upload?ACCESS_TOKEN=${ACCESS_TOKEN}",
                            data:{
                                preservationId:$("#add_preservation_id").val()
							},
                            dataType:"html",
                            success: function(data){
                                $("#upload-increased-table").html(data);
                                layer.close(index);
                            },
                            error : function(XMLHttpRequest, textStatus, errorThrown) {
                                layer.msg(textStatus);
                                layer.close(index);
                            }
                        });
                    }else{
                        layer.msg("出现异常数据，请查看异常清单");
                        var reg = new RegExp(';','g');
                        var blob = new Blob(['(注：以下异常信息行号对应Excel自带行号。)\n'+json.message.replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                        saveAs(blob, "excel保全人员数据异常清单.txt");
					}
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                    layer.close(index);
                }
            });
        }

        function uploadInsure(){
            var formData = new FormData();
            var files = document.getElementById("role_record").files[0];
            if(files == undefined){
                return;
            }
            if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
                layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
                return;
            }
            var index = layer.load(0, {shade: [0.3,'#808080']});
            formData.append('role_record', files);
            $('#role_record').val('');
            $.ajax({
                type: 'POST',
                url:baseUrl + '/pc/preservation/uploadRoleFile?ACCESS_TOKEN=${ACCESS_TOKEN}',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + "/pc/preservation/update_detail_add_upload?ACCESS_TOKEN=${ACCESS_TOKEN}",
                            data:{
                                preservationId:$("#add_preservation_id").val()
							},
                            dataType:"html",
                            success: function(data){
                                $("#upload-increased-table").html(data);
                                layer.close(index);
                            },
                            error : function(XMLHttpRequest, textStatus, errorThrown) {
                                layer.msg(textStatus);
                                layer.close(index);
                            }
                        });
                    }else{
                        layer.msg("出现异常数据，请查看异常清单");
                        var reg = new RegExp(';','g');
                        var blob = new Blob(['(注：以下异常信息行号对应Excel自带行号。)\n'+json.message.replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                        saveAs(blob, "excel保全人员数据异常清单.txt");
					}
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                    layer.close(index);
                }
            });
        }

		/*保全单明细导出操作*/
        function downRecordList(){
            var str = "<div>" +
                "<p style='padding-bottom: 5px;'>保单号：<input type='text' class='form-control' id='skeyword' /></p>" +
                "<p style='padding-bottom: 5px;'>姓名：<input type='text' class='form-control' id='sname' /></p>" +
                "<p style='padding-bottom: 5px;'>申请时间起：<input type='text' class='form-control' id='sstart_time' onClick=\"laydate({elem: '#sstart_time'})\"/></p>" +
                "<p style='padding-bottom: 5px;'>申请时间止：<input type='text' class='form-control' id='send_time' onClick=\"laydate({elem: '#send_time'})\"/></p>" +
                "</div>";
            var index = layer.confirm(str,{btn: ['下载','取消'], title: "导出批单信息"}, function(){
                var keyword = $('#skeyword').val();
                if(keyword == undefined){
                    keyword = '';
                }
                var name = $('#sname').val();
                if(name == undefined){
                    name = '';
                }
                var start_time = $('#sstart_time').val();
                if(start_time == undefined){
                    start_time = '';
                }
                var end_time = $('#send_time').val();
                if(end_time == undefined){
                    end_time = '';
                }
                location.href = baseUrl + '/pc/preservation/down_preservation_list?keyword='+keyword+'&name='+name+'&start_time='+start_time+'&end_time='+end_time;
                layer.close(layer.index);
            });
        }


	</script>

	<script>
        $('ul.aside-list li').removeClass('on');
        $("#myPreservation").addClass('on');
	</script>
	</body>
</html>
