<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-我的账户</title>
</head>

<body style="position: relative">
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container">
	<%--<div class="addr">
		<span>当前位置：</span>
		<span class="current">首页 > </span>
		<a class="active" href="#">我的账户</a>
	</div>--%>
	<jsp:include page="../../../index/multi_pc_l.jsp"/>
	<!--右边内容块-->
	<div class="pp-content">
		<ul class="order-list wed-list" id="wed-list">
			<li onclick="openThisModel()">批改申请记录</li>
			<li class="active">保全缴费</li>
			<li onclick="openBatchModel();">批量减员</li>
		</ul>
		<p class="pp-wert">人员变更</p>
	</div>
	<div class="tab-query tab-order my-order">
		<div class="tab-con" id="tab-con">
			<div class="sdf">
				<div class="con-srt con-s2" style="display: block;">
					<div class="s-head clearfix">
						<div class="head-input fl">
							<span>关键字</span>
							<input type="text" id="keyword_it" value="${keyword}" placeholder="请填写保险公司名称/保单号">
						</div>
						<div class="head-time fl">
							<span>结算时间</span>
							<input type="text" value="${start_time}" id="start-s2">
							<span class="sdf">至</span>
							<input type="text" value="${end_time}" id="end-s2">
						</div>
						<div class="head-status fl">
							<span>状态</span>
							<div class="status fr">
								<p id="status-xuan-s2" data-status="${pay_status }">
									<c:if test="${empty pay_status}">请选择</c:if>
									<c:if test="${pay_status eq '1'}">待支付</c:if>
									<c:if test="${pay_status eq '2'}">待审核</c:if>
									<c:if test="${pay_status eq '3'}">已支付</c:if>
								</p>
								<ul class="status-select" id="drag-s2">
									<li<c:if test="${empty pay_status}"> class="active"</c:if> data-status="">请选择</li>
									<%--<li<c:if test="${pay_status eq '0'}"> class="active"</c:if> data-status="0">待处理</li>--%>
									<li<c:if test="${pay_status eq '1'}"> class="active"</c:if> data-status="1">待支付</li>
									<li<c:if test="${pay_status eq '2'}"> class="active"</c:if> data-status="2">待审核</li>
									<li<c:if test="${pay_status eq '3'}"> class="active"</c:if> data-status="3">已支付</li>
								</ul>
							</div>
						</div>
						<div class="head-button fr" onclick="searchList()">
							<p>搜索</p>
						</div>
					</div>
					<div class="tab-content" id="preservationPaysArea">
						<ul class="order-num wed-num">
							<li class="width-s3">
								<span>单号信息</span>
							</li>
							<li class="width-s3">
								<span>保险公司</span>
							</li>
							<li class="width-s3">
								<span>增员人数</span>
							</li>
							<li class="width-s3">
								<span>减员人数</span>
							</li>
							<li class="width-s3">
								<span>替换人数</span>
							</li>
							<li class="width-s3">
								<span>状态</span>
							</li>
							<li class="width-s3">
								<span>金额</span>
							</li>
							<li class="width-s3">
								<span>结算时间范围</span>
							</li>
							<li class="width-s3">
								<span>操作</span>
							</li>
						</ul>
						<ul class="tab-body">
							<c:choose>
								<c:when test="${empty payList }">
									<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
										暂无记录！！
									</li>
								</c:when>
								<c:otherwise>
									<c:forEach items="${payList }" var="pay">
										<li class="clearfix">
											<div class="no-cont">
												<span>${pay.external_reference }</span>
											</div>
											<div class="no-cont">
												<span>${pay.company_name }</span>
											</div>
											<div class="no-cont">
												<span>${pay.add_count}人</span>
											</div>
											<div class="no-cont">
												<span>${pay.minus_count }人</span>
											</div>
											<div class="no-cont">
												<span>${pay.replace_count }人</span>
											</div>
											<div class="no-cont">
												<span>${fns:getDictLabel (pay.pay_status,"payStatus","")}</span>
											</div>
											<div class="no-cont">
												<span>${empty pay.fact_total_amount ? '' : '￥'}${empty pay.fact_total_amount ? '-' : pay.fact_total_amount}</span>
											</div>
											<div class="no-cont">
												<p>${pay.star_pay_time }</p>
												<i>至</i>
												<p>${pay.end_pay_time }</p>
											</div>
											<div class="no-cont">
												<a href="javascript:;" onclick="openPayDetail('${pay.oid }');" class="po-details">详情</a>
												<c:if test="${pay.pay_status eq '1'||pay.pay_status eq '2' }">
													<a href="javascript:;" onclick="uploadPay('${pay.oid }');loadCanvas('${pay.pay_order_path }');" class="a-progress">上传缴费凭证</a>
												</c:if>
												<c:if test="${pay.pay_status eq '3'&&fn:contains(pay.product_code,'GZZRX-CA')}">
													<a href="javascript:;" onclick="getFP('${pay.oid }');" class="a-progress">发票下载</a>
												</c:if>
											</div>
										</li>
									</c:forEach>
								</c:otherwise>
							</c:choose>
						</ul>
					</div>
					<!--分页-->
					<ul class="paper-num">
						<div class="filter-pagination">
							<div id="callBackPager"></div>
						</div>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<div class="clearfix"></div>
	<form id="preservationPayForm" action="<c:url value='/pc/preservation/pay/payList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
		<input type="hidden" id="start_time" name="start_time" value="${start_time }"/>
		<input type="hidden" id="end_time" name="end_time" value="${end_time }"/>
		<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
		<input type="hidden" id="pay_status" name="pay_status" value="${pay_status }"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
</div>

<!--缴费凭证弹窗-->
<div class="payment-voucher animated" style="position: absolute!important;">
	<div class="payment-head">
		<span>缴费凭证</span>
		<a href="javascript:;" id="payment-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<form id="uploadPayForm">
		<div class="payment-cont">
			<canvas id="cvs" width="440" height="260"></canvas>
			<input type="hidden" name="payId" id="payId" />
			<div class="payment-span">
				<span class="payment-ert">关闭</span>
				<span class="p-upload">再次上传<input type="file" class="upload_pic" name="pay_file" id="upload" onchange="uploadFilePay('uploadPayForm')"/></span>
			</div>
		</div>
	</form>
</div>

<!--人员变更提示弹窗-->
<div class="personnel-changes animated" style="position: absolute!important;">
	<div class="payment-head">
		<span>提示</span>
		<a href="javascript:;" id="personnel-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<div class="personnel-cont">
		<p>
			如有企业人员变动（如，员工离职、新员工入职等）<br/>
			可在“我的订单”中查询对应的保险，<br/>
			点击“保全”进入保单中的人员增减操作！
		</p>
	</div>
	<div class="personnel-butt">
		<span class="personnel-bibi">关闭</span>
		<span class="personnel-wed" onclick="openPolicy()">进入“我的订单”</span><%--<c:url value='/pc/order/myOrder'/>--%>
	</div>
</div>

<!--详情弹窗-->
<div class="details-popover animated" style="position: absolute!important;">
	<div class="popover-cont">
		<div class="popo-head">
			<span>缴费详情</span>
			<a href="javascript:;" id="popo-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="loadRecordDetail">

		</div>
	</div>
</div>

<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<jsp:include page="../../../index/multi_f.jsp"/>
<script src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/corrections.js' />"></script>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;

    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("preservationPayForm","preservationPaysArea");
        }
    });

    function openThisModel(){
        location.href=baseUrl+'/pc/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}';
    }

	function openBatchModel(){
		location.href=baseUrl+'/pc/preservation/batchMinus?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}

    function openPolicy(){
        location.href=baseUrl+'/pc/order/myOrder?policyStatus=21&ACCESS_TOKEN=${ACCESS_TOKEN}';
    }
    function uploadPay(_id){
        $("#payId").val(_id);
    }
	function getFP(_id){
		$.ajax({
			type: 'POST',
			url:baseUrl + '/pc/preservation/pay/getFP/'+_id,
			dataType:"json",
			async:false,
			success: function(json){
				if(json.retType == '0') {//支付成功
					window.open(json.data);
				}else{
					layer.msg(json.msg);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.msg(textStatus);
			}
		});
	}

    function loadCanvas(_img){
        clearCanvas();
        var c=document.getElementById("cvs");
        var cxt=c.getContext("2d");
        var img=new Image()
        img.src=baseUrl + _img;
        img.onload = function () //确保图片已经加载完毕
        {
            cxt.drawImage(img, 0, 0, 440, 260);
        }
        payUploadShow();
    }
    function payUploadShow () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    }

    function clearCanvas(){
        var c=document.getElementById("cvs");
        var cxt=c.getContext("2d");
        cxt.clearRect(0,0,c.width,c.height);
    }

    function uploadFilePay(_form){
        if($("#upload").val() == ''){
            return false;
        }
        var index = layer.load(0, {shade: [0.3,'#808080']});
        var formData = new FormData(document.forms.namedItem(_form));
        $.ajax({
            type: 'POST',
            url:baseUrl + '/pc/preservation/pay/uploadFilePay',
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(json){
                layer.msg(json.message);
                $('.payment-voucher').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                $('.black-mask').hide();
                clearCanvas();
                getListForPage("preservationPayForm","preservationPaysArea");
                layer.close(index);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }

    function openPayDetail(_id){
        $.ajax({
            type : 'POST',
            url : baseUrl + "/pc/preservation/pay/getInsPreservationPayByPayId/"+_id,
            dataType : "html",
            success : function(data) {
                $("#loadRecordDetail").html(data);
            },
            error: function(){
            }
        });
    }

    function searchList(){
        $("#start_time").val($("#start-s2").val());
        $("#end_time").val($("#end-s2").val());
        $("#keyword").val($("#keyword_it").val());
        $("#pageNum").val(1);
        $("#numPerPage").val(5);
        $("#totalCount").val(0);
        $("#pay_status").val($('.con-s2 #status-xuan-s2').attr('data-status'));
        $("#preservationPayForm").submit();
    }

    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("preservationPayForm","preservationPaysArea");
            }
        });
    };


    function getListForPage(formId,contentId){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : baseUrl + "/pc/preservation/pay/getPayListForPage",
            data : $("#"+formId).serialize(),
            dataType : "text",
            success : function(data) {
                layer.close(index);
                $("#"+contentId).html(data);
            },
            error: function(){
                layer.close(index);
            }
        });
    }

    function choisePolicyStatus(policyStatus,totalCount,obj){
        $(".order-list li").removeClass("active");
        $(obj).addClass("active");
        $("#policyStatus").val(policyStatus);
        $('#totalCount').val(totalCount);
        $('#pageNum').val("1");
        loadDataAndPage();
        getListForPage("preservationPayForm","preservationPaysArea");
    }

    function deletePreservationRecord(preservationId){
        layer.confirm('确定删除此订单？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/deleteInsPreservationRecord",
                data : {
                    "oid":preservationId,
                },
                dataType : "json",
                success : function(data) {
                    layer.close(index);
                    layer.msg(data.message);
                    if(data.status =="200"){
                        getListForPage("preservationPayForm","preservationPaysArea");
                    }
                },
                error: function(){
                    layer.close(index);
                }
            });
        });
    }

    function refreshTotal(){
        var total = Number($("#"+id).html());
        var totalCount = total -1;
        var numPerPage = Number($('#numPerPage').val());
        var pageNum = Number($("#pageNum").val());
        if(totalCount%numPerPage ==0)
            pageNum = pageNum -1;

        $("#"+id).html(totalCount);
        $('#totalCount').val(totalCount);
        $('#pageNum').val(pageNum);
        loadDataAndPage();

        $("#callBackPager li").each(function(){
            $(this).removeClass('active');
            if ($(this).find('a').html() == pageNum) {
                $(this).addClass('active');
            }
        });

        getListForPage("preservationPayForm","preservationPaysArea");
    }
</script>
</body>
</html>

<script>
    $('ul.aside-list li').removeClass('on');
    $("#myPreservation").addClass('on');
</script>