<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<div class="popo-title">
	<div class="title-img clearfix">
		<img src="<c:url value='/resources/versions-2.0.2/images/icon-pingan.png'/>" />
		<div class="title-wed">
			<p><span>保单号: <i>${payVo.external_reference }</i></span></p>
			<p><span>总保费金额: <i>${payVo.fact_total_amount }元</i></span></p>
		</div>
		<a target="_blank" href="<c:url value='${payVo.pay_inform_path }'/>">缴费通知单</a>
		<c:if test="${not empty payVo.pay_order_path }">
			<a target="_blank" href="<c:url value='${payVo.pay_order_path }'/>">缴费凭证</a>
		</c:if>
	</div>
</div>
<div class="popo-content">
	<ul class="popo-header clearfix">
		<li class="width-s1">
			<span>暂批改单号</span>
		</li>
		<li class="width-s2">
			<span>批改类型</span>
		</li>
		<li class="width-s3">
			<span>生效时间</span>
		</li>
		<li>
			<span>批改状态</span>
		</li>
		<li>
			<span>增员</span>
		</li>
		<li>
			<span>减员</span>
		</li>
		<li>
			<span>替换</span>
		</li>
		<li>
			<span>保全金额</span>
		</li>
	</ul>
	<ul class="popo-tbody">
		<c:choose>
			<c:when test="${empty recordVoList }">
				<li style="float: none">
					<p style="text-align: center">暂无记录！！</p>
				</li>
			</c:when>
			<c:otherwise>
				<c:forEach items="${recordVoList }" var="iprVo">
				<li class="clearfix">
					<div class="p-no no-s1">
						<span>${iprVo.revise_serial_number }</span>
					</div>
					<div class="p-no no-s2">
						<span>${fns:getDictLabel (iprVo.revise_type,"revise_type","")}</span>
					</div>
					<div class="p-no no-s3">
						<span>${iprVo.inception_date }</span>
					</div>
					<div class="p-no">
						<span>${fns:getDictLabel (iprVo.revise_status,"revise_status","")}</span>
					</div>
					<div class="p-no">
						<span>${empty iprVo.add_count ? '0' : iprVo.add_count}人</span>
					</div>
					<div class="p-no">
						<span>${empty iprVo.minus_count ? '0' : iprVo.minus_count}人</span>
					</div>
					<div class="p-no">
						<span>${empty iprVo.replace_count ? '0' : iprVo.replace_count}人</span>
					</div>
					<div class="p-no">
						<span>${iprVo.total_premium }元</span>
					</div>
				</li>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</ul>
</div>
