<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="tab-title">
	<li class="wid-220">基本信息</li>
	<li>被保险人</li>
	<li>保障时间</li>
	<li>份数</li>
	<li>保费（元）</li>
	<li>状态</li>
	<li>操作</li>
</ul>
<div class="tab-content">
	<c:choose>
		<c:when test="${empty orderList }">
			<div class="order-detail">
				<ul class="order-num">
					<li style="float: none">
						<p style="text-align: center">暂无订单！！</p>
					</li>
				</ul>
			</div>
		</c:when>
		<c:otherwise>
			<c:forEach items="${orderList }" var="policy">
				<div class="order-detail">
					<ul class="order-num">
						<li>
							<span  class="num-name">订单号：</span>
							<span>${policy.trade_serial_number}</span>
						</li>
						<li>
							<c:choose>
								<c:when test="${empty policy.external_reference && not empty policy.policy_serial_number}">
									<span  class="num-name">投保单号：</span>
									<span>${policy.policy_serial_number}</span>
								</c:when>
								<c:otherwise>
									<span  class="num-name">保单号：</span>
									<span>${policy.external_reference}</span>
								</c:otherwise>
							</c:choose>
						</li>
						<li class="order-time">
							创建时间：${policy.start_time}
						</li>
					</ul>
					<ul class="tab-body">
						<li class="wid-220 two">
							<a href="${policy.headurl}/insurance/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="insu">${policy.product_name }</a>
							<c:if test="${ not empty policy.customRemarks }"><p title="${policy.customRemarks }">(${fn:substring(policy.customRemarks, 0, 3) }...)</p></c:if>
						</li>
						<li class="wed">
							<span>
							<c:choose>
								<c:when test="${fn:contains(policy.product_code, 'TYX')||fn:contains(policy.product_code, 'GZZRX') }">
									团体
								</c:when>
								<c:otherwise>
									${policy.insured_role}
								</c:otherwise>
							</c:choose>
							</span>
						</li>
						<li class="three">
							<div class="qoi">${policy.inception_date}</div>
							<div>至</div>
							<div>${policy.planned_end_date}</div>
						</li>
						<li>
							<span>
								1份
							</span>
						</li>
						<li>
							<span>
								<c:if test="${not empty policy.gross_premium}">
									￥${policy.gross_premium}
								</c:if>
							</span>
						</li>
						<li class="pay">
							<span>
								<c:choose>
									<c:when test="${policy.policy_status eq '4' || policy.policy_status eq '16' }">
										${fns:getDictLabel (policy.policy_status,"order_status","")}
									</c:when>
									<c:otherwise>
										${fns:getDictLabel (policy.policy_status,"order_status","")}
									</c:otherwise>
								</c:choose>
							</span>
						</li>
						<li class="pay-delete" style="overflow-y: auto; display: block;">
							<c:if test="${policy.policy_status != '1' }">
								<a target="_blank" href="<c:url value='/pc/order/exportDetailByOrderID/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">查看${ empty policy.external_reference ? '投保单':'保单'}</a>
							</c:if>
							<c:if test="${policy.policy_status eq '1' }">
								<c:if test="${policy.product_code eq 'BZX-TB-GCTB'||policy.product_code eq 'BZX-YG-GCTB'||policy.product_code eq 'BZX-DB-GCTB' }"><a target="_blank" href="${policy.headurl}/insurance/build/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${policy.product_code eq 'BZX-GCLY' }"><a target="_blank" href="${policy.headurl}/insurance/build/policy/pg_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${policy.product_code eq 'BZX-SSBQ' }"><a target="_blank" href="${policy.headurl}/insurance/lawsuit/policy/lt_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${policy.product_code eq 'XYX-XWCK' }"><a target="_blank" href="${policy.headurl}/insurance/customs/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${policy.product_code eq 'XYX-DQCK' }"><a target="_blank" href="${policy.headurl}/insurance/customs/policy/qy_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
<%--								<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a target="_blank" href="${policy.headurl}/insurance/afr/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>--%>
								<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'TYX') }"><a target="_blank" href="${policy.headurl}/insurance/tyx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GYX') }"><a target="_blank" href="${policy.headurl}/insurance/gyx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'ZZX') }"><a target="_blank" href="${policy.headurl}/insurance/zzx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZZRX') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
							</c:if>
							<c:if test="${policy.policy_status eq '3'}">
								<c:choose>
									<c:when test="${fn:contains(policy.product_code, 'TYX-PAC') }">
										<a href="${policy.headurl}/insurance/tyx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
									</c:when>
									<c:when test="${fn:contains(policy.product_code, 'GZZRX-ZH') }">
										<a href="${policy.headurl}/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
									</c:when>
									<c:when test="${fn:contains(policy.product_code, 'GZZRX-CA') }">
										<a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
									</c:when>
									<c:when test="${fn:contains(policy.product_code, 'TYX-CA') }">
										<a target="_blank" href="${policy.headurl}/insurance/tyx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
									</c:when>
									<c:otherwise>
										<a target="_blank" href="${policy.headurl}/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">确认报价</a>
									</c:otherwise>
								</c:choose>
							</c:if>
							<c:if test="${policy.policy_status eq '4'}">
								<c:if test="${policy.product_code eq 'BZX-TB-GCTB'}">
									<c:if test="${ empty policy.policy_serial_number}"><a target="_blank" href="${policy.headurl}/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
									<c:if test="${not empty policy.policy_serial_number && not empty policy.show_url}"><a target="_blank" href="${policy.show_url}" class="again-pay">立即支付</a></c:if>
								</c:if>
								<c:if test="${policy.product_code eq 'BZX-YG-GCTB'||policy.product_code eq 'BZX-DB-GCTB'}">
									<a target="_blank" href="${policy.headurl}/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a>
								</c:if>
								<c:if test="${ policy.product_code eq 'BZX-GCLY'}"><a target="_blank" href="${policy.headurl}/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${policy.product_code eq 'BZX-SSBQ'}"><a target="_blank" href="${policy.headurl}/insurance/lawsuit/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'TYX')&&!fn:contains(policy.product_code, 'TYX-CA') }"><a target="_blank" href="${policy.headurl}/insurance/tyx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GYX') }"><a target="_blank" href="${policy.show_url}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'ZZX') }"><a href="${policy.headurl}/insurance/zzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZZRX-CA') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZZRX-QH') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'TYX-CA') }"><a target="_blank" href="${policy.headurl}/insurance/gmr/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZZRX')&&!fn:contains(policy.product_code, 'GZZRX-CA')&&!fn:contains(policy.product_code, 'GZZRX-QH') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
							</c:if>
							<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'TYX') || fn:contains(policy.product_code, 'GZZRX')) }">
								<a href="<c:url value='/pc/preservation/resultSet/resultSetList?policyId=${policy.oid }&ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">保全</a>
							</c:if>
							<c:if test="${policy.policy_status eq '6' && fn:contains(policy.product_code, 'TYX-PAC') }">
								<a href="<c:url value='/pc/order/policyReport?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">理赔申请</a>
							</c:if>
							<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'GZZRX-PAC')||fn:contains(policy.product_code, 'GZZRX-ZH')||fn:contains(policy.product_code, 'GZZRX-CA')||fn:contains(policy.product_code, 'TYX-CA')) }">
								<a href="<c:url value='/pc/report/reportInit/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">理赔申请</a>
							</c:if>
							<c:if test="${ policy.policy_status eq '16'}">
								<c:choose>
									<c:when test="${fn:contains(policy.product_code, 'GZZRX-PAC') }">
										<a href="${policy.headurl}/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
									</c:when>
									<c:otherwise>
										<a target="_blank" href="${policy.headurl}/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a>
									</c:otherwise>
								</c:choose>
							</c:if>
							<c:if test="${policy.policy_status eq '3' || policy.policy_status eq '4' }">
								<div class="again-pay" onclick="copyOrder('${policy.oid }');">复制</div>
							</c:if>
							<c:if test="${policy.policy_status eq '1' || policy.policy_status eq '2' || policy.policy_status eq '4' }">
								<div class="delete" onclick="deleteExportOrder('${policy.oid }','${policy.policy_status }');">删除</div>
							</c:if>
							<c:if test="${policy.policy_status eq '6'}">
								<a href="javascript:void(0);" class="again-pay" onclick="openSetRemarks('${policy.oid }','${policy.policy_status }','${policy.customRemarks }');">备注</a>
							</c:if>
						</li>
					</ul>
				</div>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</div>
<script type="text/javascript">
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    $('.order-detail ul.tab-body li.pay-delete').each(function () {
        var s = $(this).children().length;
        if(s <= 2){
            $(this).css({"line-height":'28px',"padding-top":"18px"});
        }else if(s > 2){
            $(this).css({"line-height":'28px',"padding-top":"2px"});
        }
    })
</script>
