<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-信息详情</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body style="background: rgba(244,245,246,1);">

<jsp:include page="../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<ol class="breadcrumb">
	  <li><a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">首页</a></li>
	  <li><a href="<c:url value='/pc/insureInfo/init?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">我的账户</a></li>
	  <li class="active">信息详情</li>
	</ol>
	<div class="message-war"><!-- message-war start -->
		<h2>${ mapPolicy['productName']}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ mapPolicy['tradeSerialNumber']}</h5>
			<div class="mess-title"><h3>投保人（申请人/原告）基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody> 
						<tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人／被保险人</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['app_fullName']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">申请人主体资格</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['appRightAsPrincipalName']}</td>
                        </tr>
						<tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['appIdTypeName']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['app_organizingCode']}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">地址</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['app_address']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮编</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['app_zipcode']}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['app_name']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人邮箱</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['app_email']}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人电话</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['app_phone']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">身份证复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['app_idcardPath']}"><a target="_blank" href="${ mapPolicy['app_idcardPath']}">查看</a></c:if></td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">常住地证明文件复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['app_addressPath']}"><a target="_blank" href="${ mapPolicy['app_addressPath']}">查看</a></c:if></td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">配偶身份证复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['app_spouseCardPath']}"><a target="_blank" href="${ mapPolicy['app_spouseCardPath']}">查看</a></c:if></td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">结婚证复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['app_trauscheinPath']}"><a target="_blank" href="${ mapPolicy['app_trauscheinPath']}">查看</a></c:if></td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业执照复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['app_businessPath']}"><a target="_blank" href="${ mapPolicy['app_businessPath']}">查看</a></c:if></td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3> 对方当事人（被告／第三人）基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
						<tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被申请人/被告</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['par_full_name']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被申请人／被告主体资格</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['parRightAsPrincipalName']}</td>
                        </tr>
						<tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['parIdTypeName']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['par_organizingCode']}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">地址</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['par_address']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮编</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['par_zipcode']}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['par_name']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人邮箱</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['par_email']}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人电话</td>
                            <td class="col-sm-4 col-xs-4">${ mapPolicy['par_phone']}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">身份证复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['par_idcardPath']}"><a target="_blank" href="${ mapPolicy['par_idcardPath']}">查看</a></c:if></td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">常住地证明文件复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['par_addressPath']}"><a target="_blank" href="${ mapPolicy['par_addressPath']}">查看</a></c:if></td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">配偶身份证复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['par_spouseCardPath']}"><a target="_blank" href="${ mapPolicy['par_spouseCardPath']}">查看</a></c:if></td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">结婚证复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['par_trauscheinPath']}"><a target="_blank" href="${ mapPolicy['par_trauscheinPath']}">查看</a></c:if></td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业执照复印件</td>
                            <td class="col-sm-4 col-xs-4"><c:if test="${ not empty mapPolicy['par_businessPath']}"><a target="_blank" href="${ mapPolicy['par_businessPath']}">查看</a></c:if></td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			
			<c:if test="${not empty mapPolicy['partyRecord']}">
			<c:forEach items="${fn:split( mapPolicy['partyRecord'],',')}" var="party">
			<div class="mess-title"><h3> 对方当事人（被告／第三人）基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
						<tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被申请人/被告</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_full_name_copy" value="par_full_name_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_full_name_copy]}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被申请人／被告主体资格</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_rightAsPrincipal_copy" value="par_rightAsPrincipal_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_rightAsPrincipal_copy] eq 'CITIZEN' ? '公民':'法人'}</td>
                        </tr>
						<tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_idType_copy" value="par_idType_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_idType_copy] eq 'IDCARD' ? '身份证':'组织机构代码或统一社会信用代码'}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_organizingCode_copy" value="par_organizingCode_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_organizingCode_copy]}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">地址</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_address_copy" value="par_address_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_address_copy]}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮编</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_zipcode_copy" value="par_zipcode_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_zipcode_copy]}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_name_copy" value="par_name_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_name_copy]}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人邮箱</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_email_copy" value="par_email_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_email_copy]}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人电话</td>
                            <td class="col-sm-4 col-xs-4"><c:set var="par_phone_copy" value="par_phone_copy${fn:split(party,'_')[2] }"></c:set>${ mapPolicy[par_phone_copy]}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">身份证复印件</td>
                            <td class="col-sm-4 col-xs-4">
	                            <c:set var="par_idcardPath_copy" value="par_idcardPath_copy${fn:split(party,'_')[2] }"></c:set>	
	                            <c:if test="${ not empty mapPolicy[par_idcardPath_copy]}"><a target="_blank" href="${ mapPolicy[par_idcardPath_copy]}">查看</a></c:if>
                            </td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">常住地证明文件复印件</td>
                            <td class="col-sm-4 col-xs-4">
	                            <c:set var="par_addressPath_copy" value="par_addressPath_copy${fn:split(party,'_')[2] }"></c:set>	
	                            <c:if test="${ not empty mapPolicy[par_addressPath_copy]}"><a target="_blank" href="${ mapPolicy[par_addressPath_copy]}">查看</a></c:if>
                            </td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">配偶身份证复印件</td>
                            <td class="col-sm-4 col-xs-4">
	                            <c:set var="par_spouseCardPath_copy" value="par_spouseCardPath_copy${fn:split(party,'_')[2] }"></c:set>	
	                            <c:if test="${ not empty mapPolicy[par_spouseCardPath_copy]}"><a target="_blank" href="${ mapPolicy[par_spouseCardPath_copy]}">查看</a></c:if>
	                        </td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">结婚证复印件</td>
                            <td class="col-sm-4 col-xs-4">
	                            <c:set var="par_trauscheinPath_copy" value="par_trauscheinPath_copy${fn:split(party,'_')[2] }"></c:set>	
	                            <c:if test="${ not empty mapPolicy[par_trauscheinPath_copy]}"><a target="_blank" href="${ mapPolicy[par_trauscheinPath_copy]}">查看</a></c:if>
	                        </td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业执照复印件</td>
                            <td class="col-sm-4 col-xs-4">
	                            <c:set var="par_businessPath_copy" value="par_businessPath_copy${fn:split(party,'_')[2] }"></c:set>	
	                            <c:if test="${ not empty mapPolicy[par_businessPath_copy]}"><a target="_blank" href="${ mapPolicy[par_businessPath_copy]}">查看</a></c:if>
	                        </td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			</c:forEach>
			</c:if>
			
			<div class="mess-title"><h3> 案件信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">1.案件审理法院</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['court']}</td>
						</tr>
                        <tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">2.案由</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['brief']}</td>
						</tr>
                        <tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">3.案号</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['reference']}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">4.原告</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['app_fullName']}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">5.被告</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['par_full_name']}</td>
						</tr> 
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">6.第三人</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['par_anyOne']}</td>
						</tr> 
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">7.保全类型</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['preserveTypeName']}</td>
						</tr> 
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>申请保全的财产信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">申请保全的财产价值</td>
							<td class="col-sm-10 col-xs-10">因情况紧急，被保险人（申请人）向人民法院对被申请人价值人民币        ${ mapPolicy['valuation']}        元整的财产进行财产保全。</td>
						</tr> 
                   	</tbody>
				</table>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
							<td class="tablebg_f5f8fa col-sm-3 col-xs-3">申请保全的财产的类别</td>
							<td class="tablebg_f5f8fa col-sm-3 col-xs-3">保全标的物地址</td> 
							<td class="tablebg_f5f8fa col-sm-6 col-xs-6">相关文件</td>
						</tr>
						<tr>
							<td class="col-sm-3 col-xs-3">房产</td>
							<td class="col-sm-3 col-xs-3">${ mapPolicy['house_address']}</td> 
							<td class="col-sm-6 col-xs-6"><c:if test="${ not empty mapPolicy['house_claims']}"><a target="_blank" href="${ mapPolicy['house_claims']}">查看</a></c:if></td>
						</tr>
						<tr>
							<td class="col-sm-3 col-xs-3">现金/银行账户</td>
							<td class="col-sm-3 col-xs-3">${ mapPolicy['cash_address']}</td> 
							<td class="col-sm-6 col-xs-6"><c:if test="${ not empty mapPolicy['cash_claims']}"><a target="_blank" href="${ mapPolicy['cash_claims']}">查看</a></c:if></td>
						</tr>
						<tr>
							<td class="col-sm-3 col-xs-3">机械设备</td>
							<td class="col-sm-3 col-xs-3">${ mapPolicy['instrument_address']}</td> 
							<td class="col-sm-6 col-xs-6"><c:if test="${ not empty mapPolicy['instrument_claims']}"><a target="_blank" href="${ mapPolicy['instrument_claims']}">查看</a></c:if></td>
						</tr>
						<tr>
							<td class="col-sm-3 col-xs-3">汽车/工程机械</td>
							<td class="col-sm-3 col-xs-3">${ mapPolicy['facility_address']}</td> 
							<td class="col-sm-6 col-xs-6"><c:if test="${ not empty mapPolicy['facility_claims']}"><a target="_blank" href="${ mapPolicy['facility_claims']}">查看</a></c:if></td>
						</tr>
						<tr>
							<td class="col-sm-3 col-xs-3">其它标的</td>
							<td class="col-sm-3 col-xs-3">${ mapPolicy['otherobject_address']}</td> 
							<td class="col-sm-6 col-xs-6"><c:if test="${ not empty mapPolicy['otherobject_claims']}"><a target="_blank" href="${ mapPolicy['otherobject_claims']}">查看</a></c:if></td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>保险信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">赔偿限额(元)</td>
							<td class="col-sm-10 col-xs-10">${ mapPolicy['insuredAmount']}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保险期间</td>
							<td class="col-sm-10 col-xs-10">自保险人签发本保险单时起，至保险单载明的案件调解、裁定或判决生效，或解除财产保全时止。</td>
						</tr> 
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
							<td class="col-sm-10 col-xs-10">中华人民共和国司法管辖（港澳台除外）</td>
						</tr> 
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
							<td class="col-sm-10 col-xs-10">诉讼</td>
						</tr> 
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>案件资料</h3></div>
			<div class="affirm-warr download-table">
				<table class="table ">
                    <tbody> 
                       	<tr class="tablebg_f5f8fa">
                            <td class=" col-sm-1 col-xs-1">一、</td>
							<td class="col-sm-10 col-xs-10">起诉：</td>
                        </tr>
                        <tr>
							<td class=" col-sm-1 col-xs-1">1</td>
							<td class="col-sm-10 col-xs-10">《起诉状》原件（盖公章）<c:if test="${ not empty mapPolicy['qs_subfile_1']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['qs_subfile_1']}','《起诉状》原件');">下载</a></c:if></td>
						</tr> 
						<tr>
							<td class=" col-sm-1 col-xs-1">2</td>
							<td class="col-sm-10 col-xs-10">证据目录及证据（证据须标明来源、有无原件）<c:if test="${ not empty mapPolicy['qs_subfile_2']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['qs_subfile_2']}','证据目录及证据');">下载</a></c:if></td>
						</tr>
						<tr class="tablebg_f5f8fa">
                            <td class=" col-sm-1 col-xs-1">二、</td>
							<td class="col-sm-10 col-xs-10">保全：</td>
                        </tr>
                        <tr>
							<td class=" col-sm-1 col-xs-1">1</td>
							<td class="col-sm-10 col-xs-10">《保全申请书》<c:if test="${ not empty mapPolicy['bq_subfile_1']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['bq_subfile_1']}','《保全申请书》');">下载</a></c:if></td>
						</tr> 
						<tr>
							<td class=" col-sm-1 col-xs-1">2</td>
							<td class="col-sm-10 col-xs-10">财产线索<c:if test="${ not empty mapPolicy['bq_subfile_2']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['bq_subfile_2']}','财产线索');">下载</a></c:if></td>
						</tr>
						<tr class="tablebg_f5f8fa">
                            <td class=" col-sm-1 col-xs-1">三、</td>
							<td class="col-sm-10 col-xs-10">法院受理：</td>
                        </tr>
                        <tr>
							<td class=" col-sm-1 col-xs-1">1</td>
							<td class="col-sm-10 col-xs-10">受理案件通知书<c:if test="${ not empty mapPolicy['sl_subfile_1']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['sl_subfile_1']}','受理案件通知书');">下载</a></c:if></td>
						</tr> 
						<tr>
							<td class=" col-sm-1 col-xs-1">2</td>
							<td class="col-sm-10 col-xs-10">诉讼须知、举证通知书<c:if test="${ not empty mapPolicy['sl_subfile_2']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['sl_subfile_2']}','诉讼须知、举证通知书');">下载</a></c:if></td>
						</tr>
						<tr>
							<td class=" col-sm-1 col-xs-1">2</td>
							<td class="col-sm-10 col-xs-10">告知审判庭组成人员通知书<c:if test="${ not empty mapPolicy['sl_subfile_3']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['sl_subfile_3']}','告知审判庭组成人员通知书');">下载</a></c:if></td>
						</tr>
						<tr class="tablebg_f5f8fa">
                            <td class=" col-sm-1 col-xs-1">四、</td>
							<td class="col-sm-10 col-xs-10">补充资料：</td>
                        </tr>
                        <tr>
							<td class=" col-sm-1 col-xs-1">1</td>
							<td class="col-sm-10 col-xs-10">资料一<c:if test="${ not empty mapPolicy['supplement_1']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['supplement_1']}','资料一');">下载</a></c:if></td>
						</tr> 
						<tr>
							<td class=" col-sm-1 col-xs-1">2</td>
							<td class="col-sm-10 col-xs-10">资料二<c:if test="${ not empty mapPolicy['supplement_2']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['supplement_2']}','资料二');">下载</a></c:if></td>
						</tr>
						<tr>
							<td class=" col-sm-1 col-xs-1">2</td>
							<td class="col-sm-10 col-xs-10">资料三<c:if test="${ not empty mapPolicy['supplement_3']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['supplement_3']}','资料三');">下载</a></c:if></td>
						</tr>
						<tr>
							<td class=" col-sm-1 col-xs-1">2</td>
							<td class="col-sm-10 col-xs-10">资料四<c:if test="${ not empty mapPolicy['supplement_4']}"><a target="_blank" class="pull-right" href="javascript:void(0);" onclick="sodownload('${ mapPolicy['supplement_4']}','资料四');">下载</a></c:if></td>
						</tr>
						
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>风评报告</h3></div>
			<div class="affirm-warr download-table">
				<table class="table ">
                       <tbody> 
                       	<tr>
							<td class=" col-sm-1 col-xs-1">风评报告</td>
							<td class="col-sm-10 col-xs-10"><c:if test="${ not empty orderFirm.riskReportPath }"><a target="_blank" class="pull-right" href="sodownload('${orderFirm.riskReportPath }','风评报告');">下载</a></c:if></td>
						</tr>
                   	</tbody>
				</table>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
	<div class="row next-step" id="btnArea">
		<div class="col-sm-12 col-xs-12" >
			<c:if test="${ orderFirm.riskStatus eq 'UNENTERING'}">
			<p id="insureArea">
				<a href="javascript:void(0);" onclick="dropInsure('${orderFirm.oid}');" class="ns-btn">放弃承接此单</a>
				<a href="javascript:void(0);" onclick="acceptInsure('${orderFirm.oid}');" class="ns-btn">确认承接此单</a>
			</p>
			</c:if>
			<c:if test="${orderFirm.riskUploadStatus ne 'UPLOADING' && orderFirm.riskStatus ne 'GIVEUP' }">
			<p id="enteringArea" ${ mapPolicy['policyStatus'] eq 'WAITOFFER' && orderFirm.riskStatus eq 'ACCEPT' && orderFirm.riskUploadStatus eq 'UNUPLOADING' ? '':'style="display:none;"' }>
				<a id="rateBtn" href="javascript:void(0);" onclick="showRiskReportModal('${orderFirm.oid}');" class="ns-btn">上传风评报告</a>
			</p>
			</c:if>
		</div>
	</div>
</div><!-- container end --> 



<!-- 内容部分  注册  结束 -->
<jsp:include page="../../index/multi_f.jsp" />
<!-- 上传风评报告 start -->
<div class="modal fade" id="revamp-riskReport" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">上传风评报告</h4>
		  </div>
		  <form id="riskReportForm" method="post" enctype="multipart/form-data" action='<c:url value="/lawFirm/uploadRiskReprot.json?ACCESS_TOKEN=${ACCESS_TOKEN}"/>'>
			  <input type="hidden" name="orderFirmId" id="orderFirmId" value="${orderFirm.oid }">
			  <div class="modal-body">
			  	<p> 
					<div class="col-sm-12 col-xs-12" id="bhPath_isHidden">
						<div class="basic-file">
							<input name="riskReportPath_file" id="riskReportPath_file-5" class="file" type="file" data-drawview="${orderFirm.riskReportPath }" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
						</div> 
					</div> 
			  	</p> 
			  </div>
			  <div class="modal-footer">
				<div class="mofo-sub">
					<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
					<button type="button" class="btn notarize-btn pull-right" onclick="uploadRiskReprot('close');">确认</button>
				</div>
			  </div> 
		  </form> 
		</div> 
  </div> 
</div> 
<!-- 上传风评报告 end -->
<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
	<input name="path" id="path-dow" type="hidden">
	<input name="name" id="name-dow" type="hidden">
</form>
<!-- script -->
<script type="text/javascript" src="<c:url value='/resources/js/lawFirm.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function sodownload(path,name){
		path = path.split(".com/")[1];
		$("#path-dow").val(path);
		$("#name-dow").val(name);
		$("#dow-now").submit();
	}
</script>

</body>
</html>