<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">


		<title>百联保-我的账户</title>
		
	</head>
	<style>
		.line-limit-length {

			overflow: hidden;

			text-overflow: ellipsis;

			white-space: nowrap; //文本不换行，这样超出一行的部分被截取，显示...

		}
	</style>
	<body>
	<jsp:include page="../index/multi_h.jsp"/>
	<div class="container">
		<%--<div class="addr">
			<span>当前位置：</span>
			<span class="current">首页 > </span>
			<a class="active" href="#">我的账户</a>
		</div>--%>
		<jsp:include page="../index/multi_pc_l.jsp"/>
		<!--右边部分开始-->
		<div class="user-info">
			<ul class="info-list">
				<li>
					<div class="list-left">
						<img src="<c:url value='/resources/version_new/images/user-photo.png' />" alt="用户头像" class="user-photo">
					</div>
					<div class="list-right">
						<span class="right-user line-limit-length" title="${not empty userdetail.company_name ? userdetail.company_name : not empty userdetail.real_name ? userdetail.real_name :  userdetail.login_name }">你好，${not empty userdetail.company_name ? userdetail.company_name : not empty userdetail.real_name ? userdetail.real_name :  userdetail.login_name }</span>
						<c:if test="${not empty userdetail.terminal_type && userdetail.terminal_type  eq '1'}">
							<span>个人用户</span>
						</c:if>
						<c:if test="${not empty userdetail.terminal_type && userdetail.terminal_type  eq '2'}">
							<span>企业用户</span>
						</c:if>
						<c:if test="${not empty userdetail.is_certification && userdetail.is_certification  eq '1'}">
							<i class="user-icon"></i>
						</c:if>
						<c:if test="${not empty userdetail.c_is_certification && userdetail.c_is_certification  eq '1'}">
							<i class="user-icon"></i>
						</c:if>

					</div>
				</li>
				<li class="phone-info">
					<c:if test="${not  empty  userdetail.telephone}">
						<div class="phone-up">
							<i class="phone-icon"></i>
							<span>${userdetail.telephone }</span>
							<span>|</span>
							<span>已验证</span>
						</div>
					</c:if>
					<c:if test="${empty  userdetail.telephone}">
						<div class="phone-down">
							<i class="phone-icon"></i>
							<a href="<c:url value='/pc/phoneInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="phone-ver">立即验证</a>
						</div>
					</c:if>
					<c:if test="${not  empty  userdetail.email}">
						<div class="email-up" style="margin-top: 5px;">
							<i class="email-icon"></i>
							<span>${userdetail.email }</span>
							<span>|</span>
							<span>已验证</span>
						</div>
					</c:if>
					<c:if test="${empty  userdetail.email}">
						<div class="email-down">
							<i class="email-icon"></i>
							<a href="<c:url value='/pc/emailInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="email-ver">立即验证</a>
						</div>
					</c:if>

				</li>
				<li class="login-stat">
					<div class="login-time">
						<span class="prev-time">上次登录时间：</span>
						<c:if test="${empty  userdetail.last_login_time}">
							<span>${date}</span>
						</c:if>
						<c:if test="${ not empty  userdetail.last_login_time}">
							<span>${userdetail.last_login_time}</span>
						</c:if>
					</div>
					<div class="info-stat">
						<span class="info-detail">资料完整度：</span>
						<div class="stat-bc">
							<div class="stat-num"></div>
						</div>
						<span id="info-number" style="float: right;">${num}%</span>
					</div>
				</li>
			</ul>
		</div>
		<ul class="order-list">
			<li ${ policyStatus eq '25'?'class="active"':'' } onclick="choisePolicyStatus('25','${empty policyTotals['ALL'] ? '0' : policyTotals['ALL'] }',this);">全部订单（${empty policyTotals['ALL'] ? '0' : policyTotals['ALL'] }）</li>
			<li ${ policyStatus eq '1'?'class="active"':'' } onclick="choisePolicyStatus('1','${empty policyTotals['INSSUM'] ? '0' : policyTotals['INSSUM'] }',this);">投保中（${empty policyTotals['INSSUM'] ? '0' : policyTotals['INSSUM'] }）</li>
			<li ${ policyStatus eq '2'?'class="active"':'' } onclick="choisePolicyStatus('2','${empty policyTotals['AUDITSUM'] ? '0' : policyTotals['AUDITSUM'] }',this);">待核保（${empty policyTotals['AUDITSUM'] ? '0' : policyTotals['AUDITSUM'] }）</li>
			<li ${ policyStatus eq '22'?'class="active"':'' } onclick="choisePolicyStatus('22','${empty policyTotals['NOPAYSUM'] ? '0' : policyTotals['NOPAYSUM'] }',this);">待支付（${empty policyTotals['NOPAYSUM'] ? '0' : policyTotals['NOPAYSUM'] }）</li>
			<li ${ policyStatus eq '5'?'class="active"':'' } onclick="choisePolicyStatus('5','${empty policyTotals['TOBEINSURED'] ? '0' : policyTotals['TOBEINSURED'] }',this);">待承保（${empty policyTotals['TOBEINSURED'] ? '0' : policyTotals['TOBEINSURED'] }）</li>
			<li ${ policyStatus eq '23'?'class="active"':'' } onclick="choisePolicyStatus('23','${empty policyTotals['DOPAY'] ? '0' : policyTotals['DOPAY'] }',this);">已购买（${empty policyTotals['DOPAY'] ? '0' : policyTotals['DOPAY'] }）</li>
			<li ${ policyStatus eq '21'?'class="active"':'' } onclick="choisePolicyStatus('21','${empty policyTotals['UNDERWRITESUM'] ? '0' : policyTotals['UNDERWRITESUM'] }',this);">保障中（${empty policyTotals['UNDERWRITESUM'] ? '0' : policyTotals['UNDERWRITESUM'] }）</li>
			<li ${ policyStatus eq '24'?'class="active"':'' } onclick="choisePolicyStatus('24','${empty policyTotals['TORENEW'] ? '0' : policyTotals['TORENEW'] }',this);">已失效（${empty policyTotals['TORENEW'] ? '0' : policyTotals['TORENEW'] }）</li>
		</ul>
		<div class="tab-query tab-order my-order wed-ert">
			<div id="policysArea">

				<ul class="tab-title">
					<li class="wid-220">基本信息</li>
					<li>被保险人</li>
					<li>保障时间</li>
					<li>份数</li>
					<li>保费（元）</li>
					<li>状态</li>
					<li>操作</li>
				</ul>
				<div class="tab-content">
					<c:choose>
						<c:when test="${empty orderList }">
							<div class="order-detail">
								<ul class="order-num">
									<li style="float: none">
										<p style="text-align: center">暂无订单！</p>
									</li>
								</ul>
							</div>
						</c:when>
						<c:otherwise>
							<c:forEach items="${orderList }" var="policy">
								<div class="order-detail">
									<ul class="order-num">
										<li>
											<span  class="num-name">订单号：</span>
											<span>${policy.trade_serial_number}</span>
										</li>
										<li>
											<c:choose>
												<c:when test="${empty policy.external_reference && not empty policy.policy_serial_number}">
													<span  class="num-name">投保单号：</span>
													<span>${policy.policy_serial_number}</span>
												</c:when>
												<c:otherwise>
													<span  class="num-name">保单号：</span>
													<span>${policy.external_reference}</span>
												</c:otherwise>
											</c:choose>
										</li>
										<li class="order-time">
											创建时间：${policy.start_time}
										</li>
									</ul>
									<ul class="tab-body">
										<li class="wid-220 two">
											<a href="#" class="insu">${policy.product_name }</a>
										</li>
										<li class="wed">
											<span>
												<c:choose>
													<c:when test="${fn:contains(policy.product_code, 'TYX') }">
														团体
													</c:when>
													<c:otherwise>
														${policy.insured_role}
													</c:otherwise>
												</c:choose>
											</span>
										</li>
										<li class="three">
											<c:if test="${not empty policy.inception_date && not empty policy.planned_end_date}">
												<div class="qoi">${fn:replace(policy.inception_date,' 00:00:00', '')}</div>
												<div>至</div>
												<div>
													<c:if test="${fn:contains(policy.planned_end_date,' 23:59:59')}">
														${fn:replace(policy.planned_end_date,' 23:59:59', '')}
													</c:if>
													<c:if test="${fn:contains(policy.planned_end_date,' 00:00:00')}">
														${fn:replace(policy.planned_end_date,' 00:00:00', '')}
													</c:if>
												</div>
											</c:if>
										</li>
										<li>
											<span>
												1份
											</span>
										</li>
										<li>
											<span>
												<c:if test="${not empty policy.gross_premium}">
													￥${policy.gross_premium}
												</c:if>
											</span>
										</li>
										<li class="pay">
											<span>
												<c:choose>
													<c:when test="${policy.policy_status eq '4' || policy.policy_status eq '16' }">
														${fns:getDictLabel (policy.policy_status,"order_status","")}
													</c:when>
													<c:otherwise>
														${fns:getDictLabel (policy.policy_status,"order_status","")}
													</c:otherwise>
												</c:choose>
											</span>
										</li>
										<li class="pay-delete">
											<c:if test="${policy.policy_status != '1' }">
												<a target="_blank" href="<c:url value='/pc/order/exportDetailByOrderID/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">查看${ empty policy.external_reference ? '投保单':'保单'}</a>
											</c:if>
											<c:if test="${policy.policy_status eq '1' }">
												<c:if test="${policy.product_code eq 'BZX-TB-GCTB'||policy.product_code eq 'BZX-YG-GCTB'||policy.product_code eq 'BZX-DB-GCTB' }"><a target="_blank" href="${policy.headurl}/insurance/build/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${policy.product_code eq 'BZX-GCLY' }"><a target="_blank" href="${policy.headurl}/insurance/build/policy/pg_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${policy.product_code eq 'BZX-SSBQ' }"><a target="_blank" href="${policy.headurl}/insurance/lawsuit/policy/lt_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${policy.product_code eq 'XYX-XWCK' }"><a target="_blank" href="${policy.headurl}/insurance/customs/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${policy.product_code eq 'XYX-DQCK' }"><a target="_blank" href="${policy.headurl}/insurance/customs/policy/qy_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
<%--												<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a target="_blank" href="${policy.headurl}/insurance/afr/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>--%>
												<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'TYX') }"><a target="_blank" href="${policy.headurl}/insurance/tyx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GYX') }"><a target="_blank" href="${policy.headurl}/insurance/gyx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'ZZX') }"><a target="_blank" href="${policy.headurl}/insurance/zzx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GZZRX') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">继续投保</a></c:if>
											</c:if>
											<c:if test="${policy.policy_status eq '3'}">
												<c:choose>
													<c:when test="${fn:contains(policy.product_code, 'TYX-PAC') }">
														<a href="${policy.headurl}/insurance/tyx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
													</c:when>
													<c:when test="${fn:contains(policy.product_code, 'GZZRX-ZH') }">
														<a href="${policy.headurl}/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
													</c:when>
													<c:when test="${fn:contains(policy.product_code, 'GZZRX-CA') }">
														<a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
													</c:when>
													<c:when test="${fn:contains(policy.product_code, 'TYX-CA') }">
														<a target="_blank" href="${policy.headurl}/insurance/tyx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
													</c:when>
													<c:otherwise>
														<a target="_blank" href="${policy.headurl}/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">确认报价</a>
													</c:otherwise>
												</c:choose>
											</c:if>
											<c:if test="${policy.policy_status eq '4'}">
												<c:if test="${policy.product_code eq 'BZX-TB-GCTB'}">
													<c:if test="${ empty policy.policy_serial_number}"><a target="_blank" href="${policy.headurl}/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
													<c:if test="${not empty policy.policy_serial_number && not empty policy.show_url}"><a target="_blank" href="${policy.show_url}" class="again-pay">立即支付</a></c:if>
												</c:if>
												<c:if test="${policy.product_code eq 'BZX-YG-GCTB'||policy.product_code eq 'BZX-DB-GCTB'}">
													<a target="_blank" href="${policy.headurl}/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a>
												</c:if>
												<c:if test="${ policy.product_code eq 'BZX-GCLY'}"><a target="_blank" href="${policy.headurl}/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${policy.product_code eq 'BZX-SSBQ'}"><a target="_blank" href="${policy.headurl}/insurance/lawsuit/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a target="_blank" href="${policy.headurl}/insurance/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'TYX')&&!fn:contains(policy.product_code, 'TYX-CA') }"><a target="_blank" href="${policy.headurl}/insurance/tyx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GYX') }"><a target="_blank" href="${policy.show_url}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'ZZX') }"><a target="_blank" href="${policy.headurl}/insurance/zzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GZZRX-CA') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GZZRX-QH') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'TYX-CA') }"><a target="_blank" href="${policy.headurl}/insurance/gmr/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
												<c:if test="${fn:contains(policy.product_code, 'GZZRX')&&!fn:contains(policy.product_code, 'GZZRX-CA')&&!fn:contains(policy.product_code, 'GZZRX-QH') }"><a target="_blank" href="${policy.headurl}/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a></c:if>
											</c:if>
											<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'TYX') || fn:contains(policy.product_code, 'GZZRX')) }">
												<a href="<c:url value='/pc/preservation/resultSet/resultSetList?policyId=${policy.oid }&ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">保全</a>
											</c:if>
											<c:if test="${policy.policy_status eq '6' && fn:contains(policy.product_code, 'TYX-PAC') }">
												<a href="<c:url value='/pc/order/policyReport?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">理赔申请</a>
											</c:if>
											<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'GZZRX-PAC')||fn:contains(policy.product_code, 'GZZRX-ZH')||fn:contains(policy.product_code, 'GZZRX-CA')||fn:contains(policy.product_code, 'TYX-CA')) }">
												<a href="<c:url value='/pc/report/reportInit/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">理赔申请</a>
											</c:if>
											<c:if test="${ policy.policy_status eq '16'}">
												<c:choose>
													<c:when test="${fn:contains(policy.product_code, 'GZZRX-PAC') }">
														<a href="${policy.headurl}/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">缴费单</a>
													</c:when>
													<c:otherwise>
														<a target="_blank" href="${policy.headurl}/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}" class="again-pay">立即支付</a>
													</c:otherwise>
												</c:choose>
											</c:if>
											<c:if test="${policy.policy_status eq '3' || policy.policy_status eq '4' }">
												<div class="again-pay" onclick="copyOrder('${policy.oid }');">复制</div>
											</c:if>
											<c:if test="${policy.policy_status eq '1' || policy.policy_status eq '2' || policy.policy_status eq '4' }">
												<div class="delete" onclick="deleteExportOrder('${policy.oid }','${policy.policy_status }');">删除</div>
											</c:if>
										</li>
									</ul>
								</div>
							</c:forEach>
						</c:otherwise>
					</c:choose>
				</div>
			</div>
			<div class="filter-pagination">
				<div id="callBackPager"></div>
			</div>
		</div>		<!--右边部分介绍-->

		<form id="orderForm">
			<input type="hidden" id="policyStatus" name="policyStatus" value="${policyStatus }"/>
			<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
			<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
			<input type="hidden" name="totalCount" id="totalCount" value="${empty dwzPage.totalCount ? 0 : dwzPage.totalCount}">
		</form>
	</div>
	<jsp:include page="../index/multi_f.jsp"/>
	<script type="text/javascript" src="<c:url value='/resources/js/exportOrder.js?'/>${fns:getTime()}"></script>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript">
        var baseUrl = '${pageContext.request.contextPath }';
        $(function () {
            function mouse(even, stat, iconA, iconB) {
                $('.order-detail').on(even, '.guar', function () {
                    $(this).siblings('.guar-list').css('display',stat);
                    $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
                });
            }
            //鼠标移动到元素上显示
            mouse('mouseenter', 'block', 'down-icon', 'up-icon');
            //鼠标移出元素
            mouse('mouseleave', 'none', 'up-icon', 'down-icon');
        })
        var totalCount = Number($('#totalCount').val()) || 0;
        var showCount = $('#showCount').val() || 5;
        var limit = Number($('#numPerPage').val()) || 5;

        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("orderForm","policysArea");
            }
        });

		var info_width = $('#info-number').text();
		$('.stat-bc .stat-num').css({"width":info_width});

		$('.order-detail ul.tab-body li.wed').each(function () {
			var s = $(this).find('p').height();
			if(s > 95 && s < 210){
				$('.order-detail ul.tab-body li.wed').css({"line-height":'28px',"padding-top":"18px"});
			}else if(s > 210){
				$('.order-detail ul.tab-body li.wed').css({"line-height":'28px',"padding-top":"5px"});
			}
		})

	</script>
</html>

