<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-应收账款管理-查询</title>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
		<jsp:include page="../../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="container w100-mt20"><!-- container start --> 
				<div class="nav-list" >
					<div class="row">
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">1</i><span class=" pull-left">选择保单</span></p>
						</div>
						<div class="col-sm-4 col-sm-4 active">
							<p><i class="glyphicon glyphicon-ok  pull-left"></i><span class="pull-left">应收账款查询</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">3</i><span class="pull-left">收款登记</span></p>
						</div> 
					</div>
				</div>

				<form id="searchForm" name="searchForm">
				<div class="message-war">
					<!-- message-war start -->
					<div class="w-95-auto">
						<!-- w-95-auto start -->
						<div class="mess-title">
							<h3>查询条件</h3>
						</div>
						<div class="clearfix">
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>保单号</p>
									<input type="text" id="externalReference" name="external_reference" class="form-control" value="${policy.external_reference}" readonly="readonly">
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>被保险人</p>
									<select id="insured" name="insured" class="form-control" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
										<option value="">请选择被保险人</option>
										<c:forEach items="${policyInsured}" var="listI">
		                                 <option value="${listI}">${listI}</option>
		                                </c:forEach>
									</select>
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>申报类型</p>
									<div class="col-sm-12 col-xs-12">
										<div class="row">
											<div class="col-sm-12 col-xs-12 rad-io">
												<span><input type="radio" name="declare_type" id="declare_type" checked="checked" readonly="readonly">
												<label for="radio_tb" class="pull-left"></label><strong class="pull-left lh-17">投保出运</strong></span>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>国家</p>
									<select name="buyers_country" id="buyers_country" class="form-control" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
										<option value="">请选择</option>
										<c:forEach items="${buyers_country}" var="list">
		                                 <option value="${list}">${list}</option>
		                                </c:forEach>
									</select>
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>发票号</p>
									<input id="invoice_no" name="invoice_no" type="text" class="form-control" placeholder="">
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>卖家名称</p>
									<input id="applicant" name="applicant" type="text" class="form-control" placeholder="请输入卖家名称">
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>处理状态</p>
									<select id="status" name="status" class="form-control" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
										<option value="">请选择</option>
										<option value="0">未偿还</option>
										<option value="1">已偿清</option>
										<option value="2">部分偿清</option>
									</select>
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>出运期间</p>
									<div class="row fs-lh34">
										<div class="col-sm-5 col-xs-5">
											<label class="pull-left"><input placeholder="" id="startDate" name="startDate" class="laydate-icon form-control"></label>
										</div>
										<div class="col-sm-1 col-xs-1">到</div>
										<div class="col-sm-5 col-xs-5">
											<input placeholder="" id="endDate" name="endDate" class="laydate-icon form-control">
										</div>
									</div>
								</div>
								<div class="next-step">
									<div class="col-sm-3 col-xs-3 pull-right mt-20">
										<a href="javascript:void(0);" onclick="doSearch()" class="ns-btn">查询</a>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- w-95-auto end -->
				</div>
				<!-- message-war end -->
				</form>

				<!-- 以下供查询使用 -->
				<div class="message-war"><!-- message-war start --> 
					<div class="w-95-auto"><!-- w-95-auto start --> 
						<div class="mess-title"><h3>请选择一张保单</h3></div>
						<div class="affirm-warr"  id="policysArea"></div> 
					</div><!-- w-95-auto end -->
				</div><!-- message-war end -->
				<div class="row next-step">
					<div class="col-sm-6 col-sm-6">
							<!-- 分页 start -->
						<nav class="text-center">
							 <form id="policyForm">
				            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
				            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
				            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
				            	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
				            </form>
						</nav>
					</div>
					<div class="col-sm-6 col-xs-6 pull-right">
						<p> 
							<a href="javascript:void(0);" onclick="goBack()" class="ns-btn">上一步</a> 
						</p> 
					</div>
				</div>
				
			</div><!-- container end --> 
			</div><!-- mar-content 右边内容块 end -->
		</div>
	</body> 
</html>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/extendPagination.js'/>" ></script>
<script type="text/javascript">
	choiseMenu("receiveAmounts");
	var baseUrl = '${pageContext.request.contextPath}';
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 10;
	getListForPage("policyForm","policysArea");
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage("policyForm","policysArea");
		}
	});
	function getListForPage(formId,contentId){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/exports/receive/accounts/getDeclarationByPolicyIdForPage/"+${policy.oid},
			data : $("#"+formId).serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#"+contentId).html(data);			
			},
			error: function(){
				layer.close(index);
			}
		});
	}
	
	function doSearch(){
		var baseUrl = '${pageContext.request.contextPath}';
		var totalCount = Number($('#totalCount').val()) || 0;
		var showCount = $('#showCount').val() || 5;
		var limit = Number($('#numPerPage').val()) || 10;
		getListForPage2("policyForm","policysArea");
		$('#callBackPager').extendPagination({
			totalCount: totalCount,
			showCount: showCount,
			limit: limit,
			callback: function (curr, limit, totalCount) {
				getListForPage2("policyForm","policysArea");
			}
		});
		function getListForPage2(formId,contentId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			var formData = $("#searchForm").serialize();
			var policyOid = ${policy.oid};
			layer.close(index);
				$.ajax({
				type : 'POST',
				url : baseUrl + "/exports/receive/accounts/getDeclarationBySearch?"+formData+"&policyOid="+policyOid,
				data : $("#"+formId).serialize(),
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#"+contentId).html(data);			
				},
				error: function(){
					layer.close(index);
				}
			});
		}
	}
	
	function goReceiveDeclaration(declarationOid){
		var oid = declarationOid;
		var baseUrl = '${pageContext.request.contextPath}';
		window.location=baseUrl+"/exports/receive/accounts/getDeclarationMessage/"+oid+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	
	function goBack(){
		var baseUrl = '${pageContext.request.contextPath}';
		window.location=baseUrl+"/exports/receive/accounts/index?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
	//日期范围限制
	var startDate = {
	    elem: '#startDate',
	    format: 'YYYY-MM-DD',
	    min: '2015-01-01', //设定最小日期为当前日期
	    max: '2099-06-16', //最大日期
	    istime: true,
	    istoday: false,
	    choose: function(datas){
	        endDate.min = datas; //开始日选好后，重置结束日的最小日期
	        endDate.startDate = datas //将结束日的初始值设定为开始日
			endDate.max = time1;
	    }
	};
	var endDate = {
	    elem: '#endDate',
	    format: 'YYYY-MM-DD',
	    min: laydate.now(),
	    max: '2099-06-16',
	    istime: true,
	    istoday: false,
	    choose: function(datas){
	        startDate.max = datas; //结束日选好后，充值开始日的最大日期
	    }
	};
	Date.prototype.Format = function (fmt) { //author: meizz 
	    var o = {
	        "M+": this.getMonth() + 1, //月份 
	        "d+": this.getDate(), //日 
	        "h+": this.getHours(), //小时 
	        "m+": this.getMinutes(), //分 
	        "s+": this.getSeconds(), //秒 
	        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
	        "S": this.getMilliseconds() //毫秒 
	    };
	    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	    for (var k in o)
	    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
	    return fmt;
	}
	laydate(startDate);
	laydate(endDate);
</script>


