<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-应收账款管理-选择保单</title>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="../../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="container w100-mt20"><!-- container start --> 
				<div class="nav-list" >
					<div class="row">
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">1</i><span class=" pull-left">选择保单</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">2</i><span class="pull-left">应收账款查询</span></p>
						</div>
						<div class="col-sm-4 col-sm-4  active">
							<p><i class="glyphicon glyphicon-ok pull-left"></i><span class="pull-left">收款登记</span></p>
						</div> 
					</div>
				</div>
				
					<div class="message-war"><!-- message-war start --> 
						<div class="w-95-auto"><!-- w-95-auto start --> 
							<div class="clearfix">
								<div class="clearfix">
									<div class="col-sm-4 col-xs-4">
										<p>保单号</p>
										<input type="text" id="externalReference" name="external_reference" value="${declaration.policy.external_reference}" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4 col-xs-4">
										<p>被保险人</p>
										<input type="text" id="insured" name="insured" value="${declaration.insured}" class="form-control"  readonly="readonly">
									</div> 
								</div> 
								<div class="mess-title"><h3></h3></div> 
								<div class="clearfix">
									<div class="col-sm-4">
										<p>买家代码：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>买家公司名称：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>注册地址：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
								</div>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>邮编：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>证照类型：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>证照号码：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
								</div>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>公司级别： </p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>注册资本： </p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>员工数：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
								</div>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>行业类别：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>联系人姓名：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>电话号码：</p>
										<input type="text" id="" name="" value="" class="form-control"  readonly="readonly">
									</div>
								</div> 
							</div> 
							<div class="mess-title"><h3>出运信息</h3></div>
							<div class="clearfix">
								<div class="col-sm-4">
									<p>发票号：</p>
									<input type="text" id="invoice_no" name="invoice_no" value="${declaration.invoice_no}" class="form-control"  readonly="readonly">
								</div>
								<div class="col-sm-4">
									<p>发票金额：</p>
									<input type="text" id="invoice_amount" name="invoice_amount" value="${declaration.invoice_amount}" class="form-control"  readonly="readonly">
								</div>
								<div class="col-sm-4">
									<p>商品名称：</p>
									<input type="text" id="c_name" name="c_name" value="${declaration.c_name}" class="form-control"  readonly="readonly">
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4">
									<p>数量/包装：</p>
									<input type="text" id="pack_num" name="pack_num" value="${declaration.pack_num}" class="form-control"  readonly="readonly">
								</div>
								<div class="col-sm-4">
									<p>出运日期：</p>
									<input type="text" id="delivery_time" name="delivery_time" value="${declaration.delivery_time}" class="form-control"  readonly="readonly">
								</div>
								<div class="col-sm-4">
									<p>运输方式：</p>
									<input type="text" id="mode_of_transport" name="mode_of_transport" value="${declaration.mode_of_transport}" class="form-control"  readonly="readonly">
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4">
									<p>合同账期：</p>
									<input type="text" id="contract_days" name="contract_days" value="${declaration.contract_days}" class="form-control"  readonly="readonly">
								</div>
								<div class="col-sm-4">
									<p>报关单号：</p>
									<input type="text" id="declaration_no" name="declaration_no" value="${declaration.declaration_no}" class="form-control"  readonly="readonly">
								</div>
								<div class="col-sm-4">
									<p>投保金额：</p>
									<input type="text" id="coverage" name="coverage" value="${declaration.coverage}" class="form-control"  readonly="readonly">
								</div>
							</div>	
							<div class="mess-title"><h3>应收款登记</h3></div>
							<div class="clearfix">
								<div class="col-sm-4">
									<p>收款标记：</p>
									<div class="col-sm-4 col-xs-4 rad-io">
										<span><input type="radio" name="declare_type" id="declare_type" checked="checked" readonly="readonly">
										<label for="radio_tb"></label><strong >完全收款</strong></span>
									</div>
								</div>
								<div class="col-sm-4">
									<p>结算方式：</p>
									<input type="text" id="paymentTerms" name="payment_terms" value="${declaration.payment_terms}" class="form-control"  readonly="readonly">
								</div>
								<div class="col-sm-4">
									<p>结算银行：</p>
									<input type="text" id="issuing_swift" name="issuing_swift" value="${declaration.issuing_swift}" class="form-control"  readonly="readonly">
								</div>
							</div>
							<form id="receiveForm">
							<c:choose>
								<c:when test="${declaration.shipmentReceiveAmounts.status.value ne '1'}">
								<div class="clearfix">
									<div class="col-sm-4">
										<p>收款类别：</p>
										<select class="form-control" id="receivedType" name="receivedType" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
											<option value="">请选择</option>
											<option value="1">1</option>
											<option value="2">2</option>
										</select>
									</div>
									<div class="col-sm-4">
										<p>收款金额CNY</p>
										<input type="text" id="receivedAmounts" name="receivedAmounts" class="form-control" placeholder="">
									</div> 
								</div> 
								</c:when>
								<c:otherwise>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>收款类别：</p>
										<input type="text" id="receivedType" name="receivedType" value="${declaration.shipmentReceiveAmounts.receivedType}" class="form-control"  readonly="readonly">
									</div>
									<div class="col-sm-4">
										<p>收款金额CNY</p>
										<input type="text" id="receivedAmounts" name="receivedAmounts" value="${declaration.shipmentReceiveAmounts.receivedAmounts}" class="form-control" readonly="readonly">
									</div> 
								</div> 
								</c:otherwise>
							</c:choose>
							
							</form> 
						</div><!-- w-95-auto end -->
					</div><!-- message-war end -->
				
				<div class="row next-step"> 
					<div class="col-sm-6 col-xs-6">
						<p> 
							<c:if test="${declaration.shipmentReceiveAmounts.status.value ne '1'}">
							<a href="javascript:void(0);" onclick="doReceive(${declaration.oid})" class="ns-btn">收款</a> 
							</c:if>
							<a href="javascript:void(0);" onclick="goBack(${declaration.policy.oid})" class="ns-btn">上一步</a> 
						</p> 
					</div>
				</div>
				
				
			</div> <!-- container end --> 
			</div> <!-- mar-content 右边内容块 end -->
		</div>
	</body>
	
</html>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
		choiseMenu("receiveAmounts");
		var baseUrl = '${pageContext.request.contextPath}';
		function goBack(oid){
			window.location=baseUrl+"/exports/receive/accounts/choise/"+oid+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
		function doReceive(oid){
			$.ajax({
				type: 'POST',
				url:baseUrl + "/exports/receive/accounts/payDeclaration/"+oid,
				data:$("#receiveForm").serialize(),
				dataType:"json",
				cache: false,
				success: function(json){
					if(json.statusCode == '200') {
						layer.msg(json.resultDto.message);
						//刷新当前页面
						window.location.reload();
					}
					if(json.statusCode == '300') {
						layer.msg(json.resultDto.message);
					}
				}
			});
		}
</script>
