<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>
<%@ page import="org.springframework.security.core.AuthenticationException"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
<table class="table ">
	<tbody>
		<tr>
			<td class="col-sm-1 col-xs-1">发票号</td>
			<td class="col-sm-2 col-xs-2">买方公司名称</td>
			<td class="col-sm-1 col-xs-1">国家</td>
			<td class="col-sm-1 col-xs-1">结算方式</td>
			<td class="col-sm-2 col-xs-2">发票金额</td>
			<td class="col-sm-2 col-xs-2">已收金额</td>
			<td class="col-sm-1 col-xs-1">出运日期</td>
			<td class="col-sm-1 col-xs-1">处理状态</td>
			<td class="col-sm-2 col-xs-2">操作选项</td>
		</tr>

		<c:choose>
			<c:when test="${empty declarationList}">
				<tr>
					<td colspan="9" style="text-align: center;">暂无相关数据</td>
				</tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${declarationList}" var="declaration" varStatus="status">
					<tr>
						<td class="col-sm-1 col-xs-1">${declaration.invoice_no}</td>
						<td class="col-sm-2 col-xs-2">${declaration.oid}</td>
						<td class="col-sm-1 col-xs-1">${declaration.buyersQuota.buyers_country}</td>
						<td class="col-sm-1 col-xs-1">${declaration.payment_terms}</td>
						<td class="col-sm-2 col-xs-2">${declaration.invoice_amount}CNY</td>
						<td class="col-sm-2 col-xs-2">${declaration.shipmentReceiveAmounts.receivedAmounts}CNY</td>
						<td class="col-sm-1 col-xs-1">${declaration.delivery_time}</td>
						<c:choose>
							<c:when test="${declaration.shipmentReceiveAmounts.status.value eq '0'}">
								<td class="col-sm-1 col-xs-1">未偿还</td>
								<td class="col-sm-1 col-xs-1"><label><a href="javascript:void()" onclick="goReceiveDeclaration(${declaration.oid})">收款登记</a></label></td>
							</c:when>
							<c:when test="${declaration.shipmentReceiveAmounts.status.value eq '1'}">
								<td class="col-sm-1 col-xs-1">已偿清</td>
								<td class="col-sm-1 col-xs-1"><label><a href="javascript:void()" onclick="goReceiveDeclaration(${declaration.oid})">详细</a></label></td>
							</c:when>
							<c:when test="${declaration.shipmentReceiveAmounts.status.value eq '2'}">
								<td class="col-sm-1 col-xs-1">部分偿清</td>
								<td class="col-sm-1 col-xs-1"><label><a href="javascript:void()" onclick="goReceiveDeclaration(${declaration.oid})">收款登记</a></label></td>
							</c:when>
							<c:otherwise>
								<td class="col-sm-1 col-xs-1">--</td>
								<td class="col-sm-1 col-xs-1"><label>--</label></td>
							</c:otherwise>
						</c:choose>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</tbody>
</table>