<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>


<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<link type="text/css" rel="stylesheet"
      href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/>
<link type="text/css" rel="stylesheet"
      href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
<link type="text/css" rel="stylesheet"
      href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>"/>
<link type="text/css" rel="stylesheet"
      href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>"/>
<div class="container w100-mt20"><!-- container start -->
    <div class="nav-list">
        <div class="row">
            <div class="col-sm-4 col-sm-4">
                <p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">选择保单</span></p>
            </div>
            <div class="col-sm-4 col-sm-4 active">
                <p><i class="pull-left">2</i><span class="pull-left">限额查询</span></p>
            </div>
            <div class="col-sm-4 col-sm-4">
                <p><i class="pull-left">3</i><span class="pull-left">申请/修改</span></p>
            </div>
        </div>
    </div>
    <div class="message-war"><!-- message-war start -->
        <div class="w-95-auto"><!-- w-95-auto start -->
            <form id="buyerSerachForm" action="<c:url value='/exports/credit/findBuyerBySearchLlimit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
                <div class="mess-title"><h3>查询条件</h3></div>

                <div class="clearfix">

                    <div class="clearfix">
                        <div class="col-sm-4 col-xs-4">
                            <p>保单号</p>
                            <input type="text" class="form-control" value="${buyerdto.vo.external_reference }"
                                   readonly="readonly" placeholder="">
                        </div>
                        <div class="col-sm-4 col-xs-4">
                            <p>被保险人</p>
                            <select class="form-control"
                                    style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
                                <option>${buyerdto.vo.applicant_name }</option>
                            </select>
                        </div>
                        <div class="col-sm-4 col-xs-4">
                            <p>请选择国家</p>
                            <select class="form-control" name="country"
                                    style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
                                <option value="">请选择${topBuyersVo.country}</option>
                                <c:forEach items="${countryList}" var="c">
                                    <option value="${c.value}">${c.value}</option>
                                </c:forEach>
                                <%--
                                                                    <option value="中国" <c:if test="${not empty topBuyersVo.country && topBuyersVo.country eq '中国'}">selected="selected"</c:if>>中国</option>
                                --%>
                            </select>
                        </div>
                    </div>

                    <div class="clearfix">
                        <div class="col-sm-4 col-xs-4">
                            <p>买家代码</p>
                            <input type="text" class="form-control" name="code" value="${topBuyersVo.code}"
                                   placeholder="请输入买家代码">
                        </div>
                        <div class="col-sm-4 col-xs-4">
                            <p>买家名称</p>
                            <input type="text" class="form-control" name="customer_name"
                                   value="${topBuyersVo.customer_name}" placeholder="请输入买家名称">
                        </div>
                        <div class="col-sm-4 col-xs-4">
                            <p>限额类型</p>
                            <select class="form-control" name="limit_type"
                                    style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
                                <option value="">请选择</option>
                                <c:forEach items="${ApplicationLimitTypes }" var="applicationLimitType">
                                    <option value="${applicationLimitType.value}">${applicationLimitType.label}</option>
                                </c:forEach>
                            </select>


                        </div>
                    </div>
                    <div class="clearfix">
                        <div class="col-sm-8 col-xs-8">
                            <p>申请金额（USD）</p>
                            <label>从</label>
                            <label><input placeholder="" name="min_amount" type="text"></label>
                            <label>至</label>
                            <label><input placeholder="" name="max_amount" type="text"></label>

                        </div>
                        <div class="next-step">
                            <div class="col-sm-3 col-xs-3 pull-right mt-20">
                                <a onclick="doSearch()" class="ns-btn">查询</a>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
                <input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
                <input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
            </form>

        </div><!-- w-95-auto end -->


        <div class="mess-title"><h3>查询结果</h3></div>
        <div class="affirm-warr" id="buyerArea">
            <table class="table">
                <tbody>
                <tr>
                    <td class="col-sm-1 col-xs-1">买家代码</td>
                    <td class="col-sm-2 col-xs-2">买方公司名称</td>
                    <td class="col-sm-1 col-xs-1">国家</td>
                    <td class="col-sm-1 col-xs-1">限额类型</td>
                    <td class="col-sm-2 col-xs-2">申请限额</td>
                    <td class="col-sm-1 col-xs-1">批复限额</td>
                    <td class="col-sm-1 col-xs-1">批复状态</td>
                    <td class="col-sm-2 col-xs-2">操作选项</td>
                </tr>
                <c:choose>
                    <c:when test="${empty buyList}">
                        <tr>
                            <td class="col-sm-12" colspan="8" style="text-align: center;">暂无相关数据</td>
                        </tr>
                    </c:when>
                    <c:otherwise>
                        <c:forEach items="${buyList}" var="buyersQuota" varStatus="status">
                            <tr>
                                <td class="col-sm-1 col-xs-1">${buyersQuota.code}</td>
                                <td class="col-sm-2 col-xs-2">${buyersQuota.customer_name}</td>
                                <td class="col-sm-1 col-xs-1">${buyersQuota.country}</td>
                                <td class="col-sm-1 col-xs-1">${fns:getDictLabel (buyersQuota.limit_type,"applicationLimitType","")}</td>
                                <td class="col-sm-2 col-xs-2">${buyersQuota.amount_requested}</td>
                                <td class="col-sm-1 col-xs-1"><c:if
                                        test="${not empty  buyersQuota.reply_amount}">${buyersQuota.reply_amount}</c:if>
                                    <c:if test="${empty   buyersQuota.reply_amount}">0</c:if> USD
                                </td>
                                <td class="col-sm-1 col-xs-1">${fns:getDictLabel (buyersQuota.apply_type,"applyCreditAmountType","")}</td>
                                <td class="col-sm-2 col-xs-2">
                                    <label><a href="<c:url value='/exports/credit/getApplyAmount/${buyersQuota.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">详情</a></label>
                                    <c:if test="${buyersQuota.apply_type eq '0'}">
                                        <label><a
                                                href="<c:url value='/exports/credit/delApplyAmount/${buyersQuota.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">取消</a></label>
                                    </c:if>
                                    <c:if test="${buyersQuota.apply_type eq '2'}">
                                        <label><a
                                                href="<c:url value='/exports/credit/updApplyAmount/${buyersQuota.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">限额</a></label>
                                    </c:if>
                                    <c:if test="${buyersQuota.apply_type eq '1' || buyersQuota.apply_type eq '3'||buyersQuota.apply_type eq '4'}">
                                        <c:if test="${ not empty buyersQuota.code}">
                                            <label><a
                                                    href="<c:url value='/exports/credit/updApplyAmount/${buyersQuota.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">限额</a></label>
                                        </c:if>
                                        <c:if test="${ empty buyersQuota.code}">
                                            <label><a
                                                    href="<c:url value='/exports/credit/addApplyAmount?oid=${buyersQuota.oid}&ACCESS_TOKEN=${ACCESS_TOKEN}'/>">限额</a></label>
                                        </c:if>
                                    </c:if>
                                </td>
                            </tr>
                        </c:forEach>
                    </c:otherwise>
                </c:choose>
                </tbody>
            </table>

        </div>


    </div>
</div>
<!-- message-war end -->
<div class="row next-step">
    <div class="col-sm-6 col-sm-6">
        <!-- 分页  start-->
        <nav class="text-center">

            <div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>

        </nav>
        <!-- 分页 end -->
    </div>
    <div class="col-sm-6 col-xs-6 text-right pull-right">
        <p>

            <a href="<c:url value='/exports/credit/addApplyAmount?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="ns-btn">新限额申请</a>
            <a href="<c:url value='/exports/credit/policyChange?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="ns-btn">上一步</a>
        </p>
    </div>
</div>

<script src="<c:url value='/resources/js/extendPagination.js'/>"
        type="text/javascript"></script>
<script>
    var baseUrl = '${pageContext.request.contextPath }';
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 10;
    var curPage = $('#pageNum').val() || 5;
    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        curPage: curPage,
        callback: function (curr, limit, totalCount) {
            getListForPage();
        }
    });
    function doSearch() {
        $("#pageNum").val('1');
        $("#numPerPage").val('5');
        $("#totalCount").val('0');
        getListForPage();
    }
    function getListForPage() {
        var formId = "buyerSerachForm";
        var contentId = "buyerArea";
        var index = layer.load(0, {
            shade: [0.3, '#808080']
        });
        $.ajax({
            type: 'POST',
            url: baseUrl + "/exports/credit/findBuyerBySearchLlimit",
            data: $("#" + formId).serialize(),
            dataType: "text",
            success: function (data) {
                layer.close(index);
                $("#content123").html(data);

            },
            error: function () {
                layer.close(index);
            }
        });
    }

    function resetSerach() {
        alert('重置所有的 搜搜条件')
    }


</script>
</div><!-- container end -->

