<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="policyholder" data-example-id="togglable-tabs">
					<ul id="myTabs" class="nav nav-tabs" role="tablist">
					  <li class="active">
					  	<a href="#policyholder-one" data-toggle="tab">常用投保人1</a>
					  </li>
					  <li >
					  	<a href="#policyholder-two" data-toggle="tab">常用投保人2</a>
					  </li>
					  <li>
					  	<a href="#policyholder-three" data-toggle="tab">常用投保人3</a>
					  </li> 
					</ul>
					<div id="myTabContent" class="tab-content">
						<div  class="tab-pane fade active in" id="policyholder-one"> 
							<div class="row">
								<form id="applicantForm1">
									<div class="col-sm-1 col-xs-1 user-img">
										<input type="hidden" name="oid" id="oid1" value="${ applicantList[0].oid }">
										<img src="<c:url value='/resources/versions-2.0/images/account/user-img1.jpg'/>">
									</div>
									<div class="col-sm-5 col-xs-5">
										<p>
											<label>企业名称（个人用户填写个人姓名）</label>
											<input type="text" class="form-control" placeholder="" name="com_fullName" id="com_fullName1" value="${applicantList[0].com_fullName }">
										</p>
										<p>
											<label>组织机构代码（个人用户填写身份证号码）</label>
											<input type="text" class="form-control" placeholder="" name="com_organizingCode" id="com_organizingCode1" value="${applicantList[0].com_organizingCode }">
										</p>
										<p class="">
											<label>企业联系电话</label>
											<input type="text" class="form-control" placeholder="注：区号-电话号码-分机号" name="com_phone" id="com_phone1" value="${applicantList[0].com_phone }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p>
											<label>邮政编码</label>
											<input type="text" class="form-control" placeholder="" name="com_zipcode" id="com_zipcode1" value="${applicantList[0].com_zipcode }">
										</p>
									</div>
									<div  class="col-sm-5 col-xs-5">
										<p>
											<label>联系人姓名</label>
											<input type="text" class="form-control" placeholder="" name="name" id="name1" value="${applicantList[0].name }">
										</p>
										<p class="">
											<label>联系人电话</label>
											<input type="text" class="form-control" placeholder="请输入11位手机号码" name="tel" id="tel1" value="${applicantList[0].tel }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p class="">
											<label>联系人邮箱</label>
											<input type="text" class="form-control" placeholder="" name="email" id="email1" value="${applicantList[0].email }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p>
											<label>联系地址</label>
											<input type="text" class="form-control" placeholder="" name="com_address" id="com_address1" value="${applicantList[0].com_address }">
										</p>
										<div class="pull-right sachange-btn"><a href="javascript:void(0);" onclick="submitForm('1')">保存更改</a></div>
									</div>
								</form>
							</div>
						</div>
						<div class="tab-pane fade" id="policyholder-two">
							<div class="row">
								<form id="applicantForm2">
									<div class="col-sm-1 col-xs-1 user-img">
										<input type="hidden" name="oid" id="oid2" value="${ applicantList[1].oid }">
										<img src="<c:url value='/resources/versions-2.0/images/account/user-img1.jpg'/>">
									</div>
									<div class="col-sm-5 col-xs-5">
										<p>
											<label>企业名称（个人用户填写个人姓名）</label>
											<input type="text" class="form-control" placeholder="" name="com_fullName" id="com_fullName2" value="${applicantList[1].com_fullName }">
										</p>
										<p>
											<label>组织机构代码（个人用户填写身份证号码）</label>
											<input type="text" class="form-control" placeholder="" name="com_organizingCode" id="com_organizingCode2" value="${applicantList[1].com_organizingCode }">
										</p>
										<p class="">
											<label>企业联系电话</label>
											<input type="text" class="form-control" placeholder="注：区号-电话号码-分机号" name="com_phone" id="com_phone2" value="${applicantList[1].com_phone }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p>
											<label>邮政编码</label>
											<input type="text" class="form-control" placeholder="" name="com_zipcode" id="com_zipcode2" value="${applicantList[1].com_zipcode }">
										</p>
									</div>
									<div  class="col-sm-5 col-xs-5">
										<p>
											<label>联系人姓名</label>
											<input type="text" class="form-control" placeholder="" name="name" id="name2" value="${applicantList[1].name }">
										</p>
										<p class="">
											<label>联系人电话</label>
											<input type="text" class="form-control" placeholder="请输入11位手机号码" name="tel" id="tel2" value="${applicantList[1].tel }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p class="">
											<label>联系人邮箱</label>
											<input type="text" class="form-control" placeholder="" name="email" id="email2" value="${applicantList[1].email }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p>
											<label>联系地址</label>
											<input type="text" class="form-control" placeholder="" name="com_address" id="com_address2" value="${applicantList[1].com_address }">
										</p>
										<div class="pull-right sachange-btn"><a href="javascript:void(0);" onclick="submitForm('2')">保存更改</a></div>
									</div>
								</form>
							</div>
						</div>
						<div  class="tab-pane fade" id="policyholder-three">
							<div class="row">
								<form id="applicantForm3">
									<div class="col-sm-1 col-xs-1 user-img">
										<input type="hidden" name="oid" id="oid3" value="${ applicantList[2].oid }">
										<img src="<c:url value='/resources/versions-2.0/images/account/user-img1.jpg'/>">
									</div>
									<div class="col-sm-5 col-xs-5">
										<p>
											<label>企业名称（个人用户填写个人姓名）</label>
											<input type="text" class="form-control" placeholder="" name="com_fullName" id="com_fullName3" value="${applicantList[2].com_fullName }">
										</p>
										<p>
											<label>组织机构代码（个人用户填写身份证号码）</label>
											<input type="text" class="form-control" placeholder="" name="com_organizingCode" id="com_organizingCode3" value="${applicantList[2].com_organizingCode }">
										</p>
										<p class="">
											<label>企业联系电话</label>
											<input type="text" class="form-control" placeholder="注：区号-电话号码-分机号" name="com_phone" id="com_phone3" value="${applicantList[2].com_phone }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p>
											<label>邮政编码</label>
											<input type="text" class="form-control" placeholder="" name="com_zipcode" id="com_zipcode3" value="${applicantList[2].com_zipcode }">
										</p>
									</div>
									<div  class="col-sm-5 col-xs-5">
										<p>
											<label>联系人姓名</label>
											<input type="text" class="form-control" placeholder="" name="name" id="name3" value="${applicantList[2].name }">
										</p>
										<p class="">
											<label>联系人电话</label>
											<input type="text" class="form-control" placeholder="请输入11位手机号码" name="tel" id="tel3" value="${applicantList[2].tel }">
											<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p class="">
											<label>联系人邮箱</label>
											<input type="text" class="form-control" placeholder="" name="email" id="email3" value="${applicantList[2].email }">
					  						<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
										</p>
										<p>
											<label>联系地址</label>
											<input type="text" class="form-control" placeholder="" name="com_address" id="com_address3" value="${applicantList[2].com_address }">
										</p>
										<div class="pull-right sachange-btn"><a href="javascript:void(0);" onclick="submitForm('3')">保存更改</a></div>
									</div>
								</form>
							</div>
						</div> 
					</div>
				  </div>
			</div><!-- mar-content 右边内容块 end -->
		</div>
	</body>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
		choiseMenu("commonApplicant");
				
		function submitForm(formIndex){
			if(checkFormInputs(formIndex)){
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/user/editCommonApplicant.json",
					data : $("#applicantForm"+formIndex).serialize(),
					dataType : "json",
					success : function(data) {
						layer.close(index);
						layer.msg(data.message);
						if(data.status=="200")
							$("#oid"+formIndex).val(data.oid);
					},
					error: function(){
						layer.close(index);
					}
				});
			}
		}
		
		function checkFormInputs(formIndex){
			var flag = true;
			var tel = $("#tel"+formIndex).val();
			if(tel !="" && !checkMobile(tel)){
				loser_has("tel"+formIndex);
				layer.msg("联系人电话格式不对");
				flag = false;
			}else
				success_has1("tel"+formIndex);
			
			var com_phone = $("#com_phone"+formIndex).val();
			var isPhone=/^((0\d{2,3})-)?(\d{7,8})(-(\d{3,}))?$/;
			if(com_phone !="" && !isPhone.test(com_phone)){
				loser_has("com_phone"+formIndex);
				layer.msg("企业联系电话格式不对");
				flag = false;
			}else
				success_has1("com_phone"+formIndex);
			
			var email=$("#email"+formIndex).val();
			if(email !="" && !checkEmail(email)){
				loser_has("email"+formIndex);
				layer.msg("邮箱格式不对");
				flag = false;
			}else
				success_has1("email"+formIndex);
			
			return flag;
		}
		
		function success_has1(obj){
			var objId ="";
			if(typeof obj == "object")
				objId = obj.id;
			else
				objId = obj;
			removeClass($("#"+objId).parent(),'has-feedback has-success');
			removeClass($("#"+objId).parent(),'has-loser has-feedback');
			removeClass($("#"+objId).next(),'glyphicon-remove');
			removeClass($("#"+objId).next(),'glyphicon-ok');
		}
		
		function success_has(obj){
			var objId ="";
			if(typeof obj == "object")
				objId = obj.id;
			else
				objId = obj;
			removeClass($("#"+objId).parent(),'has-feedback has-success');
			removeClass($("#"+objId).parent(),'has-loser has-feedback');
			removeClass($("#"+objId).next(),'glyphicon-remove');
			removeClass($("#"+objId).next(),'glyphicon-ok');
			addClass($("#"+objId).parent(),'has-feedback has-success');
			addClass($("#"+objId).next(),'glyphicon-ok');
		}
		
		function loser_has(obj){
			var objId ="";
			if(typeof obj == "object")
				objId = obj.id;
			else
				objId = obj;
			removeClass($("#"+objId).parent(),'has-feedback has-success');
			removeClass($("#"+objId).parent(),'has-loser has-feedback');
			removeClass($("#"+objId).next(),'glyphicon-remove');
			removeClass($("#"+objId).next(),'glyphicon-ok');
			addClass($("#"+objId).parent(),'has-loser has-feedback');
			addClass($("#"+objId).next(),'glyphicon-remove');
		}
		
		function addClass(obj, cls) {  
		    if (!this.hasClass(obj, cls)) obj.attr("class",obj.attr("class").trim()+" " + cls);  
		}  
		  
		function removeClass(obj, cls) {  
		    if (hasClass(obj, cls)) {  
		        obj.attr("class",obj.attr("class").replace(cls, ''));  
		    }  
		} 
		function hasClass(obj, cls) {  
		    return obj.attr("class").indexOf(cls)==-1?false:true;;  
		}  
		
	</script>
</html>

