<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>

		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<style>
		.spinner {
			margin: 50px auto;
			width: 50px;
			height: 60px;
			text-align: center;
			font-size: 10px;
		}

		.spinner > div {
			background-color: #279df5;
			height: 100%;
			width: 6px;
			display: inline-block;

			-webkit-animation: stretchdelay 1.2s infinite ease-in-out;
			animation: stretchdelay 1.2s infinite ease-in-out;
		}

		.spinner .rect2 {
			-webkit-animation-delay: -1.1s;
			animation-delay: -1.1s;
		}

		.spinner .rect3 {
			-webkit-animation-delay: -1.0s;
			animation-delay: -1.0s;
		}

		.spinner .rect4 {
			-webkit-animation-delay: -0.9s;
			animation-delay: -0.9s;
		}

		.spinner .rect5 {
			-webkit-animation-delay: -0.8s;
			animation-delay: -0.8s;
		}

		@-webkit-keyframes stretchdelay {
			0%, 40%, 100% { -webkit-transform: scaleY(0.4) }
			20% { -webkit-transform: scaleY(1.0) }
		}

		@keyframes stretchdelay {
			0%, 40%, 100% {
				transform: scaleY(0.4);
				-webkit-transform: scaleY(0.4);
			}  20% {
				   transform: scaleY(1.0);
				   -webkit-transform: scaleY(1.0);
			   }
		}
	</style>
<body>
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container"><!-- container start -->
	<ol class="breadcrumb" id="bread_crumbs">
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<div class="row w-95-auto"><!-- w-95-auto start --> 
			<div class="playsuc-war" style="width: auto;">
				<c:if test="${empty dto ? false : dto.policy_status eq '6' ? true : false}">
					<p class="succeed-bg text-center"><i class="glyphicon glyphicon-ok text-center"></i></p>
					<p class="text-center fscl-247">支付完成，您的订单已承保通过！</p>
					<p class="text-center fscl-247">
					<ul class="text-center">
						<li style="float:none;"><a href="<c:url value='/pc/order/exportDetailByOrderID/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />">查看保单详情 </a></li>
					</ul>
					</p>
				</c:if>
				<c:if test="${empty dto ? true : dto.policy_status != '6' ? true : false}">
					<div class="spinner">
						<div class="rect1"></div>
						<div class="rect2"></div>
						<div class="rect3"></div>
						<div class="rect4"></div>
						<div class="rect5"></div>
					</div>
					<p class="text-center fscl-247">您的投保单已提交，正在等待保险公司承保...</p>
					<p class="text-center">温馨提示：
						保险公司承保需要等待返回，请点击“刷新进度”按钮，查看最新承保状态；
						若等待超过五分钟，仍未承保，请联系在线客服进行查询。</p>
					<p class="text-center fscl-247">
					<ul class="text-center" style="padding-top: 0">
						<li style="float:none;"><a style="color: #279df5" href="<c:url value='/insurance/zzx/transaction/syntony-service/${oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />"> 刷新进度 </a></li>
					</ul>
					</p>
				</c:if>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end --> 
</div><!-- container end -->
<jsp:include page="../../../index/multi_f.jsp" />
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
    var topWindow;
    function changeFrameHeight(){
        for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
            for(var i=0;i<topWindow.parent.frames.length;i++){
                var isIframe = true;
                try {
                    topWindow.parent.frames[i].window.document;
                }catch (e) {
                    isIframe = false;
                }
                if(isIframe){
                    if(topWindow.parent.frames[i].window.document==topWindow.document){
                        var tName = topWindow.parent.frames[i].name;
                        if(tName != ''){
                            var bread_crumbs;
                            if(tName.indexOf('layui-layer-iframe')==-1){
                                $("ol[class*='breadcrumb']").each(function(){
                                    $(this).html('');
                                });
                                parent.document.getElementById("frame3d").height=600;
                            }
                        }
                    }
                }

            }
        }
    }
    $(function(){
        changeFrameHeight();
	});
</script>
</body>
</html>