<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body>
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container"><!-- container start -->

    <ol class="breadcrumb" id="bread_crumbs">
    </ol>
    <div class="nav-list">
        <div class="row w-80-auto">
            <div class="col-sm-3 col-sm-4 active">
                <p><i class="pull-left">1</i><span class=" pull-left">填写保险信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-4">
                <p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-3">
                <p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
            </div>
            <div class="col-sm-3 col-sm-3 pull-right">
                <p><i class="pull-left">4</i><span class="pull-left"> 完成投保</span></p>
            </div>
        </div>
    </div>
    <form class="form-horizontal form-create-item"  action="<c:url value='/insurance/tyx/policy/gmr_confirmPage?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
        <input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>推荐人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-4 col-xs-4">
                    <p>推荐人的手机号或编号</p>
                    <input type="text" name="recommend_code" id="recommend_code" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
                    <input type="hidden" name="sigId" value="${dto.trade_serial_number}"/>
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[0].oid" id="role_appRoleID_0" value="${vo.roleSubjectList[0].oid}"/>
            <input type="hidden" name="roleSubjectList[0].kind" id="role_kind_0" value="1"/>
            <input type="hidden" name="roleSubjectList[0].roleType" id="role_roleType_0" value="1"/>
            <div class="title-war"><h3 id="cy_lxr">投保单位信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*投保单位<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称，个人不能作为投保单位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="role_namecn_0" value="${vo.roleSubjectList[0].name_cn}" class="form-control" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*所属行业</p>
                    <input Data-Val="Required" readonly type="text" name="roleSubjectList[0].industry" id="role_industry_0" value="保安服务业" class="form-control" placeholder="" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*营业性质</p>
                    <div class="row">
                        <div class="col-sm-6 col-xs-6">
                            <select data-val="Required" name="roleSubjectList[0].com_nature" id="role_comNature_0" class="form-control" onchange="natureChange(this,'role_natureTwo_0');" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].com_nature eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6" <c:if test="${empty vo.roleSubjectList[0].nature_two }"> hidden</c:if>>
                            <select name="roleSubjectList[0].nature_two" id="role_natureTwo_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureTwoList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].nature_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="role_idType_0" value="${vo.roleSubjectList[0].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].organization_code" id="role_organizationCode_0" GIST-ID="role_idType_0" value="${vo.roleSubjectList[0].organization_code}" class="form-control" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件有效期起始</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_option" id="role_idOption_0" value="${vo.roleSubjectList[0].id_option}" onchange="isNeedDate(this,'role_idStarDate_0','role_idEndDate_0')" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${idOptionList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].id_option eq list.value }"> selected="selected"</c:if>>${list.label }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3" hidden>
                    <p>*证件有效期始期</p>
                    <input Data-Val="Required" <c:if test="${empty vo.roleSubjectList[0].id_star_date}"> data-status="hidden"</c:if> type="text" name="roleSubjectList[0].id_star_date" id="role_idStarDate_0" value="${vo.roleSubjectList[0].id_star_date}" class="laydate-icon form-control" onclick="laydate({elem: '#role_idStarDate_0',format: 'YYYY-MM-DD'});"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3" hidden>
                    <p>*证件有效期止期</p>
                    <input Data-Val="Required" <c:if test="${empty vo.roleSubjectList[0].id_end_date}"> data-status="hidden"</c:if> type="text" name="roleSubjectList[0].id_end_date" id="role_idEndDate_0" value="${vo.roleSubjectList[0].id_end_date}" class="laydate-icon form-control" onclick="laydate({elem: '#role_idEndDate_0',format: 'YYYY-MM-DD'});"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*企业总人数（人）</p>
                    <input Data-Val="Num Required" type="text" name="roleSubjectList[0].total_emp" id="role_totalEmp_0" value="${vo.roleSubjectList[0].total_emp}" class="form-control" placeholder="请输入企业总在职人数数值" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*办公地址</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].do_business_address" id="role_doBusinessAddress_0" value="${vo.roleSubjectList[0].do_business_address}" class="form-control" placeholder="" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*办公电话</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].phone" id="role_phone_0" value="${vo.roleSubjectList[0].phone}" class="form-control" placeholder="例：010-0000000" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_name" id="role_linkName_0" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系部门</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_section" id="role_linkSection_0" value="${vo.roleSubjectList[0].link_section}" class="form-control" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_tel" id="role_linkTel_0" value="${vo.roleSubjectList[0].link_tel}" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_email" id="role_linkEmail_0" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*邮政编码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].zip_code" id="role_zipCode_0" value="${vo.roleSubjectList[0].zip_code}" class="form-control" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-9 col-xs-9">
                    <p>*注册地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
                                <option value="">请选择省</option>
                                <%--<c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>--%>
                                <c:if test="${!fn:contains(pd.product_code,'GZZRX-PAC') }">
                                    <c:forEach items="${provinceList }" var="list">
                                        <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                    </c:forEach>
                                </c:if>
                                <c:if test="${fn:contains(pd.product_code,'TYX-PAC') }">
                                    <option value="110000" <c:if test="${'110000' eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>北京市</option>
                                </c:if>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${cityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${areaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="roleSubjectList[0].reg_address" id="role_regAddress_0" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写详细地址" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4 col-xs-4">
                    <p>*上传附件<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top"  title="请上传营业执照和组织机构代码2个证件的扫描件。附件不能大于20M。支持1个附件，多个附件打包上传。"></i> <i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top"  title="没有营业执照如何上传？
                    以下单位需提供的资料附件：
                    ● 机关：组织机构代码证；
                    ● 事业单位：事业单位法人证书、组织机构代码证；
                    ● 社会团体：社会团体法人登记证书、组织机构代码证；
                    ● 其他：批准设立或者核准登记的文件、组织机构代码证。"></i></p>
                    <input Data-Val="FILE Required" type="hidden" name="roleSubjectList[0].app_organizing_path" id="appOrganizingPath" value="${vo.roleSubjectList[0].app_organizing_path}">
                    <div>
                        <input name="appOrganizingPath_file" id="appOrganizingPath_file-5" data-drawview="${vo.roleSubjectList[0].app_organizing_path}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war">
                <h3>
                    被保险人信息（您可以选择逐条添加被保险人信息或点击此处下载<a href="<c:url value='/resources/files/批量导入范本.xls' />">【被保险人清单模板】</a>进行<a href="javascript:void(0);" id="wed_wed">【批量上传】</a>注意：投保总人数不得低于3人）
                    <input name="role_emp" id="role_emp" type="file" onchange="uploadInsure();" style="display: none;">
                </h3>
            </div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="affirm-warr">
                    <table class="table mSign" id="add-increased-table">
                        <tbody>
                        <tr>
                            <td class="col-sm-1 col-xs-1">序号</td>
                            <td class="col-sm-1 col-xs-1">*姓名</td>
                            <td class="col-sm-1 col-xs-1">*证件类型</td>
                            <td class="col-sm-2 col-xs-2">*证件号码</td>
                            <td class="col-sm-2 col-xs-2">*出生日期</td>
                            <td class="col-sm-1 col-xs-1">*性别</td>
                            <td class="col-sm-1 col-xs-1">*职业</td>
                            <td class="col-sm-2 col-xs-2">*手机</td>
                            <td class="col-sm-1 col-xs-1">操作</td>
                        </tr>
                        <c:if test="${empty vo.roleSubjectList}">
                            <input type="hidden" name="role_num" id="role_num" value="3">
                            <c:forEach begin="0" end="2" varStatus="index">
                                <c:set var="doIndex" value="${index.index+1}"/>
                                <tr class="role_num_${doIndex}">
                                    <input type="hidden" name="roleSubjectList[${doIndex}].oid" id="role_oid_${doIndex}" value="">
                                    <input type="hidden" name="roleSubjectList[${doIndex}].kind" id="role_kind_${doIndex}" value="2"/>
                                    <td class="col-sm-1 col-xs-1 signIndex">${doIndex}</td>
                                    <td class="col-sm-1 col-xs-1">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].name_cn" id="role_namecn_${doIndex}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="roleSubjectList[${doIndex}].id_type" id="role_idType_${doIndex}" value="" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">请选择</option>
                                            <c:forEach items="${personTypeList }" var="list">
                                                <option value="${list.value }">${list.name }</option>
                                            </c:forEach>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].organization_code" GIST-ID="role_idType_${doIndex}" id="role_organizationCode_${doIndex}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].birth_date" id="role_birthDate_${doIndex}" GIST-ID="role_organizationCode_${doIndex}" class="laydate-icon form-control" onclick="laydate({elem: '#role_birthDate_${doIndex}',format: 'YYYY-MM-DD'});" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="roleSubjectList[${doIndex}].sex" id="role_sex_${doIndex}" GIST-ID="role_organizationCode_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">请选择</option>
                                            <option value="1" >男</option>
                                            <option value="2" >女</option>
                                        </select>
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="roleSubjectList[${doIndex}].major_group" id="role_majorGroup_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <c:if test="${!fn:contains(pd.product_code,'TYX-QH-DQ')&&!fn:contains(pd.product_code, 'TYX-HT-DQ')}">
                                            <option value="1">内勤人员</option>
                                            <option value="2">保安人员</option>
                                            <c:if test="${!fn:contains(pd.product_code,'TYX-RB')}"><option value="3">武装押运人员</option></c:if>
                                            <c:if test="${fn:contains(pd.product_code,'TYX-CA')}"><option value="4">保洁人员</option></c:if>
                                            </c:if>
                                            <c:if test="${fn:contains(pd.product_code,'TYX-QH-DQ')||fn:contains(pd.product_code, 'TYX-HT-DQ')}">
                                                <option value="2">保安人员</option>
                                            </c:if>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].mobile" id="role_mobile_${doIndex}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <label><a href="javascript:;" onclick="deleteThisRow('role_num_${doIndex}','2000','add-a-line')">删除</a></label>
                                    </td>
                                </tr>
                            </c:forEach>
                        </c:if>
                        <c:if test="${ vo.roleSubjectList!=null}">
                            <input type="hidden" name="role_num" id="role_num" value="${vo.roleSubjectList.size()-1}">
                            <c:forEach begin="2" end="${ vo.roleSubjectList.size() }" varStatus="index">
                                <c:set var="doIndex" value="${index.index-1}"/>
                                <tr class="role_num_${doIndex}">
                                    <input type="hidden" name="roleSubjectList[${doIndex}].oid" id="role_oid_${doIndex}" value="${ vo.roleSubjectList[doIndex].oid}">
                                    <input type="hidden" name="roleSubjectList[${doIndex}].kind" id="role_kind_${doIndex}" value="2"/>
                                    <td class="col-sm-1 col-xs-1 signIndex">${doIndex}</td>
                                    <td class="col-sm-1 col-xs-1">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].name_cn" id="role_namecn_${doIndex}" value="${ vo.roleSubjectList[doIndex].name_cn}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="roleSubjectList[${doIndex}].id_type" id="role_idType_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">-请选择-</option>
                                            <c:forEach items="${personTypeList }" var="list">
                                                <option value="${list.value }" <c:if test="${vo.roleSubjectList[doIndex].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                            </c:forEach>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].organization_code" GIST-ID="role_idType_${doIndex}" id="role_organizationCode_${doIndex}" value="${ vo.roleSubjectList[doIndex].organization_code}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].birth_date" GIST-ID="role_organizationCode_${doIndex}" id="role_birthDate_${doIndex}" value="${ vo.roleSubjectList[doIndex].birth_date}" class="laydate-icon form-control" onclick="laydate({elem: '#role_birthDate_${doIndex}',format: 'YYYY-MM-DD'});" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="roleSubjectList[${doIndex}].sex" GIST-ID="role_organizationCode_${doIndex}" id="role_sex_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">-请选择-</option>
                                            <option value="1" <c:if test="${vo.roleSubjectList[doIndex].sex eq '1' }"> selected="selected"</c:if> >男</option>
                                            <option value="2" <c:if test="${vo.roleSubjectList[doIndex].sex eq '2' }"> selected="selected"</c:if> >女</option>
                                        </select>
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="roleSubjectList[${doIndex}].major_group" id="role_majorGroup_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <c:if test="${!fn:contains(pd.product_code,'TYX-QH-DQ')&&!fn:contains(pd.product_code, 'TYX-HT-DQ')}">
                                            <option value="1" <c:if test="${vo.roleSubjectList[doIndex].major_group eq '1' }"> selected="selected"</c:if> >内勤人员</option>
                                            <option value="2" <c:if test="${vo.roleSubjectList[doIndex].major_group eq '2' }"> selected="selected"</c:if> >保安人员</option>
                                            <c:if test="${!fn:contains(pd.product_code,'TYX-RB')}"><option value="3" <c:if test="${vo.roleSubjectList[doIndex].major_group eq '3' }"> selected="selected"</c:if> >武装押运人员</option></c:if>
                                            <c:if test="${fn:contains(pd.product_code,'TYX-CA')}"><option value="4" <c:if test="${vo.roleSubjectList[doIndex].major_group eq '4' }"> selected="selected"</c:if> >保洁人员</option></c:if>
                                            </c:if>
                                            <c:if test="${fn:contains(pd.product_code,'TYX-QH-DQ')||fn:contains(pd.product_code, 'TYX-HT-DQ')}">
                                            <option value="2" <c:if test="${vo.roleSubjectList[doIndex].major_group eq '2' }"> selected="selected"</c:if> >保安人员</option>
                                            </c:if>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="roleSubjectList[${doIndex}].mobile" id="role_mobile_${doIndex}" value="${ vo.roleSubjectList[doIndex].mobile}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <label><a href="javascript:;" onclick="deleteThisRow('role_num_${doIndex}','2000','add-a-line')">删除</a></label>
                                    </td>
                                </tr>
                            </c:forEach>
                        </c:if>
                        </tbody>
                    </table>
                </div>
                <div class="col-sm-12 col-xs-12 text-center add-a-line" <c:if test="${(vo.roleSubjectList.size()-1) == 2000}"> hidden</c:if> onclick="doDIVMOD(this, 'role','add','2000');"><span><i class="glyphicon glyphicon-plus"></i> 添加</span></div>
                <%--<div class="col-sm-12 col-xs-12 text-center remove-a-line"><span><i class="glyphicon glyphicon-minus"></i> 删除被保险人</span></div>--%>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>身故受益人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*受益人<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="《继承法》规定的法定继承人范围是：第一顺序继承人为配偶、子女、父母；第二顺序继承人为兄弟姐妹、祖父母、外祖父母。"></i></p>
                    <input type="text" class="form-control" readonly value="法定继承人" />
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <c:if test="${fn:contains(pd.product_code, 'TYX-QH-DQ')||fn:contains(pd.product_code, 'TYX-HT-DQ')}">
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="specialExhibitionVo.oid" id="special_oid_0" value="${vo.specialExhibitionVo.oid}"/>
            <div class="title-war"><h3>投保基本信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*活动名称</p>
                    <input Data-Val="Required" type="text" name="specialExhibitionVo.name" id="special_name" value="${vo.specialExhibitionVo.name}" class="form-control" placeholder="请填写展会活动的具体名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>

                <div class="col-sm-9 col-xs-9">
                    <p>*活动举办地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="specialExhibitionVo.ex_province" id="special_ex_province" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('special_ex_city', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.specialExhibitionVo.ex_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="specialExhibitionVo.ex_city" id="special_ex_city" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('special_ex_county', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${exCityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.specialExhibitionVo.ex_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="specialExhibitionVo.ex_county" id="special_ex_county" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${exAreaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.specialExhibitionVo.ex_county eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="specialExhibitionVo.ex_address" id="special_ex_address" value="${vo.specialExhibitionVo.ex_address}" class="form-control" placeholder="请填写详细地址" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>

                <div class="col-sm-8 col-xs-8">
                    <p>*活动时间</p>
                    <div class="row">
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="specialExhibitionVo.star_time" id="special_star_time" value="${ vo.specialExhibitionVo.star_time}" class="laydate-icon form-control">
                            <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                        </div>
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="specialExhibitionVo.end_time" id="special_end_time" value="${ vo.specialExhibitionVo.end_time}" class="laydate-icon form-control" >
                            <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        </c:if>
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>投保计划信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <c:choose>
                    <c:when test="${'TYX-RB-3' eq pd.product_code||'TYX-RB-4' eq pd.product_code||'TYX-RB-5' eq pd.product_code||'TYX-RB-6' eq pd.product_code}">
                        <div class="col-sm-12 col-xs-12">
                            <p>保障方案确认</p>
                            <div class="affirm-warr">
                                <table class="table ">
                                    <tbody>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3"></td>
                                        <td class="col-sm-3 col-xs-3">保费</td>
                                        <td class="col-sm-3 col-xs-3">保障责任</td>
                                        <td class="col-sm-3 col-xs-3">保障金额</td>
                                    </tr>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3" rowspan="5">基础保障</td>
                                        <td class="col-sm-3 col-xs-3" rowspan="5"><strong style="color:#ff8b00;">${pd.premium_min} 元/人</strong></td>
                                        <td class="col-sm-3 col-xs-3">意外身故/残疾</td>
                                        <td class="col-sm-3 col-xs-3">${pd.product_code eq 'TYX-RB-3' ? 30 : pd.product_code eq 'TYX-RB-4' ? 40 : pd.product_code eq 'TYX-RB-5' ? 50 : pd.product_code eq 'TYX-RB-6' ? 60 : 0 } 万元</td>
                                    </tr>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3">意外医疗</td>
                                        <td class="col-sm-3 col-xs-3">${pd.product_code eq 'TYX-RB-3' ? 3 : pd.product_code eq 'TYX-RB-4' ? 4 : pd.product_code eq 'TYX-RB-5' ? 5 : pd.product_code eq 'TYX-RB-6' ? 6 : 0 } 万元</td>
                                    </tr>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3">意外住院津贴</td>
                                        <td class="col-sm-3 col-xs-3">${pd.product_code eq 'TYX-RB-3' ? 100 : pd.product_code eq 'TYX-RB-4' ? 100 : pd.product_code eq 'TYX-RB-5' ? 150 : pd.product_code eq 'TYX-RB-6' ? 200 : 0 } 元/天</td>
                                    </tr>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3">猝死（身故）</td>
                                        <td class="col-sm-3 col-xs-3">${pd.product_code eq 'TYX-RB-3' ? 10 : pd.product_code eq 'TYX-RB-4' ? 20 : pd.product_code eq 'TYX-RB-5' ? 20 : pd.product_code eq 'TYX-RB-6' ? 20 : 0 } 万元</td>
                                    </tr>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3">救护车费用</td>
                                        <td class="col-sm-3 col-xs-3">1000 元</td>
                                    </tr>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3" rowspan="1">可选保障一</td>
                                        <td class="col-sm-3 col-xs-3" rowspan="1"><strong style="color:#ff8b00;">${pd.product_code eq 'TYX-RB-3' ? 30 : pd.product_code eq 'TYX-RB-4' ? 40 : pd.product_code eq 'TYX-RB-5' ? 50 : pd.product_code eq 'TYX-RB-6' ? 60 : 0 } 元/人</strong></td>
                                        <td class="col-sm-3 col-xs-3">疾病身故/全残</td>
                                        <td class="col-sm-3 col-xs-3">${pd.product_code eq 'TYX-RB-3' ? 15 : pd.product_code eq 'TYX-RB-4' ? 20 : pd.product_code eq 'TYX-RB-5' ? 25 : pd.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
                                    </tr>
                                    <tr>
                                        <td class="col-sm-3 col-xs-3" rowspan="1">可选保障二</td>
                                        <td class="col-sm-3 col-xs-3" rowspan="1"><strong style="color:#ff8b00;">${pd.product_code eq 'TYX-RB-3' ? 260 : pd.product_code eq 'TYX-RB-4' ? 350 : pd.product_code eq 'TYX-RB-5' ? 430 : pd.product_code eq 'TYX-RB-6' ? 530 : 0 } 元/人</strong></td>
                                        <td class="col-sm-3 col-xs-3">重大疾病</td>
                                        <td class="col-sm-3 col-xs-3">${pd.product_code eq 'TYX-RB-3' ? 15 : pd.product_code eq 'TYX-RB-4' ? 20 : pd.product_code eq 'TYX-RB-5' ? 25 : pd.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                            <div class="optional_guarantee">
                                <span class="${empty vo.is_contain_repo ? '' : vo.is_contain_repo eq '3' ? 'active' : ''}" data-val="3">含可选保障一、二</span>
                                <span class="${empty vo.is_contain_repo ? '' : vo.is_contain_repo eq '1' ? 'active' : ''}" data-val="1">含可选保障一</span>
                                <span class="${empty vo.is_contain_repo ? '' : vo.is_contain_repo eq '2' ? 'active' : ''}" data-val="2">含可选保障二</span>
                                <span class="${empty vo.is_contain_repo ? 'active' : vo.is_contain_repo eq '0' ? 'active' : ''}" data-val="0">基础保障</span>
                            </div>
                            <input type="hidden" name="is_contain_repo" id="is_contain_repo" value="${empty vo.is_contain_repo ? '0' : vo.is_contain_repo}"><%--初始化默认包含附加条件--%>
                        </div>
                    </c:when>
                    <c:otherwise>
                        <div class="col-sm-12 col-xs-12">
                            <p>保障方案确认</p>
                            <div class="affirm-warr">
                                <table class="table ">
                                    <tbody>
                                    <tr>
                                        <td class="col-sm-6 col-xs-6">保障责任</td>
                                        <td class="col-sm-6 col-xs-6">保障金额</td>
                                    </tr>
                                    <c:forEach items="${ pd.responsibilityVoList }" var="irp">
                                        <tr <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
                                            <td class="col-sm-6 col-xs-6">${irp.name}</td>
                                            <td class="col-sm-6 col-xs-6">${irp.fcy}${empty irp.compensation_days ? '元' : '元/天'}</td>
                                        </tr>
                                    </c:forEach>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </c:otherwise>
                </c:choose>
                <div class="col-sm-12 col-xs-12">
                    <div class="row">
                        <div class="col-sm-6 col-sm-6 mt-20">
                            <div class="insure-check">
                                    <span class="check-box pull-left" id="check_span">
                                        <input type="checkbox" id="check_007" class="form-control" Data-Val="Required" />
                                        <label for="check_007" id="check_007_for"></label>
                                    </span>
                                <span class="pull-left" style="line-height: 13px;font-weight: bold;color: red">本企业理解并接受上述已选保障方案</span><br />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 reminder">
                    <label>温馨提示：若需线下转账进行支付，请在起保日期之前完成转账，以免影响保单效力。</label>
                </div>
                <c:if test="${!fn:contains(pd.product_code, 'TYX-QH-DQ')&&!fn:contains(pd.product_code, 'TYX-HT-DQ')}">
                <div class="col-sm-5 col-xs-5">
                    <p>*起保日期选择</p>
                    <input Data-Val="Date Required" type="text" name="inception_date" id="inceptionDate" autocomplete="off" value="${ vo.inception_date}" class="laydate-icon form-control" onclick="laydate({elem: '#inceptionDate',min: laydate.now(+1),max: laydate.now(+90), format: 'YYYY-MM-DD'})" data-toggle="tooltip" data-placement="top" title="建议您起保日期尽量往后选，若您选择的起保日期是明天，请确保在今天17：00 前（工作日）完成支付，否则保单可能无法及时生效。">
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                </c:if>
                <c:if test="${fn:contains(pd.product_code, 'TYX-QH-DQ')||fn:contains(pd.product_code, 'TYX-HT-DQ')}">
                    <div class="col-sm-9 col-xs-9">
                        <p>*保险期间</p>
                        <div class="row fs-lh34">
                            <div class="col-sm-1 col-xs-1">自</div>
                            <div class="col-sm-3 col-xs-3"><input Data-Val="Date Required" placeholder="" name="inception_date" id="inceptionDate" autocomplete="off" value="${vo.inception_date}" class="laydate-icon form-control"> </div>
                            <div class="col-sm-2 col-xs-2">零时起</div>
                            <div class="col-sm-1 col-xs-1">至</div>
                            <div class="col-sm-3 col-xs-3"><input Data-Val="Date Required" placeholder="" name="planned_end_date" id="plannedEndDate" autocomplete="off" value="${vo.planned_end_date}" class="laydate-icon form-control"></div>
                            <div class="col-sm-2 col-xs-2">二十四时止</div>
                        </div>
                    </div>
                </c:if>
                <div class="col-sm-3 col-xs-3">
                    <p>保费</p>
                    <strong class="d-l-36" id="mPremium">${empty dto.gross_premium ? pd.premium_min*(empty vo.roleSubjectList ? 3 : (vo.roleSubjectList.size()-1)) : dto.gross_premium}元</strong>
                </div>
                <div class="clearfix"></div>
                <c:if test="${fn:contains(pd.product_code, 'TYX-PAS')}">
                    <div class="col-sm-4 col-xs-4">
                        <p>客户识别授权书(<a href="<c:url value='/resources/files/客户授权及声明.docx' />" target="_blank" style="color: red">下载</a>)<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top"  title="请下载授权声明书，认真阅读后按要求填写经办人信息，申请企业盖章后将该扫描件上传。"></i></p>
                        <input type="hidden" title="" name="accredit_path" id="accreditPath" value="${vo.accredit_path }">
                        <div>
                            <input title="" value="${vo.accredit_path }" name="accreditPath_file" id="accreditPath_file-5" data-drawview="${vo.accredit_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="f-c-12"><i class="glyphicon glyphicon-info-sign"></i>请下载授权声明书，认真阅读后按要求填写经办人信息，申请企业盖章后将该扫描件上传。</span>
                    </div>
                </c:if>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>退保账户信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder">
                    <label>温馨提示：团意险/雇主险每期结算保费时，若有需要退回保费的情况，将往以下账户进行转账。</label>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行省</p>
                    <select Data-Val="Required" title="省" name="roleSubjectList[0].bank_province" id="tkbankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bank_city_0', '', '2', this);">
                        <option value="">请选择省</option>
                        <c:forEach items="${provinceList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_province }"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行市</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_city" id="bank_city_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankType('bank_type_0', this);">
                        <option value="">请选择市</option>
                        <c:forEach items="${bankCityList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_city}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户银行</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_type" id="bank_type_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankAddr('bank_addr_0', 'bank_city_0', this);">
                        <option value="">请选择名称</option>
                        <c:forEach items="${bankTypeList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_type}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行地址</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_addr" id="bank_addr_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankName('bank_name_0', this);">
                        <option value="">请选择地址</option>
                        <c:forEach items="${bankAddrList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_addr}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                    <input Data-Val="Required" type="hidden" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" />
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*账户开户类型</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_pub_pri" id="bank_pub_pri_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">请选择类型</option>
                        <option value="1" <c:if test="${'1' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对公</option>
                        <option value="2" <c:if test="${'2' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对私</option>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*账户户名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].account_name" id="account_name_0" value="${vo.roleSubjectList[0].account_name}" class="form-control" placeholder="请填写开户名" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="col-sm-3 col-xs-3">
                    <p>*账户开户行</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" placeholder="请填写账户开户行" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*银行账号</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_account" id="bank_account_0" value="${vo.roleSubjectList[0].bank_account}" class="form-control" placeholder="请填写银行账号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>单证信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder" style="line-height: 25px;">
                    <label>
                        温馨提示：<br/>
                        1.本产品采取电子保单/电子发票形式，投保成功后，电子保单及电子发票会实时发送到您填写的投保人邮箱中；<br/>
                        2.根据《中华人民共和国合同法》第十一条规定，数据电文是合法的合同表现形式，<span style="color:red;">电子保单与纸质保单具有同等法律效力</span>；您可以登录保险公司官网自助查询对电子保单的真实性进行验证；<br/>
                        <span style="color:red;">3.电子发票是以电子方式存储的收付款凭证，其法律效力、基本用途、基本使用规定等与税务机关监制的纸质发票相同。</span>
                    </label>
                </div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <input type="checkbox" checked="checked" id="need_insur_dz" disabled/>
                        <label for="need_insur_dz"></label>
                    </span>
                    <span class="pull-left lhml5">开具电子保单<span class="label label-primary" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">系统默认</span>（实时出单、安全保密、易存易查、不影响理赔）</span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;<c:if test="${fn:contains(pd.product_code, 'TYX-PAS')}">display: none;</c:if>">
                    <span class="pull-left check-box">
                        <c:set var="is_send_einvoice_1" value="${(not empty vo.mailPolicyVo.is_send_einvoice && vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                        <input type="checkbox" value="1" id="is_send_einvoice"<c:if test="${is_send_einvoice_1 eq '1'}"> checked="checked"</c:if>/>
                        <label for="is_send_einvoice"></label>
                        <input type="hidden" name="mailPolicyVo.is_send_einvoice" value="${vo.mailPolicyVo.is_send_einvoice}" />
                    </span>
                    <span class="pull-left lhml5">开具电子发票<span class="label label-success" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">推荐使用</span>（实时开具、加密防伪、长期保存、随打随用）</span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_insur_bill" value="${(not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1')?'1':'0'}"></c:set>
                        <input disabled type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill"<c:if test="${is_need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
                    <span class="pull-left lhml5">开具纸质保单<span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</span>
                </div>
                <div class="clear"></div>
                <div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-6 col-xs-6">
                        <p>*收件人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_receipt" value="${(not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1')?'1':'0'}"></c:set>
                        <input disabled type="checkbox" value="1" id="need_receipt" ${fn:contains(pd.product_code, 'TYX-PAS')?'disabled':''} <c:if test="${is_need_receipt eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_receipt"></label>
                        <input type="hidden" name="mailPolicyVo.need_receipt" value="${vo.mailPolicyVo.need_receipt}" />
                    </span>
                    <span class="pull-left lhml5">开具纸质发票<c:if test="${!fn:contains(pd.product_code, 'TYX-PAS')}"><span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</c:if><c:if test="${fn:contains(pd.product_code, 'TYX-PAS')}"><span class="label label-primary" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">系统默认</span></c:if></span>
                </div>
                <div class="clear"></div>
                <div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-12 col-xs-12">
                        <p>发票种类</p>
                        <div class="row">
                            <div class="col-sm-12 col-xs-12">
                                <div class="row">
                                    <div class="col-sm-2 col-xs-2 rad-io">
                                        <c:set var="is_invoice_type_1" value="${(empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' || vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0"<c:if test="${is_invoice_type_1 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
                                    </div>
                                    <div class="col-sm-2 col-xs-2 rad-io"<c:if test="${vo.mailPolicyVo.is_send_einvoice eq '1'}"> style="display: none;"</c:if>><%--选电子发票就隐藏该项--%>
                                        <c:set var="is_invoice_type_2" value="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1')?'1':'0'}"></c:set>
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1"<c:if test="${is_invoice_type_2 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0') || vo.mailPolicyVo.is_send_einvoice eq '0' }"> style="display: none;"</c:if>>
                    <label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
                </div>
                <div id="mod_2_2" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*单位名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人姓名</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3" <c:if test="${vo.mailPolicyVo.invoice_type eq '1'}"> style="display: none;"</c:if>>
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.invoice_type eq '1') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"<c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*注册地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*电话</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行省</p>
                        <select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择省</option>
                            <c:forEach items="${provinceList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行市</p>
                        <select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择市</option>
                            <c:forEach items="${bankCityList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*银行账号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                    <div class="col-sm-4 col-xs-4">
                        <p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>一般纳税人证明</p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>银行开户许可证</p>
                        <input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
                        <input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
    </form>
    <div class="row next-step">
        <div class="col-sm-12 col-xs-12 text-right pull-right">
            <p>
                <a href="javascript:void(0);" onclick="saveGMRInfo();" id="pendingInfo" class="save">暂存本页</a>
                <c:if test="${fn:split(pd.product_code,'-')[1] eq 'TK'}">
                    <a href="javascript:void(0);" onclick="submitMsg('${fn:split(pd.product_code,'-')[2]}');" class="ns-btn">下一步</a>
                </c:if>
                <c:if test="${fn:split(pd.product_code,'-')[1] != 'TK'}">
                    <a href="javascript:void(0);" onclick="save_policy_gmr();" class="ns-btn">下一步</a>
                </c:if>
            </p>
            <%--<p>
                <a href="javascript:void(0);" onclick="saveGMRInfo();" id="pendingInfo" class="save">暂存本页</a>
                <a href="javascript:void(0);" onclick="save_policy_gmr();" class="ns-btn">下一步</a>
            </p>--%>
        </div>
    </div>
</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">营业执照</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
            </div>
        </div>
    </div>
</div>
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">组织机构代码证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">税务登记证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/FileSaver.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<script src="/static/weChat/js/weixin_g.js"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
    window.onload = function () {
        //以后优化 频繁变更水印
        watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
    }
    function closeUMsg(){
        var _bContentHeight = $('#_bContent').scrollTop();
        console.log(_bContentHeight);
        <c:if test="${fn:contains(pd.product_code,'TYX-HT')}">
        if(_bContentHeight<3700){
            laySomenType(1,null,"请阅读到底部",0);
            return;
        }
        </c:if>
        <c:if test="${fn:contains(pd.product_code,'TYX-QH')}">
        if(_bContentHeight<4400){
            laySomenType(1,null,"请阅读到底部",0);
            return;
        }
        </c:if>
        <c:if test="${!fn:contains(pd.product_code,'TYX-QH')&&!fn:contains(pd.product_code,'TYX-HT')}">
        if(_bContentHeight<3700){
            laySomenType(1,null,"请阅读到底部",0);
            return;
        }
        </c:if>
        $('.contacts_modal_oth').hide();
        $('.black-mask-oth').hide();
    }
    function closeUMsg1(){
        var _text = $('#closeUMsg').text();
        if(_text.indexOf('(')>0){
            return;
        }
        var khgzsHeight = $('#khgzs').scrollTop();
        if(khgzsHeight<620){
            laySomenType(1,null,"“客户告知书”内容请阅读到底部",0);
            return;
        }
        var starP='<p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">保险条款</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-bottom:7.8500pt;mso-para-margin-bottom:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;">_pcs<b><span style="font-family: 宋体; font-size: 10pt;"><o:p></o:p></span></b></p>';
        var starA='';
        <c:if test="${not empty pd.pro_clauses}">
        <c:forEach items="${fn:split(pd.pro_clauses, '#')}" var="pcs">
        starA += '<b><span style="font-family: 宋体; font-size: 12pt;">${fn:split(pcs, "::")[1]}</span></b><iframe id="frame3d" name="frame3d" frameborder="0" width="100%" height="400px" scrolling="auto" title="${fn:split(pcs, "::")[1]}" src="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />" ></iframe>';
        </c:forEach>
        </c:if>
        starP = starP.replace('_pcs',starA);
        <c:if test="${fn:contains(pd.product_code,'TYX-HT')}">
        $('#_bContent').html('<p class="MsoNormal" align="center" style="text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 14pt;">投保须知</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 20pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;">本产品条款备案号</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">：《华泰财险团体人身意外伤害保险（互联网专属）</font>-C00015432312021121421663》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">、</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《华泰财险附加意外伤害医疗保险</font>A款（互联网专属）—C00015432522021120102203》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">、</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《华泰财险附加意外伤害住院津贴保险</font>A款（互联网专属）—C00015432522021121517143》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">、</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《华泰财险附加猝死保险（</font>A款） -C00015431922021040133311》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;">请您如实填写投保信息</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，根据《中华人民共和国保险法》第十六条规定：投保人故意或因重大过失未履行如实告知义务的，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，但应当退还保险费</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本产品由华泰财产保险有限公司承保</font>(以下简称“华泰财”),目前该公司在北京、上海、天津、重庆、江苏、广东、陕西、四川、云南、辽宁、浙江、河北、湖南、湖北、 安徽、山西、福建、山东、广西、河南、江西、深圳、青岛、大连、宁波、贵州、内蒙古、厦门、黑龙江、新疆设有分支机构。本保险产品的销售区域为全国（不含港澳台）。若您处于华泰财险无分支机构的地区，不影响您的理赔，但可能会存在其他服务不到位等问题</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;">偿付能力披露</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">:</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">华泰财险偿付能力充足率已达到监管要求，您可进入华泰财险官网</font> (http://pc.ehuatai.com)→点击“公开信息披露”→在“专项信息”→“偿付能力”中进行查询。我公司202</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">年第</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">季度综合偿付能力充足率为</font>221%，202</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">年第</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">季度风险综合评级（分类监管）评价结果为</font>AA类。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;">保单形式：</span></b><span style="font-family: 宋体; font-size: 10.5pt;">本保险产品为互联网销售保险产品，为您提供电子保单，根据《中华人民共和国民法典》第四百六十九条规定，数据电文是合法的合同表现形式，电子保单与纸质保单具有同等法律效力。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;">发票形式：</span></b><span style="font-family: 宋体; font-size: 10.5pt;">本保险产品为互联网销售保险产品，在线趸交支付保费，为您提供电子发票，电子发票效力等同于纸质发票。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">7.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本保单仅承保被保险人年龄为</font>18周岁（含）-65周岁（含）身体健康、能正常工作和生活的自然人。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">8.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">保险地域：本保险单仅承保被保险人在</span><b><span style="font-family: 宋体; font-size: 10.5pt;">中国境内</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">（不包含香港、澳门、台湾）的保险责任；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">9.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">意外伤害医疗费用：被保险人因遭受意外伤害事故并在医院进行治疗，保险公司就其事故发生之日起一百八十天内实际支出的，</span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">符合保单签发地社会医疗保险标准的医疗费用扣除免赔额</font>100元</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">后按</font>100%的比例给付意外伤害医疗保险金；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">10.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">意外住院津贴：每次事故无免赔，单次事故最多赔付</font>90天，累计赔偿不超过180天；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">11.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保单仅承保被保险人以保安身份参加保单指定的活动或项目期间的意外事故；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">12.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">猝死指平素身体健康或貌似健康的患者，在短时间内，因自然疾病而突然身故。猝死的时间限度指从首次发病到身故所经过的时间，</span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">本保单约定为</font>24小时</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，该时间以外身故的，不属于本附加险合同保险责任。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">	</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">13.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">阅读条款：请确认您已认真阅读《华泰财险团体人身意外伤害保险（互联网专属）</font>-C00015432312021121421663》、《华泰财险附加意外伤害医疗保险A款（互联网专属）—C00015432522021120102203》《华泰财险附加意外伤害住院津贴保险A款（互联网专属）—C00015432522021121517143》、《华泰财险附加猝死保险（A款） -C00015431922021040133311》， </span><b><span style="font-family: 宋体; font-size: 10.5pt;">您了解、同意并确认上述条款内容，特别是保险责任及责任免除的部分。作为投保人，您确认对于被保险人具有保险利益。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">14.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;">客户信息收集条款</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">：本人授权华泰保险，除法律另有规定外，将本人提供给华泰保险的信息、享受华泰保险服务产生的信息（包括本保单签署之前提供和产生的信息）以及华泰保险根据本条约定查询、收集的信息，用于华泰保险及其因服务必须委托的合作伙伴为本人提供服务、推荐产品、开展市场调查与信息数据分析。本人授权华泰保险，除法律另有规定外，基于为本人提供更优质服务和产品的目的，向华泰保险因服务必要开展合作的伙伴提供、查询、收集本人的信息。为确保本人信息的安全，华泰保险及其合作伙伴对上述信息负有保密义务，并采取各种措施保证信息安全。本条款自本单证签署时生效，具有独立法律效力，不受合同成立与否及效力状态变化的影响。本条所称</font>“华泰保险”是指华泰保险集团股份有限公司及其直接或间接控股的公司，以及华泰保险集团股份有限公司直接或间接作为其单一最大股东的公司。如您不同意上述授权条款的部分或全部，可致电客服热线 4006095509 取消或变更授权。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">15.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">如对本保险产品有任何咨询、报案或投诉问题，请拨打华泰保险客户</span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">服务热线</font>:4006095509</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，我们将竭诚为您服务。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 20pt;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">责任免除内容</span></b><b><span style="font-family: 宋体; font-size: 14pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; font-size: 12pt;"><font face="宋体">具体以条款内容及释义为准</font>:</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; font-size: 12pt;">一、</span></b><b><span style="font-family: 宋体; font-size: 12pt;">意外伤害保险</span></b><b><span style="font-family: 宋体; font-size: 12pt;">:</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">因下列情形之一，直接或间接造成被保险人身故或伤残的，保险人不承担给付保险金责任：</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（一）投保人的故意行为；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（二）被保险人自致伤害或自杀，但被保险人自杀时为无民事行为能力人的除外；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（三）因被保险人挑衅或故意行为而导致的打斗、被袭击或被谋杀；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（四）被保险人犯罪或者抗拒依法采取的刑事强制措施；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">（五）被保险人醉酒；</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（六）被保险人服用、吸食、注射毒品或服用影响行为能力的相关药品或受管制的药品；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（七）被保险人未遵医嘱，私自服用、涂用、注射药物；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（八）被保险人妊娠、流产、分娩（但因遭受意外伤害所致不在此限）；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（九）被保险人受细菌、病毒或寄生虫感染（但因意外伤害事故致伤口感染者除外），或被保险人中暑、猝死、药物过敏、食物中毒；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（十）被保险人因精神错乱或失常而导致的意外；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（十一）被保险人因接受检查、麻醉、整容手术及其它内外科手术、药物治疗等导致的事故；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（十二）被保险人因意外事故、自然灾害以外的原因失踪而被法院宣告死亡的；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（十三）任何生物、化学、原子武器、原子能或核能爆炸、辐射或污染。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（</span><span style="font-family: 宋体; font-size: 10.5pt;">十四）</span><span style="font-family: 宋体; font-size: 10.5pt;">被保险人酒后驾驶、无有效驾驶证驾驶，或驾驶无有效行驶证的机动交通工具期间，或无有效操作证操作施工设备期间；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（</span><span style="font-family: 宋体; font-size: 10.5pt;">十五</span><span style="font-family: 宋体; font-size: 10.5pt;">）被保险人违反法律法规或交通管理部门的规定搭乘交通工具或搭乘未经当地相关政府部门登记许可的交通工具期间；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（</span><span style="font-family: 宋体; font-size: 10.5pt;">十六</span><span style="font-family: 宋体; font-size: 10.5pt;">）保险人因受酒精、毒品、管制药品的影响期间；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（</span><span style="font-family: 宋体; font-size: 10.5pt;">十七</span><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">）被保险人从事潜水、跳伞、攀岩、探险活动、武术比赛、摔跤比赛、特技表演、赛马、赛车等高风险运动或活动期间；</font> </span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">（</span><span style="font-family: 宋体; font-size: 10.5pt;">十八</span><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">）战争（无论宣战与否）、内战、军事行动、恐怖活动、暴乱或其它类似的武装叛乱期间。</font> &nbsp;&nbsp;&nbsp;</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">若由于本保险合同中责任免除的情形导致被保险人身故，保险人对该被保险人的保险责任终止，除法律规定不退还保险费的情形外，保险人退还相应的未满期保险费。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">&nbsp;</span></p><p class="MsoNormal"><b><span style="font-family: 宋体; font-size: 12pt;">二、</span></b><b><span style="font-family: 宋体; font-size: 12pt;">意外伤害医疗保险</span></b><b><span style="font-family: 宋体; font-size: 12pt;">:</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">因下列情形之一，直接或间接导致被保险人发生医疗费用支出的，保险人不承担赔偿责任：</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">1.被保险人身患疾病所支付的费用；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">2.被保险人康复治疗、健康护理(含体检、健康体检、疗养、特别护理或静养) 等非治疗性的行为及无客观病征证明其不健康及以捐献身体器官为目的的医疗行为；</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">3. 被保险人流产、堕胎、分娩、不孕症、避孕或绝育手术、变性手术、人体试验和人工生殖，及由此而引起的并发症；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">4. 被保险人未经保险人同意的转院治疗或在家自设病床治疗；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">5. 未经保险人同意，被保险人在非认可的医疗机构治疗，但被保险人因情况紧急必须立即就医的除外；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">6. 被保险人未遵医嘱，私自服用、涂用、注射药物； </span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">7.被保险人因接受检查、麻醉、整容手术及其它内外科手术、药物治疗等导致的住院；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">8.因医疗事故、医疗意外及并发症增加的医疗费；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">9. 主险合同约定的责任免除事项。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">1</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">0</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">. 护理（陪住）费、取暖费、交通费、误工费、空调费、膳食费、特需服务费、营养性药品等需要自理的费用；</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">11</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">. 用于矫形、整容、美容、心理咨询、康复治疗（训练）、器官移植、角膜屈光成形手术或修复、安装及购买残疾用具（如轮椅、假肢、助听器、假眼、假牙、配镜等）的费用；</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">12</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">. 被保险人参加社会医疗保险所在地地社会医疗保险主管部门规定的自费项目。</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">&nbsp;</span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; font-size: 12pt;"><font face="宋体">三、意外住院津贴</font>:</span></b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">存在</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">下列情形或</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">因下列情形之一，直接或间接导致被保险人住院治疗的，保险人不承担赔偿责任：</span><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">1. </span><span style="font-family: 宋体; font-size: 10.5pt;">被保险人身患疾病而住院；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">2. </span><span style="font-family: 宋体; font-size: 10.5pt;">被保险人因流产、堕胎、分娩、不孕症、避孕或绝育手术、变性手术、人体试验和人工生殖，及由此而引起的并发症而住院；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">3. </span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">被保险人因康复治疗、健康护理</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">(</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">含体检、健康体检、疗养、特别护理或静养</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">)</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">&nbsp;<font face="宋体">等非治疗性的行为及</font></span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">无</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">客</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">观</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">病征</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">证</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">明其不健康</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">及以捐献身体器官为目的的医疗行为</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">导致的住院；</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">4.</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">&nbsp;</span><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">以矫形、整容、美容、心理咨询、器官移植、角膜屈光成形手术或修复为目的的住院</span><span style="font-family: 宋体; font-size: 10.5pt;">；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">5.</span><span style="font-family: 宋体; font-size: 10.5pt;">&nbsp;</span><span style="font-family: 宋体; font-size: 10.5pt;">被保险人在非认可的医疗机构治疗，但被保险人因情况紧急必须立即就医的除外；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">6. </span><span style="font-family: 宋体; font-size: 10.5pt;">被保险人未经保险人同意的转院治疗，被保险人在家自设病床治疗；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">7. 被</span><span style="font-family: 宋体; font-size: 10.5pt;">保险人因接受检查、麻醉、整容手术及其它内外科手术、药物治疗等导致的住院；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">8</span><span style="font-family: 宋体; font-size: 10.5pt;">. 因医疗事故、医疗意外及并发症</span><span style="font-family: 宋体; font-size: 10.5pt;">导致</span><span style="font-family: 宋体; font-size: 10.5pt;">的住院</span><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">；</font> </span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-bottom:7.8000pt;mso-para-margin-bottom:0.5000gd;mso-outline-level:1;"><span style="font-family: 宋体; font-size: 10.5pt;">9</span><span style="font-family: 宋体; font-size: 10.5pt;">.主险合同约定的责任免除事项。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-bottom:7.8000pt;mso-para-margin-bottom:0.5000gd;mso-outline-level:1;"><span style="font-family: 宋体; font-size: 10.5pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-bottom:7.8000pt;mso-para-margin-bottom:0.5000gd;mso-outline-level:1;"><b><span style="font-family: 宋体; font-size: 12pt;">四、猝死</span></b><b><span style="font-family: 宋体; font-size: 12pt;">：</span></b><b><span style="font-family: 宋体; font-size: 14pt;"><br></span></b><span style="font-family: 宋体; font-size: 10.5pt;">因下列原因之一导致被保险人猝死的，保险人不承担保险金给付责任：</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(一)投保人的故意杀害、故意伤害行为；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(二)被保险人故意犯罪或者抗拒依法采取的刑事强制措施、自致伤害或自杀，但被保险人自杀时为无民事行为能力人的除外； </span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(三)因被保险人挑衅或故意行为而导致的打斗、被袭击或被谋杀；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(四)被保险人未遵医嘱，私自服用、涂用、注射药物；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(五)被保险人及家庭成员（释义1）不遵医嘱，拒绝配合治疗的；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(六)被保险人醉酒或者受酒精、毒品或者管制药品的影响期间；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">(七)慢性病的急性发作；</span><span style="font-family: 宋体; font-size: 10.5pt;">&nbsp;</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(八)战争、军事行动、暴动、恐怖活动或武装叛乱；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(九)被保险人流产、分娩及由以上原因引起之并发症；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">(十)被保险人接受医疗检查、麻醉、整容、整形手术及其他内、外科手术；</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(十一)被保险人因意外伤害（释义2）事故身故；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(十二)被保险人从事跳伞、滑翔、探险活动、武术比赛、摔跤比赛、特技表演、赛马、马术表演、赛车、拳击等高风险运动或活动；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(十三)任何生物、化学、原子能武器，原子能或核能装置所造成的爆炸、灼伤、污染或辐射。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(十</span><span style="font-family: 宋体; font-size: 10.5pt;">四</span><span style="font-family: 宋体; font-size: 10.5pt;">)精神和行为障碍(以世界卫生组织颁布的《疾病和有关健康问题的国际统计分类(ICD-10)》为准)或者癫痫发作期间；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(</span><span style="font-family: 宋体; font-size: 10.5pt;">十五</span><span style="font-family: 宋体; font-size: 10.5pt;">)任何获取移植器官或者捐献器官的行为；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(</span><span style="font-family: 宋体; font-size: 10.5pt;">十六</span><span style="font-family: 宋体; font-size: 10.5pt;">)被保险人患艾滋病（AIDS）或感染艾滋病病毒（HIV呈阳性）；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(</span><span style="font-family: 宋体; font-size: 10.5pt;">十七</span><span style="font-family: 宋体; font-size: 10.5pt;">)被保险人患精神病、遗传性疾病（释义3）、先天性疾病、先天性畸形（释义4）、性传播疾病；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">(</span><span style="font-family: 宋体; font-size: 10.5pt;">十八</span><span style="font-family: 宋体; font-size: 10.5pt;">)被保险人在投保前已知或已经明确诊疗的疾病，在保险期间因此疾病身故的。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="font-family: 宋体; font-size: 10.5pt;">主险合同中规定的其他责任免除事项也适用于本附加险合同。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">特别约定</span></b><b><span style="font-family: 宋体; font-size: 14pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本保单仅承保被保险人年龄为</font>18周岁（含）-65周岁（含）身体健康、能正常工作和生活的自然人。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">保险地域：本保险单仅承保被保险人在中国境内（不包含香港、澳门、台湾）的保险责任；</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">意外伤害医疗费用：被保险人因遭受意外伤害事故并在医院进行治疗，保险公司就其事故发生之日起一百八十天内实际支出的</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">，符合保单签发地社会医疗保险标准的医疗费用扣除免赔额</font>100元</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">后按</font>100%的比例给付意外伤害医疗保险金；</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">意外住院津贴：每次事故无免赔，单次事故最多赔付</font>90天，累计赔偿不超过180天；</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保单仅承保被保险人以保安身份参加保单指定的活动或项目期间的意外事故；</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">猝死指平素身体健康或貌似健康的患者，在短时间内，因自然疾病而突然身故。猝死的时间限度指从首次发病到身故所经过的时间，</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保单约定为</font>24小时，该时间以外身故的，不属于本附加险合同保险责任。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">	</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;">投保人声明</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:18.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">本投保人兹声明上述各项投保内容填写属实；</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">本投保人确认购买本保险产品前，已仔细阅读并充分理解并同意接受本《投保须知》、《保险条款》、《责任免责声明》、《投保人声明》等，</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">特别是其中有关责任条款及免除责任条款、退保规则、投保人和被保险人义务的内容等重大事项。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p>'+starP);
        </c:if>
        <c:if test="${fn:contains(pd.product_code,'TYX-QH')}">
        $('#_bContent').html('<p class="p" align="center" style="text-autospace:ideograph-numeric;mso-pagination:widow-orphan;text-align:center;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 14pt;">投保须知</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 18pt;"><o:p></o:p></span></b></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">1.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">本保险产品由新疆前海联合财产保险股份有限公司（以下简称</font>“前海财险”）承保，通过百联保平台在中华人民共和国境内（香港、澳门、台湾地区除外）销售。目前前海财险在广东、深圳、新疆、四川、湖北有分支机构。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">2.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">本保险产品适用条款为《新疆前海联合财产保险股份有限公司前海财险团体人身意外伤害保险（</font>2022版）》（注册号：C00020832312022061321761）、《新疆前海联合财产保险股份有限公司前海财险团体人身意外伤害保险附加意外伤害医疗保险（2023版）》（注册号：C00020832522023083140861）、《新疆前海联合财产保险股份有限公司前海财险团体人身意外伤害保险附加住院津贴保险》（注册号：C00020832522022060111401）。</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">请投保人了解、同意并确认上述条款内容，特别是保险责任及责任免除的部分。购买本保险产品即表示投保人同意接受本产品条款及投保须知的全部内容。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">3.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;">投保人：仅限保安行业与物业行业企业。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">4.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">被保险人：本保单被保险人必须是投保前已经在</font>“百保盾”平台注册的保安人员。</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">非百保盾上注册登记的人员发生的事故，保险人不承担保险责任。</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">5.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">本保单仅承保被保险人职业为保安的人员。</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">当被保险人职业不符合前述要求时，保险人有权解除合同，保险合同自始无效，且不承担保险责任。本保险产品同一被保险人累计最高有效承保份数为</font>1份，多投无效。</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">6.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">本保单被保险人均为自愿本次参加临时性安保工作的人员，非所属工作单位要求参加和委派，不属于工作时间和工作内容，因此本保单不与雇主责任险重复赔付。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">7.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保单记名投保，保险期间可以替换人员（但已经出险的雇员不得变更），请提前</font>1天在系统中批改换人名单，新换人员第二天零时保险生效。保险期间批增人员，无论剩余保险天数长短，均按原每人保费标准加收保险费。</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">8.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">保险人在符合条款规定的医疗费用内扣除绝对免赔额人民币</font>200元及其他已报销或已获得赔偿的医疗费用后，剩余部分按100％的比例在保险金额内赔付意外伤害保险金。如其他已报销或已获得赔偿的医疗费用金额（不含社保和公费医疗）大于免赔额200元，则剩余部分无需扣除免赔额。具体详见条款内容规定。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">9.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保单附加意外住院津贴保险项下，每次事故每人意外伤害住院津贴绝对免赔天数为</font>0天，每天给付100元，同一次住院的住院津贴给付天数以90天为限，累计住院津贴给付的天数以180天为限。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">10.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">被保险人自遭受该意外之日起一百八十日内以该意外为直接、完全原因而导致《人身保险伤残评定标准及代码》（</font>JR/T 0083—2013，保监发[2014]6 号）中所列伤残的，保险人按该处残疾的伤残等级对应的给付比例和该被保险人的意外伤害保险金额的乘积给付意外伤残保险金。</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">伤残等级对应的保险金给付比例分为十档，伤残程度第一级对应的保险金给付比例为</font>100%，伤残程度第十级对应的保险金给付比例为10%，每级相差10%。</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">11.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">本保单仅承担被保险人在直接去本次临时性活动任务地点或从其直接返回的途中以及参加本次临时性活动任务期间的意外事故。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">12.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">被保险人须在知道或应当知道保险事故发生后的</font>48 小时内向保险人报案。</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">因延迟报案致使保险事故的性质、原因、损失程度等难以确定的，保险人对无法确定的部分，不承担赔偿责任。</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">13.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">退保规则：保单生效前投保人要求解除本合同，自保险人接到投保人申请后，本合同的效力终止，并全额退还保费。保单生效后投保人要求解除本合同，自保险人接到保险合同解除申请书之日次日零时起，本合同的效力终止，保险人收到证明文件和资料之日起</font>30日内退还未满期净保险费。</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">未满期净保险费</font>=保险费×（1-保险单已经过天数/保险期间天数），经过天数不足一天的按一天计算。</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">14.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保险产品采用电子保单形式承保，法律效力等同于纸质保单。投保人可登陆前海财险官网</font>https://www.qhins.com/，进行保单查询、验真及电子保单下载等操作。如需要纸质保单及发票，请拨打前海财险全国客服专线4008110110，我们提供顺丰快递到付服务。</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">15.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">在投保本保险产品前您应履行相应的如实告知义务，具体如下：投保人或被保险人应如实填写投保信息，并就保险公司提出的询问据实告知，</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">否则保险公司有权根据《中华人民共和国保险法》第十六条的规定解除保险合同且不承担赔偿责任</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">；订立保险合同时，保险公司就保险标的或者被保险人的有关情况提出询问的，投保人应当如实告知。</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">投保人故意或者因重大过失未履行前款规定的如实告知义务，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿责任，但退还保险费。</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">16.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">保险人在提供承保、理赔等保险服务时可能需要通过知悉被保险人信息的机构查询被保险人的个人信息，包括但不限于投保、承保、理赔、医疗等。保险人保证严格遵守现行的关于个人信息、数据及隐私保护的法律法规，采取充分的技术手段和制度管理，保护由被保险人提供或由保险人获取的被保险人的个人信息、数据和隐私不受到非法的泄露或披露给未经许可的第三方。在必要情形下第三方可能接触并使用被保险人的个人信息，包括得到授权的保险人的员工、以及不时执行与保险人的业务、营销活动和数据整理有关工作的其他公司或人员。所有此类人员及公司均需遵守相关保密协议，同时也需要遵守国家关于个人信息保护有关的法律法规，以确保被保险人的个人信息随时得到保护。除上述用途外，保险人不会将被保险人的个人信息用于任何未经被保险人同意的用途。除了保险人的业务合作伙伴、法律顾问、外部审计机构或按照法律规定、监管规定或法庭裁决之外，保险人不会将所接受的任何个人信息泄露、篡改、毁损、出售或者提供给任何第三方。</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">17.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">偿付能力告知：新疆前海联合财产保险股份有限公司达到监管要求的风险综合评级，偿付能力及风险综合评级（分类监管）结果可登录保险公司网站</font>https://www.qhins.com/cms/statics/solvencyInfos.html查询。</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l0 level1 lfo1;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">18.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保险产品详细保险条款内容可登录保险公司官方网站</font>https://www.qhins.com/cms/statics/notCarInsuranceProduct.html查询。</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="line-height: 150%;"><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">&nbsp;</span></p><p class="p" style="line-height: 150%;"><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">&nbsp;</span></p><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">责任免除特别提示</span></b><b><span style="font-family: 宋体; font-size: 14pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 16pt;">&nbsp;</span></b></p><p class="MsoNormal" style="text-indent: 21.1pt;"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">责任免除是免除保险人责任，即保险人不承担保险金给付责任的内容。本保险产品责任免除包含适用主险和附加险条款中的责任免除条款及保单的特别约定等内容，请投保人认真阅读本责任免除的全部内容以及对部分内容（已用蓝色文字标记）的解释说明。对责任免除内容有任何不理解或不接受之处，请勿投保。购买本保险产品即表示投保人接受本责任免除的全部内容。</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="center" style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">第一部分</span></b><b><span style="font-family: 宋体; font-size: 14pt;">&nbsp;</span></b><b><span style="font-family: 宋体; font-size: 14pt;">条款中的责任免除</span></b><b><span style="font-family: 宋体; font-size: 16pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:0.0000pt;mso-char-indent-count:0.0000;text-autospace:ideograph-numeric;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 12pt;"><font face="宋体">一、团体人身意外伤害保险（</font>2022版）条款</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 12pt;">的</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 12pt;">责任免除</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 12pt;"><o:p></o:p></span></b></p><p class="20" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">第</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">一</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">条</font> </span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">因下列原因造成被保险人身故或残疾的，保险人不承担给付保险金责任：</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（一）投保人的故意行为；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（二）被保险人自致伤害或自杀，但被保险人自杀时为无民事行为能力人的除外；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（三）因被保险人挑衅或故意行为而导致的打斗、被袭击或被谋杀；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（四）被保险人妊娠、流产、分娩、疾病、过敏、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">猝死</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">中暑</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">高原反应</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（五）</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">被保险人接受包括但不限于检查、检验、麻醉、手术、口服药物治疗、注射治疗等医疗行为；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（六）被保险人未遵医嘱，私自服用、涂用、注射药物；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（七）任何生物、化学、原子能武器，原子能或核能装置所造成的爆炸、灼伤、污染或辐射；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（八）恐怖袭击、战争、军事行动、暴动或武装叛乱；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（九）</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">被保险人从事高风险运动，包括但不限于</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">潜水</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">、滑水、冲浪、赛艇、漂流、跳伞或其他高空运动、蹦极、乘坐或驾驶商业民航班机以外的飞行器、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">攀岩</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">、攀登海拔</font>3500米以上的独立山峰、滑雪、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">武术比赛</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">、摔跤、马术、赛马、赛车、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">特技表演</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">（含训练）、替身表演（含训练）、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">探险</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">或考察活动（洞穴、极地、沙漠、火山、冰川等）、生存训练等。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="20" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">第</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">二</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">条</font> </span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">被保险人在下列期间遭受伤害导致身故、残疾的，保险人也不承担给付保险金责任：</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（一）被保险人在犯罪活动期间或者抗拒依法采取的</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">刑事强制措施</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">期间；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（二）被保险人</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">醉酒</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">或受</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">毒品</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">管制药物</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">的影响期间；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（三）被保险人</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">饮酒</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">驾驶、</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">无有效驾驶证</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">驾驶或驾驶</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 255); font-size: 10.5pt;">无有效行驶证</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">的机动交通工具期间；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="18" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（四）被保险人在</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">患</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">精神</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">或</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">行为障碍</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">性疾病</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（以世界卫生组织颁布的《疾病和有关健康问题的国际统计分类（</font>ICD-10）》为准）期间；</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="18" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;line-height:150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（五）被保险人感染艾滋病病毒或患艾滋病期间。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;">&nbsp;</span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 12pt;">二</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 12pt;"><font face="宋体">、团体人身意外伤害保险附加意外伤害医疗保险（</font>2023版）条款的责任免除</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">第</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">一</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">条</font> &nbsp;<font face="宋体">因下列原因造成被保险人支出医疗费用的，保险人不负给付保险金的责任：</font></span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">（一）主险合同条款列明的</font>“责任免除”事项，若主险合同条款中责任免除条款与本附加险合同有相抵触之处，则应以本附加险合同为准；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（二）被保险人在家自设病床治疗、健康保健治疗、康复疗养治疗、物理治疗、</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 255); font-size: 10.5pt;">椎间盘突出症</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">的治疗和非医疗行为的治疗等；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（三）被保险人妊娠、流产、分娩、任何疾病及其并发症、先天性畸形、变形或染色体异常、食物过敏、药物过敏；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（四）被保险人接受整容手术、其他内外科手术或其他诊疗活动过程中发生的医疗意外和医疗损害；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（五）被保险人健康体检、疗养、静养、心理咨询；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（六）被保险人未遵医嘱，私自服用、涂用、注射药物；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（七）被保险人洗牙、洁齿、验光、装配假眼、假牙、假肢或者助听器等；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（八）被保险人投保前所患的</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 255); font-size: 10.5pt;">既往症</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">、残疾及其并发症的治疗；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">（九）被保险人在特需病房、外宾病房、干部病房、联合病房、国际医疗中心、</font>VIP部或其他不属于社会医疗保险范畴的高等级病房入住；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（十）未经保险人同意的转院治疗。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">第</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">二</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">条</font> <font face="宋体">下列费用支出，保险人也不承担给付保险金责任：</font></span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（一）营养费、康复费、</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 255); font-size: 10.5pt;">辅助器具费</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">、护理费、交通费、伙食费、住宿费、误工费、取暖费、丧葬费、误工补贴；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent:21.1000pt;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（二）其他不属于保险责任的医疗费用支出。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 21.1pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">第六条</font> &nbsp;<font face="宋体">根据主险条款和本附加险条款其他部分内容中的相关约定，保险人应不承担或免除保险责任的各种情形下的损失、费用或责任，或保险人有权予以扣除、减少的部分，保险人不负责赔偿。</font></span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;"><b><span style="font-family: 宋体; font-size: 10.5pt;">&nbsp;</span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 12pt;">三</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 12pt;">、团体人身意外伤害保险附加住院津贴保险条款的责任免除</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 20.25pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">第</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">一</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">条</font> </span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">对于因下列情形住院治疗或发生在下列期间的住院治疗，保险人不承担津贴给付责任：</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 20.25pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（一）</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">主险合同条款列明的</font>“责任免除”事项，若主险合同条款中责任免除条款与本附加险合同有相抵触之处，则应以本附加险合同为准；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 20.25pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">（二）被保险人接受康复性治疗、物理治疗、美容</font>/整形/矫形治疗、椎间盘突出治疗；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="text-indent: 20.25pt; line-height: 150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（三）被保险人接受健康体检、疗养、静养、心理咨询；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoBodyTextFirstIndent2" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;text-autospace:ideograph-numeric;mso-pagination:none;vertical-align:baseline;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（四）被保险人接受投保前已有伤残的治疗和康复。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoBodyTextFirstIndent2"><b><span style="font-family: 长城仿宋; font-size: 15pt;">&nbsp;</span></b></p><p class="MsoNormal" align="center" style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">第二部分</span></b><b><span style="font-family: 宋体; font-size: 14pt;">&nbsp;</span></b><b><span style="font-family: 宋体; font-size: 14pt;">特别约定中的责任免除</span></b><b><span style="font-family: 宋体; font-size: 14pt;"><o:p></o:p></span></b></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">1．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保单仅承保被保险人职业为保安的人员。当被保险人职业不符合前述要求时，保险人有权解除合同，保险合同自始无效，且不承担保险责任。本保险产品同一被保险人累计最高有效承保份数为</font>1份，多投无效。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">2．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保单被保险人必须是投保前已经在</font>“百保盾”平台注册的保安人员。非百保盾上注册登记的人员发生的事故，保险人不承担保险责任。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">3．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">本保单被保险人均为自愿本次参加临时性安保工作的人员，非所属工作单位要求参加和委派，不属于工作时间和工作内容，因此本保单不与雇主责任险重复赔付。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">4．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">保险人在符合条款规定的医疗费用内扣除绝对免赔额人民币</font>200元及其他已报销或已获得赔偿的医疗费用后，剩余部分按100％的比例在保险金额内赔付意外伤害保险金。如其他已报销或已获得赔偿的医疗费用金额（不含社保和公费医疗）大于免赔额200元，则剩余部分无需扣除免赔额。具体详见条款内容规定。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">5．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">本保单附加意外住院津贴保险项下，每次事故每人意外伤害住院津贴绝对免赔天数为</font>0天，每天给付100元，同一次住院的住院津贴给付天数以90天为限，累计住院津贴给付的天数以180天为限。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">6．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">被保险人自遭受该意外之日起一百八十日内以该意外为直接、完全原因而导致《人身保险伤残评定标准及代码》（</font>JR/T 0083—2013，保监发[2014]6 号）中所列伤残的，保险人按该处残疾的伤残等级对应的给付比例和该被保险人的意外伤害保险金额的乘积给付意外伤残保险金。伤残等级对应的保险金给付比例分为十档，伤残程度第一级对应的保险金给付比例为100%，伤残程度第十级对应的保险金给付比例为10%，每级相差10%。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">7．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">本保单仅承担被保险人在直接去本次临时性活动任务地点或从其直接返回的途中以及参加本次临时性活动任务期间的意外事故。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;mso-list:l2 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">8．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">被保险人须在知道或应当知道保险事故发生后的</font>48 小时内向保险人报案。因延迟报案致使保险事故的性质、原因、损失程度等难以确定的，保险人对无法确定的部分，不承担赔偿责任。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 11pt;"><o:p></o:p></span></b></p><p class="p" style="margin-right:0.0000pt;mso-para-margin-right:0.0000gd;mso-para-margin-left:2.0000gd;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 11pt;">&nbsp;</span></b></p><p class="MsoNormal" align="center" style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">第三部分</span></b><b><span style="font-family: 宋体; font-size: 14pt;">&nbsp;</span></b><b><span style="font-family: 宋体; font-size: 14pt;">责任免除的解释说明</span></b><b><span style="font-family: 宋体; font-size: 14pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">1．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">猝死：</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">指平素身体健康或貌似健康的人突发症状，且在此症状出现后</font>6小时内发生的身故</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">2．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">中暑：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;">是在暑热季节、高温和（或）高湿环境下，发生以体温调节功能障碍、汗腺功能障碍和水电解质丢失过多为特征的疾病。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">3．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">高原反应</font>:</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;">指人到达一定海拔高度后，身体为适应因海拔高度而造成的气压差、含氧量少、空气干燥等的变化，而产生的自然生理反应。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">潜水：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指以辅助呼吸器材在江、河、湖、水库、运河等水域进行的水下运动。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">攀岩：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指攀登悬崖、楼宇外墙、人造悬崖、冰崖、冰山等运动。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">武术比赛：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指两人或两人以上对抗柔道、空手道、跆拳道、散打、拳击等各种拳术及各种使用器械的对抗性比赛。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">7．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">特技表演：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指从事马术、杂技、驯兽等特殊技能。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">8．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">探险：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指明知在某种特定的自然条件下有失去生命或使身体受到伤害的危险，而故意使自己置身其中的行为。如江河漂流、徒步穿越沙漠或人迹罕至的原始森林等活动。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">9．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">刑事强制措施：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;">是指公安机关、人民检察院和人民法院为了保证刑事诉讼的顺利进行，依法对刑事案件的犯罪嫌疑人、被告人的人身自由进行限制或者剥夺的各种强制性方法。强制措施的种类包括拘传、取保候审、监视居住、拘留和逮捕。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">10．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">醉酒：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">指事故发生时被保险人血液中的酒精含量大于或者等于</font>80mg/100ml。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">11．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">毒品：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:0.0000pt;">指中华人民共和国刑法规定的鸦片、海洛因、甲基苯丙胺（冰毒）、吗啡、大麻、可卡因以及国家规定管制的其他能够使人形成瘾癖的麻醉药品和精神药品，但不包括由医生开具并遵医嘱使用的用于治疗疾病但含有毒品成分的处方药品。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">12．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">管制药物：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指根据《中华人民共和国药品管理法》及有关法规被列为特殊管理的药品，包括麻醉药品、精神药品、毒性药品及放射性药品。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">13．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">饮酒：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">指事故发生时被保险人血液中的酒精含量大于或者等于</font>20mg/100ml。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">14．</span><!--[endif]--><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">无有效驾驶证：被保险人存在下列情形之一者：</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>1）无驾驶证或驾驶证有效期已届满；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>2）驾驶的机动车与驾驶证载明的准驾车型不符；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>3）实习期内驾驶公共汽车、营运客车或者载有爆炸物品、易燃易爆化学物品、剧毒或者放射性等危险物品的机动车，实习期内驾驶的机动车牵引挂车；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>4）持未按规定审验的驾驶证，以及在暂扣、扣留、吊销、注销驾驶证期间驾驶机动车；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>5）使用各种专用机械车、特种车的人员无国家有关部门核发的有效操作证，驾驶营业性客车的驾驶人无国家有关部门核发的有效资格证书；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="text-indent:21.0000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>6）依照法律法规或公安机关交通管理部门有关规定不允许驾驶机动车的其他情况下驾车。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">15．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">无有效行驶证：</span></b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">指下列情形之一：</span><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>1）机动车被依法注销登记的；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>2）无公安机关交通管理部门核发的行驶证、号牌，或临时号牌或临时移动证的机动交通工具；</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="19" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>3）未在规定检验期限内进行机动车安全技术检验或检验未通过的机动交通工具。未依法按时进行或通过机动车安全技术检验。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">16．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">椎间盘突出症</font><font face="宋体">：</font></span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指椎间盘各组成部分（髓核、纤维环、软骨板），尤其是髓核，发生不同程度的退行性病变后，在外界因素的作用下，椎间盘的纤维环破裂，髓核组织从破裂之处突出（或脱出）于后（侧）方或椎管内，从而导致相邻的组织，如脊神经根和脊髓等受到刺激或压迫，产生颈、肩、腰腿痛，麻木等一系列临床症状的疾病。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">17．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 10.5pt;">既往症：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指在本保险合同生效之前被保险人已患有的且已知晓的有关疾病或症状。</span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">18．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">辅助器具费</font><font face="宋体">：</font></span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">指购买、安装或修理假肢、矫形器、假眼、假牙和配置轮椅等辅助器具的费用。</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p>'+starP);
        </c:if>
        $('#closeUMsg').text('已阅读、理解并完全接受');
        $('.contacts-bottom-oth span.sureoth').removeClass('sureoth_color');
        dingshi1(10);
    }
    function goBack(){
        history.go(-1);
    }
    function dingshi(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读并同意('+isDo+')');
                dingshi(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读并同意');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            $('#closeUMsg').attr('onclick','closeUMsg1();');
            <%--<c:if test="${fn:contains(pd.product_code,'TYX-HT')}">
            $('#closeUMsg').attr('onclick','closeUMsg1();');
            </c:if>
            <c:if test="${!fn:contains(pd.product_code,'TYX-HT')}">
            $('#closeUMsg').attr('onclick','closeUMsg();');
            </c:if>--%>
        }
    }
    function dingshi1(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读、理解并完全接受('+isDo+')');
                dingshi1(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读、理解并完全接受');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            $('#closeUMsg').attr('onclick','closeUMsg();');
        }
    }
    $(function () {
        if('${empty dto.oid ? '0' : '1'}' == '0'){
            var khgzs = '<div class="contacts_modal_oth" style="width: 820px;top: 120px;"><h2 class="contacts-title">确认进入投保流程</h2><div id="_bContent" style="margin: 20px;height: 450px;overflow: auto;"><p style="margin-top: 0;margin-bottom: 10px;">尊敬的客户:</p><p style="margin-top: 0;margin-bottom: 10px;">&nbsp;&nbsp;&nbsp;您即将进入投保流程，请仔细阅读保险条款。本保险产品由【${pd.insurance_name}】承保，由上海亚太保险经纪有限公司提供销售和协助理赔等保险服务。</p><p style="margin-top: 0;margin-bottom: 10px;">投保前请您阅读名户告知书</p><p style="margin-top: 0;margin-bottom: 10px;">点击“已阅读并同意”，您在销售页面的操作将被依法记录和候存。</p><div style="width: 780px;height: 220px;overflow-y: scroll;" id="khgzs"><img style="width: 775px" src="/resources/images/客户告知书-亚太保险经纪（盖章件）.png"> </div></div><div class="contacts-bottom-oth"><span id="closeUMsg" class="sureoth">已阅读并同意(10)</span>&nbsp;<span onclick="history.go(-1)">返回</span></div></div><div class="black-mask-oth"></div>';
            $('body').append(khgzs);
            $('.contacts_modal_oth').show();
            $('.black-mask-oth').show();
            dingshi(10);
        }
        if('${userdetail.web_type}' == 'BLB'){
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
                var str = "";
                if (json.length > 0){
                    for (var i = 0; i < json.length; i++) {
                        str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                    }
                }
                if(str != ""){
                    var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                    $('body').append(lxr_html);
                    $("#userList").html(str);
                    addCylxr();
                }
            });
            function addCylxr(){
                //点击联系人
                $('.contacts_modal ul li').click(function () {
                    $('.contacts_modal ul li').removeClass('active');
                    $(this).addClass('active');
                    if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                        $('.contacts-bottom span.sure').addClass('sure_color');
                    }
                });
                //点击取消
                $('.contacts-bottom .cancel').click(function () {
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                });
                $('.contacts_modal .title-cancel').click(function () {
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                });
                //点击填入
                $('.contacts-bottom .sure').click(function () {
                    if($(this).hasClass('sure_color')){
                        setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                        $('.contacts_modal').hide();
                        $('.black-mask').hide();
                        $('.contacts_modal ul li').removeClass('active');
                    }else{
                        //没有点击选择联系人
                        // alert('请选择一个联系人！');
                    }
                })
                var _html = '投保单位信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals()">选择常用投保人</a>';
                $("#cy_lxr").html(_html);
            }
            function setTBR(_json){
                var json = eval("(" + _json + ")");
                $("#role_namecn_0").val(json.company_name);//企业名称
                $("#role_idType_0").val(json.certificate_type);//证件类型
                if(json.certificate_code != ''){
                    var cccode = json.certificate_code;
                    if(json.certificate_type == '1'){
                        cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                    }
                    $("#role_organizationCode_0").val(cccode);//证件号码
                }
                $("#role_regAddress_0").val(json.address);//详细地址
                $("#regProvince").val(json.province);//省
                $("#regProvince").change();
                setTimeout(function(){
                    $("#regCity").val(json.city);//市
                    $("#regCity").change();
                    setTimeout(function(){
                        $("#regDistrict").val(json.district);//区
                    },1000);
                },1000);
                $("#role_comNature_0").val(json.enterprise_type_one);//营业性质
                $("#role_comNature_0").change();
                $("#role_natureTwo_0").val(json.enterprise_type_two);//
                $("#role_linkName_0").val(json.user_name);//联系人
                $("#role_linkTel_0").val(json.telephone);//手机
                $("#role_linkEmail_0").val(json.email);//邮箱
            }

            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
                if(json != undefined && json != null){
                    if('${dto.oid}' == ''){
                        $('#need_insur_bill').on('click',function(){//纸质保单
                            if($(this).is(":checked")){
                                $("#receiverName").val(json.user_name);
                                $("#receiverMobile").val(json.telephone);
                                $("#receiverAddressDetail").val(json.address);
                            }
                        });
                        $('#need_receipt').on('click',function(){//纸质发票
                            if($(this).is(":checked")){
                                $("#takerName").val(json.user_name);
                                $("#takerMobile").val(json.telephone);
                                $("#takerAddressDetail").val(json.address);
                                <%--if('${pd.product_code}'.indexOf('TYX-RB')>-1){--%>
                                    <%--$("input[name='mailPolicyVo.need_receipt']").val('1');--%>
                                <%--}--%>
                            }else{
                                <%--if('${pd.product_code}'.indexOf('TYX-RB')>-1){--%>
                                    <%--$("input[name='mailPolicyVo.need_receipt']").val('0');--%>
                                <%--}--%>
                            }
                        });
                        $('#is_send_einvoice').on('click',function(){//电子发票
                            if($(this).is(":checked")){
                                $("#takerName").val(json.user_name);
                                $("#takerMobile").val(json.telephone);
                                $("#takerAddressDetail").val(json.address);
                            }
                        });
                    }else{
                        if('${vo.mailPolicyVo.need_insur_bill}'!='1'){
                            $('#need_insur_bill').on('click',function(){//纸质保单
                                if($(this).is(":checked")){
                                    $("#receiverName").val(json.user_name);
                                    $("#receiverMobile").val(json.telephone);
                                    $("#receiverAddressDetail").val(json.address);
                                }
                            });
                        }
                        if('${vo.mailPolicyVo.need_receipt}'!='1'){
                            $('#need_receipt').on('click',function(){//纸质发票
                                if($(this).is(":checked")){
                                    $("#takerName").val(json.user_name);
                                    $("#takerMobile").val(json.telephone);
                                    $("#takerAddressDetail").val(json.address);
                                    <%--if('${pd.product_code}'.indexOf('TYX-RB')>-1){--%>
                                        <%--$("input[name='mailPolicyVo.need_receipt']").val('1');--%>
                                    <%--}--%>
                                }else{
                                    <%--if('${pd.product_code}'.indexOf('TYX-RB')>-1){--%>
                                        <%--$("input[name='mailPolicyVo.need_receipt']").val('0');--%>
                                    <%--}--%>
                                }
                            });
                        }
                        $('#is_send_einvoice').on('click',function(){//电子发票
                            if($(this).is(":checked")){
                                $("#takerName").val(json.user_name);
                                $("#takerMobile").val(json.telephone);
                                $("#takerAddressDetail").val(json.address);
                            }
                        });
                    }
                }

            });
        }
        document.onmousedown = function(ev){
            ev = ev || window.event;
            var nr = '已阅读并同意 roleSubjectList[0].reg_address appOrganizingPath_file roleSubjectList[1].reg_address appOrganizingPath1_file 【批量上传】 inception_date check_007_for roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
            var x=ev.clientX;
            var y=ev.clientY;
            if((ev.target.childNodes.length > 0 && ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || (ev.target.name != '' && nr.indexOf(ev.target.name)!=-1) || (ev.target.id != '' && ev.target.id!=undefined && nr.indexOf(ev.target.id)!=-1 )){
                if(ev.target.name=='inception_date'){
                    //到这里需要整个页面都截图一次
                    <%--insOperation('${dto.oid}','${sigId}','投保信息提交');--%>
                }
                insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
                <%--fun(ev.target.name);--%>
                <%--insOperation2('${dto.oid}','${sigId}','投保信息提交',x,y);--%>
            }
        }
    })
    //点击可选保障
    $('.optional_guarantee span').click(function () {
        $('#is_contain_repo').val($(this).attr('data-val'));
        $('.optional_guarantee span').removeClass('active');
        $(this).addClass('active');
        var doNum = Number($('#role_num').val());
        premiumServer(doNum);
    })
    //点击弹窗出现
    function showContractsModals() {
        $('.contacts_modal').show();
        $('.black-mask').show();
    }

</script>

<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    var count = 2;
    $(function(){
        changeFrameSet(0,'');
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else if($("#is_send_einvoice").is(':checked')){
            $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
            $("#mod_2").fadeIn(1000);
            $("#mod_2_1").fadeOut(1000);
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }
    });
    var countdown=5;
    function submitMsg(num){
        if(!customsVerify()){
            return;
        }
        var _htm = '<div>针对本产品从事武装押运保安人员（如：金融守押员，保镖）的保障方案为：</div><br/>';
        var _num = Number(num);
        if(_num == 1){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>7万</span></div><br/>' +
                '<div><span>意外医疗</span><span>7000</span></div><br/>';
        }else if(_num == 2){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>15万</span></div><br/>' +
                '<div><span>意外医疗</span><span>1.5万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>50元/天</span></div>';
        }else if(_num == 3){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>20万</span></div><br/>' +
                '<div><span>意外医疗</span><span>2万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>50元/天</span></div>';
        }else if(_num == 4){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>30万</span></div><br/>' +
                '<div><span>意外医疗</span><span>3万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>50元/天</span></div>';
        }else if(_num == 5){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>35万</span></div><br/>' +
                '<div><span>意外医疗</span><span>3.5万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>100元/天</span></div>';
        }else if(_num == 6){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>40万</span></div><br/>' +
                '<div><span>意外医疗</span><span>4万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>150元/天</span></div>';
        }
        if(win_sign == 0) {//本站内嵌
            parent.layer.confirm(_htm, {
                btn: ['已知悉（5）','再看看'], //按钮
                title:'特别提示'
            }, function(){
                parent.layer.closeAll();
                save_policy_gmr();
            }, function(){

            });
            parent.$('.layui-layer-btn0').attr('style','border-color: #dedede;background-color: #f1f1f1;color: #333;');
            parent.$('.layui-layer-btn').css("position",'relative');
            parent.$('.layui-layer-btn0').before("<div id='layui-layer-btn0' style='width: 110.22px;height: 32px;position: absolute;left: 148px;z-index: 9;opacity: 0;'></div>");
            sendemail_p();
        }else{
            layer.confirm(_htm, {
                btn: ['已知悉（5）','再看看'], //按钮
                title:'特别提示'
            }, function(){
                save_policy_gmr();
            }, function(){

            });
            $('.layui-layer-btn0').attr('style','border-color: #dedede;background-color: #f1f1f1;color: #333;');
            $('.layui-layer-btn').css("position",'relative');
            $('.layui-layer-btn0').before("<div id='layui-layer-btn0' style='width: 110.22px;height: 32px;position: absolute;left: 148px;z-index: 9;opacity: 0;'></div>");
            sendemail_c();
        }

    }

    function sendemail_p() {
        if (countdown == 0) {
            parent.$('#layui-layer-btn0').remove();
            parent.$('.layui-layer-btn0').attr('style','border-color: #4898d5;background-color: #2e8ded;color: #fff;');
            countdown = 5;
            return;
        } else {
            countdown--;
            if(countdown == 0){
                parent.$('.layui-layer-btn0').html('已知悉');
            }else{
                parent.$('.layui-layer-btn0').html('已知悉（'+countdown+'）');
            }
        }
        setTimeout(function() {
                sendemail_p()
            }
            ,1000)
    };
    function sendemail_c() {
        if (countdown == 0) {
            $('#layui-layer-btn0').remove();
            $('.layui-layer-btn0').attr('style','border-color: #4898d5;background-color: #2e8ded;color: #fff;');
            countdown = 5;
            return;
        } else {
            countdown--;
            if(countdown == 0){
                $('.layui-layer-btn0').html('已知悉');
            }else{
                $('.layui-layer-btn0').html('已知悉（'+countdown+'）');
            }
        }
        setTimeout(function() {
                sendemail_c()
            }
            ,1000)
    };
    var win_sign = 0;//0本站内嵌，1它站内嵌
    <c:if test="${fn:contains(userdetail.web_type, 'ARS')||fn:contains(userdetail.web_type, 'SAAS')||fn:contains(userdetail.web_type, 'PASP')}">
    win_sign = 1;
    </c:if>
    function save_policy_gmr(){
        //index是遮罩层，layer.load弹出层
        var index = laySomenType(0,null,'',0);
        if(!mailVerify()){//判断投保人与发票信息一致
            //关闭遮罩
            laySomenType(2,index,'',0);
            return ;
        }
        //如果校验没问题
        if(customsVerify()){
            $.ajax({
                type: 'POST',
                //ajax动态调用pendingGMRPolicyVoPolicy方法，都会保存订单
                url:baseUrl + '/insurance/tyx/policy/pendingGMRPolicyVoPolicy',
                //表单所有信息
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    //保存订单信息成功状态码
                    if(json.statusCode == '200') {
                        insOperation(json.navTabId,'${dto.trade_serial_number}','投保信息提交');
                        //关闭遮罩
                        laySomenType(2,index,'',0);
                        window.location.href = baseUrl + '/insurance/tyx/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                        /*var _t = setInterval(function () {
                            if(_tong==1){
                                clearInterval(_t);
                                //关闭遮罩
                                laySomenType(2,index,'',0);
                                window.location.href = baseUrl + '/insurance/tyx/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                            }
                        },300);*/
                    }else{
                        if(json.message.indexOf('部分证件号已在保，无法重复投保：')!=-1){
                            laySomenType(1,null,"部分证件号已在保，无法重复投保!",0);
                            var reg = new RegExp(',','g');
                            var blob = new Blob(['(注：以下证件号已在保，请检查并剔除后重新提交。)\n'+json.message.split('：')[1].replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                            saveAs(blob, "人员重复投保清单.txt");
                        }else{
                            laySomenType(1,null,json.message,0);
                        }
                        //关闭遮罩
                        laySomenType(2,index,'',0);
                    }
                },
                //返回错误
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //返回错误信息在遮罩层上
                    laySomenType(1,null,textStatus,0);
                }
            });
        }else{
            //关闭遮罩
            laySomenType(2,index,'',0);
        }
    }

    function mailVerify(){
        var taxpayerNumberInvoice = $('#taxpayerNumberInvoice').val();
        if(taxpayerNumberInvoice == ''){
            taxpayerNumberInvoice = $('#taxpayerNumberInvoice_1').val();
        }
        if(taxpayerNumberInvoice == ''){
            laySomenType(1,null,"请完善发票信息！",0);
            return false;
        }
        <c:if test="${fn:contains(pd.product_code,'TYX-CA')}">
        var role_namecn_0 = $('#role_namecn_0').val();
        var role_organizationCode_0 = $('#role_organizationCode_0').val();
        var receipt_head = $('#receipt_head').val();
        if(receipt_head != ''){
            if(receipt_head!=role_namecn_0||taxpayerNumberInvoice!=role_organizationCode_0){
                laySomenType(1,null,"发票信息必须与投保人信息一致！",0);
                return false;
            }
        }
        </c:if>
        return true;
    }

    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required"){
                    if(this.id.indexOf( 'check_00' ) > -1 &&!$(this).is(':checked')){
                        document.getElementById(this.id+'_for').scrollIntoView();
                        laySomenType(1,null,"有确认项未完成确认！",0);
                        $(this).focus();
                        flag = false;
                        return true;
                    }
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        laySomenType(1,null,"必填项不能为空！",0);
                        $(this).focus();
                        flag = false;
                        return true;
                    }else{
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"长度超出限制！",0);
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id == 'role_doBusinessAddress_0'||_id == 'role_regAddress_0'){
                                if(_val.length<8||_val.length>60){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"内容长度不能少于8位！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }
                            if(_id.indexOf('role_birthDate')!=-1){
                                var _idVal = $(this).attr("GIST-ID");
                                var _gistVal = $("#"+_idVal).val();
                                if(_gistVal == ""){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"证件号码不能为空！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }else{
                                    var _idTy = $("#"+_idVal).attr("GIST-ID");
                                    var _gistTy = $("#"+_idTy).val();
                                    if(_gistTy == "0"){
                                        if(_val != getBirthdayFromIDNo(_gistVal)){
                                            document.getElementById(this.id).scrollIntoView();
                                            laySomenType(1,null,"该日期与身份证不匹配！",0);
                                            $(this).val('');
                                            $(this).focus();
                                            flag = false;
                                            return true;
                                        }
                                    }
                                    var age_b = Number(getbirthDayByAge(_val));
                                    if(age_b<16||age_b>65){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"被保险人年龄(16-65周岁)超出限制！",0);
                                        $(this).val('');
                                        $(this).focus();
                                        flag = false;
                                        return true;
                                    }
                                }
                            }
                        }
                    }

                }
            }
            if(dataVal == "FILE Required"){//FILE Required
                if($(this).val() == ''){
                    document.getElementById(this.id+'_file-5').scrollIntoView();
                    laySomenType(1,null,"上传文件不能为空！",0);
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
        });
        if(flag){
            $("input[Data-Val]").each(function() {
                var dataVal = $(this).attr("Data-Val");
                if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                    if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                        $(this).blur();
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"请正确填写相关信息！",0);
                            flag = false;
                            return true;
                        }else{
                            if(this.id == 'inceptionDate'){
                                if(Gdate.getDaysDiff($(this).val(), Gdate.curtime())<=0){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"起保日期必须大于今天！",0);
                                    flag = false;
                                    return true;
                                }
                            }
                        }
                    }
                }
            });
        }
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"必填项不能为空！",0);
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id.indexOf('role_sex')!=-1){
                                var _idVal = $(this).attr("GIST-ID");
                                var _gistVal = $("#"+_idVal).val();
                                if(_gistVal == ""){
                                    document.getElementById(_id).scrollIntoView();
                                    laySomenType(1,null,"请先完善证件号码！",0);
                                    $(this).val('');
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }else{
                                    var _idTy = $("#"+_idVal).attr("GIST-ID");
                                    var _gistTy = $("#"+_idTy).val();
                                    if(_gistTy == "0"){
                                        var _sex = "M";
                                        if($(this).val() == "2"){
                                            _sex = "F";
                                        }
                                        if( _sex != getSexFromIDNo(_gistVal)){
                                            document.getElementById(_id).scrollIntoView();
                                            laySomenType(1,null,"该性别与身份证不匹配！",0);
                                            $(this).val('');
                                            $(this).focus();
                                            flag = false;
                                            return true;
                                        }
                                    }
                                }
                            }
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                laySomenType(1,null,"必填项不能为空！",0);
                                $(this).focus();
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"长度超出限制(100字符)！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        mailSet();
        return flag;
    }
    function createSH(_val,_id){
        if(_val == '7'){
            $("#"+_id).show();
        }else{
            $("#"+_id).hide();
        }
    }
    /*function doDIVMOD(obj, sign, status, vals){
        var num = Number($(".mSign tr").last().attr("class").split("_")[2]);
        var vls = Number(vals);
        var g = 0;
        $("tr").each(function(){
            var _cla = $(this).attr("class");
            if(_cla != undefined){
                if(_cla.indexOf("role_num_")!= -1){
                    g++;
                }
            }
        });
        if("add" == status){
            var ns = num+1;
            var nodes = $("."+sign+"_num_"+num).clone(true);
            nodes.attr("class",nodes.attr("class").replace("_"+num, "_"+ns));
            nodes.find("td").each(function(){
                var _class = $(this).attr("class");
                if(_class.indexOf("signIndex") !=-1){
                    $(this).html(Number($(this).html())+1);
                }
                _class = _class.replace("has-success", "");
                _class = _class.replace("has-loser", "");
                $(this).attr("class",_class);
            });
            nodes.find("input").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                var _gistID = $(this).attr("GIST-ID");
                if(_gistID != undefined && _gistID != ''){
                    $(this).attr("GIST-ID",_gistID.replace("_"+num, "_"+ns));
                }
                if(_id.indexOf("role_kind") == -1 && _id.indexOf("role_majorGroup") == -1){
                    $(this).val('');
                }
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
                var _onclick = $(this).attr("onclick");
                if(_onclick != ''&&_onclick != undefined){
                    $(this).attr("onclick",_onclick.replace("_"+num, "_"+ns));
                }
            });
            nodes.find("select").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                $(this).val('');
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
            });
            nodes.find("a").each(function(){
                $(this).attr("onclick","deleteThisRow('role_num_"+ns+"','"+vls+"','add-a-line')");
            });
            $("."+sign+"_num_"+num).after(nodes);
            if((g+1) == vls){
                $(obj).fadeOut(1000);
            }else if(g>1){
                $(obj).next().fadeIn(1000);
            }
            var doNum = Number($("#"+sign+"_num").val())+1;
            $("#"+sign+"_num").val(doNum);
            $("#mPremium").html((doNum * parseFloat('${pd.premium_min}') / 3)+".00元");
        }
     changeFrameSet(0,'');//加载当前内容高度并重置iframe
    }*/

    //职业可选的时候的方法
    function doDIVMOD(obj, sign, status, vals){

        var num = Number($(".mSign tr").last().attr("class").split("_")[2]);
        var vls = Number(vals);
        var g = 0;
        $("tr").each(function(){
            var _cla = $(this).attr("class");
            if(_cla != undefined){
                if(_cla.indexOf("role_num_")!= -1){
                    g++;
                }
            }
        });
        if("add" == status){
            var ns = num+1;
            var nodes = $("."+sign+"_num_"+num).clone(true);
            nodes.attr("class",nodes.attr("class").replace("_"+num, "_"+ns));
            nodes.find("td").each(function(){
                var _class = $(this).attr("class");
                if(_class.indexOf("signIndex") !=-1){
                    $(this).html(Number($(this).html())+1);
                }
                _class = _class.replace("has-success", "");
                _class = _class.replace("has-loser", "");
                $(this).attr("class",_class);
            });
            nodes.find("input").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                var _gistID = $(this).attr("GIST-ID");
                if(_gistID != undefined && _gistID != ''){
                    $(this).attr("GIST-ID",_gistID.replace("_"+num, "_"+ns));
                }
                if(_id.indexOf("role_kind") == -1 && _id.indexOf("role_majorGroup") == -1){
                    $(this).val('');
                }
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
                var _onclick = $(this).attr("onclick");
                if(_onclick != ''&&_onclick != undefined){
                    $(this).attr("onclick",_onclick.replace("_"+num, "_"+ns));
                }
            });
            nodes.find("select").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                $(this).find('option').first().prop("selected", 'selected');
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
                var _gistID = $(this).attr("GIST-ID");
                if(_gistID != undefined && _gistID != ''){
                    $(this).attr("GIST-ID",_gistID.replace("_"+num, "_"+ns));
                }
            });
            nodes.find("a").each(function(){
                $(this).attr("onclick","deleteThisRow('role_num_"+ns+"','"+vls+"','add-a-line')");
            });
            $("."+sign+"_num_"+num).after(nodes);
            if((g+1) == vls){
                $(obj).fadeOut(1000);
            }else if(g>1){
                $(obj).next().fadeIn(1000);
            }
            var doNum = Number($("#"+sign+"_num").val())+1;
            $("#"+sign+"_num").val(doNum);
            premiumServer(doNum);
        }
        changeFrameSet(0,'');//加载当前内容高度并重置iframe
    }
    function saveGMRInfo(){
        var index = laySomenType(0,null,'',0);
        mailSet();
        if(isAllNull() == 1){
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/tyx/policy/pendingGMRPolicyVoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,json.message,0);
                    if(json.statusCode == '200') {
                        insOperation(json.navTabId,'${dto.trade_serial_number}','投保信息提交');
                        window.location.href = baseUrl + '/insurance/tyx/policy/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        }else{
            laySomenType(2,index,'',0);
            laySomenType(1,null,"表单未检索到数据，请完善信息后暂存！",0);
        }
    }
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')&&!$("#is_send_einvoice").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    function isNeedDate(_this,starID,endID){
        if($(_this).val() == "1"){
            $("#"+starID).parent().show();
            $("#"+endID).parent().show();
            $("#"+starID).attr('data-status','');
            $("#"+endID).attr('data-status','');
        }else{
            $("#"+starID).parent().hide();
            $("#"+endID).parent().hide();
            $("#"+starID).attr("value"," ");
            $("#"+endID).attr("value"," ");
            $("#"+starID).attr('data-status','hidden');
            $("#"+endID).attr('data-status','hidden');
        }
    }
    function initID_Date(){
        var idOption = '${vo.roleSubjectList[0].id_option}';
        if(idOption == "1"){
            $("#role_idStarDate_0").parent().show();
            $("#role_idEndDate_0").parent().show();
        }
    }
    $(function(){
        initID_Date();
        $('[data-toggle="tooltip"]').tooltip();
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });
        $("input[id=need_receipt]").on("click",function(){
            $('#invoice_type_2').parent().parent().show();//显示增值税选项
            $("#is_send_einvoice").attr("checked",false);
            $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            if($(this).is(':checked')){
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                <%--if('${pd.product_code}'.indexOf('TYX-RB')>-1){--%>
                    <%--$("input[name='mailPolicyVo.need_receipt']").val('1');--%>
                <%--}--%>
                $("input[name='mailPolicyVo.need_receipt']").val('1');
            }else{
                <%--if('${pd.product_code}'.indexOf('TYX-RB')>-1){--%>
                    <%--$("input[name='mailPolicyVo.need_receipt']").val('0');--%>
                <%--}--%>
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
//                $("input[name='mailPolicyVo.invoice_type'][value='0']").attr("checked",true);
                $("input[name='mailPolicyVo.need_receipt']").val('');
            }
            setTimeout(function(){
                changeFrameSet(0,'');
                setTimeout(changeFrameSet(0,''),1050);
            },1050);//加载当前内容高度并重置iframe
        });
        $("input[id=is_send_einvoice]").on("click",function(){
            $("#need_receipt").attr("checked",false);//纸质发票不选中
            $("input[name='mailPolicyVo.need_receipt']").val('');
            if($(this).is(':checked')){
                $('#invoice_type_1').click();
                $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                mailSet();
                $("input[name='mailPolicyVo.is_send_einvoice']").val('1');
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $('#invoice_type_2').parent().parent().show();//显示增值税选项
                $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });
        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#taxpayerNumberInvoice_1").parent().hide();
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","hidden");
                $("#taxpayerNumberInvoice_1").val("");
            }else{
                $("#taxpayerNumberInvoice_1").parent().show();
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","");
                $("#taxpayerNumberInvoice").val("");
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });
        initCheck();
    });

    function initCheck(){
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required"){
                var _class = $(this).attr("class");
                if(_class.indexOf('laydate-icon')!=-1){
                    $(this).on("change",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_id.indexOf('role_birthDate')!=-1){
                            var _idVal = $(this).attr("GIST-ID");
                            var _gistVal = $("#"+_idVal).val();
                            if(_gistVal == ""){
                                laySomenType(1,null,"请先完善证件号码！",0);
                                loser_has_ins(this);
                                $(this).val('');
                            }else{
                                var _idTy = $("#"+_idVal).attr("GIST-ID");
                                var _gistTy = $("#"+_idTy).val();
                                if(_gistTy == "0"){
                                    if(_val != getBirthdayFromIDNo(_gistVal)){
                                        laySomenType(1,null,"该日期与身份证不匹配！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    }else{
                                        success_has_ins(this);
                                    }
                                }else{
                                    var age_b = Number(getbirthDayByAge(_idVal));
                                    if(age_b<16||age_b>65){
                                        laySomenType(1,null,"被保险人年龄(16-65周岁)超出限制！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    }else{
                                        success_has_ins(this);
                                    }
                                }
                            }
                        }
                    });
                }else{
                    $(this).on("blur",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_val == ''){
//                        被保险人信息的6个输入框匹配id字段
                            var patt1 = new RegExp("role_namecn_");
                            var patt3 = new RegExp("role_organizationCode_");
                            var patt6 = new RegExp("role_mobile_");
                            if(_id == 'role_namecn_0'){
                                laySomenType(1,null," 投保单位名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_0'){
                                laySomenType(1,null," 证件号码不能为空！",0);
                            } else if(_id == 'role_totalEmp_0'){
                                laySomenType(1,null," 企业总人数不能为空！",0);
                            } else if(_id == 'role_doBusinessAddress_0'){
                                laySomenType(1,null," 办公地址不能为空！",0);
                            } else if(_id == 'role_phone_0'){
                                laySomenType(1,null," 办公电话不能为空！",0);
                            } else if(_id == 'role_linkName_0'){
                                laySomenType(1,null," 联系人姓名不能为空！",0);
                            } else if(_id == 'role_linkTel_0'){
                                laySomenType(1,null," 联系人手机不能为空！",0);
                            } else if(_id == 'role_linkEmail_0'){
                                laySomenType(1,null," 联系人email不能为空！",0);
                            } else if(_id == 'role_zipCode_0'){
                                laySomenType(1,null," 邮政编码不能为空！",0);
                            } else if(_id == 'role_regAddress_0'){
                                laySomenType(1,null," 注册详细地址不能为空！",0);
                            } else if(_id == 'receiptHead'){
                                laySomenType(1,null," 单位名称不能为空！",0);
                            } else if(_id == 'takerName'){
                                laySomenType(1,null," 收票人姓名不能为空！",0);
                            } else if(_id == 'takerMobile'){
                                laySomenType(1,null," 收票人手机不能为空！",0);
                            } else if(_id == 'takerAddressDetail'){
                                laySomenType(1,null," 收票人地址不能为空！",0);
                            } else if(_id == 'receiverName'){
                                laySomenType(1,null," 收件人名称不能为空！",0);
                            } else if(_id == 'receiverMobile'){
                                laySomenType(1,null," 收件人手机不能为空！",0);
                            } else if(_id == 'receiverAddressDetail'){
                                laySomenType(1,null," 收件人地址不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice_1'){
                                laySomenType(1,null," 纳税人识别号不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice'){
                                laySomenType(1,null," 纳税人识别号不能为空！",0);
                            } else if(_id == 'registerAddressInvoice'){
                                laySomenType(1,null," 注册地址不能为空！",0);
                            } else if(_id == 'receiptPhone'){
                                laySomenType(1,null," 企业电话不能为空！",0);
                            } else if(_id == 'bankProvince'){
                                laySomenType(1,null," 开户银行省不能为空！",0);
                            } else if(_id == 'bankCity'){
                                laySomenType(1,null," 开户银行市不能为空！",0);
                            } else if(_id == 'bankInvoice'){
                                laySomenType(1,null," 开户银行不能为空！",0);
                            } else if(_id == 'bankAccountInvoice'){
                                laySomenType(1,null," 企业银行账号不能为空！",0);
                            } else if(patt1.test(_id)){
                                laySomenType(1,null," 被保险人姓名不能为空！",0);
                            } else if(patt3.test(_id)){
                                laySomenType(1,null," 被保险人证件号不能为空！",0);
                            } else if(patt6.test(_id)){
                                laySomenType(1,null," 被保险人手机不能为空！",0);
                            } else {
                                laySomenType(1,null," 该项为必填字段,不能为空！",0);
                            }
                            if(_id.indexOf('_0')!=-1||_id.indexOf('role_')<0){
                                loser_has(this);
                            }else{
                                loser_has_ins(this);
                            }
                            if(patt6.test(_id)||patt1.test(_id)||patt3.test(_id)){
                                $(this).attr('style','padding-right:12px;');
                            }
                        }else{
                            if(_val.length>32){
                                laySomenType(1,null,"超过最长限制长度！",0);
                                loser_has(this);
                                $(this).val('');
                            }else{
                                var doIt = 0;
                                if(_id.indexOf("role_namecn")!=-1){
                                    if(0<Number(_id.split("_")[2])){
                                        doIt = 1;
                                    }
                                }
                                if(_id == 'role_namecn_0'){
                                    var isCN = new RegExp("[\\u4E00-\\u9FFF]+","g");
                                    if(isCN.test(_val)){//中文
                                        if(_val.indexOf('(') > -1 || _val.indexOf(')') > -1){
                                            laySomenType(1,null,"中文企业名称中的括号必须使用中文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else{
                                        if(_val.indexOf('（') > -1 || _val.indexOf('）') > -1){
                                            laySomenType(1,null,"英文企业名称中的括号必须使用英文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }
                                }else if(_id == 'role_linkName_0'||doIt == 1){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(doIt == 0){
                                        if(!isName.test(_val)||_val.length>13){
                                            laySomenType(1,null,"请输入正确联系人姓名！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else{
                                        if(!isName.test(_val)||_val.length>10){
                                            laySomenType(1,null,"请输入正确姓名！",0);
                                            loser_has_ins(this);
                                            $(this).val('');
                                            return;
                                        }else if(_val.length!=_val.trim().length){
                                            laySomenType(1,null,"请输入正确姓名！",0);
                                            loser_has_ins(this);
                                            $(this).val('');
                                            return;
                                        }else{
                                            success_has_ins(this);
                                            return;
                                        }
                                    }

                                }else if(_id == 'receiptPhone'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_phone_0'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkTel_0'){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_doBusinessAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的办公详细地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_regAddress_0'||_id == 'role_doBusinessAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的注册地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_zipCode_0'){
                                    if(checkZipCode(_val) == false){
                                        laySomenType(1,null,"请输入正确的邮政编码！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id.indexOf('role_mobile')!=-1){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has_ins(this);
                                        return;
                                    }
                                }else if(_id == 'role_linkEmail_0'){
                                    if(checkEmail(_val) == false){
                                        laySomenType(1,null,"电子邮箱格式不正确，格式参考：blbservice@baichuanxin.com",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'taxpayerNumberInvoice_1'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                }else if(_id == 'taxpayerNumberInvoice'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                    /*var reg= /^[A-Za-z]+$/;
                                     if(_val.length == 15&&checkInt1(_val)){
                                     success_has(this);
                                     }else if(_val.length == 20&&(checkInt1(_val)||(checkInt1(_val.substring(0,_val.length-1))&&reg.test(_val.substring(_val.length-1,_val.length))))){
                                     success_has(this);
                                     }else{
                                     layer.msg("只能为15位数字，或20位数字，或19位数字与字母X组合！");
                                     loser_has(this);
                                     $(this).val('');
                                     }*/
                                }else if(_id.indexOf('role_organizationCode')!=-1){
                                    if(_id == 'role_organizationCode_0'){
                                        var _idVal = $(this).attr("GIST-ID");
                                        var _gistVal = $("#"+_idVal).val();
                                        if(_gistVal == '1'){//组织机构代码证校验
                                            if(checkOrganizingCode(_val) == 0){
                                                laySomenType(1,null,"只能包含数字或英文大写字母，必须用连字符“-”隔开！",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '2'){//三证合一信用代码证校验
                                            if(doValidCreditCode(_val) == 0){
                                                laySomenType(1,null,"由数字或大写英文字母组成，共18位",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '6'){//税务登记证校验
                                            var flass = false;
                                            var reg= /^[A-Za-z]+$/;
                                            if(_val.length == 15&&checkInt1(_val)){
                                                flass = true;
                                            }else if(_val.length == 20&&(checkInt1(_val)||(checkInt1(_val.substring(0,_val.length-1))&&reg.test(_val.substring(_val.length-1,_val.length))))){
                                                flass = true;
                                            }else{
                                                if(doValidCreditCode(_val) == 0){

                                                }else{
                                                    flass = true;
                                                }
                                            }
                                            if(flass){
                                                success_has(this);
                                            }else{
                                                laySomenType(1,null,"请输入正确的税务登记证或信用代码证代码！",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }
                                        }else if(_gistVal == '7'){//营业执照校验
                                            var reg= /^\d{15}$/;
                                            if(!reg.test(_val)){
                                                laySomenType(1,null,"只能为15位数字！",0);
                                                loser_has(this);
                                                $(this).val('');
                                            }else{
                                                success_has(this);
                                            }
                                        }else{
                                            laySomenType(1,null,"请先选择证件类型！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }
                                    }else{//被保险人证件号校验
                                        var nums = Number($("#role_num").val());
                                        var _doI = 0;
                                        for(var t=1;t<=nums;t++){
                                            var this_id = "role_organizationCode_"+t;
                                            if(_id != this_id){
                                                var _idCo = $("#"+this_id).val();
                                                if(_val == _idCo){
                                                    _doI = 1;
                                                }
                                            }
                                        }
                                        if(_doI == 1){
                                            laySomenType(1,null,"该证件号已在本清单中，请勿重复录入人员！",0);
                                            loser_has_ins(this);
                                            $(this).val('');
                                        }else{
                                            var _idVal = $(this).attr("GIST-ID");
                                            var _gistVal = $("#"+_idVal).val();
                                            if(_gistVal == '0'){//身份证校验
                                                var age_c = Number(getAgeByAge(_val));
                                                if(!validateIdent.IdentityCodeValid(_val)){
                                                    laySomenType(1,null,"请输入正确证件号！",0);
                                                    loser_has_ins(this);
                                                    $(this).val('');
                                                }else if(age_c<16||age_c>65){
                                                    laySomenType(1,null,"被保险人年龄(16-65周岁)超出限制！",0);
                                                    loser_has_ins(this);
                                                    $(this).val('');
                                                }else{
                                                    var _thr = _id.split("_")[_id.split("_").length-1];
                                                    $("#role_birthDate_"+_thr).val(getBirthdayFromIDNo(_val));
                                                    $("#role_sex_"+_thr).val(getSexFromIDNo(_val) == 'M'?'1':'2');
                                                    success_has_ins(this);
                                                }
                                            }else if(_gistVal == '3'){//护照校验
                                                if(!checkProtection(_val)){
                                                    laySomenType(1,null,"请输入正确护照号！",0);
                                                    loser_has_ins(this);
                                                    $(this).val('');
                                                }else{
                                                    success_has_ins(this);
                                                }
                                            }else if(_gistVal == '4'){//台胞证校验
                                                if(!checkCompatriotsCard(_val)){
                                                    laySomenType(1,null,"请输入正确台胞证号！",0);
                                                    loser_has_ins(this);
                                                    $(this).val('');
                                                }else{
                                                    success_has_ins(this);
                                                }
                                            }else if(_gistVal == '5'){//返乡证校验
                                                if(!checkHomeCard(_val)){
                                                    laySomenType(1,null,"请输入正确返乡证号！",0);
                                                    loser_has_ins(this);
                                                    $(this).val('');
                                                }else{
                                                    success_has_ins(this);
                                                }
                                            }else{
                                                laySomenType(1,null,"请先选择证件类型！",0);
                                                loser_has_ins(this);
                                                $(this).val('');
                                            }
                                        }
                                        $(this).attr('style','padding-right:12px;');
                                    }
                                }else{
                                    if(_id.indexOf('_0')!=-1||_id.indexOf('role_')<0){
                                        success_has(this);
                                    }else{
                                        success_has_ins(this);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if(dataVal == "Date Required"){
                $(this).on("change",function(){
                    if($(this).val() == ''){
                        laySomenType(1,null,"请选择起保日期！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
            if(dataVal == "Point"||dataVal == "Point Required"){
                $(this).on("keyup",function(){
                    var regm = /^[0-9]+.?[0-9]*$/;
                    if(isNaN($(this).val())){
                        laySomenType(1,null,"请输入正确的数字格式！",0);
                        $(this).val('');
                    }
                });
            }
            if(dataVal == "Num"||dataVal == "Num Required"){
                $(this).on("blur",function(){
                    var regm = /^[0-9]*[0-9][0-9]*$/;
                    if(!regm.test($(this).val())){
                        laySomenType(1,null,"请输入正确的数量格式！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
        });
        $("#role_idType_0").change(function(){
            if($(this).val() == 1) {
                $("#role_organizationCode_0").attr("data-original-title","只能包含数字或英文大写字母，必须用连字符“-”隔开!")
            } else if($(this).val() == 7) {
                $("#role_organizationCode_0").attr("data-original-title","只能为15位数字!")
            } else if($(this).val() == 6) {
                $("#role_organizationCode_0").attr("data-original-title","只能为15位数字，或20位数字，或19位数字与字母X组合!")
            } else if($(this).val() == 2) {
                $("#role_organizationCode_0").attr("data-original-title","由数字或大写英文字母组成，共18位!")
            }
        })
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required") {
                $(this).on("change", function () {
                    var _val = $(this).val();
                    var _id = this.id;
                    if (_val == '') {
                        var patt2 = new RegExp("role_idType_");
                        var patt4 = new RegExp("role_birthDate_");
                        var patt5 = new RegExp("role_sex_");
                        if(_id == 'role_comNature_0'){
                            laySomenType(1,null," 请选择营业性质！",0);
                        } else if(_id == 'role_idType_0'){
                            laySomenType(1,null," 请选择证件类型！",0);
                        }  else if(_id == 'inceptionDate'){
                            laySomenType(1,null," 起保日期不能为空！",0);
                        } else if(_id == 'regProvince' || _id == 'regCity' || _id == 'regDistrict'){
                            laySomenType(1,null," 注册地址不能为空！",0);
                        } else if(patt2.test(_id)){
                            laySomenType(1,null," 被保险人证件类型不能为空！",0);
                        } else if(patt4.test(_id)){
                            laySomenType(1,null," 被保险人出生日期不能为空！",0);
                        } else if(patt5.test(_id)){
                            laySomenType(1,null," 被保险人性别不能为空！",0);
                        } else {
                            if('${pd.product_code}'.indexOf('TYX-QH-DQ') > -1 || '${pd.product_code}'.indexOf('TYX-HT-DQ') > -1){
                                if(_id == 'special_name'){
                                    laySomenType(1,null,"活动名称不能为空！",0);
                                } else if(_id == 'special_star_time' || _id == 'special_end_time'){
                                    laySomenType(1,null,"活动时间不能为空！",0);
                                } else if(_id == 'special_ex_province' || _id == 'special_ex_city' || _id == 'special_ex_county' || _id == 'special_ex_address'){
                                    laySomenType(1,null,"活动举办地址不能为空！",0);
                                }else{
                                    laySomenType(1,null," 该项为必填项，不能为空！",0);
                                }
                            }else{
                                laySomenType(1,null," 该项为必填项，不能为空！",0);
                            }
                        }
                        if (_id.indexOf('_0') != -1) {
                            loser_has(this);
                        } else {
                            loser_has_ins(this);
                        }
                        $(this).val('');
                    } else {
                        success_has_ins(this);
                        if (_id.indexOf('role_sex') != -1) {
                            var _idVal = $(this).attr("GIST-ID");
                            var _gistVal = $("#" + _idVal).val();
                            if (_gistVal == "") {
                                laySomenType(1,null,"请先完善证件号码！",0);
                                loser_has_ins(this);
                                $(this).val('');
                            } else {

                                var _idTy = $("#"+_idVal).attr("GIST-ID");
                                var _gistTy = $("#"+_idTy).val();
                                if(_gistTy == "0"){
                                    var _sex = "M";
                                    if (_val == "2") {
                                        _sex = "F";
                                    }
                                    if (_sex != getSexFromIDNo(_gistVal)) {
                                        laySomenType(1,null,"该性别与身份证不匹配！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    } else {
                                        success_has_ins(this);
                                    }
                                }else{
                                    success_has_ins(this);
                                }
                            }
                        }
                    }
                });
            }
        });
    }
    function natureChange(_this,_id){
        var code = _this.value;
        if(code != ""){
            $.ajax({
                type: 'POST',
                url: baseUrl + '/insurance/tyx/policy/natureChange.json',
                data:{"nID":code},
                dataType:"json",
                async: false,
                success: function(json) {
                    $("#" + _id).empty();
                    var t = 0;
                    $("#" + _id).append("<option value=''>-请选择-</option>");
                    for (var prop in json) {
                        if (json.hasOwnProperty(prop)) {
                            t ++;
                            var appendStr = "<option value='" + prop + "' ";
                            appendStr = appendStr + ">" + json[prop] + "</option>"
                            $("#" + _id).append(appendStr);
                        }
                    }
                    if(t > 0){
                        $("#"+_id).parent().show();
                    }else{
                        $("#"+_id).parent().hide();
                    }

                }
            });
        }else{
            $("#"+_id).parent().hide();
        }
    }
    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankType(districtID, obj) {
        $("#" + districtID).empty();
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findBankType.json',
            data:{"area":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + districtID).append("<option value=''>请选择名称</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankAddr(addrID, areaID, obj) {
        $("#" + addrID).empty();
        var code = obj.options[obj.selectedIndex].text;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findBankAddr.json',
            data:{"area":$("#" + areaID).val(),"bankName":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + addrID).append("<option value=''>请选择地址</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + addrID).append(appendStr);
                }
            }
        });
    }
    function changeBankName(bankNameID, obj) {
        $("#" + bankNameID).val(obj.options[obj.selectedIndex].text);
    }
    function deleteThisRow(_class,_num,_cla){
        var cla = _class.split("_")[0]+"_"+_class.split("_")[1];
        var g = 0;
        $("tr").each(function(){
            var _cla = $(this).attr("class");
            if(_cla != undefined){
                if(_cla.indexOf(cla)!= -1){
                    g++;
                }
            }
        });
        if(g>3){//
            var _role = "role_oid_" + Number(_class.split("_")[2]);
            var _role_id = $("#"+ _role).val();
            if(_role_id == '' || _role_id == undefined || _role_id == 'null'){
                $("."+_class).remove();
                var doNum = Number($("#"+cla).val())-1;
                $("#"+cla).val(doNum);
                var count = $(".signIndex").length;
                var i = 0;
                $(".signIndex").each(function(){
                    i++;
                    $(this).html(i);
                });
                premiumServer(doNum);
            }else{
                var index = laySomenType(0,null,'',0);
                $.ajax({
                    type: 'POST',
                    url:baseUrl + '/insurance/tyx/policy/deleteRoleInPolicyByOid.json',
                    data:{
                        'role_id':_role_id
                    },
                    dataType:"json",
                    success: function(json){
                        laySomenType(1,null,json.message,0);
                        if(json.statusCode == '200') {
                            $("."+_class).remove();
                            var doNum = Number($("#"+cla).val())-1;
                            $("#"+cla).val(doNum);
                            var count = $(".signIndex").length;
                            var i = 0;
                            $(".signIndex").each(function(){
                                i++;
                                $(this).html(i);
                            });
                            premiumServer(doNum);
                        }
                        laySomenType(2,index,'',0);
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        laySomenType(2,index,'',0);
                        laySomenType(1,null,textStatus,0);
                    }
                });
            }
            if((g-1)<_num){
                $("."+_cla).fadeIn(1000);
            }

        }else{
            laySomenType(1,null,"被保险人必须大于三人，删除失败！",0);
        }
        changeFrameSet(0,'');//加载当前内容高度并重置iframe
    }

    function getPlusPremium(){
        var p1 = ${pd.product_code eq 'TYX-RB-3' ? 30 : pd.product_code eq 'TYX-RB-4' ? 40 : pd.product_code eq 'TYX-RB-5' ? 50 : pd.product_code eq 'TYX-RB-6' ? 60 : 0 };
        var p2 = ${pd.product_code eq 'TYX-RB-3' ? 260 : pd.product_code eq 'TYX-RB-4' ? 350 : pd.product_code eq 'TYX-RB-5' ? 430 : pd.product_code eq 'TYX-RB-6' ? 530 : 0 };
        var _t = $('#is_contain_repo').val();
        if("1" == _t){
            return p1;
        }else if("2" == _t){
            return p2;
        }else if("3" == _t){
            return p1+p2;
        }else{
            return 0;
        }
    }

    function premiumServer(_num){
        <c:if test="${!fn:contains(pd.product_code, 'TYX-QH-DQ')&&!fn:contains(pd.product_code, 'TYX-HT-DQ')}">
        var pre = (_num * (parseFloat('${pd.premium_min}')+getPlusPremium()));
        $("#mPremium").html(pre+"元");
        </c:if>
        <c:if test="${fn:contains(pd.product_code, 'TYX-HT-DQ')}">
        getPremium();
        </c:if>
    }

    <c:if test="${fn:contains(pd.product_code, 'TYX-QH-DQ')||fn:contains(pd.product_code, 'TYX-HT-DQ')}">
    Date.prototype.pattern=function(fmt) {
        var o = {
            "M+" : this.getMonth()+1, //月份
            "d+" : this.getDate(), //日
            "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
            "H+" : this.getHours(), //小时
            "m+" : this.getMinutes(), //分
            "s+" : this.getSeconds(), //秒
            "q+" : Math.floor((this.getMonth()+3)/3), //季度
            "S" : this.getMilliseconds() //毫秒
        };
        var week = {
            "0" : "/u65e5",
            "1" : "/u4e00",
            "2" : "/u4e8c",
            "3" : "/u4e09",
            "4" : "/u56db",
            "5" : "/u4e94",
            "6" : "/u516d"
        };
        if(/(y+)/.test(fmt)){
            fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
        }
        if(/(E+)/.test(fmt)){
            fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "/u661f/u671f" : "/u5468") : "")+week[this.getDay()+""]);
        }
        for(var k in o){
            if(new RegExp("("+ k +")").test(fmt)){
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
            }
        }
        return fmt;
    }
    var curDate = new Date();
    var date = new Date((curDate/1000+86400)*1000);
    var nextDate = date.pattern("yyyy-MM-dd");
    //日期范围限制
    var _star = {
        elem: '#inceptionDate',
        format: 'YYYY-MM-DD',
        min: nextDate, //设定最小日期为当前日期
        max: '2099-06-16', //最大日期
        choose: function(datas){
            _end.min = datas; //开始日选好后，重置结束日的最小日期
            var startDate = new Date(datas);
            startDate = +startDate + 1000*60*60*24*29;
            startDate = new Date(startDate);
            var nextDate1 = startDate.getFullYear()+"-"+(startDate.getMonth()+1)+"-"+startDate.getDate();
            _end.max = nextDate1;
        }
    };
    var _end = {
        elem: '#plannedEndDate',
        format: 'YYYY-MM-DD',
        min: nextDate,
        max: '2099-06-16',
        choose: function(datas){
            getPremium();
        }
    };
    laydate(_star);
    laydate(_end);
    function getPremium(){
        var itd = $('#inceptionDate').val();
        var ped = $('#plannedEndDate').val();
        var doNum = Number($('#role_num').val());
        if(itd != ''&&ped != ''){
            var sDay = DateDiff(itd,ped);
            var allPr = 0;
            var _code = '${pd.product_code}';
            if(_code=='TYX-QH-DQ-1'){
                if(sDay<2){
                    allPr = 8;
                }else if(sDay>1&&sDay<4){
                    allPr = 10;
                }else if(sDay>3&&sDay<8){
                    allPr = 13;
                }else if(sDay>7&&sDay<16){
                    allPr = 18;
                }else if(sDay>15&&sDay<31){
                    allPr = 25;
                }
            }else if(_code=='TYX-QH-DQ-2'){
                if(sDay<2){
                    allPr = 10;
                }else if(sDay>1&&sDay<4){
                    allPr = 12;
                }else if(sDay>3&&sDay<8){
                    allPr = 15;
                }else if(sDay>7&&sDay<16){
                    allPr = 20;
                }else if(sDay>15&&sDay<31){
                    allPr = 28;
                }
            }else if(_code=='TYX-QH-DQ-3'){
                if(sDay<2){
                    allPr = 12;
                }else if(sDay>1&&sDay<4){
                    allPr = 14;
                }else if(sDay>3&&sDay<8){
                    allPr = 17;
                }else if(sDay>7&&sDay<16){
                    allPr = 23;
                }else if(sDay>15&&sDay<31){
                    allPr = 30;
                }
            }else if(_code=='TYX-QH-DQ-4'){
                if(sDay<2){
                    allPr = 14;
                }else if(sDay>1&&sDay<4){
                    allPr = 16;
                }else if(sDay>3&&sDay<8){
                    allPr = 20;
                }else if(sDay>7&&sDay<16){
                    allPr = 28;
                }else if(sDay>15&&sDay<31){
                    allPr = 40;
                }
            }else if(_code=='TYX-QH-DQ-5'){
                if(sDay<2){
                    allPr = 15;
                }else if(sDay>1&&sDay<4){
                    allPr = 18;
                }else if(sDay>3&&sDay<8){
                    allPr = 23;
                }else if(sDay>7&&sDay<16){
                    allPr = 35;
                }else if(sDay>15&&sDay<31){
                    allPr = 50;
                }
            }else if(_code=='TYX-HT-DQ-1'){
                if(sDay<2){
                    allPr = 4;
                }else if(sDay>1&&sDay<4){
                    allPr = 9;
                }else if(sDay>3&&sDay<8){
                    allPr = 11;
                }else if(sDay>7&&sDay<16){
                    allPr = 15;
                }else if(sDay>15&&sDay<31){
                    allPr = 24;
                }
            }else if(_code=='TYX-HT-DQ-2'){
                if(sDay<2){
                    allPr = 6;
                }else if(sDay>1&&sDay<4){
                    allPr = 11;
                }else if(sDay>3&&sDay<8){
                    allPr = 13;
                }else if(sDay>7&&sDay<16){
                    allPr = 20;
                }else if(sDay>15&&sDay<31){
                    allPr = 28;
                }
            }else if(_code=='TYX-HT-DQ-3'){
                if(sDay<2){
                    allPr = 8;
                }else if(sDay>1&&sDay<4){
                    allPr = 12;
                }else if(sDay>3&&sDay<8){
                    allPr = 14;
                }else if(sDay>7&&sDay<16){
                    allPr = 23;
                }else if(sDay>15&&sDay<31){
                    allPr = 35;
                }
            }else if(_code=='TYX-HT-DQ-4'){
                if(sDay<2){
                    allPr = 9;
                }else if(sDay>1&&sDay<4){
                    allPr = 14;
                }else if(sDay>3&&sDay<8){
                    allPr = 16;
                }else if(sDay>7&&sDay<16){
                    allPr = 28;
                }else if(sDay>15&&sDay<31){
                    allPr = 45;
                }
            }else if(_code=='TYX-HT-DQ-5'){
                if(sDay<2){
                    allPr = 11;
                }else if(sDay>1&&sDay<4){
                    allPr = 16;
                }else if(sDay>3&&sDay<8){
                    allPr = 18;
                }else if(sDay>7&&sDay<16){
                    allPr = 35;
                }else if(sDay>15&&sDay<31){
                    allPr = 55;
                }
            }
            if(allPr == 0){
                $('#plannedEndDate').val('');
                laySomenType(1,null,"当前产品保障期限在1~30天区间！",0);
                return;
            }
            var pre = doNum*allPr.toFixed(2);
            $("#mPremium").html(pre+"元");
        }
    }
    //计算两个日期天数差的函数，通用
    function DateDiff(sDate1, sDate2) {  //sDate1和sDate2是yyyy-MM-dd格式
        var aDate, oDate1, oDate2, iDays;
        aDate = sDate1.split("-");
        oDate1 = new Date(aDate[1] + '-' + aDate[2] + '-' + aDate[0]);  //转换为yyyy-MM-dd格式
        aDate = sDate2.split("-");
        oDate2 = new Date(aDate[1] + '-' + aDate[2] + '-' + aDate[0]);
        iDays = parseInt(Math.abs(oDate1 - oDate2) / 1000 / 60 / 60 / 24); //把相差的毫秒数转换为天数
        return iDays+1;  //返回相差天数
    }

    var special_star_time = {
        elem: '#special_star_time',
        format: 'YYYY-MM-DD',
        // min: laydate.now(+1), //设定最小日期为当前日期
        // max: laydate.now(+90), //最大日期
        istime: true,
        istoday: false,
        choose: function(datas){
            console.log(datas);
            if(datas != ''){
                // $("#inceptionDate").val(datas.split(' ')[0]);
                // $("#special_end_time").val('');
                special_end_time.min = datas; //开始日选好后，重置结束日的最小日期
                var pday = 29;
                special_end_time.max = dateAddDays(datas,pday);
            }
        }
    };

    //日期加天数的方法
    //dataStr日期字符串
    //dayCount 要增加的天数
    //return 增加n天后的日期字符串
    function dateAddDays(dataStr,dayCount) {
        var strdate=dataStr; //日期字符串
        var isdate = new Date(strdate.replace(/-/g,"/"));  //把日期字符串转换成日期格式
        isdate = new Date((isdate/1000+(86400*dayCount))*1000);  //日期加1天
        var pdate = isdate.getFullYear()+"-"+(isdate.getMonth()+1)+"-"+(isdate.getDate());   //把日期格式转换成字符串

        return pdate;
    }

    var special_end_time = {
        elem: '#special_end_time',
        format: 'YYYY-MM-DD',
        min: '1900-01-01',
        max: '2099-06-16',
        istime: true,
        istoday: false,
        choose: function(datas){
            $("#plannedEndDate").val(datas.split(' ')[0]);
            _end.max = datas;
            getPremium();
            /*start.max = datas; //结束日选好后，充值开始日的最大日期
            bidtimeS.max = datas;*/
        }
    };

    laydate(special_star_time);
    laydate(special_end_time);
    </c:if>

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }

    function uploadInsure(){
        var formData = new FormData();
        var files = document.getElementById("role_emp").files[0];
        if(files == undefined){
            return;
        }
        if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
            layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
            return;
        }
        var index = laySomenType(0,null,'',0);
        formData.append('role_emp', files);
        $('#role_emp').val('');
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/tyx/policy/gzxUploadRoleFile?ACCESS_TOKEN=${ACCESS_TOKEN}',
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(json){
                laySomenType(1,null,json.message,0);
                if(json.statusCode == '200') {
                    var oid = '${dto.oid}';
                    if(oid != ''){//如果存在订单，先删除所有被保险人
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + '/insurance/tyx/policy/delectAllInsRole',
                            data:{
                                'order_id':oid
                            },
                            dataType:"json",
                            success: function(json){
                                if(json.statusCode == '200') {
                                    setUploadRole(index);
                                }else{
                                    laySomenType(1,null,json.message,0);
                                    laySomenType(2,index,'',0);
                                }
                            }
                        });
                    }else{
                        setUploadRole(index);
                    }
                }else{
                    var reg = new RegExp(';','g');
                    var blob = new Blob(['(注：以下异常信息行号对应Excel自带行号。)\n'+json.message.replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                    saveAs(blob, "excel人员数据异常清单.txt");
                    laySomenType(2,index,'',0);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                laySomenType(2,index,'',0);
                laySomenType(1,null,textStatus,0);
            }
        });

    }
    function setUploadRole(_index){//设置上传的人员到页面展示
        $.ajax({
            type: 'POST',
            url:baseUrl + "/insurance/tyx/policy/role_upload_list?ACCESS_TOKEN=${ACCESS_TOKEN}",
            data:{
                'productCode':'${pd.product_code}'
            },
            dataType:"text",
            success: function(data){
                $("#add-increased-table").html(data);
                premiumServer(Number($('#role_num').val()));
                initCheck();
                changeFrameSet(0,'');//加载当前内容高度并重置iframe
                laySomenType(2,_index,'',0);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                laySomenType(2,_index,'',0);
                laySomenType(1,null,textStatus,0);
            }
        });
    }
    function delectAllInsRole(){
        var oid = '${dto.oid}';
        if(oid != ''){
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/tyx/policy/delectAllInsRole',
                data:{
                    'order_id':oid
                },
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {

                    }
                }
            });
        }
    }
    $('#wed_wed').click(function () {
        resetFileInput($('#role_emp'));
        $('#role_emp').click();
    })
    function resetFileInput(file){
        file.after(file.clone().val(""));
        file.remove();
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>