<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-填写投保单</title>

	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>


<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<ol class="breadcrumb">
		<%--<li><a href="<c:url value='/'/>">首页</a></li>
		<li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
		<li><a href="<c:url value='/insurance/product/productInfo/${pd.oid}'/>">产品详情</a></li>
		<li class="active">投保</li>--%>
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/lawsuit/policy/confirm?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
		<input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>推荐人信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-4 col-xs-4">
					<p>推荐人的手机号或编号</p>
					<input type="text" name="recommend_code" id="recommendCode" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->

		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3 id="cy_lxr">投保人／被保险人基本信息</h3></div>
			<input type="hidden" name="roleSubjectList[0].oid" id="appRoleID" value="${vo.roleSubjectList[0].oid}"/>
			<input type="hidden" name="roleSubjectList[0].kind" id="kind" value="3"/>
			<input type="hidden" name="roleSubjectList[0].role_type" id="roleType" value="1"/>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3">
					<p>*投保人/被保险人</p>
					<input Data-Val="Required" title="投保人/被保险人" type="text" id="app_fullName" name="roleSubjectList[0].name_cn" value="${vo.roleSubjectList[0].name_cn}" class="form-control" placeholder="请填写企业名称" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*申请人／原告主体资格</p>
					<div class="row">
						<div class="col-sm-12 col-xs-12">
							<div class="row">

								<div class="col-sm-4 col-xs-4 rad-io">
									<span><input onclick="rightAsPrincipal_check(this,'{1:{app_idcard_path,app_address_path,app_spouse_card_path,app_trauschein_path};2:{app_business_path}}','app_idType')" type="radio" name="roleSubjectList[0].right_as_principal" value="1" id="app_rightAsPrincipal_radio1"<c:if test="${ empty vo.roleSubjectList[0].right_as_principal ? true : vo.roleSubjectList[0].right_as_principal eq '1' ? true : false }"> checked</c:if>><label for="app_rightAsPrincipal_radio1" class="pull-left"></label><strong class="pull-left" onclick="checkToradio('app_rightAsPrincipal_radio1','radio');">公民</strong></span>
								</div><!--  checked="checked" -->

								<div class="col-sm-4 col-xs-4 rad-io">
									<span><input onclick="rightAsPrincipal_check(this,'{1:{app_idcard_path,app_address_path,app_spouse_card_path,app_trauschein_path};2:{app_business_path}}','app_idType')" type="radio" name="roleSubjectList[0].right_as_principal" value="2" id="app_rightAsPrincipal_radio2"<c:if test="${ vo.roleSubjectList[0].right_as_principal eq '2'}"> checked</c:if>><label for="app_rightAsPrincipal_radio2" class="pull-left"></label><strong class="pull-left" onclick="checkToradio('app_rightAsPrincipal_radio2','radio');">法人</strong></span>
								</div><!--  -->

							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>证件类型</p>
					<select title="证件类型" class="form-control" disabled name="roleSubjectList[0].id_type" id="app_idType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="0"<c:if test="${vo.roleSubjectList[0].id_type eq '0' }"> selected</c:if>>身份证或护照</option>
						<option value="1"<c:if test="${vo.roleSubjectList[0].id_type eq '1' }"> selected</c:if>>组织机构代码或统一社会信用代码</option>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*证件号</p>
					<input Data-Val="Required" title="证件号" type="text" id="app_organizingCode" name="roleSubjectList[0].organization_code" value="${vo.roleSubjectList[0].organization_code}" class="form-control" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="col-sm-9 col-xs-9">
					<p>*联系地址</p>
					<div class="row">
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
								<option value="">请选择省</option>
								<c:forEach items="${provinceList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
								<option value="">请选择市</option>
								<c:forEach items="${reg_cityList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<option value="">请选择县</option>
								<c:forEach items="${reg_areaList }" var="list">
									<option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-6 col-xs-6">
							<input Data-Val="Required" title="联系地址" type="text" name="roleSubjectList[0].reg_address" id="app_address" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写详细地址" onblur="validateForms(this)" />
							<span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
						</div>
					</div>
				</div>
				<%--<div class="col-sm-6 col-xs-6">
					<p>*联系地址</p>
					<input Data-Val="Required" title="联系地址" type="text" id="app_address" name="roleSubjectList[0].address" value="${vo.roleSubjectList[0].address}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>--%>
				<div class="col-sm-3 col-xs-3">
					<p>*邮编</p>
					<input Data-Val="Required" title="邮编" type="text" id="app_zipcode" name="roleSubjectList[0].zip_code" value="${vo.roleSubjectList[0].zip_code}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系人</p>
					<input Data-Val="Required" title="联系人" type="text" id="app_linkman" name="roleSubjectList[0].link_name" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*联系电话</p>
					<input Data-Val="Required" title="联系电话" type="text" id="app_phone" name="roleSubjectList[0].phone" value="${vo.roleSubjectList[0].phone}" class="form-control" placeholder="注：区号-电话号码-转接号" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*邮箱</p>
					<input Data-Val="Required" title="邮箱" type="text" id="app_email" name="roleSubjectList[0].link_email" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-4 col-xs-4" id="app_business_path_isHidden" style="display: none;">
					<p>*营业执照<a href="#open" data-toggle="modal" data-dismiss="modal">（样例）</a></p>
					<input type="hidden" title="" name="roleSubjectList[0].app_business_path" id="app_business_path" data-status="hidden" value="${vo.roleSubjectList[0].app_business_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_business_path }" name="app_business_path_file" id="app_business_path_file-5" data-drawview="${vo.roleSubjectList[0].app_business_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4" id="app_idcard_path_isHidden">
					<p>*身份证或护照复印件</p>
					<input type="hidden" title="" name="roleSubjectList[0].app_idcard_path" id="app_idcard_path" value="${vo.roleSubjectList[0].app_idcard_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_idcard_path }" name="app_idcard_path_file" id="app_idcard_path_file-5" data-drawview="${vo.roleSubjectList[0].app_idcard_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4" id="app_address_path_isHidden">
					<p>常住地证明文件复印件</p>
					<input type="hidden" title="" name="roleSubjectList[0].app_address_path" id="app_address_path" value="${vo.roleSubjectList[0].app_address_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_address_path }" name="app_address_path_file" id="app_address_path_file-5" data-drawview="${vo.roleSubjectList[0].app_address_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4" id="app_spouse_card_path_isHidden">
					<p>配偶身份证复印件</p>
					<input type="hidden" title="" name="roleSubjectList[0].app_spouse_card_path" id="app_spouse_card_path" value="${vo.roleSubjectList[0].app_spouse_card_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_spouse_card_path }" name="app_spouse_card_path_file" id="app_spouse_card_path_file-5" data-drawview="${vo.roleSubjectList[0].app_spouse_card_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4" id="app_trauschein_path_isHidden">
					<p>结婚证复印件</p>
					<input type="hidden" title="" name="roleSubjectList[0].app_trauschein_path" id="app_trauschein_path" value="${vo.roleSubjectList[0].app_trauschein_path }">
					<div>
						<input title="" value="${vo.roleSubjectList[0].app_trauschein_path }" name="app_trauschein_path_file" id="app_trauschein_path_file-5" data-drawview="${vo.roleSubjectList[0].app_trauschein_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<c:if test="${vo.lnAccusedVo.size() == 0||vo == null}">
			<div class="message-war other-modle" id="messageWar_0"><!-- message-war start -->
				<div class="title-war">
					<h3>对方当事人（被告／第三人）基本信息</h3>
					<span onclick="dosomething(this)"><img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png' />" /></span>
				</div>
				<div class="row w-95-auto"><!-- w-95-auto start -->
					<div class="col-sm-3 col-xs-3">
						<p>*被申请人/被告</p>
						<input Data-Val="Required" title="被申请人/被告" type="text" id="par_full_name_0" name="lnAccusedVo[0].par_full_name" class="form-control" onblur="validateForms(this)">
						<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>第三人</p>
						<input title="第三人" type="text" id="par_anyOne_0" name="lnAccusedVo[0].par_any_one" data-isrequired="0" class="form-control" placeholder="">
							<%--<span class="glyphicon form-control-feedback" aria-hidden="true"></span>--%>
					</div>
					<div class="clear"></div>
					<div class="col-sm-3 col-xs-3">
						<p>*被申请人/被告主体资格</p>
						<div class="row">
							<div class="col-sm-12 col-xs-12">
								<div class="row">

									<div class="col-sm-4 col-xs-4 rad-io">
										<span><input onclick="rightAsPrincipal_check(this,'{1:{par_idcard_path_0,par_address_path_0,par_spouse_card_path_0,par_trauschein_path_0};2:{par_business_path_0}}','par_idType_0')" type="radio" name="lnAccusedVo[0].par_right_as_principal" value="1" id="par_rightAsPrincipal_0_radio1" checked><label for="par_rightAsPrincipal_0_radio1" class="pull-left"></label><strong class="pull-left" onclick="checkToradio('par_rightAsPrincipal_0_radio1','radio');">公民</strong></span>
									</div><!--  checked="checked" -->

									<div class="col-sm-4 col-xs-4 rad-io">
										<span><input onclick="rightAsPrincipal_check(this,'{1:{par_idcard_path_0,par_address_path_0,par_spouse_card_path_0,par_trauschein_path_0};2:{par_business_path_0}}','par_idType_0')" type="radio" name="lnAccusedVo[0].par_right_as_principal" value="2" id="par_rightAsPrincipal_0_radio2"><label for="par_rightAsPrincipal_0_radio2" class="pull-left"></label><strong class="pull-left" onclick="checkToradio('par_rightAsPrincipal_0_radio2','radio');">法人</strong></span>
									</div><!--  -->

								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>证件类型</p>
						<select title="证件类型" class="form-control" disabled name="lnAccusedVo[0].par_id_type" id="par_idType_0" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
							<option value="0" selected>身份证或护照</option>
							<option value="1">组织机构代码或统一社会信用代码</option>
						</select>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*证件号</p>
						<input Data-Val="Required" title="证件号" type="text" id="par_organizingCode_0" name="lnAccusedVo[0].par_organizing_code" class="form-control" onblur="validateForms(this)">
						<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
					</div>
					<div class="clear"></div>
					<div class="col-sm-6 col-xs-6">
						<p>*联系地址</p>
						<input Data-Val="Required" title="联系地址" type="text" id="par_address_0" name="lnAccusedVo[0].par_address" class="form-control" placeholder="" onblur="validateForms(this)">
						<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*邮编</p>
						<input Data-Val="Required" title="邮编" type="text" id="par_zipcode_0" name="lnAccusedVo[0].par_zipcode" class="form-control" placeholder="" onblur="validateForms(this)">
						<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
					<div class="col-sm-3 col-xs-3">
						<p>*联系人</p>
						<input Data-Val="Required" title="联系人" type="text" id="par_name_0" name="lnAccusedVo[0].par_name" class="form-control" placeholder="" onblur="validateForms(this)">
						<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*联系电话</p>
						<input Data-Val="Required" title="联系电话" type="text" id="par_phone_0" name="lnAccusedVo[0].par_phone" class="form-control" placeholder="注：区号-电话号码-转接号" onblur="validateForms(this)">
						<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*邮箱</p>
						<input Data-Val="Required" title="邮箱" type="text" id="par_email_0" name="lnAccusedVo[0].par_email" class="form-control" placeholder="" onblur="validateForms(this)">
						<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
					<div class="col-sm-4 col-xs-4" id="par_business_path_0_isHidden" style="display: none;">
						<p>*营业执照<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
						<input type="hidden" title="" name="lnAccusedVo[0].par_business_path" id="par_business_path_0" data-status="hidden">
						<div>
							<input title="" value="" name="par_business_path_0_file" id="par_business_path_0_file-5" data-drawview="" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4" id="par_idcard_path_0_isHidden">
						<p>*身份证或护照复印件</p>
						<input type="hidden" title="" name="lnAccusedVo[0].par_idcard_path" id="par_idcard_path_0">
						<div>
							<input title="" value="" name="par_idcard_path_0_file" id="par_idcard_path_0_file-5" data-drawview="" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4" id="par_address_path_0_isHidden">
						<p>常住地证明文件复印件</p>
						<input type="hidden" title="" name="lnAccusedVo[0].par_address_path" id="par_address_path_0">
						<div>
							<input title="" value="" name="par_address_path_0_file" id="par_address_path_0_file-5" data-drawview="" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4" id="par_spouse_card_path_0_isHidden">
						<p>配偶身份证复印件</p>
						<input type="hidden" title="" name="lnAccusedVo[0].par_spouse_card_path" id="par_spouse_card_path_0">
						<div>
							<input title="" value="" name="par_spouse_card_path_0_file" id="par_spouse_card_path_0_file-5" data-drawview="" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4" id="par_trauschein_path_0_isHidden">
						<p>结婚证复印件</p>
						<input type="hidden" title="" name="lnAccusedVo[0].par_trauschein_path" id="par_trauschein_path_0">
						<div>
							<input title="" value="" name="par_trauschein_path_0_file" id="par_trauschein_path_0_file-5" data-drawview="" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
				</div><!-- w-95-auto end -->
			</div><!-- message-war end -->
		</c:if>
		<c:if test="${vo.lnAccusedVo.size() > 0}">

			<c:forEach items="${vo.lnAccusedVo}" var="lna" varStatus="i">

				<div class="message-war other-modle" id="messageWar_${i.index}"><!-- message-war start -->
					<div class="title-war">
						<h3>对方当事人（被告／第三人）基本信息（<c:if test="${i.index == 0}">一</c:if><c:if test="${i.index == 1}">二</c:if><c:if test="${i.index == 2}">三</c:if><c:if test="${i.index == 3}">四</c:if><c:if test="${i.index == 4}">五</c:if><c:if test="${i.index == 5}">六</c:if><c:if test="${i.index == 6}">七</c:if><c:if test="${i.index == 7}">八</c:if><c:if test="${i.index == 8}">九</c:if><c:if test="${i.index == 9}">十</c:if>）</h3>
						<span onclick="dosomething(this)"><img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png' />" /></span>
					</div>
					<input type="hidden" name="lnAccusedVo[${i.index}].oid" id="lnAccusedOid_${i.index}" value="${vo.lnAccusedVo[i.index].oid}"/>
					<div class="row w-95-auto"><!-- w-95-auto start -->
						<div class="col-sm-3 col-xs-3">
							<p>*被申请人/被告</p>
							<input Data-Val="Required" title="被申请人/被告" type="text" id="par_full_name_${i.index}" name="lnAccusedVo[${i.index}].par_full_name" value="${vo.lnAccusedVo[i.index].par_full_name}" class="form-control" onblur="validateForms(this)">
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
						<div class="col-sm-3 col-xs-3">
							<p>第三人</p>
							<input title="第三人" type="text" id="par_anyOne_${i.index}" name="lnAccusedVo[${i.index}].par_any_one" data-isrequired="0" value="${vo.lnAccusedVo[i.index].par_any_one}" class="form-control" placeholder="">
								<%--<span class="glyphicon form-control-feedback" aria-hidden="true"></span>--%>
						</div>
						<div class="clear"></div>
						<div class="col-sm-3 col-xs-3">
							<p>*被申请人/被告主体资格</p>
							<div class="row">
								<div class="col-sm-12 col-xs-12">
									<div class="row">

										<div class="col-sm-4 col-xs-4 rad-io">
											<span><input onclick="rightAsPrincipal_check(this,'{1:{par_idcard_path_${i.index},par_address_path_${i.index},par_spouse_card_path_${i.index},par_trauschein_path_${i.index}};2:{par_business_path_${i.index}}}','par_idType_${i.index}')" type="radio" name="lnAccusedVo[${i.index}].par_right_as_principal" value="1" id="par_rightAsPrincipal_${i.index}_radio1"<c:if test="${ empty vo.lnAccusedVo[i.index].par_right_as_principal ? true : vo.lnAccusedVo[i.index].par_right_as_principal eq '1' ? true : false }"> checked</c:if>><label for="par_rightAsPrincipal_${i.index}_radio1" class="pull-left"></label><strong class="pull-left" onclick="checkToradio('par_rightAsPrincipal_${i.index}_radio1','radio');">公民</strong></span>
										</div><!--  checked="checked" -->

										<div class="col-sm-4 col-xs-4 rad-io">
											<span><input onclick="rightAsPrincipal_check(this,'{1:{par_idcard_path_${i.index},par_address_path_${i.index},par_spouse_card_path_${i.index},par_trauschein_path_${i.index}};2:{par_business_path}}','par_idType_${i.index}')" type="radio" name="lnAccusedVo[${i.index}].par_right_as_principal" value="2" id="par_rightAsPrincipal_${i.index}_radio2"<c:if test="${vo.lnAccusedVo[i.index].par_right_as_principal eq '2' }"> checked</c:if>><label for="par_rightAsPrincipal_${i.index}_radio2" class="pull-left"></label><strong class="pull-left" onclick="checkToradio('par_rightAsPrincipal_${i.index}_radio2','radio');">法人</strong></span>
										</div><!--  -->

									</div>
								</div>
							</div>
						</div>
						<div class="col-sm-3 col-xs-3">
							<p>证件类型</p>
							<select title="证件类型" class="form-control" disabled name="lnAccusedVo[${i.index}].par_id_type" id="par_idType_${i.index}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<option value="0"<c:if test="${vo.lnAccusedVo[i.index].par_id_type eq '0' }"> selected</c:if>>身份证或护照</option>
								<option value="1"<c:if test="${vo.lnAccusedVo[i.index].par_id_type eq '1' }"> selected</c:if>>组织机构代码或统一社会信用代码</option>
							</select>
						</div>
						<div class="col-sm-3 col-xs-3">
							<p>*证件号</p>
							<input Data-Val="Required" title="证件号" type="text" id="par_organizingCode_${i.index}" name="lnAccusedVo[${i.index}].par_organizing_code" value="${vo.lnAccusedVo[i.index].par_organizing_code}" class="form-control" onblur="validateForms(this)">
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
						<div class="clear"></div>
						<div class="col-sm-6 col-xs-6">
							<p>*联系地址</p>
							<input Data-Val="Required" title="联系地址" type="text" id="par_address_${i.index}" name="lnAccusedVo[${i.index}].par_address" value="${vo.lnAccusedVo[i.index].par_address}" class="form-control" placeholder="" onblur="validateForms(this)">
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
						<div class="col-sm-3 col-xs-3">
							<p>*邮编</p>
							<input Data-Val="Required" title="邮编" type="text" id="par_zipcode_${i.index}" name="lnAccusedVo[${i.index}].par_zipcode" value="${vo.lnAccusedVo[i.index].par_zipcode}" class="form-control" placeholder="" onblur="validateForms(this)">
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
						<div class="clear"></div>
						<div class="bb-mt-e7"></div>
						<div class="col-sm-3 col-xs-3">
							<p>*联系人</p>
							<input Data-Val="Required" title="联系人" type="text" id="par_name_${i.index}" name="lnAccusedVo[${i.index}].par_name" value="${vo.lnAccusedVo[i.index].par_name}" class="form-control" placeholder="" onblur="validateForms(this)">
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
						<div class="col-sm-3 col-xs-3">
							<p>*联系电话</p>
							<input Data-Val="Required" title="联系电话" type="text" id="par_phone_${i.index}" name="lnAccusedVo[${i.index}].par_phone" value="${vo.lnAccusedVo[i.index].par_phone}" class="form-control" placeholder="注：区号-电话号码-转接号" onblur="validateForms(this)">
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
						<div class="col-sm-3 col-xs-3">
							<p>*邮箱</p>
							<input Data-Val="Required" title="邮箱" type="text" id="par_email_${i.index}" name="lnAccusedVo[${i.index}].par_email" value="${vo.lnAccusedVo[i.index].par_email}" class="form-control" placeholder="" onblur="validateForms(this)">
							<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
						</div>
						<div class="clear"></div>
						<div class="bb-mt-e7"></div>
						<div class="col-sm-4 col-xs-4" id="par_business_path_${i.index}_isHidden"<c:if test="${vo.lnAccusedVo[i.index].par_right_as_principal eq '1' }"> style="display: none;"</c:if>>
							<p>*营业执照<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
							<input type="hidden" title="" name="lnAccusedVo[${i.index}].par_business_path" id="par_business_path_${i.index}" data-status="hidden" value="${vo.lnAccusedVo[i.index].par_business_path }">
							<div>
								<input title="" value="${vo.lnAccusedVo[i.index].par_business_path }" name="par_business_path_${i.index}_file" id="par_business_path_${i.index}_file-5" data-drawview="${vo.lnAccusedVo[i.index].par_business_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
							</div>
							<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
						</div>
						<div class="col-sm-4 col-xs-4" id="par_idcard_path_${i.index}_isHidden"<c:if test="${vo.lnAccusedVo[i.index].par_right_as_principal eq '2' }"> style="display: none;"</c:if>>
							<p>*身份证或护照复印件</p>
							<input type="hidden" title="" name="lnAccusedVo[${i.index}].par_idcard_path" id="par_idcard_path_${i.index}" value="${vo.lnAccusedVo[i.index].par_idcard_path }">
							<div>
								<input title="" value="${vo.lnAccusedVo[i.index].par_idcard_path }" name="par_idcard_path_${i.index}_file" id="par_idcard_path_${i.index}_file-5" data-drawview="${vo.lnAccusedVo[i.index].par_idcard_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
							</div>
							<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
						</div>
						<div class="col-sm-4 col-xs-4" id="par_address_path_${i.index}_isHidden"<c:if test="${vo.lnAccusedVo[i.index].par_right_as_principal eq '2' }"> style="display: none;"</c:if>>
							<p>常住地证明文件复印件</p>
							<input type="hidden" title="" name="lnAccusedVo[${i.index}].par_address_path" id="par_address_path_${i.index}" value="${vo.lnAccusedVo[i.index].par_address_path }">
							<div>
								<input title="" value="${vo.lnAccusedVo[i.index].par_address_path }" name="par_address_path_${i.index}_file" id="par_address_path_${i.index}_file-5" data-drawview="${vo.lnAccusedVo[i.index].par_address_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
							</div>
							<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
						</div>
						<div class="col-sm-4 col-xs-4" id="par_spouse_card_path_${i.index}_isHidden"<c:if test="${vo.lnAccusedVo[i.index].par_right_as_principal eq '2' }"> style="display: none;"</c:if>>
							<p>配偶身份证复印件</p>
							<input type="hidden" title="" name="lnAccusedVo[${i.index}].par_spouse_card_path" id="par_spouse_card_path_${i.index}" value="${vo.lnAccusedVo[i.index].par_spouse_card_path }">
							<div>
								<input title="" value="${vo.lnAccusedVo[i.index].par_spouse_card_path }" name="par_spouse_card_path_${i.index}_file" id="par_spouse_card_path_${i.index}_file-5" data-drawview="${vo.lnAccusedVo[i.index].par_spouse_card_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
							</div>
							<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
						</div>
						<div class="col-sm-4 col-xs-4" id="par_trauschein_path_${i.index}_isHidden"<c:if test="${vo.lnAccusedVo[i.index].par_right_as_principal eq '2' }"> style="display: none;"</c:if>>
							<p>结婚证复印件</p>
							<input type="hidden" title="" name="lnAccusedVo[${i.index}].par_trauschein_path" id="par_trauschein_path_${i.index}" value="${vo.lnAccusedVo[i.index].par_trauschein_path }">
							<div>
								<input title="" value="${vo.lnAccusedVo[i.index].par_trauschein_path }" name="par_trauschein_path_${i.index}_file" id="par_trauschein_path_${i.index}_file-5" data-drawview="${vo.lnAccusedVo[i.index].par_trauschein_path }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
							</div>
							<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
						</div>
					</div><!-- w-95-auto end -->
				</div><!-- message-war end -->

			</c:forEach>

		</c:if>
		<div class="add-party"><a href="javascript:;"><i class="glyphicon glyphicon-plus"></i> 对方当事人（被告／第三人）基本信息</a></div>

		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>案件信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-9 col-xs-9">
					<p>地区</p>
					<div class="row">
						<div class="col-sm-3 col-xs-3">
							<select title="省" name="province" id="provinceID" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="changeDistrict('cityID', '', '2', this);">
								<option value="">请选择省</option>
								<c:forEach items="${provinceList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.province }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-3 col-xs-3">
							<select title="市" name="city" id="cityID" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="changeDistrict('areaID', '', '3', this);">
								<option value="">请选择市</option>
								<c:forEach items="${cityList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.city}"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-3 col-xs-3">
							<select Data-Val="Required" title="县" name="area_code" id="areaID" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<option value="">请选择县</option>
								<c:forEach items="${areaList }" var="list">
									<option value="${list.codes }" <c:if test="${vo.area_code eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-3 col-xs-3">
					<p>律师事务所</p>
					<input title="律师事务所" type="text" id="lawFirm" name="law_firm" data-isrequired="0" value="${vo.law_firm }" class="form-control" placeholder="" onblur="validateForms(this)" onkeyup="findLawFirmName(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>保全类型</p>
					<select class="form-control" onchange="validateForms(this);preserveTypeCall(this,'reference');" name="preserve_type" id="preserveType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="1"<c:if test="${vo.preserve_type eq '1' }"> selected</c:if>>诉讼前财产保全</option>
						<option value="2"<c:if test="${vo.preserve_type eq '2' }"> selected</c:if>>诉讼中财产保全</option>
					</select>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*案件审理法院</p>
					<input Data-Val="Required" title="案件审理法院" type="text" id="court" name="court" data-isrequired="1" value="${vo.court }" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3" id="reference_isHidden"<c:if test="${empty vo.preserve_type ? true : vo.preserve_type eq '1' }"> style="display: none;"</c:if>>
					<p>*案号</p>
					<input title="案号" type="text" id="reference" name="reference" data-isrequired="1" value="${vo.reference }" class="form-control" placeholder="" onblur="validateForms(this)">
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12 text-area">
					<p>*案由</p>
					<textarea Data-Val="Required" title="案由" id="brief" name="brief" class="form-control" onblur="validateForms(this)">${vo.brief }</textarea>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>申请保全的财产信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-12 col-xs-12">
					<p>*申请保全的财产价值</p>
					<div class="worth">
						<span class="pull-left">因情况紧急，被保险人（申请人）向人民法院对被申请人价值人民币</span>
						<span class="pull-left"><input Data-Val="Required" type="text" title="财产保全价值" id="valuation" name="valuation" value="${vo.valuation }" class="form-control" placeholder="" onblur="validateForms(this)"></span>
						<span class="pull-left">元整的财产进行财产保全。</span>
					</div>
				</div>
				<div class="col-sm-3 col-xs-3 type-mb ">
					<p>申请保全的财产类别</p>
					<div class="row">
						<span class="pull-left check-box type-m">
							<input type="checkbox" name="property"<c:if test="${fn:contains(vo.property,'1') }"> checked</c:if> value="1" id="property_HOUSE" onclick="property_true(this,'house_address#house_claims#house_c#house_x')">
							<label for="property_HOUSE"></label>
						</span>
						<span class="pull-left" onclick="checkToradio('property_HOUSE','checkbox');">房产</span>
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12 text-area" id="house_address_isHidden"<c:if test="${!fn:contains(vo.property,'1') }"> style="display: none;"</c:if>>
					<p>*保全标的物地址</p>
					<textarea title="保全标的物地址" id="house_address" name="house_address" class="form-control" onblur="validateForms(this)">${vo.house_address}</textarea>
				</div>
				<div class="col-sm-6 col-xs-6 file-none" id="house_claims_isHidden"<c:if test="${!fn:contains(vo.property,'1') }"> style="display: none;"</c:if>>
					<p>*标的物资料上传</p>
					<input type="hidden" name="house_claims" id="house_claims" value="${vo.house_claims}">
					<div>
						<input name="house_claims_file" id="house_claims_file-5" class="file" data-drawview="${vo.house_claims}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="clear" id="house_c_isHidden"<c:if test="${!fn:contains(vo.property,'1') }"> style="display: none;"</c:if>></div>
				<div class="bb-mt-e7" id="house_x_isHidden"<c:if test="${!fn:contains(vo.property,'1') }"> style="display: none;"</c:if>></div>
				<div class="col-sm-3 col-xs-3 type-mb  mt-20">

					<div class="row">
						<span class="pull-left check-box type-m">
							<input type="checkbox" name="property"<c:if test="${fn:contains(vo.property,'2') }"> checked</c:if> value="2" id="property_CASH" onclick="property_true(this,'cash_address#cash_claims#cash_c#cash_x')">
							<label for="property_CASH"></label>
						</span>
						<span class="pull-left" onclick="checkToradio('property_CASH','checkbox');">现金/银行账户</span>
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12 text-area" id="cash_address_isHidden"<c:if test="${!fn:contains(vo.property,'2') }"> style="display: none;"</c:if> >
					<p>*保全标的物地址</p>
					<textarea title="保全标的物地址" id="cash_address" name="cash_address" class="form-control" onblur="validateForms(this)">${vo.cash_address}</textarea>
				</div>
				<div class="col-sm-6 col-xs-6 file-none" id="cash_claims_isHidden"<c:if test="${!fn:contains(vo.property,'2') }"> style="display: none;"</c:if> >
					<p>*标的物资料上传</p>
					<input type="hidden" name="cash_claims" id="cash_claims" value="${vo.cash_claims}">
					<div>
						<input name="cash_claims_file" id="cash_claims_file-5" class="file" data-drawview="${vo.cash_claims}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="clear" id="cash_c_isHidden"<c:if test="${!fn:contains(vo.property,'2') }"> style="display: none;"</c:if>></div>
				<div class="bb-mt-e7" id="cash_x_isHidden"<c:if test="${!fn:contains(vo.property,'2') }"> style="display: none;"</c:if>></div>
				<div class="col-sm-3 col-xs-3 type-mb  mt-20">
					<div class="row">
						<span class="pull-left check-box type-m">
							<input type="checkbox" name="property"<c:if test="${fn:contains(vo.property,'3') }"> checked</c:if> value="3" id="property_FACILITY" onclick="property_true(this,'facility_address#facility_claims#facility_c#facility_x')">
							<label for="property_FACILITY"></label>
						</span>
						<span class="pull-left" onclick="checkToradio('property_FACILITY','checkbox');">机器设备</span>
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12 text-area" id="facility_address_isHidden"<c:if test="${!fn:contains(vo.property,'3') }"> style="display: none;"</c:if> >
					<p>*保全标的物地址</p>
					<textarea title="保全标的物地址" id="facility_address" name="facility_address" class="form-control" placeholder="" onblur="validateForms(this)">${vo.facility_address}</textarea>
				</div>
				<div class="col-sm-6 col-xs-6 file-none" id="facility_claims_isHidden"<c:if test="${!fn:contains(vo.property,'3') }"> style="display: none;"</c:if> >
					<p>*标的物资料上传</p>
					<input type="hidden" name="facility_claims" id="facility_claims" value="${vo.facility_claims}">
					<div>
						<input name="facility_claims_file" id="facility_claims_file-5" class="file" data-drawview="${vo.facility_claims}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="clear" id="facility_c_isHidden"<c:if test="${!fn:contains(vo.property,'3') }"> style="display: none;"</c:if>></div>
				<div class="bb-mt-e7" id="facility_x_isHidden"<c:if test="${!fn:contains(vo.property,'3') }"> style="display: none;"</c:if>></div>
				<div class="col-sm-3 col-xs-3 type-mb  mt-20">
					<div class="row">
						<span class="pull-left check-box type-m">
							<input type="checkbox" name="property"<c:if test="${fn:contains(vo.property,'4') }"> checked</c:if> value="4" id="property_INSTRUMENT" onclick="property_true(this,'instrument_address#instrument_claims#instrument_c#instrument_x')">
							<label for="property_INSTRUMENT"></label>
						</span>
						<span class="pull-left" onclick="checkToradio('property_INSTRUMENT','checkbox');">汽车/工程机械</span>
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12 text-area" id="instrument_address_isHidden"<c:if test="${!fn:contains(vo.property,'4') }"> style="display: none;"</c:if> >
					<p>*保全标的物地址</p>
					<textarea title="保全标的物地址" id="instrument_address" name="instrument_address" class="form-control" onblur="validateForms(this)">${vo.instrument_address}</textarea>
				</div>
				<div class="col-sm-6 col-xs-6 file-none" id="instrument_claims_isHidden"<c:if test="${!fn:contains(vo.property,'4') }"> style="display: none;"</c:if> >
					<p>*标的物资料上传</p>
					<input type="hidden" name="instrument_claims" id="instrument_claims" value="${vo.instrument_claims}">
					<div>
						<input name="instrument_claims_file" id="instrument_claims_file-5" class="file" data-drawview="${vo.instrument_claims}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="clear" id="instrument_c_isHidden"<c:if test="${!fn:contains(vo.property,'4') }"> style="display: none;"</c:if>></div>
				<div class="bb-mt-e7" id="instrument_x_isHidden"<c:if test="${!fn:contains(vo.property,'4') }"> style="display: none;"</c:if>></div>
				<div class="col-sm-3 col-xs-3 type-mb  mt-20">
					<div class="row">
						<span class="pull-left check-box type-m">
							<input type="checkbox" name="property"<c:if test="${fn:contains(vo.property,'5') }"> checked</c:if> value="5" id="property_OTHEROBJECT" onclick="property_true(this,'otherobject_address#otherobject_claims')">
							<label for="property_OTHEROBJECT"></label>
						</span>
						<span class="pull-left" onclick="checkToradio('property_OTHEROBJECT','checkbox');">其它标的</span>
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12 text-area" id="otherobject_address_isHidden"<c:if test="${!fn:contains(vo.property,'5') }"> style="display: none;"</c:if> >
					<p>*保全标的物地址</p>
					<textarea title="保全标的物地址" id="otherobject_address" name="otherobject_address" value="${vo.otherobject_address}" class="form-control" placeholder="" onblur="validateForms(this)"></textarea>
				</div>
				<div class="col-sm-6 col-xs-6 file-none" id="otherobject_claims_isHidden"<c:if test="${!fn:contains(vo.property,'5') }"> style="display: none;"</c:if> >
					<p>*标的物资料上传</p>
					<input type="hidden" name="otherobject_claims" id="otherobject_claims" value="${vo.otherobject_claims}">
					<div>
						<input name="otherobject_claims_file" id="otherobject_claims_file-5" class="file" data-drawview="${vo.otherobject_claims}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
			</div><!-- w-95-auto end -->
		</div>
	</form>
	<div class="row next-step">
		<div class="col-sm-12 col-xs-12 text-right pull-right">
			<p>
				<a href="javascript:void(0);" onclick="saveSLInfo('1');" id="pendingInfo" dataWait="0" class="save">暂存本页</a>
				<a href="javascript:void(0);" id="next_policy" onclick="save_policy_sl('2');" class="ns-btn">下一步</a>
			</p>
		</div>
	</div>
</div><!-- container end -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header bg-1f96ef">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title">营业执照</h4>
			</div>
			<div class="modal-body">
				<img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
			</div>
		</div>
	</div>
</div>
<!-- 营业执照 end -->
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script src="<c:url value='/resources/commonJS/con-common.js'/>" type="text/javascript"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>

<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
	window.onload = function () {
		//以后优化 频繁变更水印
		watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
	}
	function closeUMsg(){
		$('.contacts_modal_oth').hide();
		$('.black-mask-oth').hide();
	}
	function goBack(){
		history.go(-1);
	}
	function dingshi(isDo){
		if(isDo > 0){
			setTimeout(function() {
				isDo --;
				$('#closeUMsg').text('已阅读并同意('+isDo+')');
				dingshi(isDo);
			},1000);
		}else{
			$('#closeUMsg').text('已阅读并同意');
			$('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
			insOperation('','${dto.trade_serial_number}','客户告知书确认');
			$('#closeUMsg').attr('onclick','closeUMsg();');
		}
	}
	$(function () {
		if('${empty dto.oid ? '0' : '1'}' == '0'){
			var khgzs = '<div class="contacts_modal_oth" style="width: 820px;top: 120px;"><h2 class="contacts-title">确认进入投保流程</h2><div style="margin: 20px;"><p style="margin-top: 0;margin-bottom: 10px;">尊敬的客户:</p><p style="margin-top: 0;margin-bottom: 10px;">&nbsp;&nbsp;&nbsp;您即将进入投保流程，请仔细阅读保险条款。本保险产品由【${pd.insurance_name}】承保，由上海亚太保险经纪有限公司提供销售和协助理赔等保险服务。</p><p style="margin-top: 0;margin-bottom: 10px;">投保前请您阅读名户告知书</p><p style="margin-top: 0;margin-bottom: 10px;">点击“已阅读并同意”，您在销售页面的操作将被依法记录和候存。</p><div style="width: 780px;height: 250px;overflow-y: scroll;" id="khgzs"><img style="width: 775px" src="/resources/images/客户告知书-亚太保险经纪（盖章件）.png"> </div></div><div class="contacts-bottom-oth"><span id="closeUMsg" class="sureoth">已阅读并同意(10)</span>&nbsp;<span onclick="history.go(-1)">返回</span></div></div><div class="black-mask-oth"></div>';
			$('body').append(khgzs);
			$('.contacts_modal_oth').show();
			$('.black-mask-oth').show();
			dingshi(10);
		}
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });
        function addCylxr(){
            //点击联系人
            $('.contacts_modal ul li').click(function () {
                $('.contacts_modal ul li').removeClass('active');
                $(this).addClass('active');
                if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                    $('.contacts-bottom span.sure').addClass('sure_color');
                }
            });
            //点击取消
            $('.contacts-bottom .cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            $('.contacts_modal .title-cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            //点击填入
            $('.contacts-bottom .sure').click(function () {
                if($(this).hasClass('sure_color')){
                    setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                }else{
                    //没有点击选择联系人
                    // alert('请选择一个联系人！');
                }
            })
            var _html = '投保人／被保险人基本信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals()">选择常用投保人</a>';
            $("#cy_lxr").html(_html);
        }
        function setTBR(_json){
            var json = eval("(" + _json + ")");
            $('#app_rightAsPrincipal_radio2').click();
            $("#app_fullName").val(json.company_name);//企业名称
            $("#app_idType").val(json.certificate_type);//证件类型
            if(json.certificate_code != ''){
                var cccode = json.certificate_code;
                if(json.certificate_type == '1'){
                    cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                }
                $("#app_organizingCode").val(cccode);//证件号码
            }
            $("#app_address").val(json.address);//详细地址
            $("#regProvince").val(json.province);//省
            $("#regProvince").change();
            setTimeout(function(){
                $("#regCity").val(json.city);//市
                $("#regCity").change();
                setTimeout(function(){
                    $("#regDistrict").val(json.district);//区
                },1000);
            },1000);
            $("#app_linkman").val(json.user_name);//联系人
//                $("#role_linkTel_0").val(json.telephone);//手机
            $("#app_email").val(json.email);//邮箱
        }
        document.onmousedown = function(ev){
			ev = ev || window.event;
			var nr = '已阅读并同意 roleSubjectList[0].reg_address appOrganizingPath_file roleSubjectList[1].reg_address appOrganizingPath1_file 【批量上传】 inception_date roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
			var x=ev.clientX;
			var y=ev.clientY;
			if((ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || nr.indexOf(ev.target.name)!=-1 ){
				if(ev.target.name=='inception_date'){
					//到这里需要整个页面都截图一次
					<%--insOperation('${dto.oid}','${sigId}','投保信息提交');--%>
				}
				insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
			}
		}

    })
    //点击弹窗出现
    function showContractsModals() {
        $('.contacts_modal').show();
        $('.black-mask').show();
    }

</script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    var count = 2;
    $(function(){
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }

    });
    function save_policy_sl(_page){
        if(customsVerify()){
            $("select[disabled]").each(function(){
                $(this).removeAttr('disabled');
            });
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/lawsuit/policy/pendingSpecialLitigation_1VoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {
						insOperation(json.navTabId,'${dto.trade_serial_number}','投保信息提交');
						layer.close(index);
						window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/'+json.navTabId+'/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
						/*var _t = setInterval(function () {
							if(_tong==1){
								clearInterval(_t);
								layer.close(index);
								window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/'+json.navTabId+'/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
							}
						},300);*/
                    }else{
						layer.close(index);
                        layer.msg(json.message);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });
        }
    }
    function saveSLInfo(page){
        if(isAllNull() == 1){
            $("select[disabled]").each(function(){
                $(this).removeAttr('disabled');
            });
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/lawsuit/policy/pendingSpecialLitigation_'+page+'VoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    layer.close(index);
                    layer.msg(json.message);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/'+json.navTabId+'/'+page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });
        }else{
            layer.msg("表单未检索到数据，请完善信息后暂存！");
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("必填项不能为空！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }else{
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("长度超出限制！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }
                    }

                }
            }
        });
        if(flag){
            $("input[Data-Val]").each(function() {
                var dataVal = $(this).attr("Data-Val");
                if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                    if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                        $(this).blur();
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            flag = false;
                            return true;
                        }
                    }
                }
            });
            if(!flag){
                layer.msg("请正确填写相关信息！");
            }
        }
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("必填项不能为空！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("必填项不能为空！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    layer.msg("长度超出限制(100字符)！");
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        return flag;
    }
    $(function(){
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
        });
        $("input[id=need_receipt]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
            }
        });
        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
            }
        });

        $("#recommend_code").on("blur",function(){
            var rCode = $(this).val();
            var pID = $(this).attr("data-relate");
            if(rCode != '' && pID != ''){
                if( pID != ''){
                    $.ajax({
                        type: 'POST',
                        url:baseUrl + '/insurance/build/policy/isFeeByrecommend_codeAndProductID.json',
                        data:{
                            'productID':pID,
                            'recommend_code':rCode
                        },
                        dataType:"json",
                        success: function(json){
                            layer.msg(json.message);
                            if(json.statusCode != '200') {
                                $(this).val('');
                            }
                        },
                        error : function(XMLHttpRequest, textStatus, errorThrown) {
                            layer.msg(textStatus);
                        }
                    });
                }else{
                    layer.msg("数据丢失，请刷新页面重试！");
                }

            }

        });

        var app_rightAsPrincipal = '${vo.roleSubjectList[0].right_as_principal}';
        if(app_rightAsPrincipal != ''){
            var o = $("input[name='roleSubjectList[0].right_as_principal']:checked");
            radioForCheck(o);
        }
        var par_rightAsPrincipal = '${vo.lnAccusedVo[0].par_right_as_principal }';
        if(par_rightAsPrincipal != ''){
            var o = $("input[name='lnAccusedVo[0].par_right_as_principal']:checked");
            radioForCheck(o);
        }
        var property = '${vo.property}';
        if(property != '' && property.length>1){
            $("input[name='property']:checked").each(function(){
                var jsMethon = $(this).attr("onclick").split("'")[1];

                for(var i=0;i<jsMethon.split("#").length;i++){
                    $("#"+jsMethon.split("#")[i]+"_isHidden").show();
                }
            });
        }
        var preserveType = '${vo.preserve_type }';
        if(preserveType != '' && preserveType.length>1){
            var ty = $("#preserveType").val();
            if(ty == "2"){
                $("#reference_isHidden").show();
            }
        }
    });
    function radioForCheck(o){
        var _n = o.attr("id");
        var vio = "";
        if(_n.indexOf("_copy")!=-1){
            for(var i=0;i<_n.split("_").length;i++){
                if(_n.split("_")[i].indexOf("copy")!=-1){
                    vio = "_"+_n.split("_")[i];
                }
            }
        }
        var v_ = o.val();
        var jsMethon = o.attr("onclick").split("'")[1];
        jsMethon = jsMethon.substring(1,jsMethon.length-1);
        var jsMethon_1 = jsMethon.split(";")[0];
        var jsMethon_2 = jsMethon.split(";")[1];
        if(v_ == jsMethon_1.split(":")[0]){
            var h_ = jsMethon_2.split(":")[1];
            h_ = h_.substring(1,h_.length-1);
            for(var i=0;i<h_.split(",").length;i++){
                $("#"+h_.split(",")[i]+"_isHidden"+vio).hide();
            }
            var k_ = jsMethon_1.split(":")[1];
            k_ = k_.substring(1,k_.length-1);
            for(var i=0;i<k_.split(",").length;i++){
                $("#"+k_.split(",")[i]+"_isHidden"+vio).show();
            }

        }else{
            var h_ = jsMethon_1.split(":")[1];
            h_ = h_.substring(1,h_.length-1);
            for(var i=0;i<h_.split(",").length;i++){
                $("#"+h_.split(",")[i]+"_isHidden"+vio).hide();
            }
            var k_ = jsMethon_2.split(":")[1];
            k_ = k_.substring(1,k_.length-1);
            for(var i=0;i<k_.split(",").length;i++){
                $("#"+k_.split(",")[i]+"_isHidden"+vio).show();
            }

        }
    }
    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                layer.close(index);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    layer.msg(result.message);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
    function rightAsPrincipal_check(o,option,_id){
        var _n = o.id;
        var vio = "";
        if(_n.indexOf("_copy")!=-1){
            for(var i=0;i<_n.split("_").length;i++){
                var _r = _n.split("_")[i];
                if(_r.indexOf("copy")!=-1){
                    vio = "_"+_r;
                }
            }
        }
        var _fir = _n.split("_")[0];
        $("#"+_fir+"_organizingCode"+vio).val('');
        loser_sty(_fir+"_organizingCode"+vio);
        var str1 = option.substring(1,option.length-1);
        var cit = str1.split(";")[0];
        var leg = str1.split(";")[1];
        //值一
        var c_1 = cit.split(":")[1];
        c_1 = c_1.substring(1,c_1.length-1);
        var c_arr = c_1.split(",");
        //值二
        var l_1 = leg.split(":")[1];
        l_1 = l_1.substring(1,l_1.length-1);
        var l_arr = l_1.split(",");

        if(cit.split(":")[0] == o.value){//如果等于值一，值一显示值二隐藏
            $("#"+_id+vio).val("0");
            for(var i=0;i<l_arr.length;i++){
                $("#"+l_arr[i]+"_isHidden"+vio).hide();
                ajaxFormDataDelete(l_arr[i]);
                $("#"+l_arr[i]).attr("data-status","hidden");
            }
            for(var i=0;i<c_arr.length;i++){
                $("#"+c_arr[i]+"_isHidden"+vio).show();
                $("#"+c_arr[i]).attr("data-status","");
            }
        }else if(leg.split(":")[0] == o.value){
            $("#"+_id+vio).val("1");
            for(var i=0;i<c_arr.length;i++){
                $("#"+c_arr[i]+"_isHidden"+vio).hide();
                ajaxFormDataDelete(c_arr[i]);
                $("#"+c_arr[i]).attr("data-status","hidden");
            }
            for(var i=0;i<l_arr.length;i++){
                $("#"+l_arr[i]+"_isHidden"+vio).show();
                $("#"+l_arr[i]).attr("data-status","");
            }
        }

    }
    function preserveTypeCall(o,_id){
        if(o.value == "1"){
            $("#"+_id+"_isHidden").hide();
            $("#"+_id).val('');
            removeClass($("#"+_id).parent(),'has-feedback has-success');
            removeClass($("#"+_id).parent(),'has-loser has-feedback');
            removeClass($("#"+_id).next(),'glyphicon-remove');
            removeClass($("#"+_id).next(),'glyphicon-ok');
        }else if(o.value == "2"){
            $("#"+_id+"_isHidden").show();
        }
    }
    function property_true(o,option){
        var arr = option.split("#");
        if($(o).is(":checked")){
            for(var i=0;i<arr.length;i++){
                $("#"+arr[i]+"_isHidden").show();
            }
        }else{
            for(var i=0;i<arr.length;i++){
                $("#"+arr[i]+"_isHidden").hide();
                if(i==0){
                    $('#'+arr[i]).val(' ');
				}
            }
        }
    }
    function checkToradio(_id, type){
        var o = $("#"+_id);
        if(type=="radio"){
            o.prop('checked',true);
            if(o.val() == "VATINVOICE"||o.val() == "ORDINARYINVOICE"){
                invoiceToHide(_id);
            }else{
                o.click();
            }
			/*if(_id=="app_rightAsPrincipal_radio1"||_id=="app_rightAsPrincipal_radio2"){
			 o.click();
			 }*/
        }else if(type=="checkbox"){

            if($("#"+_id).attr('checked')) {
                o.attr('checked', false);
            } else {
                o.attr('checked', true);
                //o.parents('.checkbox').find('span').addClass('checked');
            }
            o.click();
        }
    }
    function validateForms(o){
        if($("#"+o.id).val() == ""){
            if(o.id.indexOf("par_name")>-1 || o.id.indexOf("par_phone")>-1 || o.id.indexOf("par_email")>-1 )
            {
                success_has1(o);
            }else{
                loser_has(o);
                if(o.id == "lawFirm"){
                    $("#fuzzy_query").hide();
                }
            }
            return;
        }
        if(o.id=="valuation" || o.id=="insuredAmount" ){
            if(!checkInt1($("#"+o.id).val()) && !checkDouble1($("#"+o.id).val())){
                loser_has_ts(o);
                return;
            }
        }
        if(o.id == "app_organizingCode"){
            if($("#app_idType").length>0){
                if("IDCARD" == $("#app_idType").val()){
                    if(!validateIdent.IdentityCodeValid($("#"+o.id).val())){
                        loser_has_ts(o);
                        return;
                    }
                }else{
                    if($("#"+o.id).val().length >30){
                        loser_has_ts(o);
                        return;
                    }
                }
            }else{
                if(!validateIdent.IdentityCodeValid($("#"+o.id).val())){
                    loser_has_ts(o);
                    return;
                }
            }
        }
        if(o.id == "par_organizingCode"){
            if($("#par_idType").length>0){
                if("IDCARD" == $("#par_idType").val()){
                    if(!validateIdent.IdentityCodeValid($(o).val())){
                        loser_has_ts(o);
                        return;
                    }
                }else{
                    if($(o).val().length >30){
                        loser_has_ts(o);
                        return;
                    }
                }
            }else{
                if(!validateIdent.IdentityCodeValid($(o).val())){
                    loser_has_ts(o);
                    return;
                }
            }
        }

        if(o.id.indexOf("par_organizingCode_copy") >-1){
            var indexStr = o.id.substring(o.id.lastIndexOf("_copy"),o.id.length).replace("_copy","");
            if($("#par_idType_copy"+indexStr).length>0){
                if("IDCARD" == $("#par_idType_copy"+indexStr).val()){
                    if(!validateIdent.IdentityCodeValid($(o).val())){
                        loser_has_ts(o);
                        return;
                    }
                }else{
                    if($(o).val().length >30){
                        loser_has_ts(o);
                        return;
                    }
                }
            }else{
                if(!validateIdent.IdentityCodeValid($(0).val())){
                    loser_has_ts(o);
                    return;
                }
            }
        }

        if(o.id.indexOf("par_phone_copy") >-1){
            var indexStr = o.id.substring(o.id.lastIndexOf("_copy"),o.id.length).replace("_copy","");
            if(!checkPhone($("#"+o.id).val()) && !checkMobile($("#"+o.id).val())){
                loser_has_ts(o);
                return;
            }
        }


        if(o.id.indexOf("par_email_copy") >-1){
            var indexStr = o.id.substring(o.id.lastIndexOf("_copy"),o.id.length).replace("_copy","");
            if(!checkEmail($("#"+o.id).val())){
                loser_has_ts(o);
                return;
            }
        }

        if(o.id == "lawFirm"){
            if($("#fuzzy_query ul").find("li").length == 0){
                $("#fuzzy_query").hide();
            }
        }
        if(o.id == "app_email"||o.id == "par_email"){
            if(checkEmail($("#"+o.id).val()) == false){
                loser_has_ts(o);
                return;
            }
        }
        if(o.id == "app_tel"||o.id == "par_tel"){
            if(checkMobile($("#"+o.id).val()) == false){
                loser_has_ts(o);
                return;
            }
        }
        if(o.id == "app_phone" || o.id == "par_phone"){
            var ph = $("#"+o.id).val();
            if(!checkPhone(ph)){
                loser_has_ts(o);
                return;
            }else{
                var arrs = ph.split("-");

                if(arrs.length>1){
                    if(arrs.length == 2){
                        if(isSameNumber(arrs[0])||isSameNumber(arrs[1])){
                            loser_has_ts(o);
                            return;
                        }
                    }else if(arrs.length == 3){
                        if(isSameNumber(arrs[0])||isSameNumber(arrs[1])||isSameNumber(arrs[2])){
                            loser_has_ts(o);
                            return;
                        }
                    }
                }else{
                    if(isSameNumber(arrs[0])){
                        loser_has_ts(o);
                        return;
                    }
                }
            }
        }


        if(o.id == "bidPeriod"){
            if($("#bidPeriod").val() != ''){
                var regu = "^[0-9]*[1-9][0-9]*$";
                var re = new RegExp(regu);
                if($("#bidPeriod").val().search(re)!=0){
                    loser_has_ts(o);
                    return;
                }
                $.ajax({
                    type: 'POST',
                    url:baseUrl + '/insurance/lawsuit/policy/requestPlanEndTime',
                    data:{
                        "bidtime":$("#bidtime").val(),
                        "bidPeriod":$("#bidPeriod").val()
                    },
                    dataType:"json",
                    async :false,
                    success: function(json){
                        if(json.statusCode == '200') {
                            $("#inceptionDate").val($("#bidtime").val());
                            $("#plannedEndDate").val(json.resultDto.message);
                        }
                        if(json.statusCode == '300') {
                            layer.msg(json.resultDto.message);
                        }
                        if(json.statusCode == '301') {
                            loser_has($("#bidtime"));
                        }
                        if(json.statusCode == '302') {
                            loser_has($("#bidPeriod"));
                        }
                    }
                });
            }
        }
        success_has(o);
    }

    function isSameNumber(vals){
        var count = 1;
        var flag = false;
        for(var i = 1; i< vals.length; i++){
            if(vals.charAt(0) == vals.charAt(i)){
                count ++;
            }
        }
        if(count == vals.length){
            flag = true;
        }
        return flag;
    }

    function dosomething(obj){
        var _id = $(obj).parent().next().attr('id');
        var num = $('div').find('.other-modle').length;
        if(num == 1){
            layer.msg("至少存在一个当事人信息！");
        }else{
            if(_id == ''|| _id == undefined){
                $(obj).parents('.other-modle').remove();
                ert();
            }else{
                if(_id == ''||$("#"+_id).val() == ''){
                    $(obj).parents('.other-modle').remove();
                    ert();
                }else{
                    var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
                    $.ajax({
                        type: 'POST',
                        url:baseUrl + '/insurance/lawsuit/policy/deleteLnAccusedByOid.json',
                        data:{
                            'lna_id':$("#"+_id).val()
                        },
                        dataType:"json",
                        success: function(json){
                            layer.msg(json.message);
                            if(json.statusCode == '200') {
                                $(obj).parents('.other-modle').remove();
                                ert();
                            }
                            layer.close(index);
                        },
                        error : function(XMLHttpRequest, textStatus, errorThrown) {
                            layer.close(index);
                            layer.msg(textStatus);
                        }
                    });
                }
            }
		}

    }

    $('.add-party a').click(function () {
        var parentDiv = $(this).parent();
        var num_div = $('div').find('.other-modle').length-1;
        if(num_div<9){

            var radioN = 1;
            var nodes = parentDiv.prev().clone();
            var _warID = nodes.attr('id');
            var num = Number(_warID.split('_')[1]);
            var ns = num+1;
            var _nowWar = _warID.split('_')[0]+"_"+ns;
            nodes.attr('id',_nowWar);

            nodes.find("input").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
                if(_name.indexOf('_file')!= -1){
                    $(this).attr("name",_name.replace("_"+num, "_"+ns));
                    var fInput = '<input title="" name="'+$(this).attr("name")+'" id="'+$(this).attr("id")+'" data-drawview="" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">';
                    $(this).parents('.col-sm-4').children('div').html(fInput)
                }

                var _onclick = $(this).attr("onclick");
                if(_onclick != ''&&_onclick != undefined){
                    for(var x=0;x<10;x++){
                        if(_onclick.indexOf('_'+num)!= -1){
                            _onclick = _onclick.replace("_"+num, "_"+ns)
                        }else{
                            x = 10;
						}
					}
                    $(this).attr("onclick",_onclick);
                }
                if($(this).attr('type') == 'radio'){
                    /*if(radioN == 1){
                        $(this).parent().parent().parent().find('input').first().attr('checked',true);
                        radioN = 2;
					}*/
				}else{
                    $(this).val('');
                }
            });
            nodes.find("strong").each(function(){
                var _onclick = $(this).attr("onclick");
                if(_onclick != ''&&_onclick != undefined){
                    for(var x=0;x<10;x++){
                        if(_onclick.indexOf('_'+num)!= -1){
                            _onclick = _onclick.replace("_"+num, "_"+ns)
                        }else{
                            x = 10;
                        }
                    }
                    $(this).attr("onclick",_onclick);
                }
			});
            nodes.find("select").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                /*$(this).attr('selected','');*/
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
            });
            nodes.find("div").each(function(){
                var _id = $(this).attr("id");
                if(_id != undefined){
                    $(this).attr("id",_id.replace("_"+num, "_"+ns));
				}
                var _class = $(this).attr("class");
                if(_class != undefined){
                    _class = _class.replace('has-feedback has-success','').trim();
                    _class = _class.replace('has-loser has-feedback','').trim();
                    $(this).attr('class',_class);
				}
            });
            nodes.find("span").each(function(){
                var _class = $(this).attr("class");
                if(_class != undefined){
                    _class = _class.replace('glyphicon-remove','').trim();
                    _class = _class.replace('glyphicon-ok','').trim();
                    $(this).attr('class',_class);
                }
			});
            nodes.find("label").each(function(){
                var _for = $(this).attr("for");
                if(_for != undefined){
                    $(this).attr("for",_for.replace("_"+num, "_"+ns));
				}
            });
            parentDiv.before(nodes);
            ert();
            initDoFile();
        }else{
            layer.msg("最多录入十个当事人信息");
		}
    });

    function ert() {
        s = $('div').find('.other-modle').length;
        if(s<=1){
            $('.other-modle .title-war h3').text("对方当事人（被告／第三人）基本信息");
        }else{
            for(var i=0;i<s;i++){
                $('.other-modle .title-war').eq(i).find('h3').text("对方当事人（被告／第三人）基本信息"+getCNNum(i + 1));
            }
        }
    }
    function getCNNum(_s){
        if(_s == 1){
            return '（一）';
		}else if(_s == 2){
            return '（二）';
        }else if(_s == 3){
            return '（三）';
        }else if(_s == 4){
            return '（四）';
        }else if(_s == 5){
            return '（五）';
        }else if(_s == 6){
            return '（六）';
        }else if(_s == 7){
            return '（七）';
        }else if(_s == 8){
            return '（八）';
        }else if(_s == 9){
            return '（九）';
        }else{
            return '（十）';
		}
    }
    function initDoFile(){
        var $input = $('input.file[type=file]'), count = $input.attr('type') ? $input.length : 0;
        if (count > 0) {
            $input.each(function(a,b){
                var type_img = ['.jpg','.jpeg','.gif','.png','.psd','.tiff','bmp'];
                var type_wj = ['.txt','.pdf','.doc','.docx','.ppt','.rar','.zip','.tar'];

                var maxFileSize = 20480;//文件限制20M(20480KB)
                var paths = $(b).attr('data-drawview');
                var name = paths;
                var allowedFiles = $(b).attr('data-allowedFileExtensions');
                var fileType = $(b).attr("data-preview-file-type");
                var allowedFileArr = new Array();//创建一个数组
                if(allowedFiles == undefined || allowedFiles == ""){
                    if(fileType == undefined || fileType == ""){
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }else if(fileType == "image"){
                        allowedFileArr =["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG"];
                        maxFileSize = 8192; //图片限制2M(2048KB)
                    }else{
//        				allowedFileArr =["doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }
                }else{
                    allowedFileArr = allowedFiles.replace("[","").replace("]","").split(",");
                }
                if(paths != undefined && paths != '' && paths.length>1){
                    var code = "";
                    for(var i=0;i<type_img.length;i++){
                        if(code != "1"){
                            if(paths.replace(type_img[i])){
                                code = "1";
                                paths = '<img src="'+paths+'" class="file-preview-image" title="'+name+'" alt="'+name+'" style="width:200px;height:154px;">';
                            }
                        }
                    }
                    if(code == ""){
                        for(var i=0;i<type_wj.length;i++){
                            if(code != "2"){
                                if(paths.replace(type_wj[i])){
                                    code = "2";
                                }
                            }
                        }
                    }
                    if(code == "1"){
                        name = name.split("/")[name.split("/").length-1];
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ],
                            initialPreviewAsData: true,
                            initialPreviewFileType: 'image',
                            deleteUrl: "/site/file-delete",
                            overwriteInitial: true,
                            initialPreviewConfig: [
                                {caption: name, size: 576237, width: "210px", url: "/site/file-delete", key: 1},
                            ]
                        });
                    }else if(code == "2"){
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ]
                        });
                    }
                }else
                    $(b).fileinput({
                        allowedFileExtensions: allowedFileArr,//接收的文件后缀
                        maxFileSize:maxFileSize
                    });


            });
        }
    }
</script>

<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>

<jsp:include page="../../../index/multi_f.jsp" />
</body>
</html>