<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">
		
<title>百联保—保单详情</title>
<link href="<c:url value='/resources/css/public.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/product_details.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/login.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/personal_center.css' />" rel="stylesheet" type="text/css" />

</head>
<body>

<jsp:include page="../../../header.jsp"/>
<!-- 产品详情 保单详情  开始 -->
<div class="pro_detwar"><!-- pro_detwar start -->
 	<div class="pro_detsub"><!-- pro_detsub start -->
       
       <div class="chitdet_title"><p><a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />">首页></a>  <a href="<c:url value='/user/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的账户></a>  保单详情</p></div>
      
       
<!-- 确认保单 开始 -->
       <div class="affirm_warr">
        	<h3>${policySaleForm.agreementSpec.name}</h3>
       	 <c:if test="${policySaleForm.policyStatus eq 'IN_FORCE'}">
         <p class="font_16">保单号码：${policySaleForm.external_reference}</p>
         </c:if>
         <c:if test="${policySaleForm.policyStatus eq 'PENDING'}">
         <p class="font_16">订单号码：${policySaleForm.policyTransaction.tradeSerialNumber}</p>
         </c:if>
         <!-- 投保人（投标人/承包人）基本信息 开始 -->
         <div class="company_title" id="width_95"><p>投保人(投标人/施工单位)基本信息 </p></div>
        <table>
            <tr>
              <td height="33" class="tablebg_f3f4f5" width="130">名称（全称）</td>
              <td colspan="3">&nbsp;${policySaleForm.roleMap['Applicant'].name}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5">投保人地址</td>
              <td colspan="3">&nbsp;${policySaleForm.roleMap['Applicant'].address}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5" width="130">组织机构代码</td>
              <td>&nbsp;${policySaleForm.roleMap['Applicant'].organizingCode}</td>
              <td height="33" class="tablebg_f3f4f5" width="130">邮政编码</td>
              <td>&nbsp;${policySaleForm.roleMap['Applicant'].zipcode}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5" width="130">联系人</td>
              <td>&nbsp;${policySaleForm.roleMap['Applicant'].linkman}</td>
              <td height="33" class="tablebg_f3f4f5" width="130">联系电话</td>
              <td>&nbsp;${policySaleForm.roleMap['Applicant'].linkphone}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5" width="130">联系邮箱</td>
              <td>&nbsp;${policySaleForm.roleMap['Applicant'].linkEmail}</td>
              <td height="33" class="tablebg_f3f4f5" width="130">手机号码</td>
              <td>&nbsp;${policySaleForm.roleMap['Applicant'].linkTel}</td>
            </tr>
          </table>
        <!-- 投保人（投标人/承包人）基本信息 结束 -->
        
         <!-- 被保险人（招标人/发包人）基本信息 开始 -->
         <div class="company_title" id="width_95"><p>被保险人（招标人/发包人）基本信息 </p></div>
        <table>
            <tr>
              <td height="33" class="tablebg_f3f4f5" width="130">名称（全称）</td>
              <td colspan="3">&nbsp;${policySaleForm.roleMap['Insured'].name}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5">投保人地址</td>
              <td colspan="3">&nbsp;${policySaleForm.roleMap['Insured'].address}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5" width="130">组织机构代码</td>
              <td>&nbsp;${policySaleForm.roleMap['Insured'].organizingCode}</td>
              <td height="33" class="tablebg_f3f4f5" width="130">邮政编码</td>
              <td>&nbsp;${policySaleForm.roleMap['Insured'].zipcode}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5" width="130">联系人</td>
              <td>&nbsp;${policySaleForm.roleMap['Insured'].linkman}</td>
              <td height="33" class="tablebg_f3f4f5" width="130">联系电话</td>
              <td>&nbsp;${policySaleForm.roleMap['Insured'].linkphone}</td>
            </tr>
            <tr>
              <td height="33" class="tablebg_f3f4f5">手机号码</td>
              <td colspan="3">&nbsp;${policySaleForm.roleMap['Applicant'].linkTel}</td>
            </tr>
          </table>
        <!-- 被保险人（招标人/发包人）基本信息 结束 -->
         
         <!-- 投保基本信息 开始 -->
         <div class="company_title" id="width_95"><p>投保基本信息</p></div>
         <table width="902" border="1">
            <tr>
                <td width="126" rowspan="2" class="tablebg_f3f4f5">建设工程</td>
                <td width="106" class="tablebg_f3f4f5">项目名称及标段</td>
                <td width="258">&nbsp;${policySaleForm.buildProject.projectName}</td>
                <td width="181" class="tablebg_f3f4f5">招标文件编号</td>
                <td width="243">&nbsp;${policySaleForm.buildProject.invitationCode}</td>
            </tr>
            <tr>
                <td height="22" class="tablebg_f3f4f5">投标日期</td>
                <td width="258">&nbsp;<fmt:formatDate pattern="yyyy-MM-dd" value="${policySaleForm.buildProject.bidtime}"/></td>
                <td width="106" class="tablebg_f3f4f5">工程建设地点</td>
                <td width="243">&nbsp;${policySaleForm.buildProject.projectAddress}</td>
            </tr>
            <tr>
                <td height="22" class="tablebg_f3f4f5">计划工期</td>
                <td width="258" colspan="4">&nbsp;${policySaleForm.buildProject.projectTime}</td>
                
            </tr>
            <c:if test="${policySaleForm.agreementSpec.productType eq 'CONBID'}">
            <tr>
                <td class="tablebg_f3f4f5">保证金额度</td>
                <td colspan="4">&nbsp;¥${policySaleForm.insuredAmount }</td>
            </tr>
            </c:if>
            <tr>
                <td class="tablebg_f3f4f5">保险期间</td>
                <td colspan="4">&nbsp;自 <fmt:formatDate pattern="yyyy-MM-dd" value="${policySaleForm.inceptionDate}"/> 零时起至 <fmt:formatDate pattern="yyyy-MM-dd" value="${policySaleForm.plannedEndDate}"/> 二十四时止</td>
            </tr>
            <tr>
                <td class="tablebg_f3f4f5">司法管辖</td>
                <td colspan="4">中华人民共和国司法管辖（港澳台除外）</td>
            </tr>
            <tr>
                <td class="tablebg_f3f4f5">争议处理</td>
                <td colspan="4">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：<c:if test="${policySaleForm.dispute eq 'LITIGATION'}">诉讼</c:if><c:if test="${policySaleForm.dispute eq 'ARBITRATION'}">仲裁，仲裁机构 ${policySaleForm.arbitralInstitution}</c:if></td>
            </tr>
        </table>
         <!-- 投保基本信息 结束 -->
         
<!-- 保险公司提示 开始 -->
         <div class="company_title" id="width_95"><p>保险公司提示</p></div>
         <div class="insurance_hint">
         	<p>1、本投保单为保险合同的组成部分。请投保人在填写投保单之前仔细阅读保险条款（包括主险和附加险），尤其是加黑突出标注的、免除保险人责任的条款内容，并听取保险公司业务人员对条款的说明以及对免除保险人责任条款的明确说明，如有不明白或有疑义的，请及时询问保险公司业务人员。</p>
             <p>2、中国太保（是指中国太平洋保险（集团）股份有限公司及其直接或间接控股的子公司，以及中国太平洋保险（集团）股份有限公司直接或间接作为其单一最大股东的公司）对您提供的资料承担保密义务，中国太保将采取恰当的物理、电子、管理技术手段保护投保人提供的资料，同时，采取适当的安全措施保护投保人提供的资料免于未经授权的访问、使用或泄露。</p>
         </div>
         <!-- 保险公司提示 结束 -->
         
         <!-- 投保人声明 开始 -->
         <div class="company_title" id="width_95"><p>投保人声明</p></div>
         <div class="insurance_hint">
         	<p><strong>1、本投保人已经收悉并仔细阅读保险条款，尤其是加黑突出标注的、免除保险人责任的条款内容。保险公司业务人员已就本合同所涉及的所有免除保险人责任条款的概念、内容及其法律后果向本投保人做出了通俗的、本投保人能够理解的解释和明确说明，本投保人对其真实含义和法律后果完全理解，没有异议，特签字、盖章予以确认并申请投保。</strong></p>
             <p>2、基于为本投保人及被保险人提供更优质服务和产品的目的，除法律另有规定外，本投保人授权中国太保可以从相关单位、组织和个人就有关保险事宜查询、索取与本投保人及被保险人有关的资料和证明。</p>
             <p> 3、除法律另有规定外，本投保人同意中国太保及其认为业务必要而委托的第三方将本投保人提供的全部资料、享受中国太保服务产生的信息，以及从相关单位、组织和个人就有关保险事宜查询、索取的资料和证明，用于为本投保人及被保险人提供服务、推荐产品、开展市场调查与信息数据分析。</p>
             <p> 4、本投保人及被保险人兹声明所填上述内容（包括投保单及投保附件）属实</p>
         </div>
         <!-- 投保人声明 开始 -->
		 <c:if test="${policySaleForm.policyStatus eq 'IN_FORCE' }">
         <!-- 保单下载   保函下载     开始 -->
         <div class="clear"></div>
         <div class="chit_up">
         	<p><a href="javascript:void(0);" onclick="dowLoad('电子保单','${policySaleForm.oid }','1')" target="_blank">保单下载</a> <label>｜</label><a href="javascript:void(0);" onclick="dowLoad('电子保函','${policySaleForm.oid }','2')" target="_blank">保函下载</a></p>
         </div> 
         <!-- 保单下载  ｜  保函下载     结束 -->
         </c:if>
         <!-- 批单 申请理赔 开始 -->
         <div class="clear"></div>
         <div class="rider_claims">
         	<p>
                 <c:if test="${policySaleForm.policyStatus eq 'IN_FORCE' }">
                 <%-- <a href="<c:url value='' />" >批单</a> --%>
                 <a href="<c:url value='/synopsis/addReport/init/${policySaleForm.policySerialNumber }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="claims">申请理赔</a>
                 </c:if>
             </p>
         </div> 
         <!--  批单 申请理赔 结束 -->
          
         </div>
         <!-- 确认保单 开始 -->
        <form action="<c:url value='/downloadAttachment?ACCESS_TOKEN=${ACCESS_TOKEN}' />" id="poForm" method="post">
        	<input type="hidden" name="name" id="name">
        	<input type="hidden" name="oid" id="oid">
        	<input type="hidden" name="code" id="code">
        </form>
     </div><!-- pro_detsub end -->
 </div><!-- pro_detwar end -->
 <!-- 产品详情 保单详情  结束 -->
 

<!-- 内容部分  注册  结束 -->
<jsp:include page="../../../index/multi_f.jsp" />

<!-- script -->
<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
function dowLoad(nam_,oid_,cod_){
	$("#name").val(nam_);
	$("#oid").val(oid_);
	$("#code").val(cod_);
	$("#poForm").submit();
	
}
</script>
</body>
</html>