<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body style="background: rgba(244,245,246,1);">


<!-- 
	CommonExportVo_1 -- vo1
	CommonExportVo_2 -- vo2
	CommonExportVo_3 -- vo3
 -->

<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保确认</li>
	</ol>--%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-3">
				<p><i class="pull-left">3</i><span class="pull-left">投保信息审核</span></p>
			</div>
			<div class="col-sm-3 col-sm-3 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left"> 缴费通知</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
            <div class="mess-title"><h3>推荐人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
                        <td class="col-sm-4 col-xs-4">${empty vo1.recommend_code ? '无' : vo1.recommend_code}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                        <td class="col-sm-4 col-xs-4"></td>
                    </tr>
                    </tbody>
                </table>
            </div>
			<div class="mess-title"><h3>1.申请人基本信息 Basic Information of Applicant</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody>
                       	 <tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">公司中英文名称 Name of Applicant</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].name_cn}&nbsp;${vo1.roleSubjectList[0].name_en}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">企业注册号 Registration No.</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].aaum_code}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">成立日期 Date of Establishment</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].register_date}</td>
						</tr>
                        <tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">注册地址 Place of Incorporation</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${ reg_role}${vo1.roleSubjectList[0].reg_address}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">联系人 Contact Name</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].link_name}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">联系人职务 Position of Contact Person</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].link_duty}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">电话 Telephone</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].link_phone}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">传真 Fax</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].link_fax}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">电邮地址 E-mail</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].link_email}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">企业性质 Type of Organization</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${fns:getDictLabel (vo1.roleSubjectList[0].com_type,"comType","")}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">投保业务类别 Business Nature</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].business_nature}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">买方所属行业 Sectors Sold To</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].sectors_sold}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">投保人关联企业信息 Details of Associated Companies</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.roleSubjectList[0].companies_detail}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">是否已有信用险保单 Any existing credit insurance cover</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${ vo1.roleSubjectList[0].id_insurance == 0 ? '否NO':'是YES'}<c:if test="${ vo1.roleSubjectList[0].id_insurance == 1}">,${vo1.roleSubjectList[0].insurance_name }</c:if></td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">投保币种  (以下所提供的资料皆以此币种表示)Currency Required <br>(to be used for all information provided)</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${fns:getDictLabel (vo1.roleSubjectList[0].currency_required,"currencyRequired","")}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">预计未来12个月的投保营业额Estimated Insurable Turnover of next 12 months</td>
							<td colspan="1" class="col-sm-6 col-xs-6">内贸：${ vo1.roleSubjectList[0].turnover_domestic}，出口：${ vo1.roleSubjectList[0].turnover_export}</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>2.业务描述 Business Description</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">投保之产品或服务 Products/Services to be Covered</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.product_service}</td>
						</tr>
                        <tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">业务的特殊性 Business Particularity</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.particularity}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">合同中是否有物权保留条款 Is there retention of title clause in your contract</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${ vo1.is_retention_contract == 0 ? '否NO':'是YES'}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">销售常用的付款方式Typical Payment Terms of Your Sales</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${fns:getDictLabel(vo1.payment_terms,"paymentTerms","")}</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">否为买家提供较长赊账期 Do you allow long credit period</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${ vo1.period_extended}</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>3.销售额 Turnover</h3></div>
			<div class="text-center mt-20">
				<h5>最近三年销售记录</h5>
				<h5>Turnover of Credit Sales for Latest 3 Years</h5>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-4 col-xs-4">财务年度  Financial Year</td>
                            <td class="tablebg_f5f8fa col-sm-4 col-xs-4">国内贸易  Domestic</td>
                            <td class="tablebg_f5f8fa col-sm-4 col-xs-4">出口贸易  Export</td> 
                        </tr>
                        <tr>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[0].financial_year}</td>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[0].domestic}</td>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[0].export}</td> 
                        </tr>
                        <tr>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[1].financial_year}</td>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[1].domestic}</td>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[1].export}</td> 
                        </tr>
                        <tr>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[2].financial_year}</td>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[2].domestic}</td>
                            <td class="col-sm-4 col-xs-4">${vo1.recentYearsSellList[2].export}</td> 
                        </tr>
                   	</tbody>
				</table>
			</div>
			<%--<div class="mess-title"><h3>对争议解决方式的选择</h3></div>--%>
			<div class="text-center mt-20">
				<h5>上一财年出口销售组成</h5>
				<h5>Breakdowns of Export Credit Sales for Last Financial Year</h5>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">现金交易占比 Percentage of Cash Transactions</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.breakdowns_cash}%</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">信用证交易占比 Percentage of L/C Transactions</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.breakdowns_lc}%</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">关联交易占比 Percentage of Associated Transactions</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.breakdowns_associated}%</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">赊账交易占比 Percentage of O/A Transactions</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.breakdowns_oa}%</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">托收交易占比 Percentage of DP&DA Transactions</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.breakdowns_dpda}%</td>
						</tr>
						<tr>
							<td colspan="3" class="tablebg_f5f8fa col-sm-6 col-xs-6">合计 Total</td>
							<td colspan="1" class="col-sm-6 col-xs-6">${vo1.breakdowns_sum}%</td>
						</tr>
                   	</tbody>
				</table>
			</div> 
			<div class="text-center mt-20">
				<h5>预计2016年所须投保的信用销售总额（按国别分类）</h5>
				<h5>Forecasted Insurable Credit Sales Turnover in 2015(By Country)</h5>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">国别<br />Country</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">年销售额 <br />Annual Turnover</td>
                            <td class="tablebg_f5f8fa col-sm-4 col-xs-4">赊账期内最高的曝险赊销金额<br />Highest Credit Amount in Credit Period</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">买家个数<br />Number of Buyers</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">付款方式<br />Payment Terms</td>
                        </tr>
                        <c:forEach items="${ vo1.forecastedDetailList }" varStatus="index">
                        <tr>
                            <td class="col-sm-2 col-xs-2">${ vo1.forecastedDetailList[index.index].country}</td>
                            <td class="col-sm-2 col-xs-2">${ vo1.forecastedDetailList[index.index].annual_sales}</td>
                            <td class="col-sm-4 col-xs-4">${ vo1.forecastedDetailList[index.index].hca}</td> 
                            <td class="col-sm-2 col-xs-2">${ vo1.forecastedDetailList[index.index].buyers_num}</td>
                            <td class="col-sm-2 col-xs-2">${fns:getDictLabel (vo1.forecastedDetailList[index.index].payment_terms,"paymentTerms","")}</td>
                        </tr>
                        </c:forEach>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>4.应收账款余额分布 Distribution of A/R of Debtors</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="ta-left">截止日期As of:${vo2.ar_as_of}</td>
                        </tr> 
                   	</tbody>
				</table>
			</div> 
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td colspan="2" class="tablebg_f5f8fa col-sm-6 col-xs-6">内贸 Domestic</td>
                            <td></td>
                            <td colspan="2" class="tablebg_f5f8fa col-sm-6 col-xs-6">出口  Export</td> 
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">未偿债务总额<br />Total Outstanding</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">债务人数量<br />No. of Buyers</td>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">未偿债务<br />Amount Outstanding</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">债务人数量<br />No. of Buyers</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">未偿债务总额<br />Total Outstanding</td> 
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[0].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[0].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">1-10,000</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[0].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[0].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[1].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[1].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">10,001-20,000</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[1].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[1].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[2].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[2].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">20,001-50,000</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[2].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[2].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[3].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[3].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">50,001-100,000</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[3].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[3].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[4].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[4].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">100,001-500,000</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[4].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[4].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[5].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[5].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">500,001-1,000,000</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[5].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[5].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[6].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[6].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">1,000,001-5,000,000</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[6].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[6].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[7].domestic_total}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[7].domestic_buyers}</td>
                            <td class="col-sm-3 col-xs-3">5,000,000-∞</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[7].export_buyers}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.arDebtorsList[7].export_total}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.domestic_total_sum}</td>
                            <td class="col-sm-2 col-xs-2">${empty vo2.domestic_buyers_sum ? '': vo2.domestic_buyers_sum eq '0' ? '' : vo2.domestic_buyers_sum}</td>
                            <td class="col-sm-3 col-xs-3">总计Total</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.export_buyers_sum}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.export_total_sum}</td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>5.账龄及坏账分析 Breakdown of Debt Ages</h3></div>
			<div class="affirm-warr">
				<table class="table">
                       <tbody> 
                        <tr>
                            <td class="ta-left">截止日期As of:${vo2.as_of}</td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">内贸<br />Domestic</td>
                            <td class="col-sm-2 col-xs-2">${vo2.domestics}</td>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">企业销售变现天数<br />Days sales outstanding (DSO)</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">出口<br />Export</td>
                            <td class="col-sm-2 col-xs-2">${vo2.exports}</td> 
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">金额<br />Amount</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">占比<br />Percentage</td>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">账龄<br />Credit Period</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">金额<br />Amount</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">占比<br />Percentage</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[0].domestic_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[0].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[0].domestic_percentage}">%</c:if></td>
                            <td class="col-sm-3 col-xs-3">未到期 <br />Current</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[0].export_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[0].export_percentage}<c:if test="${not empty vo2.debtAgesList[0].export_percentage}">%</c:if></td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[1].domestic_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[1].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[1].domestic_percentage}">%</c:if></td>
                            <td class="col-sm-3 col-xs-3">超期01-30天<br />Overdue 01-30days</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[1].export_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[1].export_percentage}<c:if test="${not empty vo2.debtAgesList[1].export_percentage}">%</c:if></td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[2].domestic_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[2].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[2].domestic_percentage}">%</c:if></td>
                            <td class="col-sm-3 col-xs-3">超期31-60天<br />Overdue 31-60days</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[2].export_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[2].export_percentage}<c:if test="${not empty vo2.debtAgesList[2].export_percentage}">%</c:if></td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[3].domestic_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[3].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[3].domestic_percentage}">%</c:if></td>
                            <td class="col-sm-3 col-xs-3">超期61-90天<br />Overdue 61-90days</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[3].export_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[3].export_percentage}<c:if test="${not empty vo2.debtAgesList[3].export_percentage}">%</c:if></td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[4].domestic_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[4].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[4].domestic_percentage}">%</c:if></td>
                            <td class="col-sm-3 col-xs-3">超期＞90天<br />Overdue＞ 120days</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[4].export_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.debtAgesList[4].export_percentage}<c:if test="${not empty vo2.debtAgesList[4].export_percentage}">%</c:if></td>
                        </tr> 
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.domestic_amount_sum}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.domestic_percentage_sum}<c:if test="${not empty vo2.domestic_percentage_sum}">%</c:if></td>
                            <td class="col-sm-3 col-xs-3">总计Total</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.export_amount_sum}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.export_percentage_sum}<c:if test="${not empty vo2.export_percentage_sum}">%</c:if></td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="col-sm-10 col-xs-10">是否已有买方逾期31天以上?  If the buyer at least 31+ days</td>
                            <td class="col-sm-2 col-xs-2">${vo2.is_overdue_buyers == 0 ? '否NO':'是YES'}</td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<c:if test="${ vo2.is_overdue_buyers == 1 }">
			<div class="text-mt0">
				<p>Please provide details of customers that are 31+ days overdue or giving cause for concern</p>
				<p>如有买方逾期31天以上，请提供以下详细信息</p>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">买方名称/国家<br />Buyer Name/Country</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">总账款余额<br />Total Debt Outstanding</td>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">逾期账款<br />Overdue debt</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">最早到期日<br />Due Date</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">已执行的催收方案<br />Action taken</td>
                        </tr>
                        <c:forEach items="${ vo2.overdueDetailList }" varStatus="index">
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.overdueDetailList[index.index].country}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.overdueDetailList[index.index].total_debt}</td>
                            <td class="col-sm-3 col-xs-3">${vo2.overdueDetailList[index.index].debt}</td> 
                            <td class="col-sm-2 col-xs-2">${vo2.overdueDetailList[index.index].due_date}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.overdueDetailList[index.index].taken}</td> 
                        </tr> 
                        </c:forEach>
                   	</tbody>
				</table>
			</div>
			</c:if>
			<div class="text-center mt-20">
				<h5>坏账分析</h5> 
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">财务年度<br />Financial Year</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">坏账损失总计<br />Total Bad Debt</td>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">最大的单个坏账损失金额(人民币）<br />Largest Single Bad Debt Loss</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">坏账损失的个数<br />Number of Bad Debts</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">成功追回款项<br />Amounts Recovered</td>
                        </tr>
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[0].year}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[0].bad_debt_total}</td>
                            <td class="col-sm-3 col-xs-3">${vo2.badAnalysisList[0].bad_debt_loss}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[0].bad_debt_number}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[0].take_back_amount}</td> 
                        </tr> 
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[1].year}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[1].bad_debt_total}</td>
                            <td class="col-sm-3 col-xs-3">${vo2.badAnalysisList[1].bad_debt_loss}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[1].bad_debt_number}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[1].take_back_amount}</td> 
                        </tr> 
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[2].year}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[2].bad_debt_total}</td>
                            <td class="col-sm-3 col-xs-3">${vo2.badAnalysisList[2].bad_debt_loss}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[2].bad_debt_number}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.badAnalysisList[2].take_back_amount}</td> 
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<div class="text-center mt-20">
				<h5>过去三年中三笔最大的呆坏账详情</h5> 
				<h5>Details of 3 Largest Bad Debts Over the Past Three Years</h5>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">债务人 (姓名及地址)<br />Debtor(Name and Address)</td>
                            <td class="tablebg_f5f8fa col-sm-1 col-xs-1">年份<br />Year</td>
                            <td class="tablebg_f5f8fa col-sm-1 col-xs-1">国家<br />Country</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">付款条件<br />Payment Terms</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">坏账原因<br />Reason of Bad Debts</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">坏账金额<br />Amount of Bad Debts</td>
                            <td class="tablebg_f5f8fa col-sm-1 col-xs-1">处理现状<br />Status</td>
                        </tr>
                        <tr>
                            <td class="col-sm-3 col-xs-3">${vo2.pastBadDetailList[0].debtor}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[0].before_year}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[0].country}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[0].payment_terms}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[0].reason}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[0].debtamount}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[0].bad_status}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-3 col-xs-3">${vo2.pastBadDetailList[1].debtor}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[1].before_year}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[1].country}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[1].payment_terms}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[1].reason}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[1].debtamount}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[1].bad_status}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-3 col-xs-3">${vo2.pastBadDetailList[2].debtor}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[2].before_year}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[2].country}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[2].payment_terms}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[2].reason}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.pastBadDetailList[2].debtamount}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.pastBadDetailList[2].bad_status}</td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>6.投保的前十大买家（按赊销额） Top 10 Buyers to be Covered（by Credit Sales Turnover）</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">名称<br />Customer Name</td>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">地址<br />Address</td>
                            <td class="tablebg_f5f8fa col-sm-1 col-xs-1">国别<br />Country</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-3">付款方式<br />Payment Terms</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">年赊销金额<br />Annual Credit Amount</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">信用限额需求**<br />Limit Requested</td> 
                        </tr>
                        <c:forEach items="${ vo2.topBuyersList }" varStatus="index">
                        <tr>
                            <td class="col-sm-2 col-xs-2">${vo2.topBuyersList[index.index].customer_name}</td>
                            <td class="col-sm-3 col-xs-3">${vo2.topBuyersList[index.index].address}</td>
                            <td class="col-sm-1 col-xs-1">${vo2.topBuyersList[index.index].country}</td>
                            <td class="col-sm-2 col-xs-3">${fns:getDictLabel (vo2.topBuyersList[index.index].payment_terms,"paymentTerms","")}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.topBuyersList[index.index].credit_amount}</td>
                            <td class="col-sm-2 col-xs-2">${vo2.topBuyersList[index.index].amount_requested}</td>
                        </tr>
                        </c:forEach>
                   	</tbody>
				</table>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="col-sm-10 col-xs-10 c-red">是否同意保险公司联系买家并透露投保人名字  Agree the Insurance company to contact the buyer and disclose your company name</td>
                            <td class="col-sm-2 col-xs-2">${vo2.is_disclose_name == 0 ? '否NO':'是YES'}</td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<div class="text-mt0">
				<p>信用限额需求可设定为单个买家最高曝险金额，具体可以未来一年内该买家的最高应收账款额为参考</p>
				<p>Credit limit is usually set as the maximum exposure towards each single buyer, with the maximum aggregate A/R outstanding towards each buyer being a good reference.</p>
			</div>
			<div class="mess-title"><h3>7.公司信用管理 In-house Credit Management</h3></div>
			<div class="text-center mt-20">
				<h5>何时开具发票?  When are invoices issued?</h5> 
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-6 col-xs-6">货物发送日后Day after despatch/delivery</td>
                            <td class="col-sm-6 col-xs-6">${vo3.delivery}</td> 
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa  col-sm-6 col-xs-6">其它 – 请注明何时  Other – please state when</td>
                            <td class="col-sm-6 col-xs-6">${vo3.other_date}</td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			<div class="text-center mt-20">
				<h5>负责信用风险控制和管理人员的详细资料</h5>
				<h5>Details of all staff with responsibility for credit risk management and control</h5>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-4 col-xs-4">职务 Job Title</td>
                            <td class="tablebg_f5f8fa col-sm-4 col-xs-4">职责范围 Responsibility</td> 
                            <td class="tablebg_f5f8fa col-sm-4 col-xs-4">授权等级 Level of Authority</td> 
                        </tr>
                        <tr>
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[0].job_title}</td>
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[0].responsibility}</td> 
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[0].level}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[1].job_title}</td>
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[1].responsibility}</td> 
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[1].level}</td> 
                        </tr>
                        <tr>
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[2].job_title}</td>
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[2].responsibility}</td> 
                            <td class="col-sm-4 col-xs-4">${vo3.managerDetailList[2].level}</td> 
                        </tr>
                   	</tbody>
				</table>
			</div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="col-sm-10 col-xs-10">是否每个客户都被授予内部信用额度?  Is each customer allocated an internal credit limit?</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_creditlimit == 0 ? '否NO':'是YES'}</td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<c:if test="${ vo3.is_creditlimit == 1}">
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="col-sm-10 col-xs-10">如果以上回答为“是”，请提供内部信用额度审批所依据信息的主要获取渠道（如付款表现，企业年报，实地拜访等），并陈述针对新买方/已有买方如何应用。Please provide details on a separate sheet of all information sources (payment performance, annual accounts, visits, etc.) used in setting internal credit limits. Please advice from what level they are used for new / existing customers.</td>
                        </tr>
                        <tr>
                        	<td>${ vo3.provide_details}<c:if test="${not empty vo3.material_path}"><a href="javascript:void(0);" onclick="sodownload('${ vo3.material_path}','补充材料');">补充材料下载</a></c:if>&nbsp;</td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			</c:if>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-5 col-xs-5">应收帐款如何催收?<br/>How are debts collected?</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">是Yes  <br/>/ 否No</td> 
                            <td class="tablebg_f5f8fa col-sm-5 col-xs-5">自到期日至采取行动日的天数<br/>By what day from due date?</td> 
                        </tr>
                        <tr>
                            <td class="col-sm-5 col-xs-5">到期日前致电客户<br/>Telephone calls BEFORE due date</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_expire_before == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${ vo3.expire_before_now}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-5 col-xs-5">到期日后致电客户<br/>Telephone calls AFTER due date</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_expire_after == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${ vo3.now_expire_after}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-5 col-xs-5">催收信函<br/>Chasing letters</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_chasing_letters == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${ vo3.chasing_letters}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-5 col-xs-5">暂停发货<br/>Deliveries suspended</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_deliveries_suspended == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${vo3.deliveries_suspended_day}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-5 col-xs-5">实地拜访<br/>Visits</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_visits == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${ vo3.visits_day}</td>
                        </tr>
                         <tr>
                            <td class="col-sm-5 col-xs-5">委托追帐公司<br/>Debt collectors</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_debt_collectors == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${ vo3.debt_collectors_day}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-5 col-xs-5">诉诸法律手段<br/>Legal action</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_legal_action == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${ vo3.legal_action_day}</td>
                        </tr>
                        <tr>
                            <td class="col-sm-5 col-xs-5">其它 – 请详述<br/>Others – please specify</td>
                            <td class="col-sm-2 col-xs-2">${ vo3.is_others == 0 ? '否NO':'是YES'}</td>
                             <td class="col-sm-5 col-xs-5">${ vo3.others_day}</td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>8. 争议处理 Settlement of Disputes</h3></div> 
			<div class="affirm-warr">
				<p class="mt30">本保险合同项下的争议解决方式：</p>
				<p>According to Policy Article 5.08,  the Insured and CPIC need to choose either of the following dispute resolution mechanism for settlement of disputes under this insurance:</p>
				<p>5.08 因履行本保险合同发生的争议，由被保险人和保险人友好协商解决，协商不成的，提交  ${vo3.arbitral_institution}  仲裁委员会仲裁；</p>
				<p>All disputes arising from the performance of this insurance shall be resolved by the Insured and CPIC through friendly negotiation. If a dispute </p>
				<p class="mb30">cannot be settled through friendly negotiation, it shall be submitted to Arbitration Commission for arbitration. </p> 
			</div>
			<div class="mess-title"><h3>9.投保人申明 Declaration</h3></div>
			<div class="affirm-warr">
				<p class="mt30">本公司在此申明，本投保单及其附件中所提供的信息均属实无误，且构成与保险人签订的正式保单的基础。本公司承担在正式保单生效前向保险人告知任何重要信息变更的义务。</p>
				<p>本公司理解，除非之后的正式保单开始生效，否则本投保单对双方都不具约束力。以下签名为本公司授权人，代表本公司签订本投保单。</p>
				<p class="mb30">We declare that the information given is to the best of our knowledge true and accurate and that this proposal form and any attaching information form the basis of the insurance policy between us and CPIC. We undertake to advice of any change to a material fact prior to completion of this insurance policy. We understand that signing this proposal form does not bind us unless an insurance policy is subsequently incepted. The signature below is that of an individual who is authorised to sign on behalf of the company in this capacity.</p>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
	<div class="row next-step">
		<div class="col-sm-6 col-sm-6">
			<div class="insure-check">
				<span class="check-box pull-left">
					<input type="checkbox" id="checkbox1_ss" />
					<label for="checkbox1_ss"></label>
				</span>
				<span class="pull-left">我已仔细阅读并同意以上声明与保证事项及<a target="_blank" href="<c:url value='/synopsis/clause/my01'/>">《出口贸易信用保险（短期）条款》</a></span><br /> 
			</div> 
		</div>
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p>
				<a href="<c:url value='/insurance/customs/policy/qy_policy/${dto.oid}/1?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="save">返回修改</a>
				<a href="javascript:void(0);" onclick="validateChecked('${dto.oid}');" id="validatePost" class="ns-btn">确认申请</a>
			</p>
			<!--确认投保单详情<p>
				<a href="javascript:;" class="save">下载保单</a>
				<a href="javascript:;" class="save ml-35">下载保函</a>
			</p>-->
		</div>
	</div>
</div><!-- container end --> 

<!-- 内容部分  注册  结束 -->
<jsp:include page="../../../index/multi_f.jsp" />
<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
	<input name="path" id="path-dow" type="hidden">
	<input name="name" id="name-dow" type="hidden">
</form>
<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function validateMsg(){
		layer.msg("请先打印投保单将其盖上贵公司公章并通过“上传投保单”按钮上传盖公章后的投保单方可申请！");
	}
	$(function(){
	    $("td").each(function(){
	        var _class = $(this).attr("class");
	        if(_class != undefined){
	            if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
	                console.log($(this).prev());
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
	function validateChecked(_id){
		if($("#checkbox1_ss").is(':checked')){
			var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
			$.ajax({
				type: 'POST',
				url:baseUrl + '/insurance/customs/policy/updateOrderFormStatus',
				data:{
					'order_id':_id,
					'status':'2'
				},
				dataType:"json",
				success: function(json){
					layer.close(index);
					if(json.statusCode == '200') {
						window.location.href = baseUrl + '/insurance/customs/policy/policyPayment/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
					}else{
						layer.msg(json.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}else{
			layer.msg("请勾选“我已仔细阅读并同意以上声明与保证事项及《出口贸易信用保险（短期）条款》”！");
			/* layer.confirm('"请勾选“我同意以上告知和声明”！"', {
				  btn: ['确定'] //按钮
				}, function(){
					layer.closeAll();
				}); */
		}
			
	}
	function sodownload(path,name){
		path = path.split(".com/")[1];
		$("#path-dow").val(path);
		$("#name-dow").val(name);
		$("#dow-now").submit();
	}
	function showInsureModal(){
		$("#insureModal").modal("show");
	}
	
	function showPrintPolicyModal(policyId){
		layer.open({
			  type: 2,
			  title:'投保单预览',
			  scrollbar: false,
			  area : [ '70%', '90%' ],
			  shade : 0.8,
			  skin: 'agreementModal',
			  btn: ['打印','取消'],
			  content: baseUrl +'/insurance/transaction/printPolicy/'+policyId+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
			  yes:function(indexIframe, layero){
			    var iframeWin = window[layero.find('iframe')[0]['name']]; //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
			    iframeWin.printPage();
			  }
		});
	}
	function uploadInsure(){
		var policyId = $("#policyId").val();
		var insurePath = $("#insurePath_file-5").val();
		 if(insurePath ==""){
			layer.msg("请选择投保单");
		}
		else{
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$("#insureForm").ajaxSubmit({
				success : function(data) {
					layer.close(index);
					layer.msg(data.message);
					if(data.status == "200"){
						$("#insureModal").modal("hide");
						$("#validatePost").attr("href","javascript:validateChecked(${dto.oid});");
					}
				},
				error : function() {
					layer.close(index);
					alert('error');
				}
			});
		}
	}
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
</body>
</html>