<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
	</head>
<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保</li>
	</ol>    --%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-3">
				<p><i class="pull-left">3</i><span class="pull-left">投保信息审核</span></p>
			</div>
			<div class="col-sm-3 col-sm-3 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left"> 缴费通知</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/customs/policy/confirmPage?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
      	<input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
        <input type="hidden" name="product_id" id="product_oid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>披露与陈述Disclosure and Representation</h3></div> 
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<p><strong>在填写本投保单前，请先仔细阅读本投保单所附贸易信用保险条款（特别是黑体字部分的内容）。本投保单及任何附件的具体陈述共同构成投保资料且足以作为出具正式保单的基础。所有可能影响风险评估和承保的重要信息必须充分如实披露。 对于不能确定其是否为重要信息的，亦应充分披露。未尽以上披露和陈述义务将给予保险人取消保单并拒绝理赔的权利。如有必要，可另行附纸回答并加附其它相关文件。</strong></p>
				<p><strong>Before filling up this proposal form, please read attached  Trade Credit Insurance clause thoroughly and pay special attention to those bold clauses. This proposal form and any supporting documents, details and representations constitute Proposal Information and form the basis of the insurance policy.
	All material facts and information that are likely to influence the assessment or acceptance of this risk should be fully disclosed. If in doubt as to whether anything is material, it should be included.  Failure to disclose or truthfully represent material facts and information entitles CPIC to void the policy or avoid claims. Please continue answers on a separate sheet and attach additional documentation as necessary.</strong></p>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<!-- <div class="message-war">message-war start
			<div class="title-war"><h3>投保信息录入方式</h3></div> 
			<div class="row w-95-auto">w-95-auto start
				<p>您可以直接在下方进行投保信息的录入，也可以<a href="javascript:;">点击此处下载投保单模板</a>,完成模板填写之后在此进行上传导入<input type="button" value="上传Execl文档" class="pl-0"></p>
			</div>w-95-auto end
		</div> --><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>推荐人信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-4 col-xs-4">
					<p>推荐人的手机号或编号</p>
					<input type="text" name="recommend_code" id="recommendCode" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
				<div class="col-sm-4 col-xs-4">
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3 id="cy_lxr">1.申请人基本信息 Basic Information of Applicant</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start --> 
				<input type="hidden" name="roleSubjectList[0].oid" id="appRoleID" value="${vo.roleSubjectList[0].oid}"/>
				<input type="hidden" name="roleSubjectList[0].kind" id="kind" value="3"/>
				<input type="hidden" name="roleSubjectList[0].role_type" id="roleType" value="1"/>
				<div class="col-sm-3 col-xs-3">
					<p>*公司中文名称 Name of Applicant</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="name_cn" value="${vo.roleSubjectList[0].name_cn}" class="form-control" placeholder="" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>公司英文名称 Name of Applicant</p>
					<input type="text" name="roleSubjectList[0].name_en" id="name_en" value="${vo.roleSubjectList[0].name_en}" class="form-control" placeholder="company name" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*企业注册号 Registration No.</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].aaum_code" id="aaumCode" value="${vo.roleSubjectList[0].aaum_code}" class="form-control" placeholder="" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>成立日期 Date of Establishment</p>
					<input name="roleSubjectList[0].register_date" id="registerDate" value="${vo.roleSubjectList[0].register_date}" placeholder="" class="laydate-icon form-control" onclick="laydate({istime: true, format: 'YYYY-MM-DD'})">
				</div> 
				<div class="clear"></div>
				<div class="col-sm-9 col-xs-9">
					<p>*注册地址 Place of Incorporation</p>
					<div class="row">
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
								<option value="">请选择省</option>
								<c:forEach items="${provinceList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
								<option value="">请选择市</option>
								<c:forEach items="${reg_cityList }" var="list">
									<option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-2 col-xs-2">
							<select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
								<option value="">请选择县</option>
								<c:forEach items="${reg_areaList }" var="list">
									<option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
								</c:forEach>
							</select>
						</div>
						<div class="col-sm-6 col-xs-6">
							<input Data-Val="Required" title="详细地址" type="text" name="roleSubjectList[0].reg_address" id="app_address" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写详细地址" onblur="validateForms(this)" />
						</div>
					</div>
				</div>
				<%--<div class="col-sm-6 col-xs-6">
					<p>*注册地址 Place of Incorporation</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].reg_address" id="regAddress" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="" />
				</div>--%>
				<div class="col-sm-3 col-xs-3">
					<p>*联系人 Contact Name</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].link_name" id="linkName" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>联系人职务 Position of Contact Person</p>
					<input type="text" name="roleSubjectList[0].link_duty" id="linkDuty" value="${vo.roleSubjectList[0].link_duty}" class="form-control" placeholder="" />
				</div> 
				<div class="col-sm-3 col-xs-3">
					<p>*电话 Telephone</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].link_phone" id="linkPhone" value="${vo.roleSubjectList[0].link_phone}" class="form-control" placeholder="" />
				</div> 
				<div class="col-sm-3 col-xs-3">
					<p>传真 Fax</p>
					<input type="text" name="roleSubjectList[0].link_fax" id="linkFax" value="${vo.roleSubjectList[0].link_fax}" class="form-control" placeholder="" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>电邮地址 E-mail</p>
					<input type="text" name="roleSubjectList[0].link_email" id="linkEmail" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="" />
				</div> 
				
				<div class="col-sm-3 col-xs-3">
					<p>*企业性质 Type of Organization</p>
					<select Data-Val="Required" name="roleSubjectList[0].com_type" id="comType" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">请选择企业性质</option>
						<c:forEach items="${listType }" var="list">
						<option value="${list.value }" <c:if test="${list.value eq vo.roleSubjectList[0].com_type}"> selected="selected"</c:if>>${list.label }</option>
						</c:forEach>
					</select> 
				</div>
				
				<div class="col-sm-3 col-xs-3">
					<p>*投保业务类别 Business Nature</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].business_nature" id="businessNature" value="${vo.roleSubjectList[0].business_nature}" class="form-control" placeholder="" />
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*买方所属行业 Sectors Sold To</p>
					<input Data-Val="Required" type="text" name="roleSubjectList[0].sectors_sold" id="sectorsSold" value="${vo.roleSubjectList[0].sectors_sold}" class="form-control" placeholder="" />
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12">
					<p>*投保人关联企业信息 Details of Associated Companies</p>
					<textarea Data-Val="Required" name="roleSubjectList[0].companies_detail" id="companiesDetail" class="text-w form-control">${vo.roleSubjectList[0].companies_detail}</textarea>
				</div>
				<div class="col-sm-12 col-xs-12"> 
					<p>*是否已有信用险保单 Any existing credit insurance cover</p> 
					<div class="col-sm-8 col-xs-8">
						<div class="row">
							<div class="col-sm-2 col-xs-2 rad-io">
								<span><input type="radio" name="roleSubjectList[0].id_insurance" value="0" id="idInsurance_1" <c:if test="${empty vo.roleSubjectList[0].id_insurance}"> checked="checked"</c:if> <c:if test="${not empty vo.roleSubjectList[0].id_insurance && vo.roleSubjectList[0].id_insurance eq '0' }"> checked="checked"</c:if>><label for="idInsurance_1" class="pull-left"></label><strong  class="pull-left">否 No</strong></span>
							</div>
							<div class="col-sm-2 col-xs-2 rad-io">
								<span><input type="radio" name="roleSubjectList[0].id_insurance" value="1" id="idInsurance_2" <c:if test="${not empty vo.roleSubjectList[0].id_insurance && vo.roleSubjectList[0].id_insurance eq '1' }"> checked="checked"</c:if>><label for="idInsurance_2" class="pull-left"></label><strong  class="pull-left">是 YES</strong></span>
							</div>
							<!--<div class="col-sm-3 col-xs-3  "> 
								<p><input type="text" class="form-control" placeholder="" /></p>
							</div>--> 
							<div class="col-sm-8 col-xs-8"> 
								<input type="text" name="roleSubjectList[0].insurance_name" id="insuranceName" value="${vo.roleSubjectList[0].insurance_name}" class="form-control" placeholder="如是，保险公司名称if yes,name of insurance company" />
							</div>
						</div>
					</div> 
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>*投保币种  (以下所提供的资料皆以此币种表示)Currency Required (to be used for all information provided)</p>
					<select Data-Val="Required" name="roleSubjectList[0].currency_required" id="currencyRequired" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">请选择币种</option>
						<c:forEach items="${listCurrency }" var="list">
						<option value="${list.value }" <c:if test="${list.value eq vo.roleSubjectList[0].currency_required}"> selected="selected"</c:if>>${list.label }</option>
						</c:forEach>
					</select> 
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>*预计未来12个月的投保营业额Estimated Insurable Turnover of next 12 months</p>
					<input Data-Val="Point" type="text" name="roleSubjectList[0].turnover_domestic" id="turnover_domestic" value="${vo.roleSubjectList[0].turnover_domestic}" class="form-control" placeholder="内贸 Domestic" />
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>&nbsp;</p>
					<input Data-Val="Point Required" type="text" name="roleSubjectList[0].turnover_export" id="turnover_export" value="${vo.roleSubjectList[0].turnover_export}" class="form-control mt-30" placeholder="出口 Export" />
				</div> 
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>2.业务描述 Business Description</h3></div> 
			<div class="row w-95-auto"><!-- w-95-auto start --> 
				<div class="col-sm-6 col-xs-6">
					<p>*投保之产品或服务 Products/Services to be Covered</p>
					<input Data-Val="Required" type="text" name="product_service" id="productService" value="${vo.product_service}" class="form-control" placeholder="" />
				</div> 
				<div class="col-sm-12 col-xs-12">
					<p>*业务的特殊性 Business Particularity</p>
					<textarea Data-Val="Required" name="particularity" id="particularity" class="text-w form-control">${vo.particularity}</textarea>
				</div>
				<div class="col-sm-12 col-xs-12"> 
					<p>*合同中是否有物权保留条款 Is there retention of title clause in your contract</p> 
					<div class="col-sm-8 col-xs-8">
						<div class="row">
							<div class="col-sm-2 col-xs-2 rad-io">
								<span><input type="radio" value="0" name="is_retention_contract" id="isRetentionContract_1" <c:if test="${empty vo.is_retention_contract}"> checked="checked"</c:if> <c:if test="${not empty vo.is_retention_contract && vo.is_retention_contract eq '0' }"> checked="checked"</c:if>><label for="isRetentionContract_1" class="pull-left"></label><strong  class="pull-left">否 No</strong></span>
							</div>
							<div class="col-sm-2 col-xs-2 rad-io">
								<span><input type="radio" value="1" name="is_retention_contract" id="isRetentionContract_2" <c:if test="${not empty vo.is_retention_contract && vo.is_retention_contract eq '1' }"> checked="checked"</c:if>><label for="isRetentionContract_2" class="pull-left"></label><strong  class="pull-left">是 YES</strong></span>
							</div> 
						</div>
					</div> 
				</div> 
				<div class="col-sm-4 col-xs-4">
					<p>*销售常用的付款方式Typical Payment Terms of Your Sales</p>
					<select Data-Val="Required" name="payment_terms" id="payment_terms" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="" >请选择付款方式</option>
						<c:forEach items="${listPaymentTerms }" var="list">
						<option value="${list.value }" <c:if test="${list.value eq vo.payment_terms}"> selected="selected"</c:if>>${list.label }</option>
						</c:forEach>
					</select>
				</div>
				<div class="col-sm-8 col-xs-8">
					<p>*否为买家提供较长赊账期Do you allow long credit period</p>
					<input Data-Val="Required" type="text" name="period_extended" id="periodExtended" value="${vo.period_extended}" class="form-control" placeholder="如“是”，请告知最长的赊账期If“yes”,please specify the longest credit period extended" />
				</div> 
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>3.销售额 Turnover</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="text-center mt-20">
					<h5>最近三年销售记录</h5>
					<h5>Turnover of Credit Sales for Latest 3 Years</h5>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p class="text-center">*财务年度Financial Year</p>
				</div> 
				<div class="col-sm-4 col-xs-4">
					<p class="text-center">国内贸易Domestic</p>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p class="text-center">*出口贸易Export</p>
				</div>
				<div class="clearfix">
					<input type="hidden" name="recentYearsSellList[0].oid" value="${vo.recentYearsSellList[0].oid}" />
					<div class="col-sm-4 col-xs-4 mt-20">
						<input Data-Val="Num Required" type="text" name="recentYearsSellList[0].financial_year" id="turnover_financialYear_1" value="${vo.recentYearsSellList[0].financial_year}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point" type="text" name="recentYearsSellList[0].domestic" id="turnover_domestic_1" value="${vo.recentYearsSellList[0].domestic}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point Required" type="text" name="recentYearsSellList[0].export" id="turnover_export_1" value="${vo.recentYearsSellList[0].export}" class="form-control" placeholder="" />
					</div> 
				</div>
				<div class="clearfix">
					<input type="hidden" name="recentYearsSellList[1].oid" value="${vo.recentYearsSellList[1].oid}" />
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Num Required" type="text" name="recentYearsSellList[1].financial_year" id="turnover_financialYear_2" value="${vo.recentYearsSellList[1].financial_year}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point" type="text" name="recentYearsSellList[1].domestic" id="turnover_domestic_2" value="${vo.recentYearsSellList[1].domestic}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point Required" type="text" name="recentYearsSellList[1].export" id="turnover_export_2" value="${vo.recentYearsSellList[1].export}" class="form-control" placeholder="" />
					</div> 
				</div>
				<div class="clearfix">
					<input type="hidden" name="recentYearsSellList[2].oid" value="${vo.recentYearsSellList[2].oid}" />
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Num Required" type="text" name="recentYearsSellList[2].financial_year" id="turnover_financialYear_3" value="${vo.recentYearsSellList[2].financial_year}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point" type="text" name="recentYearsSellList[2].domestic" id="turnover_domestic_3" value="${vo.recentYearsSellList[2].domestic}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point Required" type="text" name="recentYearsSellList[2].export" id="turnover_export_3" value="${vo.recentYearsSellList[2].export}" class="form-control" placeholder="" />
					</div> 
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				
				<div class="text-center mt-20">
					<h5>上一财年出口销售组成</h5>
					<h5>Breakdowns of Export Credit Sales for Last Financial Year</h5>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>现金交易占比Percentage of Cash Transactions</p>
					<input Data-Val="Point" type="text" name="breakdowns_cash" id="breakdowns_Cash" value="${vo.breakdowns_cash}" class="form-control text-right pr-40" placeholder="" />
					<span class="po-r15-b8">%</span>
				</div> 
				<div class="col-sm-3 col-xs-3">
					<p>信用证交易占比Percentage of L/C Transactions</p>
					<input Data-Val="Point" type="text" name="breakdowns_lc" id="breakdowns_Lc" value="${vo.breakdowns_lc}" class="form-control text-right pr-40" placeholder="" />
					<span class="po-r15-b8">%</span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>关联交易占比Percentage of Associated Transactions</p>
					<input Data-Val="Point" type="text" name="breakdowns_associated" id="breakdowns_Associated" value="${vo.breakdowns_associated}" class="form-control text-right pr-40" placeholder="" />
					<span class="po-r15-b8">%</span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>赊账交易占比Percentage of O/A Transactions</p>
					<input Data-Val="Point" type="text" name="breakdowns_oa" id="breakdowns_Oa" value="${vo.breakdowns_oa}" class="form-control text-right pr-40" placeholder="" />
					<span class="po-r15-b8">%</span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>托收交易占比Percentage of DP&DA Transactions</p>
					<input Data-Val="Point" type="text" name="breakdowns_dpda" id="breakdowns_Dpda" value="${vo.breakdowns_dpda}" class="form-control text-right pr-40" placeholder="" />
					<span class="po-r15-b8">%</span>
				</div>
				<div class="col-sm-3 col-xs-3 mt-60">
					<input type="hidden" name="breakdowns_sum" id="breakdowns_sum">
					<p>合计 <strong>Total:&nbsp;<span id="breakdowns_Total"><c:if test="${not empty vo.breakdowns_sum}">${vo.breakdowns_sum}%</c:if></span></strong></p>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				
				<div class="text-center mt-20">
					<h5 class="c-red">预计未来一年内所须投保的信用销售总额（按国别分类）</h5>
					<h5>Forecasted Insurable Credit Sales Turnover in 2015(By Country)</h5>
				</div>
				<div class="col-sm-2 col-xs-2">
					<p class="text-center">*国别<br/>Country</p>
				</div> 
				<div class="col-sm-2 col-xs-2">
					<p class="text-center">*年销售额<br/>Annual Turnover</p>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p class="text-center">*赊账期内最高的曝险赊销金额<br/>Highest Credit Amount in Credit Period</p>
				</div>
				<div class="col-sm-2 col-xs-2">
					<p class="text-center">*买家个数<br/>Number of Buyers</p>
				</div>
				<div class="col-sm-2 col-xs-2">
					<p class="text-center">*付款方式<br/>Payment Terms</p>
				</div>
				<c:if test="${empty vo.forecastedDetailList}">
				<input type="hidden" name="forecasted_num" id="forecasted_num" value="1">
				<div class="clearfix forecasted_num_1">
					<input type="hidden" name="forecastedDetailList[0].oid" id="forecasted_oid_0" value="">
					<div class="col-sm-2 col-xs-2 mt-20"> 
						<input Data-Val="Required" type="text" name="forecastedDetailList[0].country" id="forecasted_country_0" value="" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-2 col-xs-2 mt-20"> 
						<input Data-Val="Point Required" type="text" name="forecastedDetailList[0].annual_sales" id="forecasted_annualSales_0" value="" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point Required" type="text" name="forecastedDetailList[0].hca" id="forecasted_hca_0" value="" class="form-control" placeholder="" />
					</div> 
					<div class="col-sm-2 col-xs-2 mt-20"> 
						<input Data-Val="Num Required" type="text" name="forecastedDetailList[0].buyers_num" id="forecasted_buyersNum_0" value="" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-2 col-xs-2 mt-20"> 
						<select Data-Val="Required" name="forecastedDetailList[0].payment_terms" id="forecasted_paymentTerms_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
							<option value="">请选择付款方式</option>
							<c:forEach items="${listPaymentTerms }" var="list">
							<option value="${list.value }">${list.label }</option>
							</c:forEach>
						</select>
					</div> 
				</div>
				</c:if>
				<c:if test="${ vo.forecastedDetailList.size()>0}">
				<input type="hidden" name="forecasted_num" id="forecasted_num" value="${vo.forecastedDetailList.size()}">
				<c:forEach items="${ vo.forecastedDetailList }" varStatus="index">
				<div class="clearfix forecasted_num_${index.index+1}">
					<input type="hidden" name="forecastedDetailList[${index.index}].oid" id="forecasted_oid_${index.index}" value="${vo.forecastedDetailList[index.index].oid}">
					<div class="col-sm-2 col-xs-2 mt-20"> 
						<input Data-Val="Required" type="text" name="forecastedDetailList[${index.index}].country" id="forecasted_country_${index.index}" value="${ vo.forecastedDetailList[index.index].country}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-2 col-xs-2 mt-20"> 
						<input Data-Val="Point Required" type="text" name="forecastedDetailList[${index.index}].annual_sales" id="forecasted_annual_sales_${index.index}" value="${ vo.forecastedDetailList[index.index].annual_sales}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-4 col-xs-4 mt-20"> 
						<input Data-Val="Point Required" type="text" name="forecastedDetailList[${index.index}].hca" id="forecasted_hca_${index.index}" value="${ vo.forecastedDetailList[index.index].hca}" class="form-control" placeholder="" />
					</div> 
					<div class="col-sm-2 col-xs-2 mt-20"> 
						<input Data-Val="Num Required" type="text" name="forecastedDetailList[${index.index}].buyers_num" id="forecasted_buyersNum_${index.index}" value="${ vo.forecastedDetailList[index.index].buyers_num}" class="form-control" placeholder="" />
					</div>
					<div class="col-sm-2 col-xs-2 mt-20">
						<select Data-Val="Required" name="forecastedDetailList[${index.index}].payment_terms" id="forecasted_paymentTerms_${index.index}" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
							<option value="">请选择付款方式</option>
							<c:forEach items="${listPaymentTerms }" var="list">
							<option value="${list.value }" <c:if test="${list.value eq vo.forecastedDetailList[index.index].payment_terms }"> selected="selected"</c:if>>${list.label }</option>
							</c:forEach>
						</select>
						<%-- <input Data-Val="Required" type="text" name="forecasted_paymentTerms_${index.index}" id="forecasted_paymentTerms_${index.index}" value="${ mapPolicy[forecasted_paymentTerms]}" class="form-control" placeholder="" /> --%>
					</div> 
				</div>
				</c:forEach>
				</c:if>
				<div class="col-sm-12 col-xs-12 text-center add-a-line" onclick="doDIVMOD(this, 'forecasted','add','20');"><span><i class="glyphicon glyphicon-plus"></i> 添加</span></div> 
				<div class="col-sm-12 col-xs-12 text-center remove-a-line" <c:if test='${empty vo.forecastedDetailList ? true : vo.forecastedDetailList.size()<2}'> style="display: none;"</c:if>  onclick="doDIVMOD(this, 'forecasted','delete','20');"><span><i class="glyphicon glyphicon-minus"></i> 删除</span></div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		</form>
		<div class="row next-step">
			<div class="col-sm-12 col-xs-12 text-right pull-right">
				<p>
					<a href="javascript:void(0);" onclick="saveCommonExportInfo('1');" id="pendingInfo" class="save">暂存本页</a>
					<a href="javascript:void(0);" onclick="save_policy_my();" class="ns-btn">下一步</a>
				</p>
			</div>
		</div>
	</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<jsp:include page="../../../index/multi_f.jsp" />
</body>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script src="<c:url value='/resources/commonJS/con-common.js'/>" type="text/javascript"></script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/customs_enterBasicInfo.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>

<script>
	$(function () {
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });
		function addCylxr(){
			//点击联系人
			$('.contacts_modal ul li').click(function () {
				$('.contacts_modal ul li').removeClass('active');
				$(this).addClass('active');
				if(!$('.contacts-bottom .sure').hasClass('sure_color')){
					$('.contacts-bottom span.sure').addClass('sure_color');
				}
			});
			//点击取消
			$('.contacts-bottom .cancel').click(function () {
				$('.contacts_modal').hide();
				$('.black-mask').hide();
				$('.contacts_modal ul li').removeClass('active');
			});
			$('.contacts_modal .title-cancel').click(function () {
				$('.contacts_modal').hide();
				$('.black-mask').hide();
				$('.contacts_modal ul li').removeClass('active');
			});
			//点击填入
			$('.contacts-bottom .sure').click(function () {
				if($(this).hasClass('sure_color')){
					setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
					$('.contacts_modal').hide();
					$('.black-mask').hide();
					$('.contacts_modal ul li').removeClass('active');
				}else{
					//没有点击选择联系人
					// alert('请选择一个联系人！');
				}
			})
			var _html = '1.申请人基本信息 Basic Information of Applicant<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals()">选择常用投保人</a>';
			$("#cy_lxr").html(_html);
		}
		function setTBR(_json){
			var json = eval("(" + _json + ")");
            $("#name_cn").val(json.company_name);//企业名称
            $("#app_address").val(json.address);//详细地址
            $("#regProvince").val(json.province);//省
            $("#regProvince").change();
            setTimeout(function(){
                $("#regCity").val(json.city);//市
                $("#regCity").change();
                setTimeout(function(){
                    $("#regDistrict").val(json.district);//区
                },1000);
            },1000);
            $("#linkName").val(json.user_name);//联系人
            $("#linkEmail").val(json.email);//邮箱
		}
	})
	//点击弹窗出现
	function showContractsModals() {
		$('.contacts_modal').show();
		$('.black-mask').show();
	}

</script>
<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
function save_policy_my(){
	if(customsVerify()){
		var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
		$.ajax({
			type: 'POST',
			url:baseUrl + '/insurance/customs/policy/pendingCommonExportVo_1Policy',
			data:$("#policyInfoForm").serialize(),
			dataType:"json",
			success: function(json){
				layer.close(index);
				if(json.statusCode == '200') {
					window.location.href = baseUrl + '/insurance/customs/policy/qy_policy/'+json.navTabId+'/2'+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
				}else{
					layer.msg(json.message);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.close(index);
				layer.msg(textStatus);
			}
		});
	}
}
function changeDistrict(districtID, areaID, level, obj) {
    $("#" + districtID).empty();
    if(areaID != '') {
        $("#" + areaID).empty();
        $("#" + areaID).append("<option value=''>--请选择区县--</option>");
    }
    var code = obj.value;
    $.ajax({
        type: 'POST',
        url: baseUrl + '/synopsis/findCity.json',
        data:{"codeLevel":level,"parentCode":code},
        dataType:"json",
        async: false,
        success: function(json) {
            if(level == '2') {
                $("#" + districtID).append("<option value=''>请选择市</option>");
            } else if(level == '3') {
                $("#" + districtID).append("<option value=''>请选择区／县</option>");
            } else {
                $("#" + districtID).append("<option value=''>--请选择--</option>");
            }
            for(var i = 0; i < json.length; i++) {
                var obj = json[i];
                var appendStr = "<option value='" + obj.codes + "' ";
                appendStr = appendStr + ">" + obj.named + "</option>"
                $("#" + districtID).append(appendStr);
            }
        }
    });
}
function customsVerify(){
	var flag = true;
	$("input[Data-Val]").each(function(){
		var dataVal = $(this).attr("Data-Val");
		if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
			if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
				if($(this).val() == ''){
					document.getElementById(this.id).scrollIntoView();
					layer.msg("必填项不能为空！");
					$(this).focus();
					flag = false;
					return false;
				}else{
                    if($(this).val().length>40){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("长度超出限制！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }
                }
				
			}
		}
	});
    if(flag){
        $("input[Data-Val]").each(function() {
            var dataVal = $(this).attr("Data-Val");
            if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                    $(this).blur();
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        flag = false;
                        return true;
                    }
                }
            }
        });
        if(!flag){
            layer.msg("请正确填写相关信息！");
        }
    }
	if(flag){
		$("select[Data-Val]").each(function(){
			var dataVal = $(this).attr("Data-Val");
			if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
				if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
					if($(this).val() == ''){
						document.getElementById(this.id).scrollIntoView();
						layer.msg("必填项不能为空！");
						$(this).focus();
						flag = false;
						return true;
					}
					
				}
			}
		});
		if(flag){
			$("textarea[Data-Val]").each(function(){
				var dataVal = $(this).attr("Data-Val");
				if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
					if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
						if($(this).val() == ''){
							document.getElementById(this.id).scrollIntoView();
							layer.msg("必填项不能为空！");
							$(this).focus();
							flag = false;
							return true;
						}else{
                            if($(this).val().length>100){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("长度超出限制(100字符)！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }
						
					}
				}
			});
			
		}
	}
	return flag;
}
</script>
</html>