<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body style="background: rgba(244,245,246,1);">

<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
			<div class="mess-title"><h3>推荐人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
						<td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
						<td class="col-sm-4 col-xs-4"></td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保人（投标人/施工单位）基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody>
					   <tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人名称</td>
							<td colspan="3" class="col-sm-10 col-xs-10">${ vo.roleSubjectList[0].name_cn}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人地址</td>
							<td colspan="3" class="col-sm-9 col-xs-9">${ reg_role}${ vo.roleSubjectList[0].reg_address}</td>
						</tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">${vo.roleSubjectList[0].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[0].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].organization_code}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮政编码</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].zip_code}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_name}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系电话</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].phone}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮箱</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_email}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">手机号码</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[0].link_tel}</td>
                        </tr> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">企业资质等级</td>
                            <td class="col-sm-4 col-xs-4">
								${vo.aptitude_level eq '1' ? '特级' : vo.aptitude_level eq '2' ? '一级' : vo.aptitude_level eq '3' ? '二级' : vo.aptitude_level eq '4' ? '三级' : vo.aptitude_level eq '5' ? '其它' : '' }
							</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>被保险人（招标人/发包人）基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人名称</td>
							<td colspan="3" class="col-sm-10 col-xs-10">${ vo.roleSubjectList[1].name_cn}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人地址</td>
							<td colspan="3" class="col-sm-9 col-xs-9">${ reg_role_1}${ vo.roleSubjectList[1].reg_address}</td>
						</tr>
                        <tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">${vo.roleSubjectList[1].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[1].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</td>
							<td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[1].organization_code}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮政编码</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[1].zip_code}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[1].link_name}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系电话</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[1].phone}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">手机号码</td>
                            <td class="col-sm-4 col-xs-4">${ vo.roleSubjectList[1].link_tel}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                            <td class="col-sm-4 col-xs-4"></td>
                        </tr> 
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">项目名称及标段</td>
                            <td class="col-sm-4 col-xs-4">${ vo.project_name}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">招标文件编号</td>
                            <td class="col-sm-4 col-xs-4">${ vo.invitation_code}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投标日期</td>
                            <td class="col-sm-4 col-xs-4">${ vo.bid_time}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">工程建设地点</td>
                            <td class="col-sm-4 col-xs-4">${ reg_policy}${ vo.address}</td>
                        </tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">工程类型</td>
							<td class="col-sm-4 col-xs-4">
								<c:forEach items="${ otList }" var="list">
									<c:if test="${vo.office_type eq list.value }">${list.name }</c:if>
								</c:forEach>
							</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">计划工期</td>
							<td class="col-sm-4 col-xs-4">${ vo.project_time}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保险金额(元)</td>
							<td colspan="3" class="col-sm-9 col-xs-9">${ vo.insured_amount}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保险期间</td>
							<td colspan="3" class="col-sm-10 col-xs-10">自&nbsp;${ vo.inception_date}&nbsp;零时起&nbsp;&nbsp;至&nbsp;${ vo.planned_end_date}&nbsp;二十四时止</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
							<td colspan="3" class="col-sm-9 col-xs-9">中华人民共和国司法管辖（港澳台除外）</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
							<td colspan="3" class="col-sm-9 col-xs-9">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：${ vo.dispute eq '0' ? '诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo.dispute eq '0' ? '': vo.arbitral_institution}</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title" id="hint1"><h3>保险公司提示</h3></div>
			<div class="affirm-warr" id="hintTest1">
				<p class="mt30">1、本投保单为保险合同的组成部分。请投保人在填写投保单之前仔细阅读保险条款（包括主险和附加险），尤其是加黑突出标注的、免除保险人责任的条款内容，并听取保险公司业务人员对条款的说明以及对免除保险人责任条款的明确说明，如有不明白或有疑义的，请及时询问保险公司业务人员。</p>
				<p class="mb30">2、中国太保（是指中国太平洋保险（集团）股份有限公司及其直接或间接控股的子公司，以及中国太平洋保险（集团）股份有限公司直接或间接作为其单一最大股东的公司）对您提供的资料承担保密义务，中国太保将采取恰当的物理、电子、管理技术手段保护投保人提供的资料，同时，采取适当的安全措施保护投保人提供的资料免于未经授权的访问、使用或泄露。</p>
			</div>
			<div class="mess-title" id="hint2"><h3>投保人声明</h3></div>
			<div class="affirm-warr" id="hintTest2">
				<p class="mt30"><strong>1、本投保人已经收悉并仔细阅读保险条款，尤其是加黑突出标注的、免除保险人责任的条款内容。保险公司业务人员已就本合同所涉及的所有免除保险人责任条款的概念、内容及其法律后果向本投保人做出了通俗的、本投保人能够理解的解释和明确说明，本投保人对其真实含义和法律后果完全理解，没有异议，特签字、盖章予以确认并申请投保。</strong></p>
				<p>2、基于为本投保人及被保险人提供更优质服务和产品的目的，除法律另有规定外，本投保人授权中国太保可以从相关单位、组织和个人就有关保险事宜查询、索取与本投保人及被保险人有关的资料和证明。</p>
				<p>3、除法律另有规定外，本投保人同意中国太保及其认为业务必要而委托的第三方将本投保人提供的全部资料、享受中国太保服务产生的信息，以及从相关单位、组织和个人就有关保险事宜查询、索取的资料和证明，用于为本投保人及被保险人提供服务、推荐产品、开展市场调查与信息数据分析。</p>
				<p class="mb30">4、本投保人及被保险人兹声明所填上述内容（包括投保单及投保附件）属实。</p>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
	<div class="row next-step">
		<div class="col-sm-3 col-sm-3">
			<div class="insure-check">
				<span class="check-box pull-left">
					<input type="checkbox" id="checkbox10" />
					<label for="checkbox10"></label>
				</span>
				<span class="pull-left">我同意以上告知和声明</span><br /> 
			</div>
			<p class="fs-20-cl">保费<strong class="fs-26"> ￥${ dto.gross_premium}</strong></p>
		</div>
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p><a href="<c:url value="/insurance/build/policy/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}" />" class="save">返回修改</a><a href="javascript:validateChecked('${dto.oid}');" class="ns-btn">确认申请</a></p>
		</div>
	</div>
</div><!-- container end --> 


<!-- 内容部分  注册  结束 -->
<jsp:include page="../../../index/multi_f.jsp" />

<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
    var code= '${dto.product_code }';
    $(document).ready(function () {
        if(code=="BZX-YG-GCTB"){
            $("#hint1").hide();
            $("#hintTest1").hide();
            $("#hint2").hide();
            $("#hintTest2").hide();
        }
    })
    $(function(){
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
	function validateChecked(_id){

		if($("#checkbox10").is(':checked')){
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            layer.msg("核保过程可能需要1-2分钟，请勿关闭浏览！",5000);
            $.ajax({
                type: 'POST',
                timeout:120000,
                url:baseUrl + '/insurance/build/policy/updateOrderFormStatus',
                data:{
                    'order_id':_id,
                    'status':'4'
                },
                dataType:"json",
                success: function(json){
                    layer.close(index);
                    if(json.statusCode == '200') {

                        if(code=="BZX-YG-GCTB"){
                            window.location.href =json.forwardUrl;

                        }else {
                            window.location.href = baseUrl + '/insurance/build/policy/policyPayment/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
						}
                    }else{
                        layer.msg(json.message);

                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });

		}else{
			layer.msg("请勾选“我同意以上告知和声明”！");
		}
			
	}
	function affirmMothen(){
		$(".stat_hint").show();
	}
</script>
</body>
</html>