<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>保障服务－生成投保单</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/bootstrap.min.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/font-awesome.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/common.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/product.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/newslist.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/fileinput.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/select2.css' />"/>
    <link type="text/css" rel="stylesheet"
          href="<c:url value='/resources/version_new/css/jquery.datetimepicker.css' />"/>
    <!--[if lt IE 9]>
    <script src="//cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="//cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

</head>
<body style="overflow-y: hidden;">
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="wer">
<div class="main product-we">

    <div class="row ensure-list mb20">
        <ul>
            <li class="first-Ypassbg"><b>填写保险信息</b></li>
            <li class="two-Nstate"><b><label style="padding-right: 30px;
  margin-left: -40px;">2</label>确认投保信息</b></li>
            <li class="three-Npassbg"><b><label>3</label>保费支付</b></li>
            <li class="last-Npassbg"><b><label>4</label>完成投保</b></li>
        </ul>
    </div>
    <div class="row bgf">
        <div class="col-md-12  table-responsive">
            <table class="table message-table">
                <tbody>
                <tr>
                    <td width="15%" rowspan="4" class="pt46"><strong>投保人信息</strong></td>
                    <td width="17%" class="bg-f9fafc">投保人名称</td>
                    <td colspan="3">${vo.roleSubjectList[0].name_cn}</td>
                    <td width="12%" rowspan="4" class="bg-f9fafc pt46">投保人证件扫描件</td>
                    <td width="12%" rowspan="4"><img src="${vo.roleSubjectList[0].app_business_path}" width="200px"
                                                     height="100px"></td>
                </tr>
                <tr>
                    <td class="bg-f9fafc">投保人地址</td>
                    <td colspan="3">${reg_role}${vo.roleSubjectList[0].reg_address}</td>
                </tr>
                <tr>
                    <td class="bg-f9fafc">联系人</td>
                    <td width="18%">${vo.roleSubjectList[0].link_name}</td>
                    <td width="14%">联系电话</td>
                    <td width="12%">${vo.roleSubjectList[0].link_phone}</td>
                </tr>
                <tr>
                    <td class="bg-f9fafc">投保人证件类型</td>

                    <%--BUSINESSLICENSE{--%>
                    <%--public String getValue(){return "7";}--%>
                    <%--public String getName(){return "营业执照";}--%>
                    <%--},TAXREGISTRATIONCERTIFICATE{--%>
                    <%--public String getValue(){return "8";}--%>
                    <%--public String getName(){return "税务登记证";}--%>
                    <%--},ORGANIZATIONCODECERTIFICATE{--%>
                    <%--public String getValue(){return "9";}--%>
                    <%--public String getName(){return "组织机构代码证";}--%>
                    <td width="18%">
                        <c:if test="${vo.roleSubjectList[0].id_type eq '7'}">
                            营业执照
                        </c:if>
                        <c:if test="${vo.roleSubjectList[0].id_type eq '8'}">
                            税务登记证
                        </c:if>
                        <c:if test="${vo.roleSubjectList[0].id_type eq '9'}">
                            组织机构代码证
                        </c:if>

                    </td>
                    <td width="14%">投保人证件号码</td>
                    <td width="12%">${vo.roleSubjectList[0].organization_code}</td>
                </tr>
                <tr>
                    <td width="15%" rowspan="5" class="pt46"><strong>被保险人信息</strong></td>
                    <td width="17%" class="bg-f9fafc">被保险人名称</td>
                    <td colspan="3">${vo.roleSubjectList[1].name_cn}</td>
                    <td width="12%" rowspan="4" class="bg-f9fafc pt46">被保人证件扫描件</td>
                    <td width="12%" rowspan="4"><img src="${vo.roleSubjectList[1].app_business_path}" width="200px"
                                                     height="100px"></td>
                </tr>
                <tr>
                    <td class="bg-f9fafc">被保险人地址</td>
                    <td colspan="3">${reg_role_1}${vo.roleSubjectList[1].reg_address}</td>
                </tr>
                <tr>
                    <td class="bg-f9fafc">联系人</td>
                    <td width="18%">${vo.roleSubjectList[1].link_name}</td>
                    <td width="14%">联系电话</td>
                    <td width="12%">${vo.roleSubjectList[1].link_phone}</td>
                </tr>
                <tr>
                    <td class="bg-f9fafc">营业性质</td>
                    <td width="18%">${vo.roleSubjectList[1].com_type}</td>
                    <td class="bg-f9fafc">被保险人证件类型</td>
                    <td width="18%">
                        <c:if test="${vo.roleSubjectList[1].id_type eq '7'}">
                        营业执照
                    </c:if>
                        <c:if test="${vo.roleSubjectList[1].id_type eq '8'}">
                            税务登记证
                        </c:if>
                        <c:if test="${vo.roleSubjectList[1].id_type eq '9'}">
                            组织机构代码证
                        </c:if></td>
                </tr>
                <tr>
                    <td width="14%">被保险人证件号码</td>
                    <td width="12%">${vo.roleSubjectList[1].organization_code}</td>
                </tr>
                <tr>
                    <td width="15%" rowspan="5" class="pt80"><strong></strong><strong>活动信息</strong></td>
                    <td width="17%" class="bg-f9fafc">活动名称</td>
                    <td colspan="3">${vo.report_name}</td>
                    <td width="12%" class="bg-f9fafc">活动类型</td>
                    <td width="12%">
                        <c:if test="${vo.report_active eq 'ZL'}">
                            展览展销类
                        </c:if>
                        <c:if test="${vo.report_active eq 'WY'}">
                            文艺演出类
                        </c:if>
                        <c:if test="${vo.report_active eq 'TY'}">
                            体育赛事类
                        </c:if>
                        <c:if test="${vo.report_active eq 'QT'}">
                            其他类活动
                        </c:if>

                    </td>
                </tr>
                <tr>
                    <td width="17%" class="bg-f9fafc">活动地点</td>
                    <td colspan="3">
                        <c:if test="${vo.activity_local eq 'INDOOR'}">
                            室内场馆
                        </c:if>
                        <c:if test="${vo.activity_local eq 'OPEN'}">
                            露天场馆
                        </c:if>
                        <c:if test="${vo.activity_local eq 'OUTDOOR'}">
                            户外场馆
                        </c:if>
                    </td>
                    <td width="12%" class="bg-f9fafc">活动时间</td>
                    <td width="12%">${vo.report_begin_date}—${vo.report_end_date}</td>
                </tr>
                <tr>

                    <td width="14%" class="bg-f9fafc">有无危险环节</td>
                    <td colspan="3">
                        <c:if test="${vo.danger eq 'HAVE'}">
                            有
                        </c:if>
                        <c:if test="${vo.danger eq 'WITHOUT'}">
                            无
                        </c:if>
                    </td>
                </tr>
                <tr>
                    <td width="17%" class="bg-f9fafc">预计活动参与总人数</td>
                    <td>${vo.people_num}</td>
                    <td colspan="2" class="bg-f9fafc">预计天数</td>
                    <td colspan="2">${vo.activity_days}</td>
                </tr>
                <tr>
                    <td width="17%" class="bg-f9fafc">活动场所消防情况</td>
                    <td colspan="5">
                        <c:if test="${vo.activity_fire_fight eq 'ACCEPTANCE'}">
                            有消防验收
                        </c:if>
                        <c:if test="${vo.activity_fire_fight eq 'EXTINGUISHER'}">
                            无消防验收但配备灭火器
                        </c:if>
                        <c:if test="${vo.activity_fire_fight eq 'NO_EXTINGUISHER'}">
                            无消防验收无灭火器
                        </c:if>

                        </td>
                </tr>
                <tr>
                    <td width="15%" rowspan="3" class="pt76"><strong>保险方案</strong></td>
                    <td width="17%" rowspan="2" class="bg-f9fafc pt28">赔偿限额</td>
                    <td colspan="5">每人每次事故赔偿限额 25万</td>
                </tr>
                <tr>
                    <td colspan="5">累计赔偿限额 ${vo.insured_amount/10000}万</td>
                </tr>
                <tr>
                    <td width="17%" class="bg-f9fafc">免赔设定</td>
                    <td colspan="5">财产损失500元，人身伤害无免赔</td>
                </tr>
                <tr>
                    <td width="15%"><strong>保险期间</strong></td>
                    <td colspan="6">
                        ${vo.inception_date}
                        零时起至
                        ${vo.planned_end_date}二十四时止
                    </td>
                </tr>

                <tr>
                    <td width="15%"><strong>总保险费</strong></td>
                    <td colspan="6">￥${dto.gross_premium}</td>
                </tr>
                <tr>
                    <td width="15%" class="pt46"><strong>附加条款</strong><br><span>（赔偿限额同主条款）</span></td>
                    <td colspan="6">
                        <ul>
                            <li>下列附加条款适用于本保险单的各个部分，若其与本保险单的其他规定相冲突，则以下列附加条款为准。</li>
                            <li>交叉责任条款</li>
                            <li>罢工、暴乱、民众骚动及恶意破坏条款</li>
                            <li>火灾和爆炸责任条款</li>
                            <li>急救费用条款</li>
                            <li>广告及装饰装置责任条款</li>
                        </ul>
                    </td>
                </tr>
                <tr>
                    <td width="15%"><strong>争议处理</strong></td>
                    <td colspan="6">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：
                        <c:if test="${vo.dispute eq '1'}">仲裁:${vo.policy_extra_dispute}</c:if>
                        <c:if test="${vo.dispute eq '0'}">诉讼</c:if>
                    </td>
                </tr>
                <tr>
                    <td width="15%" class="pt46"><strong>特别约定</strong></td>
                    <td colspan="6">
                        <ul>
                            <li>本保单不负责赔偿由于第三者自身原因（包括但不限于自身疾病、自身运动损伤、自身体质等）导致的人身伤亡或财产损失事故 , 被保险人所承担的经济赔偿责任。</li>
                            <li>参与文艺演出、体育赛事的演员、运动员不在本保单承保范围内。</li>

                        </ul>
                    </td>
                </tr>
                </tbody>
            </table>

            <div class="payinfo-sumary">
                <div class="text-right clearfix">
                    <div class="pull-right">
                        <form>
                            <p class="check-war">
                                <label><input type="checkbox" id="checkbox1_ss" class="input-ic chk_protocal"
                                              name="agreePaymethod" onclick="agreeclause();"> 我已仔细阅读并同意以上特别约定及<a
                                        href="<c:url value='/resources/files/主条款及附加条款.pdf' />" target="_blank">《主条款及附加条款》</a></label>
                            </p>
                        </form>
                    </div>
                </div>
                <p class="text-right fs18">保费金额总计 : <strong class="c-1">¥ ${dto.gross_premium}</strong></p>
                <div class="mtb20 text-right btn-paymethod-group">
                    <a href="javascript:;" onclick="validateChecked('${vo.oid}');"
                       class="btn btn-lightblue btn-gray disabled" id="btn_confirm_pay">确认投保</a>

                    <a href="<c:url value='/api/afr/policyUpdInit/${pd.oid}/${vo.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="btn btn-lightblue">返回修改</a>


                </div>
            </div>
        </div>
    </div>
</div>
</div>
<jsp:include page="../../../index/multi_f.jsp" />
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.min.js' />"></script>

<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.form.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/layer.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/enter.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/select2.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.datetimepicker.full.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/footerwarp.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/popup-bottom.js' />"></script>

<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        if(self==top){//不存在iframe
            $("body").attr("style","");
        }
        var minlimit = "${policyExtra.min_limit}";
        var rate = 2000 * 100 / minlimit;
        $("rateDiv").html(rate);

        $('.sel_fapiao').select2({width: "180", minimumResultsForSearch: -1});
    });


    function validateChecked(_id) {

        var index = parent.layer.load(0, {shade: [0.3, '#808080'], scrollbar: false});

        $.ajax({
            type: 'POST',
            url: baseUrl + '/insurance/afr/policy/updateOrderFormStatus',
            data: {
                'order_id': _id,
                'status': '4'
            },
            dataType: "json",
            success: function (json) {
                if (json.statusCode == '200') {
                    window.location.href = baseUrl + '/insurance/afr/policy/policyPayment/' + json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                } else {
                    parent.layer.msg(json.resultDto.message);
                }
                parent.layer.close(index);
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                parent.layer.close(index);
                parent.layer.msg("（APP-TK-051）订单数据丢失，请联系管理员！");
            }
        });


    }

    function agreeclause() {
        $("input[name=agreePaymethod]").each(function () {
            if (this.checked) {
                $("#btn_confirm_pay").removeClass("btn-gray");
                $('#btn_confirm_pay').removeClass("disabled");
            } else {
                $("#btn_confirm_pay").addClass("btn-gray");
                $('#btn_confirm_pay').addClass("disabled");
            }
        });
    }

    window.onload = function () {
        $('#frame3d',parent.document).css("height",1340+'px');
    }

</script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/fileinput.js' />"></script>

</body>

</html>
