<%@ page language="java" contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js'/>"></script>
<script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js'/>"></script>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/se-platform.css' />" />
<!--[if lt IE 9]>
<script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
<script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
<![endif]-->

<style>
	.ryzm_width{
		margin-right: 15px;
		padding-right: 0px;
	}
</style>
<!-- nav start -->
<nav class="navbar navbar-default bg-6f">
	<div class="container">
		<div class="navbar-header">
			<c:if test="${indexType eq 'credit'}">
				<a href="<c:url value='/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="navbar-brand logo terrace-logo">
					<img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="贸易信用风险管理服务平台 Logo" class="pull-left">
					<h3 class="pull-left">贸易信用风险管理服务平台<em>mao yi xin yong feng xian guan li fu wu ping tai</em></h3>
				</a>
			</c:if>

			<c:if test="${indexType eq 'engineering'}">
				<a href="<c:url value='/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="navbar-brand logo terrace-logo">
					<img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="工程百联保 Logo" class="pull-left">
					<h3 class="pull-left">工程百联保<em>gong cheng bao xian bao han wang</em></h3>
				</a>
			</c:if>

			<c:if test="${indexType eq 'litigation'}">
				<a href="<c:url value='/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="navbar-brand logo terrace-logo">
					<img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="法律风险管理服务平台 Logo" class="pull-left">
					<h3 class="pull-left">法律风险管理服务平台<em>fa lv feng xian guan li fu wu ping tai</em></h3>
				</a>
			</c:if>

			<c:if test="${empty indexType}">
				<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="navbar-brand logo"><img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="百联保 Logo"></a>
			</c:if>

			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-collapse">
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
			</button>
		</div>
		<div class="collapse navbar-collapse" id="navbar-collapse">
			<ul class="nav navbar-nav navbar-right">
				<li><a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">首页</a></li>
				<li>
					<c:if test="${indexType eq 'credit'}">
						<a href="<c:url value='/synopsis/product/productAllView?groupType=CUSTOMS&ACCESS_TOKEN=${ACCESS_TOKEN}'/>">产品中心</a>
					</c:if>
					<c:if test="${indexType eq 'litigation'}">
						<a href="<c:url value='/synopsis/product/productAllView?groupType=LAWSUIT&ACCESS_TOKEN=${ACCESS_TOKEN}'/>">产品中心</a>
					</c:if>
					<c:if test="${indexType eq 'engineering'}">
						<a href="<c:url value='/synopsis/product/productAllView?groupType=BUILD&ACCESS_TOKEN=${ACCESS_TOKEN}'/>">产品中心</a>
					</c:if>
					<c:if test="${empty indexType}">
						<a href="<c:url value='/synopsis/product/productAllView?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">产品中心</a>
					</c:if>
				</li>


				<li><a href="<c:url value='/synopsis/insuranceService/insure-serve?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">保险服务</a></li>
				<li><a href="<c:url value='/news/newsALLView?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">新闻资讯</a></li>

				<li><a href="<c:url value='/synopsis/us/init/about-us?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">关于我们</a></li>

				<c:if test="${empty userdetail }">
					<li class="login-btn text-center" ><a href="<c:url value='/user/login'/>" >登录</a></li>
					<li class="register-btn text-center"><a href="<c:url value='/user/register/init'/>" >注册</a></li>
				</c:if>
				<c:if test="${not empty userdetail }">
					<li id="msg_next_code" style="display: none;"><a href="#"><i class="glyphicon glyphicon-envelope mess-war"><span class="mess-count">0</span></i></a></li>
					<li class="mt18"><a href="<c:url value='/pc/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>"><c:if test="${empty userdetail.user_pic }"><img src="<c:url value='/resources/versions-2.0/images/account/user-img.png'/>"></c:if><c:if test="${not empty userdetail.user_pic }"><img src="${userdetail.picImg }"></c:if></a></li>
					<li class="btn-group dropdown">
						<div id="dropdown-menu-name">
							<div class="pull-left account">
								<a href="<c:url value='/pc/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" title="${empty userdetail.login_name ? userdetail.login_name:userdetail.login_name }">${empty userdetail.login_name ? userdetail.login_name:userdetail.login_name }</a>
								<c:if test="${userdetail.terminal_type  eq  '1' }">
									<a href="<c:url value='/pc/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="co-b5" title="${userdetail.email }">${userdetail.email }</a>
								</c:if>
								<c:if test="${userdetail.terminal_type  eq  '2' }">
									<a href="<c:url value='/pc/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="co-b5" title="${userdetail.telephone }">${userdetail.telephone }</a>
								</c:if>
							</div>
							<div class="pull-left"><i class="glyphicon glyphicon-menu-down cursor-pointer"></i></div>
						</div>
						<ul class="dropdown-menu">
							<li class="m-0">
								<ul>
									<li><a href="<c:url value='/pc/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">我的账户</a></li>
									<li><a href="<c:url value='/pc/order/myOrder?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">我的订单</a></li>
									<li><a href="<c:url value='/pc/claimList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">理赔查询</a></li>
									<li><a href="<c:url value='/pc/commonApplicant/win?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">常用投保人</a></li>
									<li><a href="<c:url value='/pc/mailAddress?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">寄送信息</a></li>
									<li><a href="<c:url value='/pc/myAccount?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">我的资料</a></li>
									<li><a href="<c:url value='/user/logout?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" style="background: #f8fafc;height: 45px;color: #56688a;line-height: 45px;">退出</a></li>

								</ul>
							</li>
						</ul>
					</li>
				</c:if>
			</ul>
		</div>
	</div>
</nav>
<!-- nav end -->

<!-- 登录 start -->
<div class="modal fade" id="login" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header bg-f8fafc">
				<div class="pal-41"><img src="<c:url value='/resources/versions-2.0/images/public/bao.png' />" class="img-responsive"></div>
			</div>
			<form id="loginForm" action="<c:url value='/user/login/clentLogin'/>" method="post">
				<div class="modal-body">
					<p class="">
						<label>邮箱地址或用户名或手机号</label>
						<input type="text" name="j_username" tabindex="1" id="j_username" onblur="validateHeaderForms(this)" class="form-control" placeholder="邮箱地址或用户名或手机号" />
						<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					</p>
					<p class="reset-pwd">
						<label>密码</label><a href="javascript:void(0);" class="pull-right" onclick="gotoReSetPwd();" class="pull-right">忘记密码</a>
						<input type="password" tabindex="2" name="j_password" id="j_password" onblur="validateHeaderForms(this)" class="form-control" placeholder="请输入密码" />
						<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					</p>
					<div class="mt-20">
						<label>验证码</label>
						<div class="row">
							<div class="col-sm-9 col-xs-9">
								<input type='hidden' name='yzType' value="0" />
								<input type="text" class="form-control" tabindex="3" placeholder="请输入验证码" onblur="baseCheckInputNoSuccessTip(this,'');" id="ryzm_login" name='j_captcha'/>
								<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
							</div>
							<div class="col-sm-3 col-xs-3 pl-0 br-img ryzm_width"><img id="imageF_login" src="<c:url value='/user/image.htm'/>" onclick="changeImg_init(this)"/></div>
						</div>
						<div class="clear"></div>
					</div>
					<p><button type="button" tabindex="4" class="btn notarize-btn w-100" id="loginUp" onclick="doLogin();">登录</button></p>
				</div>
				<div class="modal-footer">
					<div class="bo-conten">
						<span class="pull-left" >还没有账号1？</span><a href="javascript:void(0);" onclick="gotoRegister();" class="pull-right">立即注册</a>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- 登录 end -->

<!-- 重置密码 start -->
<div class="modal fade" id="reset-pwd" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header bg-f8fafc">
				<h4 class="modal-title text-center">重置密码</h4>
			</div>
			<form id="resetPwdFrom1">
				<div class="modal-body">
					<p class="">
						<label>邮箱地址</label>
						<input type="text" name="email" id="email"  class="form-control" placeholder="请输入邮箱地址\或者手机" />
						<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					</p>
					<div class="mt-20">
						<label>验证码</label>
						<div class="row">
							<div class="col-sm-9 col-xs-9">
								<input type="text" class="form-control" placeholder="请输入验证码" onblur="baseCheckInputNoSuccessTip(this,'');" id="ryzm_reset" name='j_captcha'/>
								<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
							</div>
							<div class="col-sm-3 col-xs-3 pl-0 br-img ryzm_width"><img id="imageF_reset" src="<c:url value='/user/image.htm'/>" onclick="changeImg_init(this)"/></div>
						</div>
						<div class="clear"></div>
					</div>
					<p><a href="javascript:javascript:void(0);" onclick="nextStep('1');" class="nstep-btn">下一步</a></p>
				</div>
				<div class="modal-footer">
					<div class="bo-conten">
						<span class="pull-left" >已有账号？</span><a href="javascript:void(0);" onclick="gotoLogin();" class="pull-right">立即登录</a>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<div class="modal fade" id="reset-pwd2" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header bg-f8fafc">
				<h4 class="modal-title text-center">重置密码</h4>
			</div>
			<form id="resetPwdFrom2">
				<div class="modal-body" id="reset-pwd-2">
					<p>
						<label>邮箱地址</label>
						<input type="text" value="" class="form-control" readonly="readonly" id="showEmailId"/>
					</p>
					<div class="mt-20">
						<label>验证码</label>
						<div class="row">
							<div class="col-sm-9 col-xs-9">
								<input type="text" class="form-control" placeholder="请输入验证码" onblur="baseCheckInputNoSuccessTip(this,'');" id="ryzm_reset2" name='j_captcha'/>
								<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
							</div>
							<div class="col-sm-3 col-xs-3 pl-0 br-img ryzm_width"><img id="imageF_3" src="<c:url value='/user/image.htm'/>" onclick="changeImg_init(this)"/></div>
						</div>
					</div>
					<div class="mt-20">
						<label>邮件验证码</label>
						<div class="row">
							<div class="col-sm-7 col-xs-7">
								<input type="text" class="form-control" id="v-code-captcha" placeholder="请输入验证码" onblur="baseCheckInputNoSuccessTip(this,'');"/>
								<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
							</div>
							<div class="col-sm-5 col-xs-5 pl-0">
								<input type="button" class="v-code" value="获取验证码"  onclick="getCheckCodeByEmail(this);"/>
							</div>
						</div>
					</div>
					<p><a href="javascript:void(0);" onclick="nextStep('2');" class="nstep-btn">下一步</a></p>
				</div>
				<div class="modal-footer">
					<div class="bo-conten">
						<span class="pull-left" >已有账号？</span><a href="javascript:void(0);" onclick="gotoLogin();" class="pull-right">立即登录</a>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<div class="modal fade" id="reset-pwd3" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header bg-f8fafc">
				<h4 class="modal-title text-center">重置密码</h4>
			</div>
			<form id="resetPwdFrom3">
				<div class="modal-body">
					<input type="hidden" name="oid" id="oid" value="${user.oid}"/>
					<p class="">
						<label>新密码</label>
						<input type="password" name="password" id="reset-password" onblur="validateHeaderForms(this)" class="form-control" placeholder="请输入6-20位登录密码" />
						<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					</p>
					<p class="">
						<label>确认新密码</label>
						<input type="password" name="reset-passwords" id="reset-passwords" onblur="validateHeaderForms(this)" class="form-control" placeholder="请输入6-20位登录密码" />
						<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
					</p>
					<p><a href="javascript:javascript:void(0);" onclick="resetPwd();" class="nstep-btn">确认</a></p>
				</div>
				<div class="modal-footer">
					<div class="bo-conten">
						<span class="pull-left" >已有账号？</span><a href="javascript:void(0);" onclick="gotoLogin();" class="pull-right">立即登录</a>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- 重置密码 end -->

<!-- 注册1 start -->
<div class="modal fade" id="register" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header bg-f8fafc">
				<div class="pal-41 fs-24">注册账号</div>
			</div>
			<div class="user-login">
				<ul>
					<li class="pull-left active">
						<a href="#normal-user" data-toggle="tab">个人用户</a>
					</li>
					<li class="pull-right">
						<a href="#partner" data-toggle="tab">企业用户</a>
					</li>
				</ul>
			</div>
			<div  class="tab-content"><!-- tab-content start -->
				<form class="tab-pane fade active in" id="normal-user">
					<div class="modal-body">
						<p class="">
							<label>手机号码</label>
							<input type="text" name="email" id="reg-mobile" onblur="checkExistMobile(this)" class="form-control" placeholder="请输入手机号码" />
							<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
						</p>
						<p class="">
							<label>登录密码</label>
							<input type="password" name="password" id="reg-password" onblur="validateHeaderForms(this)" class="form-control" placeholder="请输入6-20位登录密码" />
							<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
						</p>
						<p class="">
							<label>确认密码</label>
							<input type="password" id="reg-passwords" onblur="validateHeaderForms(this)" class="form-control" placeholder="请输入6-20位登录密码" />
							<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
						</p>

						<div  class="mt-20">
							<label>手机验证码</label>
							<div class="row">
								<div class="col-sm-7 col-xs-7">
									<input type="text" class="form-control" id="r-code-captcha" placeholder="请输入验证码" />
									<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
								</div>
								<div class="col-sm-5 col-xs-5 pl-0">
									<input type="button" class="v-code" id="r-code-phone" send-tp="0" value="获取验证码"/>
								</div>
							</div>
						</div>
						<div class="mt-20">
			  			<span class="pull-left check-box">
							<input type="checkbox" id="checkbox1">
							<label for="checkbox1" class="mt-2"></label>
						</span>
							<span>我已阅读并同意 </span>
							<input type="hidden" value="1" name="terminalType">
							<a target="_blank" href="<c:url value='/synopsis/protocol/init?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">《百联保用户协议》</a>
						</div>
						<p><a href="javascript:void(0);" onclick="reg_form('normal-user');" class="nstep-btn">立即注册</a></p>
					</div>
					<div class="modal-footer">
						<div class="bo-conten">
							<span class="pull-left">已有账号？</span><a href="javascript:void(0);" onclick="gotoLogin();" class="pull-right">立即登录</a>
						</div>
					</div>
				</form>
				<form  class="tab-pane fade" id="partner">
					<div class="modal-body">

						<p class="">
							<label>邮箱地址</label>
							<input type="text" name="email" id="reg-email-2" onblur="checkExistEmail(this)" class="form-control" placeholder="请输入邮箱地址" />
							<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
						</p>
						<p class="">
							<label>登录密码</label>
							<input type="password" name="password" id="reg-password-2" onblur="validateHeaderForms(this)" class="form-control" placeholder="请输入6-20位登录密码" />
							<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
						</p>
						<p class="">
							<label>确认密码</label>
							<input type="password"  id="reg-passwords-2" onblur="validateHeaderForms(this)" class="form-control" placeholder="请输入6-20位登录密码" />
							<span class="glyphicon form-control-feedback t-icon-xl" aria-hidden="true"></span>
						</p>

						<div  class="mt-20">
							<label>邮件验证码</label>
							<div class="row">
								<div class="col-sm-7 col-xs-7">
									<input type="text" class="form-control" id="r-code-captcha-2" placeholder="请输入验证码" />
									<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
								</div>
								<div class="col-sm-5 col-xs-5 pl-0">
									<input type="button" class="v-code" id="r-code-2" send-tp="0" value="获取验证码"/>
								</div>
							</div>
						</div>

						<div class="mt-20">
			  			<span class="pull-left check-box">
							<input type="checkbox" id="checkbox2">
							<label for="checkbox2" class="mt-2"></label>
						</span>
							<span>我已阅读并同意 </span>
							<input type="hidden" value="2" name="terminalType">
							<a target="_blank" href="<c:url value='/synopsis/protocol/init?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">《百联保用户协议》</a>
						</div>
						<p><a href="javascript:void(0);" onclick="reg_form('partner');" class="nstep-btn">立即注册</a></p>
					</div>
					<div class="modal-footer">
						<div class="bo-conten">
							<span class="pull-left">已有账号？</span><a href="javascript:void(0);" onclick="gotoLogin();" class="pull-right">立即登录</a>
						</div>
					</div>
				</form>

			</div><!-- tab-content end -->
		</div>
	</div>
</div>
<!-- 注册 end -->

<!-- script -->
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/v-code.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/slide.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/hover-dropdown.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/header.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/account/hover-dropdown.js'/>"></script>

<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

	$('#login').on('shown.bs.modal', function (e) {
		$("body").addClass("modal-open");
	})

	$('#reset-pwd').on('shown.bs.modal', function (e) {
		$("body").addClass("modal-open");
	})
	$('#reset-pwd2').on('shown.bs.modal', function (e) {
		$("body").addClass("modal-open");
	})
	$('#reset-pwd3').on('shown.bs.modal', function (e) {
		$("body").addClass("modal-open");
	})

	$('#register').on('shown.bs.modal', function (e) {
		$("body").addClass("modal-open");
	})
	function changeRequestPath(_th,_fid){
		var type = $(_th).val();
		var path = "";
		if(type == "1"){
			path = "<c:url value='/j_spring_security_check'/>";
		}
		if(type == "2"){
			path = "<c:url value='/pc/reseller/resellerLogin'/>";
		}
		$("#"+_fid).attr("action",path);
	}


	document.onkeydown = function(event) {
		if(!$("#login").is(':hidden')){
			e = event ? event : (window.event ? window.event : null);
			if (e.keyCode == 13) {
				//执行的方法
				doLogin();
				//alert('回车检测到了');
			}
		}
	}
</script>