<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/reset.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/YD.css' />" />
</head>
<body>
<div class="wrap">
	<div class="Con row">
		<c:forEach items="${listVo }" var="list">
			<div class="orderBox clearfix">
				<form action="">
					<div class="col-md-9 col-xs-12">
						<h2 class="order-title-h2">
								${list.product_name}
						</h2>
						<div class="bg-dfeafc clearfix" style="padding: 10px 5px 0;font-weight: bold">
							<p>${list.intro}</p>
						</div>
						<div class="tab_container">
							<table border="1">
								<tr>
									<td>保险责任</td>
									<td>保险金额</td>
								</tr>
								<c:forEach items="${list.responsibilityVoList }" var="irp">
									<tr>
										<td>${irp.name}</td>
										<td>
											<c:choose>
												<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:otherwise>
													<span>-</span>
												</c:otherwise>
											</c:choose>
										</td>
									</tr>
								</c:forEach>
							</table>
						</div>
					</div>
					<div class="col-md-3 col-xs-12 BuyInsurance" style="text-align: center;">
						<c:if test="${not empty list.min_insurance_draw && fn:contains(list.min_insurance_draw, '?') }"><img src="${ list.min_insurance_draw }" style="margin-top: 20px;width: 196px"></c:if>
						<strong class="ComName2">${ list.insurance_name }</strong>
						<div class="Howmany">
							<strong>￥${ list.premium_min }</strong>
							元起
						</div>
						<a href="<c:url value='/api/gmr/product/productInfo/${ list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="btn-b">保险详情</a>
						<a href="javascript:enterBX('${ list.oid }')" class="btn-ligr">立即购买</a>
					</div>
				</form>
			</div>
		</c:forEach>
		<%--</c:if>--%>

	</div>
</div>


</body>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script>
	var baseUrl = '${pageContext.request.contextPath }';
	//立即购买
	function enterBX(v_id){
		var loadIndex = layer.load(0, {shade : [ 0.3, '#808080']});
		window.location.href=baseUrl+"/api/gmr/policyInit/"+v_id+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
</script>
</html>
