<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="order-num wed-num">
	<li class="width-s3">
		<span>结算单号</span>
	</li>
	<li class="width-s3">
		<span>保险公司</span>
	</li>
	<li class="width-s3" style="width: 80px">
		<span>结算单数</span>
	</li>
	<li class="width-s3">
		<span>结算费用</span>
	</li>
	<li class="width-s3">
		<span>结算状态</span>
	</li>
	<li class="width-s3">
		<span>结算生成时间</span>
	</li>
	<li class="width-s3">
		<span>操作</span>
	</li>
</ul>
<ul class="tab-body">
	<c:choose>
		<c:when test="${empty payList }">
			<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
				暂无记录！！
			</li>
		</c:when>
		<c:otherwise>
			<c:forEach items="${payList }" var="pay">
				<li class="clearfix">
					<div class="no-cont">
						<span>${pay.external_reference }</span>
					</div>
					<div class="no-cont">
						<span>${pay.company_name }</span>
					</div>
					<div class="no-cont" style="width: 80px">
						<span>${pay.record_count}</span>
					</div>
					<div class="no-cont">
						<span>${empty pay.predict_total_amount ? '' : '￥'}${empty pay.predict_total_amount ? '-' : pay.predict_total_amount}</span>
					</div>
					<div class="no-cont">
						<span id="status_${pay.oid }">
							<c:if test="${pay.pay_status eq '3'}">
								已结算
							</c:if>
							<c:if test="${pay.pay_status ne '3'}">
								-
							</c:if>
						</span>
					</div>
					<div class="no-cont">
						<span>${pay.build_data}</span>
					</div>
					<div class="no-cont">
						<a href="javascript:;" onclick="openPayDetail('${pay.oid }','${pay.is_part}');">结算详情</a>
							<a href="javascript:;" onclick="uploadPay('${pay.oid }','${pay.record_count }','${pay.predict_total_amount }','${pay.pay_order_path }');" class="a-progress">缴费明细</a>
					</div>
				</li>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</ul>
<script>
    $('.no-cont .po-details').click(function () {
        $('.details-popover').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
        var s = $('.popo-tbody').height();
        if(s <= 400){

            $('.details-popover .popo-content').css({"overflow":"hidden"})
        }
    });
    /*$('.no-cont .progress').click(function () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    });*/
    $('.con-s2 .tab-content .tab-body .no-cont:nth-child(1) span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 12){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
        }
    });
    $('.con-s2 .tab-content .tab-body .no-cont:nth-child(2) span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 12){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
        }
    });
    $('.con-s2 .tab-content .tab-body .no-cont:nth-child(6) span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 12){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
        }
    });


</script>