<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	   	
	   	<style type="text/css" media=print>
			.noprint{display : none}
			.container,.payment-order,.paor-sub{
				width: 100%;margin: 0;padding: 0;
			}
			.paor-content,.paor-conlist{
				border: 1px solid #000000;
			}
			#kf5-support-123456789{
				display : none;
			}
		</style>
	</head>
	<OBJECT classid="CLSID:8856F961-340A-11D0-A96B-00C04FD705A2" height="0" id="printWB" name="printWB" width="0"></OBJECT>
<body>
<div class="container"><!-- container start -->
	<ol class="breadcrumb" id="bread_crumbs">
	</ol>
	<div class="nav-list noprint">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="payment-order">
		<div class="paor-sub">
			<div class="paor-content" style="margin-bottom: 35px;">
				<h3>中国平安财产保险股份有限公司</h3>
				<h5>付款通知书</h5>
				<div class="row paor-context">
					<div class="col-lg-7 col-sm-7">
						<strong>致尊敬的客户</strong>
						<p>   ${dto.applicant_name }</p>
					</div>
					<div class="col-lg-5 col-sm-5">
						<p class="clearfix"><span>日期：</span><label><fmt:formatDate value='${nowTime }' pattern='yyyy年MM月dd日' /></label></p>
						<p class="clearfix"><span>帐户名:  </span><label>中国平安财产保险股份有限公司北京分公司</label></p>
						<p class="clearfix"><span>地址：</span><label>北京市西城区金融大街23号15层</label></p>
						<p class="clearfix"><span>开户行: </span><label>中国农业银行北京建国门支行</label></p>
						<p class="clearfix"><span>帐号：</span><label>11191201040002886</label></p>
						<%--<p class="clearfix"><span>行号：</span><label>526</label></p>--%>
						<%--<p class="clearfix"><span>联行号：</span><label>103100019125</label></p>--%>
					</div>
				</div>
				<div class="row paor-conlist">
					<div class="paor-lsub">
						<div class="col-lg-4 col-sm-4">
							<p><span>险种</span></p>
							<p>${dto.product_name}</p>
						</div>
						<div class="col-lg-4 col-sm-4">
							<p><span>投保单号</span></p>
							<p>${dto.policy_serial_number}</p>
						</div>
						<div class="col-lg-4 col-sm-4">
							<p><span>保险费</span></p>
							<p> ${dto.gross_premium}元</p>
						</div>
					</div>
					<div class="col-lg-3 col-sm-3 col-lg-offset-9 col-sm-offset-9"><strong>合计：${dto.gross_premium}</strong></div>
				</div>
				<div class="paor-cofoot"><h6 class="pull-right">中国平安财产保险股份有限公司</h6></div>
			</div>
			<div class="row next-step noprint">
				<div class="col-lg-12 col-sm-12">
					<p>请打印付款通知书，缴费完需联系客服人员(400-662-9696)提供付款凭证</p>
					<p class="c-red">注意：若需线下转账进行支付，请在起保日期之前完成转账，以免影响保单效力</p>
				</div>
			</div>
			<div class="row next-step noprint">
				<div class="col-sm-12 col-xs-12 pay-the-fees">
					<p>
						<c:if test="${empty dto.pay_order_url}">
						<a href="javascript:void(0);" id="pm_upload" onclick="showPaymentModal();" class="ns-btn" style="margin-left: 10px;">上传付款凭证</a>
						</c:if>
						<a href="javascript:void(0);" onclick="printPaymentNotice();" class="gray-btn" style="margin-left: 10px;">打印付款通知书</a>
						<a href="javascript:void(0);" onclick="down_security_personnel();" class="gray-btn" style="margin-left: 10px;">导出保障人员</a>
					</p>
				</div>
			</div>
		</div>
	</div> 
</div><!-- container end -->

<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header bg-1f96ef">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title">上传付款凭证</h4>
			</div>
			<form id="paymentForm" method="post" enctype="multipart/form-data" action='<c:url value="/api/com/gmr/transaction/uploadPayMentFile?ACCESS_TOKEN=${ACCESS_TOKEN}"/>' >
				<input name="oid" value="${dto.oid}" type="hidden"/>
				<input name="doPayments" id="doPayments" value="1" type="hidden"/>
				<input name="payAmount" id="payAmount" value="${dto.gross_premium }" type="hidden"/>
				<input type="hidden" name="paymentPath" id="paymentPath" value="${dto.pay_order_url }">
				<div class="modal-body">
					<div class="col-sm-12 col-xs-12" style="margin-top: 8px;">
						<div class="col-sm-12 col-xs-12" id="paymentPath_isHidden">
							<div class="basic-file">
								<input data-drawview="" name="paymentPath_file" id="paymentPath_file-5" class="file" type="file" data-drawview="" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<div class="mofo-sub">
						<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
						<button type="button" class="btn notarize-btn pull-right" onclick="uploadPayment();">确认</button>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<jsp:include page="../../../index/multi_init_param.jsp"/>
<!-- script -->
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
	window.onload = function () {
		//以后优化 频繁变更水印
		watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
	}
	var baseUrl = '${pageContext.request.contextPath }';
	$(function(){

		document.onmousedown = function(ev){
			ev = ev || window.event;
			var x=ev.clientX;
			var y=ev.clientY;
			insOperation('${dto.oid}','${dto.trade_serial_number}','付款通知书');
			<%--insOperation2('${dto.oid}','','付款通知书',x,y);--%>
		}
	})
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                layer.close(index);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    layer.msg(result.message);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
    function showPaymentModal(){
        $("#paymentModal").modal("show");
		insOperation('${dto.oid}','','付款通知书-上传付款凭证');
    }

    function printPaymentNotice(){
        try{
            document.all.printWB.ExecWB(7,1);
        }catch (e)
        {
            window.print();
        }
    }
	/*人员导出操作*/
    function down_security_personnel(){
        var index = layer.confirm('是否导出该订单保障人员名单？',{btn: ['确定','取消'] //按钮
        }, function(){
			insOperation('${dto.oid}','','付款通知书-人员导出');
            location.href='/pc/down_security_personnel/${dto.oid}';
            layer.close(layer.index);
        });
    }

    function uploadPayment(){
        var paymentPath = $("#paymentPath_file-5").val();
        if(paymentPath ==""){
            layer.msg("请上传缴费凭证");
        }
        else{
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $("#paymentForm").ajaxSubmit({
                success : function(data) {
                    layer.close(index);
                    layer.msg(data.message);
                    if(data.statusCode == "200"){
                        $('#pm_upload').hide();
                        $("#paymentModal").modal("hide");
						insOperation('${dto.oid}','','付款通知书-完成凭证上传');
                    }
                },
                error : function() {
                    layer.close(index);
                    alert('error');
                }
            });
        }
    }
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
</body>
</html>