<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body>
<div class="container"><!-- container start -->
    <c:if test="${fn:contains(userdetail.web_type, 'PSS')}">
        <ol class="breadcrumb" id="bread_crumbs" style="padding-top: 20px">
            <%--<span>当前位置：</span>
            <a href="javascript:void(0);">保障服务 > </a>
            <a href="<c:url value='/api/order/myOrder?ACCESS_TOKEN=${ACCESS_TOKEN}' />">订单列表 > </a>
            <a href="javascript:void(0);">订单详情</a>--%>
        </ol>
    </c:if>
    <c:if test="${!fn:contains(userdetail.web_type, 'PSS')}">
        <ol class="breadcrumb" id="bread_crumbs">
        </ol>
    </c:if>
    <div class="message-war"><!-- message-war start -->
        <h2>${ dto.product_name}</h2>
        <div class="w-95-auto"><!-- w-95-auto start -->
            <h5><c:if test="${ not empty dto.external_reference }">保单号码：${ dto.external_reference}</c:if><c:if test="${ empty dto.external_reference }">订单号码：${ dto.trade_serial_number}</c:if></h5>
            <div class="mess-title"><h3>推荐人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保单位信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人名称</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].name_cn}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${comTypeList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].organization_code}</td>
                    </tr>

                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_tel}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_email}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
                        <td class="col-sm-4 col-xs-4">
                            ${reg_role}
                            ${vo.roleSubjectList[0].reg_address}
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>被保险人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人名称</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].name_cn}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].com_nature}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].nature_two}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${comTypeList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].id_type}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].organization_code}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_tel}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_email}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">详细地址</td>
                        <td class="col-sm-4 col-xs-4">
                            ${reg_role_1}
                            ${vo.roleSubjectList[1].reg_address}
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="mess-title"><h3>活动信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动名称</td>
                        <td class="col-sm-4 col-xs-4">
                            ${vo.report_name}
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:if test="${not empty  dto.product_code && fn:split(dto.product_code, '-')[2] eq 'ZL'}">
                                展览展销类活动
                            </c:if>
                            <c:if test="${not empty  dto.product_code && fn:split(dto.product_code, '-')[2] eq 'WY'}">
                                文艺演出类活动
                            </c:if>
                            <c:if test="${not empty  dto.product_code && fn:split(dto.product_code, '-')[2] eq 'TY'}">
                                体育赛事类活动
                            </c:if>
                            <c:if test="${not empty  dto.product_code && fn:split(dto.product_code, '-')[2] eq 'QT'}">
                                其他
                            </c:if>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">承保区域</td>
                        <td class="col-sm-4 col-xs-4">${vo.report_local}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动期间</td>
                        <td class="col-sm-4 col-xs-4">${vo.report_begin_date} ~ ${vo.report_end_date}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">临建设施搭建天数</td>
                        <td class="col-sm-4 col-xs-4">${vo.buss_days}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">临建设施拆除天数</td>
                        <td class="col-sm-4 col-xs-4">${vo.tear_days}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动地点</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:if test="${ vo.activity_local eq 'INDOOR' }">
                                室内场馆
                            </c:if>
                            <c:if test="${ vo.activity_local eq 'OPEN' }">
                                露天场馆
                            </c:if>
                            <c:if test="${ vo.activity_local eq 'OUTDOOR' }">
                                户外场馆
                            </c:if>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">预计活动参与总人数</td>
                        <td class="col-sm-4 col-xs-4">${vo.people_num}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">消防情况</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:if test="${ vo.activity_fire_fight eq 'ACCEPTANCE' }">
                                有消防验收
                            </c:if>
                            <c:if test="${ vo.activity_fire_fight eq 'EXTINGUISHER' }">
                                无消防验收但配备灭火器
                            </c:if>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">有无危险环节（如烟花）</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:if test="${ vo.danger eq 'HAVE' }">
                                有
                            </c:if>
                            <c:if test="${ vo.danger eq 'WITHOUT' }">
                                无
                            </c:if>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">展览会场所面积（平米）</td>
                        <td class="col-sm-4 col-xs-4">${vo.ex_acreage}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">预计天数</td>
                        <td class="col-sm-4 col-xs-4">${vo.activity_days}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">每人每次事故赔偿限额</td>
                        <td class="col-sm-4 col-xs-4">
                            <span>25万</span>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">每次事故及累计赔偿限额</td>
                        <td class="col-sm-4 col-xs-4">
                            <span>${ vo.insured_amount/10000}万</span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="mess-title"><h3>投保基本信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">保险期间</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">自${vo.inception_date}零时起  至${vo.planned_end_date}二十四时止</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">中华人民共和国司法管辖（港澳台除外）</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：${ vo.dispute eq '0' ? '商议或诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo.dispute eq '0' ? '': vo.policy_extra_dispute}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保计划信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <%--<tr>
                        <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
                        <td colspan="3" class="col-sm-10 col-xs-10" style="padding: 0">
                            <table class="table">
                                <tbody>
                                <tr style="border-bottom: 1px solid #e6eaee;">
                                    <td class="col-sm-6 col-xs-6">保障责任</td>
                                    <td class="col-sm-6 col-xs-6">保障金额</td>
                                </tr>
                                <c:forEach items="${ dto.responsibilityVoList }" var="irp" varStatus="index">
                                    <tr ${(index.index+1) != dto.responsibilityVoList.size()? 'style="border-bottom: 1px solid #e6eaee;"' : ''} >
                                        <td class="col-sm-6 col-xs-6" >${irp.name}</td>
                                        <td class="col-sm-6 col-xs-6" >
                                            <c:choose>
                                                <c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:otherwise>
                                                    <span>-</span>
                                                </c:otherwise>
                                            </c:choose>
                                        </td>
                                    </tr>
                                </c:forEach>
                                </tbody>
                            </table>
                        </td>
                    </tr>--%>
                    <tr>
                        <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
                        <td colspan="3" class="col-sm-10 col-xs-10">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-4 col-xs-4">保障责任</td>
                                    <td class="col-sm-2 col-xs-2">
                                        <c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
                                        <c:choose>
                                            <c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
                                                保险金额
                                            </c:when>
                                            <c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
                                                赔偿限额
                                            </c:when>
                                            <c:otherwise>
                                                保险金额
                                            </c:otherwise>
                                        </c:choose>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">免赔额</td>
                                    <td class="col-sm-2 col-xs-2">赔付比例</td>
                                    <td class="col-sm-2 col-xs-2">免赔天数</td>
                                </tr>
                                <c:forEach items="${ vo.responsibilityVoList }" var="irp">
                                    <tr <c:choose>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:otherwise>

                                        </c:otherwise>
                                    </c:choose>>
                                        <td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
                                        <td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
                                            <c:choose>
                                                <c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元起
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:otherwise>
                                                    <span>-</span>
                                                </c:otherwise>
                                            </c:choose>
                                        </td>
                                        <td class="col-sm-2 col-xs-2" >财产损失500元，人身伤害无免赔。</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
                                    </tr>
                                </c:forEach>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>退保账户信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">开户名</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].account_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">账户开户行</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">银行账号</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_account}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保声明</h3></div>
            <div class="affirm-warr">
                <p class="mt30">1、投保人通过合法途径获得团体授权，向保险人投保本险种，所有投保操作和内容已获得认可，所有被保险人均为与投保单位有劳动关系的劳动者，该产品的保障内容以及保险金额已向被保险人进行了明确说明，并征得其同意。</p>
                <p>2、投保人已就保险事宜与全部被保险人进行了宣导和沟通，凡参与该保险的全部被保险人均符合险种条款所约定（包括但不限于责任免除、投保人被保险人义务、保险金申请与给付等）的投保条件，并了解保障内容且同意由投保人统一办理投保事项，投保人已认真阅读并正确理解条款和投保须知的所有内容，并接受上述内容，同意以此作为订立保险合同的依据。</p>
                <p class="mb30">3、本产品投保填写以及所附的被保险人清单中的各项事实均属实，并作为本保险合同的组成部分，如有隐瞒或不实告知，投保人愿承担由此带来的法律后果，保险人有权解除保险合同，对于合同解除前发生的任何事故，保险人可不承担任何责任。</p>
            </div>
        </div><!-- w-95-auto end -->
    </div><!-- message-war end -->
    <c:if test="${ not empty dto.external_reference }">
        <div class="row next-step">
            <div class="col-sm-6 col-xs-6 text-right pull-right">
                <p>
                    <c:if test="${ not empty dto.insure_path }">
                        <a target="_blank" href="${dto.insure_path}" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${ empty dto.insure_path }">
                        <a href="javascript:void(0);" onclick="requestEPolicy('${ dto.oid }',this);" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${ empty vo.mailPolicyVo.e_invoice_url }">
                        <a href="javascript:void(0);" onclick="requestInvoice('${ dto.product_code }','${ dto.oid }',this);" class="ns-btn">申请电子发票</a>
                    </c:if>
                    <c:if test="${ not empty vo.mailPolicyVo.e_invoice_url }">
                        <a target="_blank" href="${vo.mailPolicyVo.e_invoice_url}" class="ns-btn">发票下载</a>
                    </c:if>
                </p>
            </div>
        </div>
    </c:if>
</div><!-- container end --> 

<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
	<input name="path" id="path-dow" type="hidden">
	<input name="name" id="name-dow" type="hidden">
</form>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function sodownload(path,name){
		path = path.split(".com/")[1];
		$("#path-dow").val(path);
		$("#name-dow").val(name);
		$("#dow-now").submit();
	}
    function requestEPolicy(_oid,_obj){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/api/gzx/policy/requestEPolicy/'+_oid,
            dataType:"json",
            success: function(json){
                if(json.statusCode == '200') {
                    $(_obj).attr("href",json.navTabId);
                    $(_obj).attr("onclick","");
                    window.open(json.navTabId);
                }else{
                    layer.msg(json.message);
                }
                layer.close(index);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }

    function requestInvoice(_code,_oid,_obj){
        layer.confirm('是否申请开具电子发票？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = laySomenType(0,null,'',0);
            var _url = '/HT-API/GZX/PRINT_INVOICE/'+_oid;
            $.ajax({
                type: 'POST',
                url:baseUrl + _url,
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {
                        $(_obj).attr("href",json.message);
                        $(_obj).attr("onclick","");
                        window.open(json.message);
                    }else{
                        laySomenType(1,null,json.message,0);
                    }
                    laySomenType(2,index,'',0);
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        });
    }

    var topWindow;
    $(function(){
        for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
            for(var i=0;i<topWindow.parent.frames.length;i++){
                if(topWindow.parent.frames[i].window.document==topWindow.document){
                    var tName = topWindow.parent.frames[i].name;
                    if(tName != ''){
                        var bread_crumbs;
                        if(tName.indexOf('layui-layer-iframe')==-1){
                            $("ol[class*='breadcrumb']").each(function(){
                                $(this).html('');
                            });
                        }else{
                            bread_crumbs = "<li>当前位置: 保障服务 </li><li> <a href='<c:url value="/api/gzx/product/productAllView?ACCESS_TOKEN=${ACCESS_TOKEN}" />'>产品列表</a> </li><li> <a href='<c:url value="/api/gzx/product/productInfo/${dto.product_oid}?ACCESS_TOKEN=${ACCESS_TOKEN}" />'>产品详情</a> </li><li> <span id='place'>填写投保单</span></li>";
                        }
                        $("#bread_crumbs").html(bread_crumbs);
                    }
                }
            }
        }
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
</script>
</body>
</html>