<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
	<meta name="viewport" content="width=device-width, initial-scale=1"/>
	<title>保障服务－保费支付</title>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/font-awesome.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/common.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/product.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/newslist.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/fileinput.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/select2.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/jquery.datetimepicker.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/hdsb.css' />" />

	<!--[if lt IE 9]>
	<script src="//cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
	<script src="//cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
	<![endif]-->

</head>
<body style="overflow-y: hidden;">

<div class="wer">

<div class="main product-we">

	<div class="row">
		<ol class="breadcrumb pull-left">
			<li><span>当前位置：</span></li>
			<li><a href="<c:url value="/"/>">首页</a></li>
			<li><a target="_blank" href="<c:url value="/insurance/product/productInfo/${vo.product_id}?ACCESS_TOKEN=${ACCESS_TOKEN}"/>" class="active">产品详情</a></li>
		</ol>
	</div>
	<div class="row ensure-list mb20">
		<ul>
			<li class="first-Ypassbg"><b>填写保险信息</b></li>
			<li class="two-Ypassbg"><b>确认投保信息</b></li>
			<li class="three-Nstate"><b><label style="padding-right: 30px;
  margin-left: 45px;">3</label>保费支付</b></li>
			<li class="last-Npassbg"><b><label>4</label>完成投保</b></li>
		</ul>
	</div>
	<div class="row main-title clearfix mt20">
		<div class="main-title-name pull-left">订单号码：${dto.trade_serial_number}</div>
	</div>
	<div class="row bgf">
		<div class="col-md-12  table-responsive">
			<div class="ht-paytable mt30" style="border:none">
				<table class="table">
					<thead>
					<tr>
						<th>产品名称</th>
						<th>保障期限</th>
						<th>保费（元）</th>
					</tr>
					</thead>
					<tbody>
					<tr>
						<td>
							<c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'ZL'}">
								展览展销类活动公众责任险
							</c:if>
							<c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'WY'}">
								文艺演出类活动公众责任险
							</c:if>
							<c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'TY'}">
								体育赛事类活动公众责任险
							</c:if>
							<c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'QT'}">
								其他类活动公众责任险
							</c:if></td>
						<td>
							${vo.inception_date}
							零时起至
							${vo.planned_end_date}二十四时止

						</td>
						<td>${dto.gross_premium}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="payinfo-sumary">
				<p class="text-right fs18">线上支付金额总计: <strong class="c-1">¥${dto.gross_premium} </strong></p>

				<div class="mtb20 text-right btn-paymethod-group">
					<a href="javascript:pay('${dto.oid}')" class="btn btn-lightblue">立即支付</a>
				</div>
			</div>
		</div>
	</div>
</div>

</div>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.min.js' />"></script>

<!--<script type="text/javascript" src="../static/js/bootstrap.min.js"></script>-->
<!--<script type="text/javascript" src="../static/js/product.js"></script>-->


<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.form.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/layer.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/enter.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/select2.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.datetimepicker.full.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/footerwarp.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/popup-bottom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/fileinput.js' />"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>



</body>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

	function pay(tradeNumber) {

		window.open( baseUrl +"/api/afr/pay/ht/"+tradeNumber+"?ACCESS_TOKEN=${ACCESS_TOKEN}");

		parent.layer.confirm('支付是否成功？(若完成二维码支付请耐心等待页面跳转结束，过程需要花费10~15秒后点击‘支付成功’按钮)', {
			btn: ['支付成功','支付失败，重新支付']
		}, function(index){
			parent.layer.close(index);
			window.location = baseUrl + "/api/afr/pay/paySuccess?tradeNumber="+tradeNumber+"&ACCESS_TOKEN=${ACCESS_TOKEN}";
			$('#frame3d',parent.document).css("height",553+'px');
		}, function(index){
			parent.layer.close(index);
			window.location = baseUrl + "/api/afr/pay/payFaid?tradeNumber="+tradeNumber+"&ACCESS_TOKEN=${ACCESS_TOKEN}";
			$('#frame3d',parent.document).css("height",493+'px');
		});
	}

    window.onload = function () {
        if(self==top){//不存在iframe
            $("body").attr("style","");
        }
        $('#frame3d',parent.document).css("height",450+'px');
    }

</script>
</html>
