package com.bcxin.ins.weixin.product.service.impl;

import com.bcxin.ins.third.gzx.huatai.util.PremiumCalc;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.utils.FreemarkerUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.weixin.product.service.OnLineOfferService;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.PdfWriter;
import gui.ava.html.image.generator.HtmlImageGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.List;
import java.util.Map;

/**
 * @Author: wuxiaozhen
 * @Date: 2018/6/29 10:10
 * @Description:
 */
@Service
public class OnLineOfferServiceImpl implements OnLineOfferService {

    @Autowired
    private ProductService productService;

    @Override
    public void buildProposal(Map<String, Object> param) {
        param.put("proPath",GlobalResources.DONOW_PATH);
        setTemValueTX(param);
    }

    /**
     * 将HTML文件生成PDF文件
     * @param param
     * @return
     */
    @Override
    public R buildPDF(Map<String, Object> param) {
        try {
            String type= (String)param.get("type");
            String fBody= (String)param.get("fBody");
            String fName= (String)param.get("fName");
            String template = "";
            param.put("proPath",GlobalResources.DONOW_PATH);
            if("1".equals(type)){//公责
                template = "weixin_gz_pdf_offer.ftl";
                String pnum= (String)param.get("pnum");
                param.put("be_z","3".equals(pnum) ? "≥1500万" : "4".equals(pnum) ? "≥2000万" : "");
                setTemValueGZ(param);
            }else if("2".equals(type)){//展责
                template = "weixin_zz_pdf_offer.ftl";
                String ea= (String)param.get("ex_acreage");
                int ex_acreage= Integer.parseInt(ea);
                param.put("be_z",ex_acreage < 109 ? "≥400万" : "≥500万");
                setTemValueZZ(param);
                String zzza= (String)param.get("zzza");
                if(StringUtils.isEmpty(zzza)){
                    type = "3";
                }
            }else if("3".equals(type)){//展责
                template = "weixin_tx_test_pdf_offer.ftl";
                setTemValueTX(param);
            }
            if(StringUtils.isNotEmpty(template)){
                String htmlC = FreemarkerUtil.getInstance().transferMapToString(template,param);
                String path = spannedFile(htmlC,type,fBody,fName);
                if(StringUtils.isNotEmpty(path)){
                    return new R(true, path);
                }
            }else{
                return new R(false, "数据不丢失");
            }
        }catch (Exception e){
            e.printStackTrace();
            throw new RuntimeException("pdf模板生成失败");
        }
        return new R(false, "报价方案生成失败");
    }

    private void setTemValueTX(Map<String, Object> param){//团险
        String product_type = (String)param.get("product_type");//产品类型
        String yj_premium = (String)param.get("yj_premium");//预计保费
        String premium = (String)param.get("premium");//保费
        String insurance_company = (String)param.get("insurance_company");//保险公司
        String product_id = (String)param.get("product_id");//保险产品
        String support_plan = (String)param.get("support_plan");//保障方案
        ProductVo vo = productService.getProduct(Long.parseLong(product_id));
        param.put("product_name_img","/resources/images/"+vo.getProduct_code()+".png");
        param.put("productVo",vo);
        List<String> list = Lists.newArrayList();
        String zhtype = "";
        if(vo.getProduct_code().contains("GZZRX-RB")){
            String _h1="",_h2="",_h3="",_h4="",_h5="",_h6="",_h7="",_h8="",_h9="";
            zhtype = "h-1-1-2,h-1-3-3" +
                    ",h-2-1-2,h-2-3-2" +
                    ",h-3-1-2,h-3-3-2" +
                    ",h-4-1-2,h-4-3-2" +
                    ",h-5-1-2,h-5-3-2" +
                    ",h-6-1-2,h-6-3-2" +
                    ",h-7-1-4" +
                    ",z-2-1-4";
            _h1 = "保障范围,保障范围,赔偿限额,赔偿限额,赔偿限额";
            _h2 = "保安人员综合责任保险,保安人员综合责任保险,每次事故责任限额,每次事故责任限额,"
                    +("GZZRX-RB-1".equals(vo.getProduct_code())?"300万元"
                    :"GZZRX-RB-2".equals(vo.getProduct_code())?"400万元"
                    :"GZZRX-RB-3".equals(vo.getProduct_code())?"500万元"
                    :"GZZRX-RB-4".equals(vo.getProduct_code())?"600万元"
                    :"");
            _h3 = "保安人员综合责任保险,保安人员综合责任保险,每人死亡、伤残责任限额,每人死亡、伤残责任限额,"
                    +("GZZRX-RB-1".equals(vo.getProduct_code())?"30万元"
                    :"GZZRX-RB-2".equals(vo.getProduct_code())?"40万元"
                    :"GZZRX-RB-3".equals(vo.getProduct_code())?"50万元"
                    :"GZZRX-RB-4".equals(vo.getProduct_code())?"60万元"
                    :"");
            _h4 = "保安人员综合责任保险,保安人员综合责任保险,每人医疗费用责任限额,每人医疗费用责任限额,"
                    +("GZZRX-RB-1".equals(vo.getProduct_code())?"3万元"
                    :"GZZRX-RB-2".equals(vo.getProduct_code())?"4万元"
                    :"GZZRX-RB-3".equals(vo.getProduct_code())?"5万元"
                    :"GZZRX-RB-4".equals(vo.getProduct_code())?"6万元"
                    :"");
            _h5 = "保安人员综合责任保险,保安人员综合责任保险,累计法律费用责任限额,累计法律费用责任限额,"
                    +("GZZRX-RB-1".equals(vo.getProduct_code())?"30万元"
                    :"GZZRX-RB-2".equals(vo.getProduct_code())?"40万元"
                    :"GZZRX-RB-3".equals(vo.getProduct_code())?"50万元"
                    :"GZZRX-RB-4".equals(vo.getProduct_code())?"60万元"
                    :"");
            _h6 = "烈士褒扬金,烈士褒扬金,每人死亡、伤残责任限额,每人死亡、伤残责任限额,"
                    +("GZZRX-RB-1".equals(vo.getProduct_code())?"30万元"
                    :"GZZRX-RB-2".equals(vo.getProduct_code())?"40万元"
                    :"GZZRX-RB-3".equals(vo.getProduct_code())?"50万元"
                    :"GZZRX-RB-4".equals(vo.getProduct_code())?"60万元"
                    :"");
            _h7 = "附加三者责任险,附加三者责任险,每次事故责任限额,每次事故责任限额,"
                    +("GZZRX-RB-1".equals(vo.getProduct_code())?"10万元"
                    :"GZZRX-RB-2".equals(vo.getProduct_code())?"14万元"
                    :"GZZRX-RB-3".equals(vo.getProduct_code())?"20万元"
                    :"GZZRX-RB-4".equals(vo.getProduct_code())?"25万元"
                    :"");
            _h8 = "附加三者责任险,附加三者责任险,累计责任限额,累计责任限额,"
                    +("GZZRX-RB-1".equals(vo.getProduct_code())?"100万元"
                    :"GZZRX-RB-2".equals(vo.getProduct_code())?"150万元"
                    :"GZZRX-RB-3".equals(vo.getProduct_code())?"200万元"
                    :"GZZRX-RB-4".equals(vo.getProduct_code())?"250万元"
                    :"");
            _h9 = "保费,保费,保费,保费,"+premium+"元";
            list.add(_h1);
            list.add(_h2);
            list.add(_h3);
            list.add(_h4);
            list.add(_h5);
            list.add(_h6);
            if("4".equals(support_plan)){
                zhtype = "h-1-1-2,h-1-3-3" +
                        ",h-2-1-2,h-2-3-2" +
                        ",h-3-1-2,h-3-3-2" +
                        ",h-4-1-2,h-4-3-2" +
                        ",h-5-1-2,h-5-3-2" +
                        ",h-6-1-2,h-6-3-2" +
                        ",h-7-1-2,h-7-3-2" +
                        ",h-8-1-2,h-8-3-2" +
                        ",h-9-1-4" +
                        ",z-2-1-4,z-7-1-2";
                list.add(_h7);
                list.add(_h8);
            }
            list.add(_h9);
        }else if(vo.getProduct_code().contains("TYX-RB")){
            String _h1="",_h2="",_h3="",_h4="",_h5="",_h6="",_h7="",_h8="",_h9="";
            _h1 = "保险责任,保险金额";
            _h2 = "意外伤害保险金,"
                    +("TYX-RB-1".equals(vo.getProduct_code())?"10万元"
                    :"TYX-RB-2".equals(vo.getProduct_code())?"20万元"
                    :"TYX-RB-3".equals(vo.getProduct_code())?"30万元"
                    :"TYX-RB-4".equals(vo.getProduct_code())?"40万元"
                    :"TYX-RB-5".equals(vo.getProduct_code())?"50万元"
                    :"TYX-RB-6".equals(vo.getProduct_code())?"60万元"
                    :"");
            _h3 = "意外医疗保险金,"
                    +("TYX-RB-1".equals(vo.getProduct_code())?"1万元"
                    :"TYX-RB-2".equals(vo.getProduct_code())?"2万元"
                    :"TYX-RB-3".equals(vo.getProduct_code())?"3万元"
                    :"TYX-RB-4".equals(vo.getProduct_code())?"4万元"
                    :"TYX-RB-5".equals(vo.getProduct_code())?"5万元"
                    :"TYX-RB-6".equals(vo.getProduct_code())?"6万元"
                    :"");
            _h4 = "意外住院津贴保险金,"
                    +("TYX-RB-1".equals(vo.getProduct_code())?""
                    :"TYX-RB-2".equals(vo.getProduct_code())?"50元/天"
                    :"TYX-RB-3".equals(vo.getProduct_code())?"100元/天"
                    :"TYX-RB-4".equals(vo.getProduct_code())?"100元/天"
                    :"TYX-RB-5".equals(vo.getProduct_code())?"150元/天"
                    :"TYX-RB-6".equals(vo.getProduct_code())?"200元/天"
                    :"");
            _h5 = "猝死,"
                    +("TYX-RB-1".equals(vo.getProduct_code())?"10万元"
                    :"TYX-RB-2".equals(vo.getProduct_code())?"10万元"
                    :"TYX-RB-3".equals(vo.getProduct_code())?"10万元"
                    :"TYX-RB-4".equals(vo.getProduct_code())?"20万元"
                    :"TYX-RB-5".equals(vo.getProduct_code())?"20万元"
                    :"TYX-RB-6".equals(vo.getProduct_code())?"20万元"
                    :"");
            _h6 = "救护车费用,"
                    +("TYX-RB-1".equals(vo.getProduct_code())?"1000元"
                    :"TYX-RB-2".equals(vo.getProduct_code())?"1000元"
                    :"TYX-RB-3".equals(vo.getProduct_code())?"1000元"
                    :"TYX-RB-4".equals(vo.getProduct_code())?"1000元"
                    :"TYX-RB-5".equals(vo.getProduct_code())?"1000元"
                    :"TYX-RB-6".equals(vo.getProduct_code())?"1000元"
                    :"");
            _h7 = "疾病身故/全残,"
                    +("TYX-RB-1".equals(vo.getProduct_code())?""
                    :"TYX-RB-2".equals(vo.getProduct_code())?""
                    :"TYX-RB-3".equals(vo.getProduct_code())?"15万元"
                    :"TYX-RB-4".equals(vo.getProduct_code())?"20万元"
                    :"TYX-RB-5".equals(vo.getProduct_code())?"25万元"
                    :"TYX-RB-6".equals(vo.getProduct_code())?"30万元"
                    :"");
            _h8 = "重大疾病,"
                    +("TYX-RB-1".equals(vo.getProduct_code())?""
                    :"TYX-RB-2".equals(vo.getProduct_code())?""
                    :"TYX-RB-3".equals(vo.getProduct_code())?"15万元"
                    :"TYX-RB-4".equals(vo.getProduct_code())?"20万元"
                    :"TYX-RB-5".equals(vo.getProduct_code())?"25万元"
                    :"TYX-RB-6".equals(vo.getProduct_code())?"30万元"
                    :"");
            _h9 = "保费,"+premium+"元";
            list.add(_h1);
            list.add(_h2);
            list.add(_h3);
            if(!"TYX-RB-1".contains(vo.getProduct_code())){
                list.add(_h4);
            }
            list.add(_h5);
            list.add(_h6);
            if("1".equals(support_plan)){
                list.add(_h7);
            }
            if("2".equals(support_plan)){
                list.add(_h8);
            }
            if("3".equals(support_plan)){
                list.add(_h7);
                list.add(_h8);
            }
            list.add(_h9);
        }else if(vo.getProduct_code().contains("TYX-PAS")){
            String _h1="",_h2="",_h3="",_h4="",_h5="",_h6="",_h7="",_h8="",_h9="",_h10="";
            _h1 = "保险责任,保险金额";
            _h2 = "意外伤害保险金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"30万元"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"40万元"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"50万元"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"60万元"
                    :"");
            _h3 = "意外医疗保险金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"2万元"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"3万元"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"4万元"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"5万元"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"6万元"
                    :"");
            _h4 = "意外住院津贴保险金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"50元/天"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"100元/天"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"120元/天"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"150元/天"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"200元/天"
                    :"");
            _h5 = "烈士褒扬金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"30万元"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"30万元"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"30万元"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"30万元"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"30万元"
                    :"");
            _h6 = "轨道列车意外伤害保险金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"20万元"
                    :"");
            _h7 = "营运汽车意外伤害保险金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"10万元"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"10万元"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"10万元"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"10万元"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"10万元"
                    :"");
            _h8 = "轮船意外伤害保险金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"20万元"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"20万元"
                    :"");
            _h9 = "飞机意外伤害保险金,"
                    +("TYX-PAS-1".equals(vo.getProduct_code())?"30万元"
                    :"TYX-PAS-2".equals(vo.getProduct_code())?"30万元"
                    :"TYX-PAS-3".equals(vo.getProduct_code())?"40万元"
                    :"TYX-PAS-4".equals(vo.getProduct_code())?"50万元"
                    :"TYX-PAS-5".equals(vo.getProduct_code())?"60万元"
                    :"");
            _h10 = "保费,"+premium+"元";
            list.add(_h1);
            list.add(_h2);
            list.add(_h3);
            list.add(_h4);
            list.add(_h5);
            list.add(_h6);
            list.add(_h7);
            list.add(_h8);
            list.add(_h9);
            list.add(_h10);
        }else if(vo.getProduct_code().contains("TYX-TK")){
            String _h1="",_h2="",_h3="",_h4="",_h5="";
            _h1 = "保险责任,保险金额";
            _h2 = "意外伤害保险金,"
                    +("TYX-TK-1".equals(vo.getProduct_code())?"10万元"
                    :"TYX-TK-2".equals(vo.getProduct_code())?"20万元"
                    :"TYX-TK-3".equals(vo.getProduct_code())?"30万元"
                    :"TYX-TK-4".equals(vo.getProduct_code())?"40万元"
                    :"TYX-TK-5".equals(vo.getProduct_code())?"50万元"
                    :"TYX-TK-6".equals(vo.getProduct_code())?"60万元"
                    :"");
            _h3 = "意外医疗保险金,"
                    +("TYX-TK-1".equals(vo.getProduct_code())?"1万元"
                    :"TYX-TK-2".equals(vo.getProduct_code())?"2万元"
                    :"TYX-TK-3".equals(vo.getProduct_code())?"3万元"
                    :"TYX-TK-4".equals(vo.getProduct_code())?"4万元"
                    :"TYX-TK-5".equals(vo.getProduct_code())?"5万元"
                    :"TYX-TK-6".equals(vo.getProduct_code())?"6万元"
                    :"");
            _h4 = "意外住院津贴保险金,"
                    +("TYX-TK-2".equals(vo.getProduct_code())?"50元/天"
                    :"TYX-TK-3".equals(vo.getProduct_code())?"100元/天"
                    :"TYX-TK-4".equals(vo.getProduct_code())?"100元/天"
                    :"TYX-TK-5".equals(vo.getProduct_code())?"150元/天"
                    :"TYX-TK-6".equals(vo.getProduct_code())?"200元/天"
                    :"");
            _h5 = "保费,"+premium+"元";
            list.add(_h1);
            list.add(_h2);
            list.add(_h3);
            if(!"TYX-TK-1".contains(vo.getProduct_code())){
                list.add(_h4);
            }
            list.add(_h5);
        }
        param.put("txlist",list);
        param.put("zhtype",zhtype);
    }

    private void setTemValueGZ(Map<String, Object> param){//公责
        param.put("pcht","1");//确定产品
        param.put("pcpac","1");//确定产品
        String etype = (String)param.get("etype");//活动类型
        String placearea = (String)param.get("placearea");//场地面积
        String pnum = (String)param.get("pnum");//活动人数
        String eplace = (String)param.get("eplace");//活动场所
        String ischeck = (String)param.get("ischeck");//消防验收
        String isdanger = (String)param.get("isdanger");//有无危险环节
        String hd_star = (String)param.get("hd_star");//活动开始时间
        String hd_end = (String)param.get("hd_end");//活动结束时间
        String bz_star = (String)param.get("bz_star");//保障开始时间
        String bz_end = (String)param.get("bz_end");//保障结束时间
        int bzDays = DateUtil.getDistDates(DateUtil.convertStringToDate(bz_star), DateUtil.convertStringToDate(bz_end));
        List<String> listht = Lists.newArrayList();
        List<String> list = Lists.newArrayList();
        String _h1="",_h2="",_h3="",_h4="";
        String _1="",_2="",_3="",_4="";
        String zhtype = "z-2-1-2,h-4-1-2";
        PremiumCalc calc = new PremiumCalc();
        if("1".equals(etype)){//展览展销
            //ht
            String _hf1 = "",_hf2 = "",_hf3 = "",_hf4 = "";
            if("1".equals(pnum)){//<5000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三,方案四";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,500-1000万,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf1 = calc.calcHT("500","ZL","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf2 = calc.calcHT("1000","ZL","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","ZL","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","ZL","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf1+","+_hf2+","+_hf3+","+_hf4;
            }else if("2".equals(pnum)){//5000-10000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf2 = calc.calcHT("1000","ZL","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","ZL","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","ZL","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf2+","+_hf3+","+_hf4;
            }else if("3".equals(pnum)){//10000-50000
                _h1 = "承保范围,赔偿限额,方案一,方案二";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,1500（含）-2000万,2000（含）-3500万";
                _hf3 = calc.calcHT("1500","ZL","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("3000","ZL","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf3+","+_hf4;
            }else if("4".equals(pnum)){//>50000
                _h1 = "承保范围,赔偿限额,方案一";
                _h2 = "第三者人身和财产损失,每人每次限额,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,2000（含）-3500万";
                _hf4 = calc.calcHT("2000","ZL","50001","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf4;
            }
            //pac
            String _f1 = "",_f2 = "",_f3 = "";
            if(bzDays<=3){
                _f1 = ("1".equals(eplace) ? "1580.00"
                        : "2".equals(eplace) ? "1960.00"
                        : "3".equals(eplace) ? "2310.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "1960.00"
                        : "2".equals(eplace) ? "2410.00"
                        : "3".equals(eplace) ? "2830.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "2350.00"
                        : "2".equals(eplace) ? "2850.00"
                        : "3".equals(eplace) ? "3310.00"
                        :"") +"元";
            }else if(3<bzDays && bzDays<8){
                _f1 = ("1".equals(eplace) ? "1890.00"
                        : "2".equals(eplace) ? "2340.00"
                        : "3".equals(eplace) ? "2750.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "2350.00"
                        : "2".equals(eplace) ? "2890.00"
                        : "3".equals(eplace) ? "3390.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "2820.00"
                        : "2".equals(eplace) ? "3440.00"
                        : "3".equals(eplace) ? "4010.00"
                        :"") +"元";
            }else if(8<bzDays && bzDays<31){
                _f1 = ("1".equals(eplace) ? "2930.00"
                        : "2".equals(eplace) ? "3480.00"
                        : "3".equals(eplace) ? "3980.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "3620.00"
                        : "2".equals(eplace) ? "4270.00"
                        : "3".equals(eplace) ? "4870.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "4320.00"
                        : "2".equals(eplace) ? "5020.00"
                        : "3".equals(eplace) ? "5620.00"
                        :"") +"元";
            }
            if("1".equals(placearea)){//3
                _1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _2 = "第三者人身和财产损失,每人每次限额,10万,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,100万,200万,500万";
                _4 = "保费,保费,"+_f1+","+_f2+","+_f3;
            }else if("2".equals(placearea)){//2
                _1 = "承保范围,赔偿限额,方案一,方案二";
                _2 = "第三者人身和财产损失,每人每次限额,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,200万,500万";
                _4 = "保费,保费,"+_f2+","+_f3;
            }else if("3".equals(placearea)){//1
                _1 = "承保范围,赔偿限额,方案一";
                _2 = "第三者人身和财产损失,每人每次限额,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,500万";
                _4 = "保费,保费,"+_f3;
            }
        }else if("2".equals(etype)){//文艺演出
            //ht
            String _hf1 = "",_hf2 = "",_hf3 = "",_hf4 = "";
            if("1".equals(pnum)){//<5000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三,方案四";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,500-1000万,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf1 = calc.calcHT("500","WY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf2 = calc.calcHT("1000","WY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","WY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","WY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf1+","+_hf2+","+_hf3+","+_hf4;
            }else if("2".equals(pnum)){//5000-10000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf2 = calc.calcHT("1000","WY","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","WY","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","WY","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf2+","+_hf3+","+_hf4;
            }else if("3".equals(pnum)){//10000-50000
                _h1 = "承保范围,赔偿限额,方案一,方案二";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,1500（含）-2000万,2000（含）-3500万";
                _hf3 = calc.calcHT("1500","WY","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","WY","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf3+","+_hf4;
            }else if("4".equals(pnum)){//>50000
                _h1 = "承保范围,赔偿限额,方案一";
                _h2 = "第三者人身和财产损失,每人每次限额,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,2000（含）-3500万";
                _hf4 = calc.calcHT("2000","WY","50001","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf4;
            }
            //pac
            String _f1 = ("1".equals(eplace) ? "1850.00"
                    : "2".equals(eplace) ? "2250.00"
                    : "3".equals(eplace) ? "2550.00"
                    :"") +"元";
            String _f2 = ("1".equals(eplace) ? "2300.00"
                    : "2".equals(eplace) ? "2700.00"
                    : "3".equals(eplace) ? "3000.00"
                    :"") +"元";
            String _f3 = ("1".equals(eplace) ? "2860.00"
                    : "2".equals(eplace) ? "3300.00"
                    : "3".equals(eplace) ? "3600.00"
                    :"") +"元";
            if("1".equals(pnum)||"2".equals(pnum)){//3
                _1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _2 = "第三者人身和财产损失,每人每次限额,10万,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,100万,200万,500万";
                _4 = "保费,保费,"+_f1+","+_f2+","+_f3;
            }else if("3".equals(pnum)){//2
                _1 = "承保范围,赔偿限额,方案一,方案二";
                _2 = "第三者人身和财产损失,每人每次限额,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,200万,500万";
                _4 = "保费,保费,"+_f2+","+_f3;
            }else if("4".equals(pnum)){//1
                _1 = "承保范围,赔偿限额,方案一";
                _2 = "第三者人身和财产损失,每人每次限额,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,500万";
                _4 = "保费,保费,"+_f3;
            }
        }else if("3".equals(etype)){//体育赛事
            //ht
            String _hf1 = "",_hf2 = "",_hf3 = "",_hf4 = "";
            if("1".equals(pnum)){//<5000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三,方案四";
                _h2 = "每人每次限额,25万,25万,25万,25万";
                _h3 = "每次事故及累计限额,500-1000万,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf1 = calc.calcHT("500","TY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf2 = calc.calcHT("1000","TY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","TY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","TY","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf1+","+_hf2+","+_hf3+","+_hf4;
            }else if("2".equals(pnum)){//5000-10000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf2 = calc.calcHT("1000","TY","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","TY","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","TY","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf2+","+_hf3+","+_hf4;
            }else if("3".equals(pnum)){//10000-50000
                _h1 = "承保范围,赔偿限额,方案一,方案二";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,1500（含）-2000万,2000（含）-3500万";
                _hf3 = calc.calcHT("1500","TY","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","TY","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf3+","+_hf4;
            }else if("4".equals(pnum)){//>50000
                _h1 = "承保范围,赔偿限额,方案一";
                _h2 = "第三者人身和财产损失,每人每次限额,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,2000（含）-3500万";
                _hf4 = calc.calcHT("2000","TY","50001","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf4;
            }

            //pac
            String _f1 = "",_f2 = "",_f3 = "";
            if(bzDays<=3){
                _f1 = ("1".equals(eplace) ? "3950.00"
                        : "2".equals(eplace) ? "4490.00"
                        : "3".equals(eplace) ? "4990.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "4850.00"
                        : "2".equals(eplace) ? "5450.00"
                        : "3".equals(eplace) ? "6000.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "5850.00"
                        : "2".equals(eplace) ? "6550.00"
                        : "3".equals(eplace) ? "7230.00"
                        :"") +"元";
            }else if(3<bzDays && bzDays<8){
                _f1 = ("1".equals(eplace) ? "5055.00"
                        : "2".equals(eplace) ? "5740.00"
                        : "3".equals(eplace) ? "6340.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "6250.00"
                        : "2".equals(eplace) ? "6950.00"
                        : "3".equals(eplace) ? "7600.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "6940.00"
                        : "2".equals(eplace) ? "7720.00"
                        : "3".equals(eplace) ? "8470.00"
                        :"") +"元";
            }else if(8<bzDays && bzDays<31){
                _f1 = ("1".equals(eplace) ? "7230.00"
                        : "2".equals(eplace) ? "8030.00"
                        : "3".equals(eplace) ? "8730.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "8750.00"
                        : "2".equals(eplace) ? "11090.00"
                        : "3".equals(eplace) ? "11890.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "10650.00"
                        : "2".equals(eplace) ? "11670.00"
                        : "3".equals(eplace) ? "12670.00"
                        :"") +"元";
            }
            if("1".equals(pnum)||"2".equals(pnum)){//3
                _1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _2 = "第三者人身和财产损失,每人每次限额,10万,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,100万,200万,500万";
                _4 = "保费,保费,"+_f1+","+_f2+","+_f3;
            }else if("3".equals(pnum)){//2
                _1 = "承保范围,赔偿限额,方案一,方案二";
                _2 = "第三者人身和财产损失,每人每次限额,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,200万,500万";
                _4 = "保费,保费,"+_f2+","+_f3;
            }else if("4".equals(pnum)){//1
                _1 = "承保范围,赔偿限额,方案一";
                _2 = "第三者人身和财产损失,每人每次限额,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,500万";
                _4 = "保费,保费,"+_f3;
            }
        }else if("4".equals(etype)){//其它
//ht
            String _hf1 = "",_hf2 = "",_hf3 = "",_hf4 = "";
            if("1".equals(pnum)){//<5000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三,方案四";
                _h2 = "每人每次限额,25万,25万,25万,25万";
                _h3 = "每次事故及累计限额,500-1000万,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf1 = calc.calcHT("500","QT","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf2 = calc.calcHT("1000","QT","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","QT","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","QT","5000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf1+","+_hf2+","+_hf3+","+_hf4;
            }else if("2".equals(pnum)){//5000-10000
                _h1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _h2 = "第三者人身和财产损失,每人每次限额,25万,25万,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,1000（含）-1500万,1500（含）-2000万,2000（含）-3500万";
                _hf2 = calc.calcHT("1000","QT","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf3 = calc.calcHT("1500","QT","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","QT","10000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf2+","+_hf3+","+_hf4;
            }else if("3".equals(pnum)){//10000-50000
                _h1 = "承保范围,赔偿限额,方案一,方案二";
                _h2 = "每人每次限额,25万,25万";
                _h3 = "每次事故及累计限额,1500（含）-2000万,2000（含）-3500万";
                _hf3 = calc.calcHT("1500","QT","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _hf4 = calc.calcHT("2000","QT","50000","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf3+","+_hf4;
            }else if("4".equals(pnum)){//>50000
                _h1 = "承保范围,赔偿限额,方案一";
                _h2 = "第三者人身和财产损失,每人每次限额,25万";
                _h3 = "第三者人身和财产损失,每次事故及累计限额,2000（含）-3500万";
                _hf4 = calc.calcHT("2000","QT","50001","1".equals(eplace)?"INDOOR":"2".equals(eplace)?"OPEN":"OUTDOOR","1".equals(isdanger)?"HAVE":"WITHOUT","1".equals(ischeck)?"ACCEPTANCE":"EXTINGUISHER",String.valueOf(bzDays)) + "元";
                _h4 = "保费,保费,"+_hf4;
            }
            //pac
            String _f1 = "",_f2 = "",_f3 = "";
            if(bzDays<=3){
                _f1 = ("1".equals(eplace) ? "4355.00"
                        : "2".equals(eplace) ? "5000.00"
                        : "3".equals(eplace) ? "5540.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "5380.00"
                        : "2".equals(eplace) ? "6100.00"
                        : "3".equals(eplace) ? "6750.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "6500.00"
                        : "2".equals(eplace) ? "7300.00"
                        : "3".equals(eplace) ? "8020.00"
                        :"") +"元";
            }else if(3<bzDays && bzDays<8){
                _f1 = ("1".equals(eplace) ? "5427.00"
                        : "2".equals(eplace) ? "6300.00"
                        : "3".equals(eplace) ? "6950.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "6870.00"
                        : "2".equals(eplace) ? "7670.00"
                        : "3".equals(eplace) ? "8370.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "7640.00"
                        : "2".equals(eplace) ? "8540.00"
                        : "3".equals(eplace) ? "9340.00"
                        :"") +"元";
            }else if(8<bzDays && bzDays<31){
                _f1 = ("1".equals(eplace) ? "8485.00"
                        : "2".equals(eplace) ? "9250.00"
                        : "3".equals(eplace) ? "10050.00"
                        :"") +"元";
                _f2 = ("1".equals(eplace) ? "10020.00"
                        : "2".equals(eplace) ? "11040.00"
                        : "3".equals(eplace) ? "11940.00"
                        :"") +"元";
                _f3 = ("1".equals(eplace) ? "12130.00"
                        : "2".equals(eplace) ? "13270.00"
                        : "3".equals(eplace) ? "14270.00"
                        :"") +"元";
            }
            if("1".equals(pnum)||"2".equals(pnum)){//3
                _1 = "承保范围,赔偿限额,方案一,方案二,方案三";
                _2 = "第三者人身和财产损失,每人每次限额,10万,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,100万,200万,500万";
                _4 = "保费,保费,"+_f1+","+_f2+","+_f3;
            }else if("3".equals(pnum)){//2
                _1 = "承保范围,赔偿限额,方案一,方案二";
                _2 = "第三者人身和财产损失,每人每次限额,15万,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,200万,500万";
                _4 = "保费,保费,"+_f2+","+_f3;
            }else if("4".equals(pnum)){//1
                _1 = "承保范围,赔偿限额,方案一";
                _2 = "第三者人身和财产损失,每人每次限额,20万";
                _3 = "第三者人身和财产损失,每次事故及累计限额,500万";
                _4 = "保费,保费,"+_f3;
            }
        }
        listht.add(_h1);
        listht.add(_h2);
        listht.add(_h3);
        listht.add(_h4);
        list.add(_1);
        list.add(_2);
        list.add(_3);
        list.add(_4);
        param.put("zhtype",zhtype);
        param.put("pacfa",list);
        param.put("htfa",listht);//华泰方案

    }

    private void setTemValueZZ(Map<String, Object> param){//展责
        param.put("zzya","1");//确定产品
        param.put("zzpac","1");//确定产品
        String ex_acreage = (String)param.get("ex_acreage");//展位总面积
        String ex_emp_num = (String)param.get("ex_emp_num");//雇员数量
        List<String> zzyalist = Lists.newArrayList();
        List<String> zzpaclist = Lists.newArrayList();
        String _y1="",_y2="",_y3="",_y4="",_y5="",_y6="",_y7="",_y8="";
        String _p1="",_p2="",_p3="",_p4="",_p5="",_p6="",_p7="",_p8="";
        String _z1="",_z2="",_z3="",_z4="",_z5="",_z6="",_z7="",_z8="";
        //ya
        String ytype = "z-3-1-2,z-5-1-2,h-7-1-2,h-8-1-2";
        if(Integer.parseInt(ex_acreage)<37){
            _y1 = "承保范围,赔偿限额,方案一,方案二,方案三";
            _y2 = "展会场馆方财产损失,每次事故及累计赔偿限额,100万,120万,150万";
            _y3 = "雇员人身损害,每次事故及累计赔偿限额,130万,180万,230万";
            _y4 = "雇员人身损害,每人每次及累计赔偿限额,25万,35万,45万";
            _y5 = "第三者的人身损害,每次事故及累计限额赔偿限额,60万,150万,150万";
            _y6 = "第三者的人身损害,每人每次及累计赔偿限额,15万,25万,35万";
            _y7 = "累计赔偿限额,累计赔偿限额,290万,400万,530万";
            _y8 = "保费,保费,200.00元,260.00元,330.00元";
        }else if(36<Integer.parseInt(ex_acreage) && Integer.parseInt(ex_acreage)<109){//2
            _y1 = "承保范围,赔偿限额,方案一,方案二,方案三";
            _y2 = "展会场馆方财产损失,每次事故及累计赔偿限额,100万,120万,150万";
            _y3 = "雇员人身损害,每次事故及累计赔偿限额,130万,180万,230万";
            _y4 = "雇员人身损害,每人每次及累计赔偿限额,25万,35万,45万";
            _y5 = "第三者的人身损害,每次事故及累计限额赔偿限额,60万,150万,150万";
            _y6 = "第三者的人身损害,每人每次及累计赔偿限额,15万,25万,35万";
            _y7 = "累计赔偿限额,累计赔偿限额,290万,400万,530万";
            _y8 = "保费,保费,280.00元,360.00元,430.00元";
        }else if(108<Integer.parseInt(ex_acreage)){
            _y1 = "承保范围,赔偿限额,方案一,方案二,方案三";
            _y2 = "展会场馆方财产损失,每次事故及累计赔偿限额,100万,120万,150万";
            _y3 = "雇员人身损害,每次事故及累计赔偿限额,130万,180万,230万";
            _y4 = "雇员人身损害,每人每次及累计赔偿限额,25万,35万,45万";
            _y5 = "第三者的人身损害,每次事故及累计限额赔偿限额,60万,150万,150万";
            _y6 = "第三者的人身损害,每人每次及累计赔偿限额,15万,25万,35万";
            _y7 = "累计赔偿限额,累计赔偿限额,290万,400万,530万";
            _y8 = "保费,保费,"+bfjs(Integer.parseInt(ex_acreage), 380)+".00元,"+bfjs(Integer.parseInt(ex_acreage), 470)+".00元,"+bfjs(Integer.parseInt(ex_acreage), 520)+".00元";
        }
        zzyalist.add(_y1);
        zzyalist.add(_y2);
        zzyalist.add(_y3);
        zzyalist.add(_y4);
        zzyalist.add(_y5);
        zzyalist.add(_y6);
        zzyalist.add(_y7);
        zzyalist.add(_y8);
        param.put("ytype",ytype);
        param.put("zzyalist",zzyalist);
        //pac s:3,5;
        String ptype = "z-3-1-2,z-5-1-2,h-7-1-2,h-8-1-2";//纵向-第3条-第1列-跨2列,纵向-第5条-第1列-跨2列,横向-第7条-第1列-跨2列
        if(Integer.parseInt(ex_acreage)<37){
            _p1 = "承保范围,赔偿限额,方案一,方案二,方案三";
            _p2 = "展会场馆方财产损失,每次事故及累计赔偿限额,20万,60万,40万";
            _p3 = "雇员人身损害,每次事故及累计赔偿限额,50万,90万,120万";
            _p4 = "雇员人身损害,每人每次及累计赔偿限额,20万,30万,40万";
            _p5 = "第三者的人身损害,每次事故及累计限额赔偿限额,100万,150万,200万";
            _p6 = "第三者的人身损害,每人每次及累计赔偿限额,20万,30万,40万";
            _p7 = "累计赔偿限额,累计赔偿限额,170万,300万,360万";
            _p8 = "保费,保费,180.00元,240.00元,300.00元";
        }else if(36<Integer.parseInt(ex_acreage) && Integer.parseInt(ex_acreage)<101){//2
            _p1 = "承保范围,赔偿限额,方案二,方案三";
            _p2 = "展会场馆方财产损失,每次事故及累计赔偿限额,120万,150万";
            _p3 = "雇员人身损害,每次事故及累计赔偿限额,180万,230万";
            _p4 = "雇员人身损害,每人每次及累计赔偿限额,35万,45万";
            _p5 = "第三者的人身损害,每次事故及累计限额赔偿限额,150万,150万";
            _p6 = "第三者的人身损害,每人每次及累计赔偿限额,25万,35万";
            _p7 = "累计赔偿限额,累计赔偿限额,300万,360万";
            _p8 = "保费,保费,340.00元,400.00元";
        }else if(Integer.parseInt(ex_acreage)>100){
            _p1 = "承保范围,赔偿限额,方案三";
            _p2 = "展会场馆方财产损失,每次事故及累计赔偿限额,150万";
            _p3 = "雇员人身损害,每次事故及累计赔偿限额,230万";
            _p4 = "雇员人身损害,每人每次及累计赔偿限额,45万";
            _p5 = "第三者的人身损害,每次事故及累计限额赔偿限额,150万";
            _p6 = "第三者的人身损害,每人每次及累计赔偿限额,35万";
            _p7 = "累计赔偿限额,累计赔偿限额,360万";
            _p8 = "保费,保费,490.00元";
        }
        zzpaclist.add(_p1);
        zzpaclist.add(_p2);
        zzpaclist.add(_p3);
        zzpaclist.add(_p4);
        zzpaclist.add(_p5);
        zzpaclist.add(_p6);
        zzpaclist.add(_p7);
        zzpaclist.add(_p8);
        param.put("ptype",ptype);
        param.put("zzpaclist",zzpaclist);

        //za
        String ztype = "";
        String zzza = "";
        List<String> zzzalist = Lists.newArrayList();
        if(Integer.parseInt(ex_acreage)<109){
            _z1 = "承保范围,赔偿限额,方案一,方案二,方案三";
            _z2 = "展会场馆方财产损失,每次事故及累计赔偿限额,50万,60万,80万";
            _z3 = "雇员人身损害,每次事故及累计赔偿限额,150万,200万,250万";
            _z4 = "雇员人身损害,每人每次及累计赔偿限额,30万,40万,50万";
            _z5 = "第三者的人身损害,每次事故及累计限额赔偿限额,100万,150万,200万";
            _z6 = "第三者的人身损害,每人每次及累计赔偿限额,20万,30万,40万";
            _z7 = "累计赔偿限额,累计赔偿限额,300万,410万,530万";
            _z8 = "保费,保费,450.00元,500.00元,600.00元";
            zzzalist.add(_z1);
            zzzalist.add(_z2);
            zzzalist.add(_z3);
            zzzalist.add(_z4);
            zzzalist.add(_z5);
            zzzalist.add(_z6);
            zzzalist.add(_z7);
            zzzalist.add(_z8);
            ztype = "z-3-1-2,z-5-1-2,h-7-1-2,h-8-1-2";
            zzza = "1";
        }
        param.put("ztype",ztype);
        param.put("zzzalist",zzzalist);
        param.put("zzza",zzza);//确定产品
    }

    private static int bfjs(int ea,int iea){//保费计算
        int _y = 0;
        if((ea-216)%108>0){
            _y = 1;
        }
        return iea + (((ea-216)/108) + _y)*30;
    }

    public static void main(String [] args){
//        System.out.println(bfjs(Integer.parseInt("570"), 380));
        try {
//            String templateName = "template/weixin_zz_pdf_offer.vm";
//            Map<String, Object> param=new HashMap<>();
//            param.put("name","哈哈哈哈哈");
//            param.put("date","2018-01-30");
//            String htmlC = FreemarkerUtil.generator(templateName, param);
//            String path = spannedFile(htmlC);
//            String sysRoot = new PathMatchingResourcePatternResolver().getResource("/weixin_gz_pdf_offer.vm").getURL().getPath();
            System.out.println(bfjs(200,380));
        }catch (Exception e){
            e.printStackTrace();
            throw new RuntimeException("pdf模板生成失败");
        }
    }

    /**
     * <b> 获取到模板渲染完数据的完整html字符串，先通过HtmlImageGenerator转成图片，再通过方法imgToPdf转成pdf文件 </b>
     * @param htmlC 字符串的html
     * @param ttype 类型 1.公责；2.展责；3.展责，不含众安报价。在图片转pdf时为了打平台logo图标用于定位在不同情况下模板中logo水印打的位置
     * @param fBody 下载地址中部文件夹，如：/policy/
     * @param fName 文件名称
     * @author ZXF
     * @create 2018/07/12 0012 14:09
     * @version
     * @注意事项 </b>
     */
    private String spannedFile(String htmlC,String ttype,String fBody, String fName) throws Exception {
        String result;
        try {
            String files =fName + ".png";
            //开发用F盘或其他盘的固定地址，部署测试或生产用配置表的地址
            String path = /*"F://D_pan/ase/"*/GlobalResources.COM_IMG_RE+fBody;
            HtmlImageGenerator imageGenerator = new HtmlImageGenerator();
            imageGenerator.loadHtml(htmlC);
            imageGenerator.getBufferedImage();
            Thread.sleep(4000);
            imageGenerator.saveAsImage(path + files);
//            imageGenerator.saveAsHtmlWithMap("a.html", "a.png");
            result = fBody + files;
            /*String filepdf = fName + ".pdf";
            result = fBody + filepdf;
            imgToPdf(path + files,path + filepdf,ttype);*/
            System.out.println("Done.");
            //测试或生产环境可正常访问，本地下载地址无效，可直接找文件夹对应的文件
            result = GlobalResources.DONOW_PATH+"/getResource?path="+result;
        } catch (Exception e) {
            e.printStackTrace();
            result = ConstProp.BLANK_CHAR;
        }
        return result;
    }

    /**
     * 将图片转换成pdf文件
     * @param imgFilePath 需要被转换的img所存放的位置。 例如imgFilePath="D:\\projectPath\\55555.jpg";
     * @param pdfFilePath 转换后的pdf所存放的位置 例如pdfFilePath="D:\\projectPath\\55555.pdf";
     * @param ttype 类型 1.公责；2.展责；3.展责，不含众安报价。在图片转pdf时为了打平台logo图标用于定位在不同情况下模板中logo水印打的位置
     * @return
     * @throws IOException
     */
    private boolean imgToPdf(String imgFilePath, String pdfFilePath, String ttype)throws IOException {
        File file=new File(imgFilePath);
        if(!file.exists()){
            return false;
        }
        Document document = new Document();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pdfFilePath);
            PdfWriter.getInstance(document, fos);

            // 添加PDF文档的某些信息，比如作者，主题等等
            document.addAuthor("百联保");
            document.addSubject("报价方案书");
            // 设置文档的大小
            document.setPageSize(PageSize.A4);
            // 打开文档
            document.open();
            // 写入一段文字
//                document.add(new Paragraph("百联保保险平台——企业保险、垂直领域定制保险平台 www.bailianbao.cn"));
            // 读取一个图片
            Image image = Image.getInstance(imgFilePath);
            float imageHeight=image.getScaledHeight();
            float imageWidth=image.getScaledWidth();
            //统一按照宽度压缩
            int percent=getPercent(imageHeight, imageWidth);
            //按百分比显示图片的比例
            image.scalePercent(percent);//表示是原来图像的比例
            image.setAlignment(Image.MIDDLE);
            // 插入一个图片
            document.add(image);
            Image img = Image.getInstance("http://www.bailianbao.cn/resources/version_new/images/bai-logo.png");
            //logo图片大小设置
            img.scaleAbsolute(img.getScaledWidth()/3, img.getScaledHeight()/3);
            //logo在整张pdf中的宽高设置
            float abY = img.getScaledHeight()*5;
            if("1".equals(ttype)){
                abY = img.getScaledHeight()*16;
            }else if("3".equals(ttype)){
                abY = img.getScaledHeight()*15;
            }
            img.setAbsolutePosition((image.getScaledWidth()-img.getScaledWidth()*2),
                    abY);
            //img.setAbsolutePosition(0, 0);
            document.add(img);
        } catch (DocumentException de) {
            System.out.println(de.getMessage());
        } catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        document.close();
        fos.flush();
        fos.close();
        return true;
    }

    /**
     * 统一按照宽度压缩
     * 这样来的效果是，所有图片的宽度是相等的，自我认为给客户的效果是最好的
     * @param h 高
     * @param w 宽
     */
    private int getPercent(float h,float w)
    {
        int p=0;
        float p2=0.0f;
        p2=530/w*100;
        p=Math.round(p2);
        return p;
    }

    /**
     * 团险页面条件获取下一个条件限制
     * @param param
     * @return
     */
    @Override
    public R matching(Map<String, Object> param) {
        if(param.get("handle") == null || param.get("handle_val") == null){
            return new R(false,"操作项参数未设置！");
        }
        //操作(handle)
        //handle=0 根据产品类型搜索最低保费并返回
        //handle=1 根据产品类型搜索保险公司列并返回
        //handle=2 根据保险公司搜索保险产品列并返回
        //handle=3 根据保险产品搜索保障方案列并返回
        String handle= (String)param.get("handle");

        //每次操作的值，如：产品类型（雇主1,团意险2）；保险公司（泰康1,平安2,人保3）；保险产品（计划一242432,计划二342432）
        String handle_val= (String)param.get("handle_val");

        if(ConstProp.DIGIT_ZERO.equals(handle)){
            int yj_premium_min;
            int yj_premium_max;
            if(ConstProp.DIGIT_ONE.equals(handle_val)){//雇主
                yj_premium_min = 180;
                yj_premium_max = 345;
            }else{//团意险
                yj_premium_min = 65;
                yj_premium_max = 990;
            }
            return new R(true,yj_premium_min+","+yj_premium_max);
        }else if(ConstProp.DIGIT_ONE.equals(handle)){
            //产品类型
            String product_type = handle_val.split(ConstProp.POUND_SIGN)[0];
            //预计保费
            String yj_premium = handle_val.split(ConstProp.POUND_SIGN)[1];
            int yj_premium_min = Integer.parseInt(yj_premium.split(",")[0]);
            int yj_premium_max = Integer.parseInt(yj_premium.split(",")[1]);
            List<Map> listMap = Lists.newArrayList();
            setICNameByProductType(product_type, yj_premium_min, yj_premium_max, listMap);
            return new R(true,listMap);
        }else if(ConstProp.DIGIT_TWO.equals(handle)){
            //产品编码
            String product_code = handle_val.split(ConstProp.POUND_SIGN)[0];
            //预计保费
            String yj_premium = handle_val.split(ConstProp.POUND_SIGN)[1];
            int yj_premium_min = Integer.parseInt(yj_premium.split(",")[0]);
            int yj_premium_max = Integer.parseInt(yj_premium.split(",")[1]);
            List<ProductVo> list = productService.getProductsByCodeForNotCache(product_code);
            List<ProductVo> plist = Lists.newArrayList();
            for(ProductVo vo : list){
                if(isHasProductVoByPremuims(vo,yj_premium_min,yj_premium_max)){
                    plist.add(vo);
                }
            }
            return new R(true,plist);
        }else if(ConstProp.DIGIT_THREE.equals(handle)){
            //产品id
            String product_id = handle_val.split(ConstProp.POUND_SIGN)[0];
            //预计保费
            String yj_premium = handle_val.split(ConstProp.POUND_SIGN)[1];
            int yj_premium_min = Integer.parseInt(yj_premium.split(",")[0]);
            int yj_premium_max = Integer.parseInt(yj_premium.split(",")[1]);
            ProductVo pvo = productService.getProduct(Long.parseLong(product_id));
            int premium = getPlusPremium(pvo.getProduct_code(),"0",pvo.getPremium_min());
            List<Map> listMap = Lists.newArrayList();
            setBZNameByProductId(yj_premium_min, yj_premium_max, pvo, premium, listMap);
            return new R(true,listMap);
        }else if(ConstProp.DIGIT_FOUR.equals(handle)){
            if(handle_val.split(ConstProp.POUND_SIGN).length!=2){
                return new R(false,"操作项入参数据格式有误！");
            }
            //产品id
            String pid = handle_val.split(ConstProp.POUND_SIGN)[0];
            //保障编号
            String bz_code = handle_val.split(ConstProp.POUND_SIGN)[1];
            ProductVo pvo = productService.getProduct(Long.parseLong(pid));
            int pm = getPlusPremium(pvo.getProduct_code(),bz_code,pvo.getPremium_min());
            return new R(true,pm);
        }else {
            return new R(false,"操作项(handle)参数未设置！");
        }
    }

    /**
     * <b> 根据保险产品搜索保障方案列并返回 </b>
     * @author ZXF
     * @create 2020/09/27 0027 14:11
     * @version
     * @注意事项 </b>
     */
    private void setBZNameByProductId(int yj_premium_min, int yj_premium_max, ProductVo pvo, int premium, List<Map> listMap) {
        if(yj_premium_min<=premium&&premium<=yj_premium_max){
            Map map_1 = Maps.newHashMap();
            map_1.put("bz_code","0");
            map_1.put("bz_name","基础保障");
            listMap.add(map_1);
        }
        if("TYX-RB-3,TYX-RB-4,TYX-RB-5,TYX-RB-6".contains(pvo.getProduct_code())){
            //人保团意险存在可选保障
            premium = getPlusPremium(pvo.getProduct_code(),"1",pvo.getPremium_min());
            if(yj_premium_min<=premium&&premium<=yj_premium_max){
                Map map_3 = Maps.newHashMap();
                map_3.put("bz_code","1");
                map_3.put("bz_name","基础保障+疾病身故/全残");
                listMap.add(map_3);
            }
            premium = getPlusPremium(pvo.getProduct_code(),"2",pvo.getPremium_min());
            if(yj_premium_min<=premium&&premium<=yj_premium_max){
                Map map_4 = Maps.newHashMap();
                map_4.put("bz_code","2");
                map_4.put("bz_name","基础保障+重大疾病");
                listMap.add(map_4);
            }
            premium = getPlusPremium(pvo.getProduct_code(),"3",pvo.getPremium_min());
            if(yj_premium_min<=premium&&premium<=yj_premium_max){
                Map map_5 = Maps.newHashMap();
                map_5.put("bz_code","3");
                map_5.put("bz_name","基础保障+疾病身故/全残+重大疾病");
                listMap.add(map_5);
            }
        }else if(pvo.getProduct_code().contains("GZZRX-RB")){
            //人保雇主存在可选保障
            premium = getPlusPremium(pvo.getProduct_code(),"4",pvo.getPremium_min());
            if(yj_premium_min<=premium&&premium<=yj_premium_max){
                Map map_2 = Maps.newHashMap();
                map_2.put("bz_code","4");
                map_2.put("bz_name","基础保障+附加第三者责任");
                listMap.add(map_2);
            }
        }
    }

    /**
     * <b> 根据产品类型搜索保险公司列并返回 </b>
     * @author ZXF
     * @create 2020/09/27 0027 14:07
     * @version
     * @注意事项 </b>
     */
    private void setICNameByProductType(String product_type, int yj_premium_min, int yj_premium_max, List<Map> listMap) {
        if(ConstProp.DIGIT_ONE.equals(product_type)){
            //雇主
            if(checkProductByPremuims("GZZRX-RB",yj_premium_min,yj_premium_max)){
                Map map_1 = Maps.newHashMap();
                map_1.put("ic_code","GZZRX-RB");
                map_1.put("ic_name","中国人民财产保险股份有限公司");
                listMap.add(map_1);
            }
        }else{
            //团意险
            if(checkProductByPremuims("TYX-TK",yj_premium_min,yj_premium_max)){
                Map map_1 = Maps.newHashMap();
                map_1.put("ic_code","TYX-TK");
                map_1.put("ic_name","泰康在线财产保险股份有限公司");
                listMap.add(map_1);
            }
            if(checkProductByPremuims("TYX-PAS",yj_premium_min,yj_premium_max)){
                Map map_2 = Maps.newHashMap();
                map_2.put("ic_code","TYX-PAS");
                map_2.put("ic_name","平安养老保险股份有限公司");
                listMap.add(map_2);
            }
            if(checkProductByPremuims("TYX-RB",yj_premium_min,yj_premium_max)){
                Map map_3 = Maps.newHashMap();
                map_3.put("ic_code","TYX-RB");
                map_3.put("ic_name","中国人民财产保险股份有限公司");
                listMap.add(map_3);
            }
        }
    }

    private int getPlusPremium(String product_code,String bz_code,String premium_min){
        int p1 = "TYX-RB-3".equals(product_code) ? 30
                : "TYX-RB-4".equals(product_code) ? 40
                : "TYX-RB-5".equals(product_code) ? 50
                : "TYX-RB-6".equals(product_code) ? 60
                : 0;
        int p2 = "TYX-RB-3".equals(product_code) ? 260
                : "TYX-RB-4".equals(product_code) ? 350
                : "TYX-RB-5".equals(product_code) ? 430
                : "TYX-RB-6".equals(product_code) ? 530
                : 0;
        int p3 = "GZZRX-RB-1".equals(product_code) ? 25
                : "GZZRX-RB-2".equals(product_code) ? 35
                : "GZZRX-RB-3".equals(product_code) ? 45
                : "GZZRX-RB-4".equals(product_code) ? 55
                :0;
        int premium = Integer.parseInt(premium_min);
        if("0".equals(bz_code)){
            return premium;
        }else if("1".equals(bz_code)){
            return premium+p1;
        }else if("2".equals(bz_code)){
            return premium+p2;
        }else if("3".equals(bz_code)){
            return premium+p1+p2;
        }else if("4".equals(bz_code)){
            return premium+p3;
        }else{
            return 0;
        }
    }

    private boolean checkProductByPremuims(String product_code, int min, int max){
        List<ProductVo> pList = productService.getProductsByCodeForNotCache(product_code);
        for (ProductVo vo: pList) {
            if(isHasProductVoByPremuims(vo,min,max)){
                return true;
            }
        }
        return false;
    }

    private boolean isHasProductVoByPremuims(ProductVo vo, int min, int max){
        int premium = getPlusPremium(vo.getProduct_code(),"0",vo.getPremium_min());
        if(min<=premium&&premium<=max){
            return true;
        }
        if(vo.getProduct_code().contains("GZZRX-RB")){
            premium = getPlusPremium(vo.getProduct_code(),"4",vo.getPremium_min());
            if(min<=premium&&premium<=max){
                return true;
            }
        }else if("TYX-RB-3,TYX-RB-4,TYX-RB-5,TYX-RB-6".contains(vo.getProduct_code())){
            premium = getPlusPremium(vo.getProduct_code(),"1",vo.getPremium_min());
            if(min<=premium&&premium<=max){
                return true;
            }
            premium = getPlusPremium(vo.getProduct_code(),"2",vo.getPremium_min());
            if(min<=premium&&premium<=max){
                return true;
            }
            premium = getPlusPremium(vo.getProduct_code(),"3",vo.getPremium_min());
            if(min<=premium&&premium<=max){
                return true;
            }
        }
        return false;
    }

}
