package com.bcxin.ins.supply.business;

import com.bcxin.ins.supply.business.entity.InsureCommonView;
import com.bcxin.ins.vo.ResultDto;

import java.util.Map;

/**
 * 保险供应商业务策略
 * @author hzp
 * @date 2018/06/12
 */
public interface BizStrategy {
    /**
     * 计算保险结束日期
     * @param startTime 开始时间
     * @param limitDays 有效期限
     * @return 结束日期
     */
    ResultDto calcInsuranceEndDate(String startTime, Integer limitDays);

    /**
     * 返回公用的全局表单
     * @param map
     * @return
     */
    InsureCommonView getInsureCommonView(Map<String,Object> map);

    /**
     * 生成请求报文消息
     * @param map
     * @param templateName 报文模板
     * @return
     */
    String createRequestMessage(Map<String,Object> map,String templateName);
}
