package com.bcxin.ins.coninsweb.product.controller;

import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProExpCustomsCompaniesAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ProExpCustomsCompaniesVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 海关产品相关业务逻辑处理（不包括后台产品配置）
 * @author zxf
 *
 */
@Controller
public class InsuranceProduct_XYX_Controller extends BaseController {

	@Autowired
	private InsProductAPIService insProductAPIService;

	@Autowired
	private ProductService productService;

	@Autowired
	private ProExpCustomsCompaniesAPIService proExpCustomsCompaniesAPIService;

	private static String COMLIST = "comList";
	private static String INSURANCETYPE = "insuranceType";

	/**
	 * <b>前台页面产品详情 </b> 
	 * 
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2016年12月21日 下午1:40:41
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/customs/product/productInfo/{oid}")
	public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid) {
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ProductVo pd = insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(oid);
		if(StringUtils.isNotEmpty(pd.getOid())){
			view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
		}else{
			return null;
		}
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/customs/product/productInfo_qy");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/customs/product/productInfo_mi");
		}
		view.addObject(ConstProp.PRODUCTDTO, pd);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);

		return view;
	}

	/**
	 * <b>企业身份校验初始化界面 </b> 
	 * 
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2016年12月21日 下午1:40:58
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/customs/product/identityCheck/{oid}")
	public ModelAndView identityCheckVeiw(HttpServletRequest request, @PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/insurance/customs/product/identityCheck");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/insurance/customs/product/identityCheck/"+oid);
		}
		try {
			ProductVo pd = insProductAPIService.accordingToInsProductIDToGetInsProductInProductVo(oid);
			view.addObject(ConstProp.PRODUCTDTO, pd);
		} catch (Exception e) {
			e.printStackTrace();
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject(COMLIST, SysDictUtils.getDictList(INSURANCETYPE));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>企业身份校验实现方法及信息反馈 </b>
	 *
	 * @param request
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:41:18
	 * @注意事项 </b>
	 * <b>
	 */
	@SuppressWarnings("unused")
	@RequestMapping("/insurance/product/identityCheck")
	@ResponseBody
	public ResultDto identityCheck(HttpServletRequest request, ProExpCustomsCompaniesVo vo){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null)
			return new ResultDto("登录超时，请重新登录！", "301",ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		//TODO 校验方法
		ProExpCustomsCompaniesVo peccVo = null;
		try {
			peccVo = proExpCustomsCompaniesAPIService.findIdentity(vo);
		}catch (Exception e){
			e.printStackTrace();
		}
		if(peccVo != null){
			return new ResultDto("检验成功！", ConstProp.CODE_SUCCESS,String.valueOf(peccVo.getExport_amount()), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("公司名称、海关代码有误或该企业不属于小微企业，请确认！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

}
