package com.bcxin.ins.coninsweb.product.controller;

import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 诉讼产品相关业务逻辑处理（不包括后台产品配置）
 * @author zxf
 *
 */
@Controller
public class InsuranceProduct_Lawsuit_Controller extends BaseController {

	@Autowired
	private InsProductAPIService insProductAPIService;
	@Autowired
	private ProductService productService;

	/**
	 * <b>前台页面产品详情 </b> 
	 * 
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2016年12月21日 下午1:42:17
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/lawsuit/product/productInfo/{oid}")
	public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/insurance/lawsuit/product/productInfo");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ProductVo pd = productService.getProduct(oid);
		if(StringUtils.isNotEmpty(pd.getOid())){
			view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
		}else{
			return null;
		}
		view.addObject(ConstProp.PRODUCTDTO, pd);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}

}
