package com.bcxin.ins.coninsweb.product.controller;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 个意险产品相关业务逻辑处理（不包括后台产品配置）
 * @author zxf
 *
 */
@Controller
public class InsuranceProduct_GYX_Controller extends BaseController {

	@Autowired
	private ProductService productService;
	@Autowired
	private PolicyService policyService;

	/**
	 *
	 * <b>产品中心，各分类产品列表 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/gyx/product/productInfo_iframe/{oid}")
	public ModelAndView productInfo_iframe(HttpServletRequest request,@PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_pro_index");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject("product_id", String.valueOf(oid));
		setTokenByApi(view);
		return view;
	}

	/**
	 *
	 * <b>跳转到投保界面 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/gyx/policy/policy_iframe/{oid}")
	public ModelAndView policy_iframe(@PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_order_index");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView(DSUtil.operation()+"/insurance/gyx/policy/policy_iframe/"+oid);
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject(ConstProp.ORDER_ID, String.valueOf(oid));
		setTokenByApi(view);
		return view;
	}

	/**
	 *
	 * <b>跳转到投保界面 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/gyx/policy/policyInit_iframe/{oid}")
	public ModelAndView policyInit_iframe(HttpServletRequest request,@PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_order_init");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView(DSUtil.operation()+"/insurance/gyx/policy/policyInit_iframe/"+oid);
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject("product_id", String.valueOf(oid));
		setTokenByApi(view);
		return view;
	}

	/**
	 *
	 * <b>跳转到投保界面 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/gyx/policy/payment_iframe/{oid}")
	public ModelAndView payment_iframe(@PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/api/gyx/gyx_order_pay");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView(DSUtil.operation()+"/insurance/gyx/policy/payment_iframe/"+oid);
		}
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(oid);
		view.addObject(ConstProp.DTO,dto);
		OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(oid);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject("payurl", vo.getShow_url());
		setTokenByApi(view);
		return view;
	}



	/**
	 * <b>前台页面产品详情 </b> 
	 * 
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2016年12月21日 下午1:40:41
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/gyx/product/productInfo/{oid}")
	public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid) {
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ProductVo pd = productService.getProduct(oid);
		if(StringUtils.isNotEmpty(pd.getOid())){
			view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
		}else{
			return null;
		}
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains("GYX-TB")){
			view.setViewName("/coninsweb/api/gyx/product/gyx_tb_product_info");
		}
		view.addObject(ConstProp.PRODUCTDTO, pd);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);

		return view;
	}

}
